/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.util.ExceptionUtil;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.struts.form.ActionFormUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.springframework.web.struts.DelegatingRequestProcessor;

/**
 * DelegatingRequestProcessorgNXB
 * <p>
 *  NCAg̃NGXgߑAURIɉANV̋NȂǂsB
 *  org.springframework.web.struts.DelegatingRequestProcessorpāA
 *  ȉ̋@\ǉĂB
 * </p>
 *
 * <ol>
 * <li>&quot;_&quot;Ŏn܂
 *  ANVtH[̃ZbVBꐫ̕ۏ</li>
 * <p>
 *  ZbVXR[ṽANVtH[_
 *  &quot;_&quot;Ŏn܂ĂꍇA
 *  CX^X쐬ƂɁAZbVɊi[Ă
 *  ̃ANVtH[̘_A&quot;_&quot;
 *  Ŏn܂ׂ̂͂č폜B
 *  ɂAZbVł͍őł1̃ANVtH[
 *  邱Ƃۏ؂AZbVXR[v
 *  ANVtH[폜LqȂĂA
 *  pȂgpʂɉ邱ƂłB
 * </p>
 * <h5>struts-config.xml̃ANVtH[w</h5>
 * <code><pre>
 * &lt;struts-config&gt;
 * &lt;form-beans&gt;
 * &lt;!-- tH[̐擪"_"  --&gt;
 * &lt;form-bean name="_sampleForm"
 * type="jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx"
 * &gt;
 * &lt;form-property name="companyId" type="java.lang.String" /&gt;
 * @@@@@EEE
 * &lt;/struts-config&gt;
 * </pre></code>
 *
 *
 * <li>tH[f}~@\</li>
 * <p>
 *  rWlXWbNsʂ𔽉fANVtH[
 *  tH[؂ւĂȂꍇ́AprocessPopulate()XLbvB
 * </p>
 *
 * <li>ANVtH[̃G[ێ</li>
 * <p>
 *  ̓`FbNG[ꍇ́A|bvAbvʂɃG[
 *  \邽߁AANVtH[ɃANVG[ۑB
 *  G[ĂȂƂ́ÃANVG[ANV
 *  tH[ɐݒ肷B
 * </p>
 *
 * <li>ÕOo͋@\</li>
 * <p>
 *  RequestProcessor#process()ŗOX[ꂽA
 *  OX^bNg[XOɏo͂B
 *  Oo͌AOServletExceptionɃbvAX[B
 * </p>
 * </ol>
 *
 * <p>
 *  RequestProcessorEx𗘗p邽߂ɂ́Astruts-config.xml
 *  &lt;controller&gt;vfprocessorClassɐݒ肪KvłB
 * <h5>struts-config.xml̐ݒ</h5>
 * <code><pre>
 * &lt;struts-config&gt;
 *   EEE
 *   &lt;controller processorClass=
 *       "jp.terasoluna.fw.web.struts.RequestProcessorEx"/&gt;
 *   EEE
 * &lt;/struts-config&gt;
 * </pre></code>
 * tH[}~@\̏ڍׂɂẮAActionExQƂ̂ƁB
 * </p>
 *
 * @see jp.terasoluna.fw.web.struts.actions.ActionEx
 * @see jp.terasoluna.fw.web.struts.form.FormEx
 *
 */
public class RequestProcessorEx extends DelegatingRequestProcessor {

    /**
     * ONXB
     */
    @SuppressWarnings("hiding")
    private static Log log
            = LogFactory.getLog(RequestProcessorEx.class);

    /**
     * processPopulate()XLbvtONGXgɐݒ肷Ƃ̃L[B
     */
    public static final String SKIP_POPULATE = "SKIP_POPULATE";
    
    /**
     * StrutsHTTPNGXggB
     *
     * <p>StrutsActionServletprocess()\bhŃX[ꂽO
     * SystemException܂߂Ẵ\bhŃLb`B
     * āAO̓eƃZbVID̃nbVlOo͂ꂽA
     * ServletExceptionɃbvăX[B</p>
     *
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @throws IOException IOO
     * @throws ServletException T[ubgO
     */
    @Override
    public void process(HttpServletRequest req, HttpServletResponse res)
            throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug("process() called.");
        }

        try {
            // X[p[NX process() s
            super.process(req, res);
        } catch (IOException e) {
            String sessionHash = RequestUtil.getSessionHash(req);
            log.error("sessionHash = " + sessionHash);
            log.error(ExceptionUtil.getStackTrace(e));
            throw e;
        } catch (ServletException e) {
            String sessionHash = RequestUtil.getSessionHash(req);
            log.error("sessionHash = " + sessionHash);
            log.error(ExceptionUtil.getStackTrace(e));
            throw e;
        } catch (Exception e) {
            String sessionHash = RequestUtil.getSessionHash(req);
            log.error("sessionHash = " + sessionHash);
            log.error(ExceptionUtil.getStackTrace(e));
            throw new ServletException(e);
        }

        if (log.isDebugEnabled()) {
            log.debug("process() finished.");
        }
    }

    /**
     * Struts̃ANVtH[擾gB
     *
     * <p>ANV}bsOŎw肳ꂽANVtH[A
     * "_"Ŏn܂ĂANVtH[̏ꍇ́A
     * processActionFormEx()ɏϏB</p>
     *
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param mapping ANV}bsO
     * @return ActionForm ANVtH[
     */
    @Override
    protected ActionForm processActionForm(HttpServletRequest req,
                                           HttpServletResponse res,
                                           ActionMapping mapping) {
        if (log.isDebugEnabled()) {
            log.debug(
                "processActionForm() called. path = " + mapping.getPath());
            log.debug("mapping.name = " + mapping.getName());
            log.debug("mapping.scope = " + mapping.getScope());
        }

        if (mapping instanceof ActionMappingEx
                && mapping.getScope() != null
                && "session".equals(mapping.getScope())
                && mapping.getName() != null
                && mapping.getName().startsWith("_")) {

            // XR[v"session"AANVtH[_"_"
            // n܂Ăꍇ́AprocessActionFormEx() s
            return processActionFormEx(req,
                res,
                (ActionMappingEx) mapping);
        }
        // X[p[NX processActionForm() s
        return super.processActionForm(req, res, mapping);
    }

    /**
     * Struts̃ANVtH[擾gB
     * processActionForm()Ă΂B
     *
     * <p>ANV}bsOŎw肳ꂽANVtH[A
     * "_"Ŏn܂ĂANVtH[B</p>
     *
     * <p>ANVtH[̏A
     * RequestProcessorprocessPopulate()\bhNB</p>
     *
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param mapping ANV}bsO
     * @return ANVtH[
     */
    protected ActionForm processActionFormEx(HttpServletRequest req,
                                             HttpServletResponse res,
                                             ActionMappingEx mapping) {
        if (log.isDebugEnabled()) {
            log.debug(
                "processActionFormEx() called. path = " + mapping.getPath());
        }

        boolean clearForm = false;
        // ANV}bsOclearFormvpeBQƂB
        clearForm = mapping.getClearForm();
        if (log.isDebugEnabled()) {
            log.debug("clearForm = " + clearForm);
        }

        if (clearForm) {
            // clearFormvpeBtruêƂ́A
            // "_"w肳ꂽANVtH[A
            // ZbV炷ׂč폜B
            HttpSession session = req.getSession();
            ActionFormUtil.clearActionForm(session);
        } else {
            // clearFormvpeBfalsêƂ́A
            // "_"Ŋi[ꂽANVtH[A
            // ZbV폜B
            // Aw肳ꂽANVtH[B
            HttpSession session = req.getSession();
            ActionFormUtil.clearActionForm(session, mapping.getName());
        }

        // X[p[NX processActionForm() s
        return super.processActionForm(req, res, mapping);
    }

    /**
     * Struts̃ANVtH[ւ̃NGXgp[^fgB
     *
     * <p>rWlXWbNsʂ𔽉fANVtH[
     * ؂芷Ăꍇ́A
     * RequestProcessorprocessPopulate()\bhNB</p>
     * <p>struts-config.xml̃ANV}bsOݒ莞A
     * cancelPopulatetrue ɂꍇA
     * processPopulate LZB</p>
     *
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param form ANVtH[
     * @param mapping ANV}bsO
     * @throws ServletException T[ubgO
     */
    @Override
    protected void processPopulate(HttpServletRequest req,
                                   HttpServletResponse res,
                                   ActionForm form,
                                   ActionMapping mapping)
            throws ServletException {

        if (log.isDebugEnabled()) {
            log.debug(
                "processPopulate() called. path = " + mapping.getPath());
        }

        boolean cancelPopulateflg  = false;
        cancelPopulateflg = ((ActionMappingEx) mapping).getCancelPopulate();
        if (cancelPopulateflg) {
            if (log.isDebugEnabled()) {
                log.debug("processPopulate() canceled.");
            }
            // ȍ~͎sȂ
            return;
        }

        String skipPopulate = (String) req.getAttribute(SKIP_POPULATE);
        if (skipPopulate != null) {
            if (skipPopulate.equals(mapping.getName())) {

                if (log.isDebugEnabled()) {
                    log.debug("processPopulate() skipped.");
                }
                // ȍ~͎sȂ
                return;
            }
            req.removeAttribute(SKIP_POPULATE);
        }
        // X[p[NX processPopulate() s
        super.processPopulate(req, res, form, mapping);

    }
}
