/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;

public class BeanPropertySqlParameterSource
extends AbstractSqlParameterSource {
    private final BeanWrapper beanWrapper;
    private String[] propertyNames = null;

    public BeanPropertySqlParameterSource(Object object) {
        this.beanWrapper = new BeanWrapperImpl(object);
    }

    public boolean hasValue(String paramName) {
        return this.beanWrapper.isReadableProperty(paramName);
    }

    public Object getValue(String paramName) throws IllegalArgumentException {
        try {
            return this.beanWrapper.getPropertyValue(paramName);
        }
        catch (NotReadablePropertyException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getReadablePropertyNames() {
        BeanPropertySqlParameterSource beanPropertySqlParameterSource = this;
        synchronized (beanPropertySqlParameterSource) {
            if (this.propertyNames == null) {
                ArrayList<String> names = new ArrayList<String>();
                PropertyDescriptor[] props = this.beanWrapper.getPropertyDescriptors();
                for (int i = 0; i < props.length; ++i) {
                    if (!this.beanWrapper.isReadableProperty(props[i].getName())) continue;
                    names.add(props[i].getName());
                }
                this.propertyNames = names.toArray(new String[names.size()]);
            }
        }
        return this.propertyNames;
    }
}

