/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc.logging;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.jdbc.logging.BaseLogProxy;
import com.ibatis.common.jdbc.logging.ResultSetLogProxy;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class PreparedStatementLogProxy
extends BaseLogProxy
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = PreparedStatementLogProxy.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement);
    private PreparedStatement statement;
    private String sql;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$CallableStatement;

    private PreparedStatementLogProxy(PreparedStatement stmt, String sql) {
        this.statement = stmt;
        this.sql = sql;
    }

    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if (EXECUTE_METHODS.contains(method.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug("{pstm-" + this.id + "} Executing Statement: " + this.removeBreakingWhitespace(this.sql));
                    log.debug("{pstm-" + this.id + "} Parameters: " + this.getValueString());
                    log.debug("{pstm-" + this.id + "} Types: " + this.getTypeString());
                }
                this.clearColumnInfo();
                if ("executeQuery".equals(method.getName())) {
                    ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                    if (rs != null) {
                        return ResultSetLogProxy.newInstance(rs);
                    }
                    return null;
                }
                return method.invoke((Object)this.statement, params);
            }
            if (SET_METHODS.contains(method.getName())) {
                if ("setNull".equals(method.getName())) {
                    this.setColumn(params[0], null);
                } else {
                    this.setColumn(params[0], params[1]);
                }
                return method.invoke((Object)this.statement, params);
            }
            if ("getResultSet".equals(method.getName())) {
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs != null) {
                    return ResultSetLogProxy.newInstance(rs);
                }
                return null;
            }
            if ("equals".equals(method.getName())) {
                Object ps = params[0];
                if (ps instanceof Proxy) {
                    return new Boolean(proxy == ps);
                }
                return new Boolean(false);
            }
            if ("hashCode".equals(method.getName())) {
                return new Integer(proxy.hashCode());
            }
            return method.invoke((Object)this.statement, params);
        }
        catch (Throwable t) {
            throw ClassInfo.unwrapThrowable(t);
        }
    }

    public static PreparedStatement newInstance(PreparedStatement stmt, String sql) {
        PreparedStatementLogProxy handler = new PreparedStatementLogProxy(stmt, sql);
        ClassLoader cl = (class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = PreparedStatementLogProxy.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement).getClassLoader();
        return (PreparedStatement)Proxy.newProxyInstance(cl, new Class[]{class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = PreparedStatementLogProxy.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement, class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = PreparedStatementLogProxy.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement}, (InvocationHandler)handler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

