/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter.mockrunner;

import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.mockrunner.Expression;
import org.activemq.filter.mockrunner.Filter;

public class ExpressionFilter
implements Filter {
    private Expression expression;

    public ExpressionFilter(Expression expression) {
        this.expression = expression;
    }

    @Override
    public boolean matches(Message message) throws JMSException {
        Object object = this.expression.evaluate(message);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        return "Filter: " + this.expression;
    }
}

