/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.struts;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.struts.ExceptionHandlerConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;

public class DefaultExceptionHandlerConfig
implements ExceptionHandlerConfig {
    private ExceptionConfig exceptionConfig;
    private ExceptionHandler exceptionHandler;
    private Class exceptionClass;

    public DefaultExceptionHandlerConfig(ExceptionConfig exceptionConfig) {
        this.exceptionConfig = exceptionConfig;
        try {
            Class<?> clazz = exceptionConfig.getClass().getClassLoader().loadClass(exceptionConfig.getHandler());
            this.exceptionHandler = (ExceptionHandler)clazz.newInstance();
            this.exceptionClass = exceptionConfig.getClass().getClassLoader().loadClass(exceptionConfig.getType());
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public DefaultExceptionHandlerConfig(ExceptionHandler exceptionHandler, ExceptionConfig exceptionConfig) {
        this.exceptionHandler = exceptionHandler;
        this.exceptionConfig = exceptionConfig;
        this.exceptionConfig.setHandler(exceptionHandler.getClass().getName());
        try {
            this.exceptionClass = exceptionConfig.getClass().getClassLoader().loadClass(exceptionConfig.getType());
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public DefaultExceptionHandlerConfig(ExceptionHandler exceptionHandler, Class clazz) {
        this.exceptionHandler = exceptionHandler;
        this.exceptionClass = clazz;
        this.exceptionConfig = new ExceptionConfig();
        this.exceptionConfig.setHandler(exceptionHandler.getClass().getName());
        this.exceptionConfig.setType(clazz.getName());
    }

    public DefaultExceptionHandlerConfig(Class clazz) {
        this.exceptionHandler = new ExceptionHandler();
        this.exceptionClass = clazz;
        this.exceptionConfig = new ExceptionConfig();
        this.exceptionConfig.setHandler(ExceptionHandler.class.getName());
        this.exceptionConfig.setType(clazz.getName());
    }

    @Override
    public boolean canHandle(Exception exception) {
        return this.exceptionClass.isInstance(exception);
    }

    @Override
    public Object handle(Exception exception, ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (!this.canHandle(exception)) {
            return null;
        }
        if (null == this.exceptionHandler) {
            return null;
        }
        return this.exceptionHandler.execute(exception, this.exceptionConfig, actionMapping, actionForm, httpServletRequest, httpServletResponse);
    }

    public ExceptionConfig getExceptionConfig() {
        return this.exceptionConfig;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

