/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.servlet;

import com.mockrunner.base.HTMLOutputModule;
import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.WebMockObjectFactory;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

public class ServletTestModule
extends HTMLOutputModule {
    private WebMockObjectFactory mockFactory;
    private HttpServlet servlet;
    private boolean doChain;

    public ServletTestModule(WebMockObjectFactory webMockObjectFactory) {
        super(webMockObjectFactory);
        this.mockFactory = webMockObjectFactory;
        this.doChain = false;
    }

    public HttpServlet createServlet(Class clazz) {
        if (!HttpServlet.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("servletClass must be an instance of javax.servlet.http.HttpServlet");
        }
        try {
            HttpServlet httpServlet = (HttpServlet)clazz.newInstance();
            this.setServlet(httpServlet, true);
            return httpServlet;
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public void setServlet(HttpServlet httpServlet) {
        this.setServlet(httpServlet, false);
    }

    public void setServlet(HttpServlet httpServlet, boolean bl) {
        try {
            this.servlet = httpServlet;
            if (bl) {
                httpServlet.init((ServletConfig)this.mockFactory.getMockServletConfig());
            }
            this.mockFactory.getMockFilterChain().setServlet((Servlet)httpServlet);
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public HttpServlet getServlet() {
        return this.servlet;
    }

    public Filter createFilter(Class clazz) {
        if (!Filter.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("filterClass must be an instance of javax.servlet.Filter");
        }
        try {
            Filter filter = (Filter)clazz.newInstance();
            this.addFilter(filter, true);
            return filter;
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public void addFilter(Filter filter) {
        this.addFilter(filter, false);
    }

    public void addFilter(Filter filter, boolean bl) {
        if (bl) {
            try {
                filter.init((FilterConfig)this.mockFactory.getMockFilterConfig());
            }
            catch (Exception exception) {
                throw new NestedApplicationException(exception);
            }
        }
        this.mockFactory.getMockFilterChain().addFilter(filter);
    }

    public void releaseFilters() {
        this.mockFactory.getMockFilterChain().release();
        this.mockFactory.getMockFilterChain().setServlet((Servlet)this.servlet);
    }

    public void setDoChain(boolean bl) {
        this.doChain = bl;
    }

    public void doFilter() {
        try {
            this.mockFactory.getMockFilterChain().doFilter((ServletRequest)this.mockFactory.getWrappedRequest(), (ServletResponse)this.mockFactory.getWrappedResponse());
            this.mockFactory.getMockFilterChain().reset();
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public void init() {
        try {
            this.servlet.init((ServletConfig)this.mockFactory.getMockServletConfig());
        }
        catch (ServletException servletException) {
            throw new NestedApplicationException(servletException);
        }
    }

    public void doDelete() {
        this.mockFactory.getMockRequest().setMethod("DELETE");
        this.callService();
    }

    public void doGet() {
        this.mockFactory.getMockRequest().setMethod("GET");
        this.callService();
    }

    public void doOptions() {
        this.mockFactory.getMockRequest().setMethod("OPTIONS");
        this.callService();
    }

    public void doPost() {
        this.mockFactory.getMockRequest().setMethod("POST");
        this.callService();
    }

    public void doPut() {
        this.mockFactory.getMockRequest().setMethod("PUT");
        this.callService();
    }

    public void doTrace() {
        this.mockFactory.getMockRequest().setMethod("TRACE");
        this.callService();
    }

    public void doHead() {
        this.mockFactory.getMockRequest().setMethod("HEAD");
        this.callService();
    }

    public void service() {
        this.callService();
    }

    public ServletRequest getFilteredRequest() {
        return this.mockFactory.getMockFilterChain().getLastRequest();
    }

    public ServletResponse getFilteredResponse() {
        return this.mockFactory.getMockFilterChain().getLastResponse();
    }

    @Override
    public String getOutput() {
        try {
            this.mockFactory.getMockResponse().getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mockFactory.getMockResponse().getOutputStreamContent();
    }

    public void clearOutput() {
        this.mockFactory.getMockResponse().resetBuffer();
    }

    private void callService() {
        try {
            if (this.doChain) {
                this.doFilter();
            } else {
                this.servlet.service((ServletRequest)this.mockFactory.getWrappedRequest(), (ServletResponse)this.mockFactory.getWrappedResponse());
            }
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }
}

