/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.mock.web.MockActionMapping;
import com.mockrunner.mock.web.MockActionServlet;
import com.mockrunner.mock.web.MockModuleConfig;
import com.mockrunner.mock.web.WebMockObjectFactory;
import com.mockrunner.struts.ActionMappingProxyGenerator;
import org.apache.struts.action.ActionMapping;

public class ActionMockObjectFactory
extends WebMockObjectFactory {
    private MockActionMapping mockMapping;
    private ActionMapping mapping;
    private MockActionServlet mockActionServlet;
    private MockModuleConfig mockModuleConfig;

    public ActionMockObjectFactory() {
        this.createMockObjects();
    }

    public ActionMockObjectFactory(WebMockObjectFactory webMockObjectFactory) {
        super(webMockObjectFactory);
        this.createMockObjects();
    }

    public ActionMockObjectFactory(WebMockObjectFactory webMockObjectFactory, boolean bl) {
        super(webMockObjectFactory, bl);
        this.createMockObjects();
    }

    private void createMockObjects() {
        this.mockMapping = this.createMockActionMapping();
        this.mapping = this.mockMapping;
        this.mockModuleConfig = this.createMockModuleConfig();
        this.mockActionServlet = this.createMockActionServlet();
        this.mockActionServlet.setServletConfig(this.getMockServletConfig());
        this.mockActionServlet.setServletContext(this.getMockServletContext());
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.getWrappedRequest().setAttribute("org.apache.struts.action.mapping.instance", (Object)this.mapping);
        this.getWrappedRequest().setAttribute("org.apache.struts.action.MODULE", (Object)this.mockModuleConfig);
    }

    public MockActionServlet createMockActionServlet() {
        return new MockActionServlet();
    }

    public MockModuleConfig createMockModuleConfig() {
        return new MockModuleConfig("testmodule");
    }

    public MockActionMapping createMockActionMapping() {
        return new MockActionMapping();
    }

    public ActionMapping prepareActionMapping(Class clazz) {
        ActionMappingProxyGenerator actionMappingProxyGenerator = new ActionMappingProxyGenerator(this.mockMapping);
        this.mapping = actionMappingProxyGenerator.createActionMappingProxy(clazz);
        this.refresh();
        return this.mapping;
    }

    public void resetActionMapping() {
        this.mapping = this.mockMapping;
    }

    public ActionMapping getActionMapping() {
        return this.mapping;
    }

    public MockActionMapping getMockActionMapping() {
        return this.mockMapping;
    }

    public MockModuleConfig getMockModuleConfig() {
        return this.mockModuleConfig;
    }

    public MockActionServlet getMockActionServlet() {
        return this.mockActionServlet;
    }
}

