/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockQueue;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.activemq.filter.mockrunner.Filter;
import org.activemq.selector.mockrunner.SelectorParser;

public class MockQueueBrowser
implements QueueBrowser {
    private MockConnection connection;
    private MockQueue queue;
    private boolean closed;
    private String messageSelector;
    private Filter messageSelectorFilter;

    public MockQueueBrowser(MockConnection mockConnection, MockQueue mockQueue) {
        this(mockConnection, mockQueue, null);
    }

    public MockQueueBrowser(MockConnection mockConnection, MockQueue mockQueue, String string) {
        this.connection = mockConnection;
        this.queue = mockQueue;
        this.closed = false;
        this.messageSelector = string;
        this.parseMessageSelector();
    }

    private void parseMessageSelector() {
        if (null == this.messageSelector || this.messageSelector.length() == 0) {
            this.messageSelectorFilter = null;
        } else {
            try {
                this.messageSelectorFilter = new SelectorParser().parse(this.messageSelector);
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw new RuntimeException("Error parsing message selector: " + invalidSelectorException.getMessage());
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Queue getQueue() throws JMSException {
        this.connection.throwJMSException();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.connection.throwJMSException();
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.connection.throwJMSException();
        if (this.isClosed()) {
            throw new JMSException("Browser is closed");
        }
        return new Vector(this.getFilteredMessageList()).elements();
    }

    public void close() throws JMSException {
        this.connection.throwJMSException();
        this.closed = true;
    }

    private List getFilteredMessageList() {
        List list = this.queue.getCurrentMessageList();
        if (null == this.messageSelectorFilter) {
            return list;
        }
        if (!this.connection.getConfigurationManager().getUseMessageSelectors()) {
            return list;
        }
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (int i = 0; i < list.size(); ++i) {
            Message message = (Message)list.get(i);
            try {
                if (!this.messageSelectorFilter.matches(message)) continue;
                arrayList.add(message);
                continue;
            }
            catch (JMSException jMSException) {
                throw new RuntimeException(jMSException.getMessage());
            }
        }
        return arrayList;
    }
}

