/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockDestination;
import com.mockrunner.mock.jms.MockQueueReceiver;
import com.mockrunner.mock.jms.MockSession;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;

public class MockQueue
extends MockDestination
implements Queue {
    private String name;

    public MockQueue(String string) {
        this.name = string;
    }

    public String getQueueName() throws JMSException {
        return this.name;
    }

    @Override
    public void addMessage(Message message) throws JMSException {
        this.addReceivedMessage(message);
        boolean bl = false;
        Iterator iterator = this.sessionSet().iterator();
        while (iterator.hasNext() && !bl) {
            MockSession mockSession = (MockSession)iterator.next();
            MessageListener messageListener = mockSession.getMessageListener();
            if (null != messageListener) {
                messageListener.onMessage(message);
                bl = true;
                this.acknowledgeMessage(message, mockSession);
                continue;
            }
            List list = mockSession.getQueueTransmissionManager().getQueueReceiverList(this.name);
            for (int i = 0; i < list.size() && !bl; ++i) {
                MockQueueReceiver mockQueueReceiver = (MockQueueReceiver)list.get(i);
                if (!mockQueueReceiver.canConsume(message)) continue;
                mockQueueReceiver.receiveMessage(message);
                bl = true;
                this.acknowledgeMessage(message, mockSession);
            }
        }
        if (!bl) {
            this.addCurrentMessage(message);
        }
    }
}

