/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.mock.jdbc.MockDriver;
import com.mockrunner.mock.jdbc.PolyResultSet;
import com.mockrunner.util.common.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MockDatabaseMetaData
implements DatabaseMetaData {
    private boolean caseSensitive = false;
    private int databaseMajorVersion = 1;
    private int databaseMinorVersion = 0;
    private int defaultTransactionLevel = 2;
    private int driverMajorVersion = 1;
    private int driverMinorVersion = 0;
    private int jdbcMajorVersion = 3;
    private int jdbcMinorVersion = 0;
    private int maxBinaryLiteralLength = 0;
    private int maxCatalogNameLength = 0;
    private int maxCharLiteralLength = 0;
    private int maxColumnNameLength = 0;
    private int maxColumnsInGroupBy = 0;
    private int maxColumnsInIndex = 0;
    private int maxColumnsInOrderBy = 0;
    private int maxColumnsInSelect = 0;
    private int maxColumnsInTable = 0;
    private int maxConnections = 0;
    private int maxCursorNameLength = 0;
    private int maxIndexLength = 0;
    private int maxProcedureNameLength = 0;
    private int maxRowSize = 0;
    private int maxSchemaNameLength = 0;
    private int maxStatementLength = 0;
    private int maxStatements = 0;
    private int maxTableNameLength = 0;
    private int maxTablesInSelect = 0;
    private int maxUserNameLength = 0;
    private int resultSetHoldability = 1;
    private int sqlStateType = 2;
    private RowIdLifetime rowIdLifetime = RowIdLifetime.ROWID_VALID_TRANSACTION;
    private boolean autoCommitFailureClosesAllResultSets = false;
    private boolean allProceduresAreCallable = true;
    private boolean allTablesAreSelectable = true;
    private boolean dataDefinitionCausesTransactionCommit = false;
    private boolean dataDefinitionIgnoredInTransactions = false;
    private boolean doesMaxRowSizeIncludeBlobs = false;
    private boolean isCatalogAtStart = false;
    private boolean isReadOnly = false;
    private boolean locatorsUpdateCopy = false;
    private boolean nullPlusNonNullIsNull = false;
    private boolean nullsAreSortedAtEnd = false;
    private boolean nullsAreSortedAtStart = false;
    private boolean nullsAreSortedHigh = false;
    private boolean nullsAreSortedLow = false;
    private boolean storesLowerCaseIdentifiers = true;
    private boolean storesLowerCaseQuotedIdentifiers = true;
    private boolean storesMixedCaseIdentifiers = true;
    private boolean storesMixedCaseQuotedIdentifiers = true;
    private boolean storesUpperCaseIdentifiers = true;
    private boolean storesUpperCaseQuotedIdentifiers = true;
    private boolean supportsANSI92EntryLevelSQL = true;
    private boolean supportsANSI92FullSQL = true;
    private boolean supportsANSI92IntermediateSQL = true;
    private boolean supportsAlterTableWithAddColumn = true;
    private boolean supportsAlterTableWithDropColumn = true;
    private boolean supportsBatchUpdates = true;
    private boolean supportsCatalogsInDataManipulation = true;
    private boolean supportsCatalogsInIndexDefinitions = true;
    private boolean supportsCatalogsInPrivilegeDefinitions = true;
    private boolean supportsCatalogsInProcedureCalls = true;
    private boolean supportsCatalogsInTableDefinitions = true;
    private boolean supportsColumnAliasing = true;
    private boolean supportsConvert = true;
    private boolean supportsCoreSQLGrammar = true;
    private boolean supportsCorrelatedSubqueries = true;
    private boolean supportsDataDefinitionAndDataManipulationTransactions = true;
    private boolean supportsDataManipulationTransactionsOnly = false;
    private boolean supportsDifferentTableCorrelationNames;
    private boolean supportsExpressionsInOrderBy = true;
    private boolean supportsExtendedSQLGrammar = true;
    private boolean supportsFullOuterJoins = true;
    private boolean supportsGetGeneratedKeys = true;
    private boolean supportsGroupBy = true;
    private boolean supportsGroupByBeyondSelect = true;
    private boolean supportsGroupByUnrelated = true;
    private boolean supportsIntegrityEnhancementFacility = true;
    private boolean supportsLikeEscapeClause = true;
    private boolean supportsLimitedOuterJoins = true;
    private boolean supportsMinimumSQLGrammar = true;
    private boolean supportsMixedCaseIdentifiers = true;
    private boolean supportsMixedCaseQuotedIdentifiers = true;
    private boolean supportsMultipleOpenResults = true;
    private boolean supportsMultipleResultSets = true;
    private boolean supportsMultipleTransactions = true;
    private boolean supportsNamedParameters = true;
    private boolean supportsNonNullableColumns = true;
    private boolean supportsOpenCursorsAcrossCommit = true;
    private boolean supportsOpenCursorsAcrossRollback = true;
    private boolean supportsOpenStatementsAcrossCommit = true;
    private boolean supportsOpenStatementsAcrossRollback = true;
    private boolean supportsOrderByUnrelated = true;
    private boolean supportsOuterJoins = true;
    private boolean supportsPositionedDelete = true;
    private boolean supportsPositionedUpdate = true;
    private boolean supportsSavepoints = true;
    private boolean supportsSchemasInDataManipulation = true;
    private boolean supportsSchemasInIndexDefinitions = true;
    private boolean supportsSchemasInPrivilegeDefinitions = true;
    private boolean supportsSchemasInProcedureCalls = true;
    private boolean supportsSchemasInTableDefinitions = true;
    private boolean supportsSelectForUpdate = true;
    private boolean supportsStatementPooling = true;
    private boolean supportsStoredProcedures = true;
    private boolean supportsSubqueriesInComparisons = true;
    private boolean supportsSubqueriesInExists = true;
    private boolean supportsSubqueriesInIns = true;
    private boolean supportsSubqueriesInQuantifieds = true;
    private boolean supportsTableCorrelationNames = true;
    private boolean supportsTransactions = true;
    private boolean supportsUnion = true;
    private boolean supportsUnionAll = true;
    private boolean usesLocalFilePerTable = false;
    private boolean usesLocalFiles = true;
    private boolean deletesAreDetected = true;
    private boolean insertsAreDetected = true;
    private boolean othersDeletesAreVisible = true;
    private boolean othersInsertsAreVisible = true;
    private boolean othersUpdatesAreVisible = true;
    private boolean ownDeletesAreVisible = true;
    private boolean ownInsertsAreVisible = true;
    private boolean ownUpdatesAreVisible = true;
    private boolean supportsResultSetHoldability = true;
    private boolean supportsResultSetType = true;
    private boolean supportsTransactionIsolationLevel = true;
    private boolean updatesAreDetected = true;
    private boolean supportsResultSetConcurrency = true;
    private boolean supportsStoredFunctionsUsingCallSyntax = true;
    private String catalogSeparator = ".";
    private String catalogTerm = "database";
    private String databaseProductName = "MockDatabase";
    private String databaseProductVersion = "1.0";
    private String driverName = MockDriver.class.getName();
    private String driverVersion = "1.0";
    private String extraNameCharacters = "";
    private String identifierQuoteString = " ";
    private String numericFunctions = "";
    private String procedureTerm = "";
    private String sqlKeywords = "";
    private String schemaTerm = "";
    private String searchStringEscape = "\\";
    private String stringFunctions = "";
    private String systemFunctions = "";
    private String timeDateFunctions = "";
    private String url;
    private String userName;
    private Connection connection;
    private ResultSet catalogs;
    private ResultSet tableTypes;
    private ResultSet typeInfo;
    private ResultSet clientInfoProperties;
    private Map schemasMap = new HashMap();
    private Map exportedKeysMap = new HashMap();
    private Map importedKeysMap = new HashMap();
    private Map primaryKeysMap = new HashMap();
    private Map proceduresMap = new HashMap();
    private Map functionsMap = new HashMap();
    private Map superTablesMap = new HashMap();
    private Map superTypesMap = new HashMap();
    private Map tablePrivilegesMap = new HashMap();
    private Map versionColumnsMap = new HashMap();
    private Map bestRowIdentifierMap = new HashMap();
    private Map indexInfoMap = new HashMap();
    private Map udtsMap = new HashMap();
    private Map attributesMap = new HashMap();
    private Map columnPrivilegesMap = new HashMap();
    private Map columnsMap = new HashMap();
    private Map procedureColumnsMap = new HashMap();
    private Map functionColumnsMap = new HashMap();
    private Map tablesMap = new HashMap();
    private Map crossReferenceMap = new HashMap();

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.databaseMajorVersion;
    }

    public void setDatabaseMajorVersion(int n) {
        this.databaseMajorVersion = n;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.databaseMinorVersion;
    }

    public void setDatabaseMinorVersion(int n) {
        this.databaseMinorVersion = n;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.defaultTransactionLevel;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.defaultTransactionLevel = n;
    }

    @Override
    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public void setDriverMajorVersion(int n) {
        this.driverMajorVersion = n;
    }

    @Override
    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public void setDriverMinorVersion(int n) {
        this.driverMinorVersion = n;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return this.jdbcMajorVersion;
    }

    public void setJDBCMajorVersion(int n) {
        this.jdbcMajorVersion = n;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return this.jdbcMinorVersion;
    }

    public void setJDBCMinorVersion(int n) {
        this.jdbcMinorVersion = n;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.maxBinaryLiteralLength;
    }

    public void setMaxBinaryLiteralLength(int n) {
        this.maxBinaryLiteralLength = n;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.maxCatalogNameLength;
    }

    public void setetMaxCatalogNameLength(int n) {
        this.maxCatalogNameLength = n;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.maxCharLiteralLength;
    }

    public void setMaxCharLiteralLength(int n) {
        this.maxCharLiteralLength = n;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.maxColumnNameLength;
    }

    public void setMaxColumnNameLength(int n) {
        this.maxColumnNameLength = n;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.maxColumnsInGroupBy;
    }

    public void setMaxColumnsInGroupBy(int n) {
        this.maxColumnsInGroupBy = n;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.maxColumnsInIndex;
    }

    public void setMaxColumnsInIndex(int n) {
        this.maxColumnsInIndex = n;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.maxColumnsInOrderBy;
    }

    public void setMaxColumnsInOrderBy(int n) {
        this.maxColumnsInOrderBy = n;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.maxColumnsInSelect;
    }

    public void setMaxColumnsInSelect(int n) {
        this.maxColumnsInSelect = n;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.maxColumnsInTable;
    }

    public void setMaxColumnsInTable(int n) {
        this.maxColumnsInTable = n;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.maxConnections;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.maxCursorNameLength;
    }

    public void setMaxCursorNameLength(int n) {
        this.maxCursorNameLength = n;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.maxIndexLength;
    }

    public void setMaxIndexLength(int n) {
        this.maxIndexLength = n;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.maxProcedureNameLength;
    }

    public void setMaxProcedureNameLength(int n) {
        this.maxProcedureNameLength = n;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.maxRowSize;
    }

    public void setMaxRowSize(int n) {
        this.maxRowSize = n;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.maxSchemaNameLength;
    }

    public void setMaxSchemaNameLength(int n) {
        this.maxSchemaNameLength = n;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.maxStatementLength;
    }

    public void setMaxStatementLength(int n) {
        this.maxStatementLength = n;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.maxStatements;
    }

    public void setMaxStatements(int n) {
        this.maxStatements = n;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.maxTableNameLength;
    }

    public void setMaxTableNameLength(int n) {
        this.maxTableNameLength = n;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.maxTablesInSelect;
    }

    public void setMaxTablesInSelect(int n) {
        this.maxTablesInSelect = n;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.maxUserNameLength;
    }

    public void setMaxUserNameLength(int n) {
        this.maxUserNameLength = n;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int n) {
        this.resultSetHoldability = n;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return this.sqlStateType;
    }

    public void setSQLStateType(int n) {
        this.sqlStateType = n;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return this.rowIdLifetime;
    }

    public void setRowIdLifetime(RowIdLifetime rowIdLifetime) {
        this.rowIdLifetime = rowIdLifetime;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return this.autoCommitFailureClosesAllResultSets;
    }

    public void setAutoCommitFailureClosesAllResultSets(boolean bl) {
        this.autoCommitFailureClosesAllResultSets = bl;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.allProceduresAreCallable;
    }

    public void setAllProceduresAreCallable(boolean bl) {
        this.allProceduresAreCallable = bl;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.allTablesAreSelectable;
    }

    public void setAllTablesAreSelectable(boolean bl) {
        this.allTablesAreSelectable = bl;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.dataDefinitionCausesTransactionCommit;
    }

    public void setDataDefinitionCausesTransactionCommit(boolean bl) {
        this.dataDefinitionCausesTransactionCommit = bl;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.dataDefinitionIgnoredInTransactions;
    }

    public void setDataDefinitionIgnoredInTransactions(boolean bl) {
        this.dataDefinitionIgnoredInTransactions = bl;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.doesMaxRowSizeIncludeBlobs;
    }

    public void setDoesMaxRowSizeIncludeBlobs(boolean bl) {
        this.doesMaxRowSizeIncludeBlobs = bl;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.isCatalogAtStart;
    }

    public void setIsCatalogAtStart(boolean bl) {
        this.isCatalogAtStart = bl;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.isReadOnly;
    }

    public void setIsReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return this.locatorsUpdateCopy;
    }

    public void setLocatorsUpdateCopy(boolean bl) {
        this.locatorsUpdateCopy = bl;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.nullPlusNonNullIsNull;
    }

    public void setNullPlusNonNullIsNull(boolean bl) {
        this.nullPlusNonNullIsNull = bl;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.nullsAreSortedAtEnd;
    }

    public void setNullsAreSortedAtEnd(boolean bl) {
        this.nullsAreSortedAtEnd = bl;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.nullsAreSortedAtStart;
    }

    public void setNullsAreSortedAtStart(boolean bl) {
        this.nullsAreSortedAtStart = bl;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.nullsAreSortedHigh;
    }

    public void setNullsAreSortedHigh(boolean bl) {
        this.nullsAreSortedHigh = bl;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.nullsAreSortedLow;
    }

    public void setNullsAreSortedLow(boolean bl) {
        this.nullsAreSortedLow = bl;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.storesLowerCaseIdentifiers;
    }

    public void setStoresLowerCaseIdentifiers(boolean bl) {
        this.storesLowerCaseIdentifiers = bl;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.storesLowerCaseQuotedIdentifiers;
    }

    public void setStoresLowerCaseQuotedIdentifiers(boolean bl) {
        this.storesLowerCaseQuotedIdentifiers = bl;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.storesMixedCaseIdentifiers;
    }

    public void setStoresMixedCaseIdentifiers(boolean bl) {
        this.storesMixedCaseIdentifiers = bl;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.storesMixedCaseQuotedIdentifiers;
    }

    public void setStoresMixedCaseQuotedIdentifiers(boolean bl) {
        this.storesMixedCaseQuotedIdentifiers = bl;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.storesUpperCaseIdentifiers;
    }

    public void setStoresUpperCaseIdentifiers(boolean bl) {
        this.storesUpperCaseIdentifiers = bl;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.storesUpperCaseQuotedIdentifiers;
    }

    public void setStoresUpperCaseQuotedIdentifiers(boolean bl) {
        this.storesUpperCaseQuotedIdentifiers = bl;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return this.supportsANSI92EntryLevelSQL;
    }

    public void setSupportsANSI92EntryLevelSQL(boolean bl) {
        this.supportsANSI92EntryLevelSQL = bl;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return this.supportsANSI92FullSQL;
    }

    public void setSupportsANSI92FullSQL(boolean bl) {
        this.supportsANSI92FullSQL = bl;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return this.supportsANSI92IntermediateSQL;
    }

    public void setSupportsANSI92IntermediateSQL(boolean bl) {
        this.supportsANSI92IntermediateSQL = bl;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.supportsAlterTableWithAddColumn;
    }

    public void setSupportsAlterTableWithAddColumn(boolean bl) {
        this.supportsAlterTableWithAddColumn = bl;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.supportsAlterTableWithDropColumn;
    }

    public void setSupportsAlterTableWithDropColumn(boolean bl) {
        this.supportsAlterTableWithDropColumn = bl;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return this.supportsBatchUpdates;
    }

    public void setSupportsBatchUpdates(boolean bl) {
        this.supportsBatchUpdates = bl;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.supportsCatalogsInDataManipulation;
    }

    public void setSupportsCatalogsInDataManipulation(boolean bl) {
        this.supportsCatalogsInDataManipulation = bl;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.supportsCatalogsInIndexDefinitions;
    }

    public void setSupportsCatalogsInIndexDefinitions(boolean bl) {
        this.supportsCatalogsInIndexDefinitions = bl;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.supportsCatalogsInPrivilegeDefinitions;
    }

    public void setSupportsCatalogsInPrivilegeDefinitions(boolean bl) {
        this.supportsCatalogsInPrivilegeDefinitions = bl;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.supportsCatalogsInProcedureCalls;
    }

    public void setSupportsCatalogsInProcedureCalls(boolean bl) {
        this.supportsCatalogsInProcedureCalls = bl;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.supportsCatalogsInTableDefinitions;
    }

    public void setSupportsCatalogsInTableDefinitions(boolean bl) {
        this.supportsCatalogsInTableDefinitions = bl;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return this.supportsColumnAliasing;
    }

    public void setSupportsColumnAliasing(boolean bl) {
        this.supportsColumnAliasing = bl;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return this.supportsConvert;
    }

    public void setSupportsConvert(boolean bl) {
        this.supportsConvert = bl;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.supportsCoreSQLGrammar;
    }

    public void setSupportsCoreSQLGrammar(boolean bl) {
        this.supportsCoreSQLGrammar = bl;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.supportsCorrelatedSubqueries;
    }

    public void setSupportsCorrelatedSubqueries(boolean bl) {
        this.supportsCorrelatedSubqueries = bl;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.supportsDataDefinitionAndDataManipulationTransactions;
    }

    public void setSupportsDataDefinitionAndDataManipulationTransactions(boolean bl) {
        this.supportsDataDefinitionAndDataManipulationTransactions = bl;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.supportsDataManipulationTransactionsOnly;
    }

    public void setSupportsDataManipulationTransactionsOnly(boolean bl) {
        this.supportsDataManipulationTransactionsOnly = bl;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.supportsDifferentTableCorrelationNames;
    }

    public void setSupportsDifferentTableCorrelationNames(boolean bl) {
        this.supportsDifferentTableCorrelationNames = bl;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.supportsExpressionsInOrderBy;
    }

    public void setSupportsExpressionsInOrderBy(boolean bl) {
        this.supportsExpressionsInOrderBy = bl;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.supportsExtendedSQLGrammar;
    }

    public void setSupportsExtendedSQLGrammar(boolean bl) {
        this.supportsExtendedSQLGrammar = bl;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.supportsFullOuterJoins;
    }

    public void setSupportsFullOuterJoins(boolean bl) {
        this.supportsFullOuterJoins = bl;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return this.supportsGetGeneratedKeys;
    }

    public void setSupportsGetGeneratedKeys(boolean bl) {
        this.supportsGetGeneratedKeys = bl;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return this.supportsGroupBy;
    }

    public void setSupportsGroupBy(boolean bl) {
        this.supportsGroupBy = bl;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.supportsGroupByBeyondSelect;
    }

    public void setSupportsGroupByBeyondSelect(boolean bl) {
        this.supportsGroupByBeyondSelect = bl;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.supportsGroupByUnrelated;
    }

    public void setSupportsGroupByUnrelated(boolean bl) {
        this.supportsGroupByUnrelated = bl;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.supportsIntegrityEnhancementFacility;
    }

    public void setSupportsIntegrityEnhancementFacility(boolean bl) {
        this.supportsIntegrityEnhancementFacility = bl;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.supportsLikeEscapeClause;
    }

    public void setSupportsLikeEscapeClause(boolean bl) {
        this.supportsLikeEscapeClause = bl;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return this.supportsLimitedOuterJoins;
    }

    public void setSupportsLimitedOuterJoins(boolean bl) {
        this.supportsLimitedOuterJoins = bl;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.supportsMinimumSQLGrammar;
    }

    public void setSupportsMinimumSQLGrammar(boolean bl) {
        this.supportsMinimumSQLGrammar = bl;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.supportsMixedCaseIdentifiers;
    }

    public void setSupportsMixedCaseIdentifiers(boolean bl) {
        this.supportsMixedCaseIdentifiers = bl;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.supportsMixedCaseQuotedIdentifiers;
    }

    public void setSupportsMixedCaseQuotedIdentifiers(boolean bl) {
        this.supportsMixedCaseQuotedIdentifiers = bl;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return this.supportsMultipleOpenResults;
    }

    public void setSupportsMultipleOpenResults(boolean bl) {
        this.supportsMultipleOpenResults = bl;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return this.supportsMultipleResultSets;
    }

    public void setSupportsMultipleResultSets(boolean bl) {
        this.supportsMultipleResultSets = bl;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return this.supportsMultipleTransactions;
    }

    public void setSupportsMultipleTransactions(boolean bl) {
        this.supportsMultipleTransactions = bl;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return this.supportsNamedParameters;
    }

    public void setSupportsNamedParameters(boolean bl) {
        this.supportsNamedParameters = bl;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return this.supportsNonNullableColumns;
    }

    public void setSupportsNonNullableColumns(boolean bl) {
        this.supportsNonNullableColumns = bl;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.supportsOpenCursorsAcrossCommit;
    }

    public void setSupportsOpenCursorsAcrossCommit(boolean bl) {
        this.supportsOpenCursorsAcrossCommit = bl;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.supportsOpenCursorsAcrossRollback;
    }

    public void setSupportsOpenCursorsAcrossRollback(boolean bl) {
        this.supportsOpenCursorsAcrossRollback = bl;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.supportsOpenStatementsAcrossCommit;
    }

    public void setSupportsOpenStatementsAcrossCommit(boolean bl) {
        this.supportsOpenStatementsAcrossCommit = bl;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.supportsOpenStatementsAcrossRollback;
    }

    public void setSupportsOpenStatementsAcrossRollback(boolean bl) {
        this.supportsOpenStatementsAcrossRollback = bl;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.supportsOrderByUnrelated;
    }

    public void setSupportsOrderByUnrelated(boolean bl) {
        this.supportsOrderByUnrelated = bl;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return this.supportsOuterJoins;
    }

    public void setSupportsOuterJoins(boolean bl) {
        this.supportsOuterJoins = bl;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return this.supportsPositionedDelete;
    }

    public void setSupportsPositionedDelete(boolean bl) {
        this.supportsPositionedDelete = bl;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return this.supportsPositionedUpdate;
    }

    public void setSupportsPositionedUpdate(boolean bl) {
        this.supportsPositionedUpdate = bl;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.supportsSavepoints;
    }

    public void setSupportsSavepoints(boolean bl) {
        this.supportsSavepoints = bl;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.supportsSchemasInDataManipulation;
    }

    public void setSupportsSchemasInDataManipulation(boolean bl) {
        this.supportsSchemasInDataManipulation = bl;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.supportsSchemasInIndexDefinitions;
    }

    public void setSupportsSchemasInIndexDefinitions(boolean bl) {
        this.supportsSchemasInIndexDefinitions = bl;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.supportsSchemasInPrivilegeDefinitions;
    }

    public void setSupportsSchemasInPrivilegeDefinitions(boolean bl) {
        this.supportsSchemasInPrivilegeDefinitions = bl;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.supportsSchemasInProcedureCalls;
    }

    public void setSupportsSchemasInProcedureCalls(boolean bl) {
        this.supportsSchemasInProcedureCalls = bl;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.supportsSchemasInTableDefinitions;
    }

    public void setSupportsSchemasInTableDefinitions(boolean bl) {
        this.supportsSchemasInTableDefinitions = bl;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return this.supportsSelectForUpdate;
    }

    public void setSupportsSelectForUpdate(boolean bl) {
        this.supportsSelectForUpdate = bl;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return this.supportsStatementPooling;
    }

    public void setSupportsStatementPooling(boolean bl) {
        this.supportsStatementPooling = bl;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.supportsStoredProcedures;
    }

    public void setSupportsStoredProcedures(boolean bl) {
        this.supportsStoredProcedures = bl;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.supportsSubqueriesInComparisons;
    }

    public void setSupportsSubqueriesInComparisons(boolean bl) {
        this.supportsSubqueriesInComparisons = bl;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.supportsSubqueriesInExists;
    }

    public void setSupportsSubqueriesInExists(boolean bl) {
        this.supportsSubqueriesInExists = bl;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.supportsSubqueriesInIns;
    }

    public void setSupportsSubqueriesInIns(boolean bl) {
        this.supportsSubqueriesInIns = bl;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.supportsSubqueriesInQuantifieds;
    }

    public void setSupportsSubqueriesInQuantifieds(boolean bl) {
        this.supportsSubqueriesInQuantifieds = bl;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.supportsTableCorrelationNames;
    }

    public void setSupportsTableCorrelationNames(boolean bl) {
        this.supportsTableCorrelationNames = bl;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.supportsTransactions;
    }

    public void setSupportsTransactions(boolean bl) {
        this.supportsTransactions = bl;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return this.supportsUnion;
    }

    public void setSupportsUnion(boolean bl) {
        this.supportsUnion = bl;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return this.supportsUnionAll;
    }

    public void setSupportsUnionAll(boolean bl) {
        this.supportsUnionAll = bl;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.usesLocalFilePerTable;
    }

    public void setUsesLocalFilePerTable(boolean bl) {
        this.usesLocalFilePerTable = bl;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.usesLocalFiles;
    }

    public void setUsesLocalFiles(boolean bl) {
        this.usesLocalFiles = bl;
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        return this.deletesAreDetected;
    }

    public void setDeletesAreDetected(boolean bl) {
        this.deletesAreDetected = bl;
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        return this.insertsAreDetected;
    }

    public void setInsertsAreDetected(boolean bl) {
        this.insertsAreDetected = bl;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return this.othersDeletesAreVisible;
    }

    public void setOthersDeletesAreVisible(boolean bl) {
        this.othersDeletesAreVisible = bl;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return this.othersInsertsAreVisible;
    }

    public void setOthersInsertsAreVisible(boolean bl) {
        this.othersInsertsAreVisible = bl;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return this.othersUpdatesAreVisible;
    }

    public void setOthersUpdatesAreVisible(boolean bl) {
        this.othersUpdatesAreVisible = bl;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return this.ownDeletesAreVisible;
    }

    public void setOwnDeletesAreVisible(boolean bl) {
        this.ownDeletesAreVisible = bl;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return this.ownInsertsAreVisible;
    }

    public void setOwnInsertsAreVisible(boolean bl) {
        this.ownInsertsAreVisible = bl;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return this.ownUpdatesAreVisible;
    }

    public void setOwnUpdatesAreVisible(boolean bl) {
        this.ownUpdatesAreVisible = bl;
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return this.supportsResultSetHoldability;
    }

    public void setSupportsResultSetHoldability(boolean bl) {
        this.supportsResultSetHoldability = bl;
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        return this.supportsResultSetType;
    }

    public void setSupportsResultSetType(boolean bl) {
        this.supportsResultSetType = bl;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return this.supportsTransactionIsolationLevel;
    }

    public void setSupportsTransactionIsolationLevel(boolean bl) {
        this.supportsTransactionIsolationLevel = bl;
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        return this.updatesAreDetected;
    }

    public void setUpdatesAreDetected(boolean bl) {
        this.updatesAreDetected = bl;
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        return this.supportsConvert;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return this.supportsResultSetConcurrency;
    }

    public void setSupportsResultSetConcurrency(boolean bl) {
        this.supportsResultSetConcurrency = bl;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return this.supportsStoredFunctionsUsingCallSyntax;
    }

    public void setSupportsStoredFunctionsUsingCallSyntax(boolean bl) {
        this.supportsStoredFunctionsUsingCallSyntax = bl;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return this.catalogSeparator;
    }

    public void setCatalogSeparator(String string) {
        this.catalogSeparator = string;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.catalogTerm;
    }

    public void setCatalogTerm(String string) {
        this.catalogTerm = string;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String string) {
        this.databaseProductName = string;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String string) {
        this.databaseProductVersion = string;
    }

    @Override
    public String getDriverName() throws SQLException {
        return this.driverName;
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.driverVersion;
    }

    public void setDriverVersion(String string) {
        this.driverVersion = string;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return this.extraNameCharacters;
    }

    public void setExtraNameCharacters(String string) {
        this.extraNameCharacters = string;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.identifierQuoteString;
    }

    public void setIdentifierQuoteString(String string) {
        this.identifierQuoteString = string;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.numericFunctions;
    }

    public void setNumericFunctions(String string) {
        this.numericFunctions = string;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return this.procedureTerm;
    }

    public void setProcedureTerm(String string) {
        this.procedureTerm = string;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.sqlKeywords;
    }

    public void setSQLKeywords(String string) {
        this.sqlKeywords = string;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.schemaTerm;
    }

    public void setSchemaTerm(String string) {
        this.schemaTerm = string;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return this.searchStringEscape;
    }

    public void setSearchStringEscape(String string) {
        this.searchStringEscape = string;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.stringFunctions;
    }

    public void setStringFunctions(String string) {
        this.stringFunctions = string;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.systemFunctions;
    }

    public void setSystemFunctions(String string) {
        this.systemFunctions = string;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.timeDateFunctions;
    }

    public void setTimeDateFunctions(String string) {
        this.timeDateFunctions = string;
    }

    @Override
    public String getURL() throws SQLException {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    @Override
    public String getUserName() throws SQLException {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.catalogs;
    }

    public void setCatalogs(ResultSet resultSet) {
        this.catalogs = resultSet;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getAll(this.schemasMap);
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, "", true, false);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImpl, this.schemasMap);
    }

    public void setSchemas(ResultSet resultSet) {
        this.schemasMap.put(new DatabaseIdentifierImpl(), resultSet);
    }

    public void setSchemas(String string, String string2, ResultSet resultSet) {
        this.schemasMap.put(new DatabaseIdentifierImpl(string, string2, ""), resultSet);
    }

    public void clearSchemas() {
        this.schemasMap.clear();
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.tableTypes;
    }

    public void setTableTypes(ResultSet resultSet) {
        this.tableTypes = resultSet;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.typeInfo;
    }

    public void setTypeInfo(ResultSet resultSet) {
        this.typeInfo = resultSet;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.clientInfoProperties;
    }

    public void setClientInfoProperties(ResultSet resultSet) {
        this.clientInfoProperties = resultSet;
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImpl, this.exportedKeysMap);
    }

    public void setExportedKeys(ResultSet resultSet) {
        this.exportedKeysMap.put(new DatabaseIdentifierImpl(), resultSet);
    }

    public void setExportedKeys(String string, String string2, String string3, ResultSet resultSet) {
        this.exportedKeysMap.put(new DatabaseIdentifierImpl(string, string2, string3), resultSet);
    }

    public void clearExportedKeys() {
        this.exportedKeysMap.clear();
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImpl, this.importedKeysMap);
    }

    public void setImportedKeys(ResultSet resultSet) {
        this.importedKeysMap.put(new DatabaseIdentifierImpl(), resultSet);
    }

    public void setImportedKeys(String string, String string2, String string3, ResultSet resultSet) {
        this.importedKeysMap.put(new DatabaseIdentifierImpl(string, string2, string3), resultSet);
    }

    public void clearImportedKeys() {
        this.importedKeysMap.clear();
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImpl, this.primaryKeysMap);
    }

    public void setPrimaryKeys(ResultSet resultSet) {
        this.primaryKeysMap.put(new DatabaseIdentifierImpl(), resultSet);
    }

    public void setPrimaryKeys(String string, String string2, String string3, ResultSet resultSet) {
        this.primaryKeysMap.put(new DatabaseIdentifierImpl(string, string2, string3), resultSet);
    }

    public void clearPrimaryKeys() {
        this.primaryKeysMap.clear();
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3, true, true);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImpl, this.proceduresMap);
    }

    public void setProcedures(ResultSet resultSet) {
        this.proceduresMap.put(new DatabaseIdentifierImpl(), resultSet);
    }

    public void setProcedures(String string, String string2, String string3, ResultSet resultSet) {
        this.proceduresMap.put(new DatabaseIdentifierImpl(string, string2, string3), resultSet);
    }

    public void clearProcedures() {
        this.proceduresMap.clear();
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3, true, true);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImpl, this.functionsMap);
    }

    public void setFunctions(ResultSet resultSet) {
        this.functionsMap.put(new DatabaseIdentifierImpl(), resultSet);
    }

    public void setFunctions(String string, String string2, String string3, ResultSet resultSet) {
        this.functionsMap.put(new DatabaseIdentifierImpl(string, string2, string3), resultSet);
    }

    public void clearFunctions() {
        this.functionsMap.clear();
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3, true, true);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImpl, this.superTablesMap);
    }

    public void setSuperTables(ResultSet resultSet) {
        this.superTablesMap.put(new DatabaseIdentifierImpl(), resultSet);
    }

    public void setSuperTables(String string, String string2, String string3, ResultSet resultSet) {
        this.superTablesMap.put(new DatabaseIdentifierImpl(string, string2, string3), resultSet);
    }

    public void clearSuperTables() {
        this.superTablesMap.clear();
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3, true, true);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImpl, this.superTypesMap);
    }

    public void setSuperTypes(ResultSet resultSet) {
        this.superTypesMap.put(new DatabaseIdentifierImpl(), resultSet);
    }

    public void setSuperTypes(String string, String string2, String string3, ResultSet resultSet) {
        this.superTypesMap.put(new DatabaseIdentifierImpl(string, string2, string3), resultSet);
    }

    public void clearSuperTypes() {
        this.superTypesMap.clear();
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3, true, true);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImpl, this.tablePrivilegesMap);
    }

    public void setTablePrivileges(ResultSet resultSet) {
        this.tablePrivilegesMap.put(new DatabaseIdentifierImpl(), resultSet);
    }

    public void setTablePrivileges(String string, String string2, String string3, ResultSet resultSet) {
        this.tablePrivilegesMap.put(new DatabaseIdentifierImpl(string, string2, string3), resultSet);
    }

    public void clearTablePrivileges() {
        this.tablePrivilegesMap.clear();
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImpl, this.versionColumnsMap);
    }

    public void setVersionColumns(ResultSet resultSet) {
        this.versionColumnsMap.put(new DatabaseIdentifierImpl(), resultSet);
    }

    public void setVersionColumns(String string, String string2, String string3, ResultSet resultSet) {
        this.versionColumnsMap.put(new DatabaseIdentifierImpl(string, string2, string3), resultSet);
    }

    public void clearVersionColumns() {
        this.versionColumnsMap.clear();
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        RowIdentifierDatabaseIdentifierImpl rowIdentifierDatabaseIdentifierImpl = new RowIdentifierDatabaseIdentifierImpl(string, string2, string3, n, bl);
        return this.findMatchingDatabaseIdentifier(rowIdentifierDatabaseIdentifierImpl, this.bestRowIdentifierMap);
    }

    public void setBestRowIdentifier(ResultSet resultSet) {
        this.bestRowIdentifierMap.put(new RowIdentifierDatabaseIdentifierImpl(), resultSet);
    }

    public void setBestRowIdentifier(String string, String string2, String string3, int n, boolean bl, ResultSet resultSet) {
        this.bestRowIdentifierMap.put(new RowIdentifierDatabaseIdentifierImpl(string, string2, string3, n, bl), resultSet);
    }

    public void clearBestRowIdentifier() {
        this.bestRowIdentifierMap.clear();
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        IndexInfoDatabaseIdentifierImpl indexInfoDatabaseIdentifierImpl = new IndexInfoDatabaseIdentifierImpl(string, string2, string3, bl, bl2);
        return this.findMatchingDatabaseIdentifier(indexInfoDatabaseIdentifierImpl, this.indexInfoMap);
    }

    public void setIndexInfo(ResultSet resultSet) {
        this.indexInfoMap.put(new IndexInfoDatabaseIdentifierImpl(), resultSet);
    }

    public void setIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2, ResultSet resultSet) {
        this.indexInfoMap.put(new IndexInfoDatabaseIdentifierImpl(string, string2, string3, bl, bl2), resultSet);
    }

    public void clearIndexInfo() {
        this.indexInfoMap.clear();
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        UDTDatabaseIdentifierImpl uDTDatabaseIdentifierImpl = new UDTDatabaseIdentifierImpl(string, string2, string3, true, true, nArray);
        return this.findMatchingDatabaseIdentifier(uDTDatabaseIdentifierImpl, this.udtsMap);
    }

    public void setUDTs(ResultSet resultSet) {
        this.udtsMap.put(new UDTDatabaseIdentifierImpl(), resultSet);
    }

    public void setUDTs(String string, String string2, String string3, int[] nArray, ResultSet resultSet) {
        this.udtsMap.put(new UDTDatabaseIdentifierImpl(string, string2, string3, nArray), resultSet);
    }

    public void clearUDTs() {
        this.udtsMap.clear();
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        AttributesDatabaseIdentifierImpl attributesDatabaseIdentifierImpl = new AttributesDatabaseIdentifierImpl(string, string2, string3, true, true, string4);
        return this.findMatchingDatabaseIdentifier(attributesDatabaseIdentifierImpl, this.attributesMap);
    }

    public void setAttributes(ResultSet resultSet) {
        this.attributesMap.put(new AttributesDatabaseIdentifierImpl(), resultSet);
    }

    public void setAttributes(String string, String string2, String string3, String string4, ResultSet resultSet) {
        this.attributesMap.put(new AttributesDatabaseIdentifierImpl(string, string2, string3, string4), resultSet);
    }

    public void clearAttributes() {
        this.attributesMap.clear();
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        ColumnDatabaseIdentifierImpl columnDatabaseIdentifierImpl = new ColumnDatabaseIdentifierImpl(string, string2, string3, string4);
        return this.findMatchingDatabaseIdentifier(columnDatabaseIdentifierImpl, this.columnPrivilegesMap);
    }

    public void setColumnPrivileges(ResultSet resultSet) {
        this.columnPrivilegesMap.put(new ColumnDatabaseIdentifierImpl(), resultSet);
    }

    public void setColumnPrivileges(String string, String string2, String string3, String string4, ResultSet resultSet) {
        this.columnPrivilegesMap.put(new ColumnDatabaseIdentifierImpl(string, string2, string3, string4), resultSet);
    }

    public void clearColumnPrivileges() {
        this.columnPrivilegesMap.clear();
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        ColumnDatabaseIdentifierImpl columnDatabaseIdentifierImpl = new ColumnDatabaseIdentifierImpl(string, string2, string3, true, true, string4);
        return this.findMatchingDatabaseIdentifier(columnDatabaseIdentifierImpl, this.columnsMap);
    }

    public void setColumns(ResultSet resultSet) {
        this.columnsMap.put(new ColumnDatabaseIdentifierImpl(), resultSet);
    }

    public void setColumns(String string, String string2, String string3, String string4, ResultSet resultSet) {
        this.columnsMap.put(new ColumnDatabaseIdentifierImpl(string, string2, string3, string4), resultSet);
    }

    public void clearColumns() {
        this.columnsMap.clear();
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        ColumnDatabaseIdentifierImpl columnDatabaseIdentifierImpl = new ColumnDatabaseIdentifierImpl(string, string2, string3, true, true, string4);
        return this.findMatchingDatabaseIdentifier(columnDatabaseIdentifierImpl, this.procedureColumnsMap);
    }

    public void setProcedureColumns(ResultSet resultSet) {
        this.procedureColumnsMap.put(new ColumnDatabaseIdentifierImpl(), resultSet);
    }

    public void setProcedureColumns(String string, String string2, String string3, String string4, ResultSet resultSet) {
        this.procedureColumnsMap.put(new ColumnDatabaseIdentifierImpl(string, string2, string3, string4), resultSet);
    }

    public void clearProcedureColumns() {
        this.procedureColumnsMap.clear();
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        ColumnDatabaseIdentifierImpl columnDatabaseIdentifierImpl = new ColumnDatabaseIdentifierImpl(string, string2, string3, true, true, string4);
        return this.findMatchingDatabaseIdentifier(columnDatabaseIdentifierImpl, this.functionColumnsMap);
    }

    public void setFunctionColumns(ResultSet resultSet) {
        this.functionColumnsMap.put(new ColumnDatabaseIdentifierImpl(), resultSet);
    }

    public void setFunctionColumns(String string, String string2, String string3, String string4, ResultSet resultSet) {
        this.functionColumnsMap.put(new ColumnDatabaseIdentifierImpl(string, string2, string3, string4), resultSet);
    }

    public void clearFunctionColumns() {
        this.functionColumnsMap.clear();
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        TableDatabaseIdentifierImpl tableDatabaseIdentifierImpl = new TableDatabaseIdentifierImpl(string, string2, true, true, string3, stringArray);
        return this.findMatchingDatabaseIdentifier(tableDatabaseIdentifierImpl, this.tablesMap);
    }

    public void setTables(ResultSet resultSet) {
        this.tablesMap.put(new TableDatabaseIdentifierImpl(), resultSet);
    }

    public void setTables(String string, String string2, String string3, String[] stringArray, ResultSet resultSet) {
        this.tablesMap.put(new TableDatabaseIdentifierImpl(string, string2, string3, stringArray), resultSet);
    }

    public void clearTables() {
        this.tablesMap.clear();
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3);
        DatabaseIdentifierImpl databaseIdentifierImpl2 = new DatabaseIdentifierImpl(string4, string5, string6);
        DatabaseIdentifierImplWrapper databaseIdentifierImplWrapper = new DatabaseIdentifierImplWrapper(databaseIdentifierImpl, databaseIdentifierImpl2);
        return this.findMatchingDatabaseIdentifier(databaseIdentifierImplWrapper, this.crossReferenceMap);
    }

    public void setCrossReference(ResultSet resultSet) {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl();
        DatabaseIdentifierImpl databaseIdentifierImpl2 = new DatabaseIdentifierImpl();
        this.crossReferenceMap.put(new DatabaseIdentifierImplWrapper(databaseIdentifierImpl, databaseIdentifierImpl2), resultSet);
    }

    public void setCrossReference(String string, String string2, String string3, String string4, String string5, String string6, ResultSet resultSet) {
        DatabaseIdentifierImpl databaseIdentifierImpl = new DatabaseIdentifierImpl(string, string2, string3);
        DatabaseIdentifierImpl databaseIdentifierImpl2 = new DatabaseIdentifierImpl(string4, string5, string6);
        this.crossReferenceMap.put(new DatabaseIdentifierImplWrapper(databaseIdentifierImpl, databaseIdentifierImpl2), resultSet);
    }

    public void clearCrossReference() {
        this.crossReferenceMap.clear();
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return false;
    }

    public Object unwrap(Class clazz) throws SQLException {
        throw new SQLException("No object found for " + clazz);
    }

    private ResultSet findMatchingDatabaseIdentifier(DatabaseIdentifier databaseIdentifier, Map map) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            DatabaseIdentifier databaseIdentifier2 = (DatabaseIdentifier)entry.getKey();
            if (!databaseIdentifier2.isGlobal() && !databaseIdentifier.matches(databaseIdentifier2)) continue;
            arrayList.add(entry.getValue());
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (ResultSet)arrayList.get(0);
        }
        return new PolyResultSet(arrayList);
    }

    private ResultSet getAll(Map map) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(map.values());
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (ResultSet)arrayList.get(0);
        }
        return new PolyResultSet(arrayList);
    }

    private class DatabaseIdentifierImplWrapper
    implements DatabaseIdentifier {
        private DatabaseIdentifier identifier1;
        private DatabaseIdentifier identifier2;

        public DatabaseIdentifierImplWrapper(DatabaseIdentifier databaseIdentifier, DatabaseIdentifier databaseIdentifier2) {
            this.identifier1 = databaseIdentifier;
            this.identifier2 = databaseIdentifier2;
        }

        public DatabaseIdentifier getIdentifier1() {
            return this.identifier1;
        }

        public DatabaseIdentifier getIdentifier2() {
            return this.identifier2;
        }

        @Override
        public boolean isGlobal() {
            if (null == this.identifier1) {
                return false;
            }
            if (null == this.identifier2) {
                return false;
            }
            return this.identifier1.isGlobal() && this.identifier1.isGlobal();
        }

        @Override
        public boolean matches(DatabaseIdentifier databaseIdentifier) {
            if (null == databaseIdentifier) {
                return false;
            }
            if (!databaseIdentifier.getClass().equals(this.getClass())) {
                return false;
            }
            DatabaseIdentifierImplWrapper databaseIdentifierImplWrapper = (DatabaseIdentifierImplWrapper)databaseIdentifier;
            if (null != this.identifier1 && !this.identifier1.matches(databaseIdentifierImplWrapper.getIdentifier1())) {
                return false;
            }
            return null == this.identifier2 || this.identifier2.matches(databaseIdentifierImplWrapper.getIdentifier2());
        }

        public boolean equals(Object object) {
            if (null == object) {
                return false;
            }
            if (!object.getClass().equals(this.getClass())) {
                return false;
            }
            DatabaseIdentifierImplWrapper databaseIdentifierImplWrapper = (DatabaseIdentifierImplWrapper)object;
            if (null != this.identifier1 && !this.identifier1.equals(databaseIdentifierImplWrapper.getIdentifier1())) {
                return false;
            }
            if (null != databaseIdentifierImplWrapper.getIdentifier1() && !databaseIdentifierImplWrapper.getIdentifier1().equals(this.identifier1)) {
                return false;
            }
            if (null != this.identifier2 && !this.identifier2.equals(databaseIdentifierImplWrapper.getIdentifier2())) {
                return false;
            }
            return null == databaseIdentifierImplWrapper.getIdentifier2() || databaseIdentifierImplWrapper.getIdentifier2().equals(this.identifier2);
        }

        public int hashCode() {
            int n = 0;
            if (null != this.identifier1) {
                n = 31 * n + this.identifier1.hashCode();
            }
            if (null != this.identifier2) {
                n = 31 * n + this.identifier2.hashCode();
            }
            return n;
        }
    }

    private class UDTDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private int[] types;

        public UDTDatabaseIdentifierImpl() {
        }

        public UDTDatabaseIdentifierImpl(String string, String string2, String string3, int[] nArray) {
            super(string, string2, string3);
            this.types = nArray;
        }

        public UDTDatabaseIdentifierImpl(String string, String string2, String string3, boolean bl, boolean bl2, int[] nArray) {
            super(string, string2, string3, bl, bl2);
            this.types = nArray;
        }

        public int[] getTypes() {
            return this.types;
        }

        @Override
        public boolean matches(DatabaseIdentifier databaseIdentifier) {
            if (!super.matches(databaseIdentifier)) {
                return false;
            }
            UDTDatabaseIdentifierImpl uDTDatabaseIdentifierImpl = (UDTDatabaseIdentifierImpl)databaseIdentifier;
            if (null == this.types) {
                return true;
            }
            if (null == uDTDatabaseIdentifierImpl.getTypes()) {
                return false;
            }
            return this.matchesTypes(uDTDatabaseIdentifierImpl);
        }

        private boolean matchesTypes(UDTDatabaseIdentifierImpl uDTDatabaseIdentifierImpl) {
            int[] nArray = uDTDatabaseIdentifierImpl.getTypes();
            for (int i = 0; i < this.types.length; ++i) {
                int n = this.types[i];
                for (int j = 0; j < nArray.length; ++j) {
                    if (n != nArray[j]) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            UDTDatabaseIdentifierImpl uDTDatabaseIdentifierImpl = (UDTDatabaseIdentifierImpl)object;
            if (null == this.types && null == uDTDatabaseIdentifierImpl.getTypes()) {
                return true;
            }
            if (null == this.types) {
                return false;
            }
            if (null == uDTDatabaseIdentifierImpl.getTypes()) {
                return false;
            }
            return Arrays.equals(this.types, uDTDatabaseIdentifierImpl.getTypes());
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            if (null != this.types) {
                for (int i = 0; i < this.types.length; ++i) {
                    n = 31 * n + this.types[i];
                }
            }
            return n;
        }
    }

    private class TableDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private String[] types;

        public TableDatabaseIdentifierImpl() {
        }

        public TableDatabaseIdentifierImpl(String string, String string2, String string3, String[] stringArray) {
            super(string, string2, string3);
            this.types = stringArray;
        }

        public TableDatabaseIdentifierImpl(String string, String string2, boolean bl, boolean bl2, String string3, String[] stringArray) {
            super(string, string2, string3, bl, bl2);
            this.types = stringArray;
        }

        public String[] getTypes() {
            return this.types;
        }

        @Override
        public boolean matches(DatabaseIdentifier databaseIdentifier) {
            if (!super.matches(databaseIdentifier)) {
                return false;
            }
            TableDatabaseIdentifierImpl tableDatabaseIdentifierImpl = (TableDatabaseIdentifierImpl)databaseIdentifier;
            if (null == this.types) {
                return true;
            }
            if (null == tableDatabaseIdentifierImpl.getTypes()) {
                return false;
            }
            return this.matchesTypes(tableDatabaseIdentifierImpl);
        }

        private boolean matchesTypes(TableDatabaseIdentifierImpl tableDatabaseIdentifierImpl) {
            String[] stringArray = tableDatabaseIdentifierImpl.getTypes();
            for (int i = 0; i < this.types.length; ++i) {
                String string = this.types[i];
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!string.equals(stringArray[j])) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            TableDatabaseIdentifierImpl tableDatabaseIdentifierImpl = (TableDatabaseIdentifierImpl)object;
            if (null == this.types && null == tableDatabaseIdentifierImpl.getTypes()) {
                return true;
            }
            if (null == this.types) {
                return false;
            }
            if (null == tableDatabaseIdentifierImpl.getTypes()) {
                return false;
            }
            return Arrays.equals(this.types, tableDatabaseIdentifierImpl.getTypes());
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            if (null != this.types) {
                for (int i = 0; i < this.types.length; ++i) {
                    if (null == this.types[i]) continue;
                    n = 31 * n + this.types[i].hashCode();
                }
            }
            return n;
        }
    }

    private class IndexInfoDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private boolean unique;
        private boolean approximate;

        public IndexInfoDatabaseIdentifierImpl() {
        }

        public IndexInfoDatabaseIdentifierImpl(String string, String string2, String string3, boolean bl, boolean bl2) {
            super(string, string2, string3);
            this.unique = bl;
            this.approximate = bl2;
        }

        public boolean isApproximate() {
            return this.approximate;
        }

        public boolean isUnique() {
            return this.unique;
        }

        @Override
        public boolean matches(DatabaseIdentifier databaseIdentifier) {
            if (!super.matches(databaseIdentifier)) {
                return false;
            }
            return this.isEqual(databaseIdentifier);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            return this.isEqual(object);
        }

        private boolean isEqual(Object object) {
            IndexInfoDatabaseIdentifierImpl indexInfoDatabaseIdentifierImpl = (IndexInfoDatabaseIdentifierImpl)object;
            if (this.unique != indexInfoDatabaseIdentifierImpl.isUnique()) {
                return false;
            }
            return this.approximate == indexInfoDatabaseIdentifierImpl.isApproximate();
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.unique ? 31 : 62);
            n = 31 * n + (this.approximate ? 93 : 124);
            return n;
        }
    }

    private class RowIdentifierDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private int scope;
        private boolean nullable;

        public RowIdentifierDatabaseIdentifierImpl() {
        }

        public RowIdentifierDatabaseIdentifierImpl(String string, String string2, String string3, int n, boolean bl) {
            super(string, string2, string3);
            this.scope = n;
            this.nullable = bl;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public int getScope() {
            return this.scope;
        }

        @Override
        public boolean matches(DatabaseIdentifier databaseIdentifier) {
            if (!super.matches(databaseIdentifier)) {
                return false;
            }
            return this.isEqual(databaseIdentifier);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            return this.isEqual(object);
        }

        private boolean isEqual(Object object) {
            RowIdentifierDatabaseIdentifierImpl rowIdentifierDatabaseIdentifierImpl = (RowIdentifierDatabaseIdentifierImpl)object;
            if (this.scope != rowIdentifierDatabaseIdentifierImpl.getScope()) {
                return false;
            }
            return this.nullable == rowIdentifierDatabaseIdentifierImpl.isNullable();
        }

        @Override
        public int hashCode() {
            int n = super.hashCode() * 31 + this.scope;
            n = 31 * n + (this.nullable ? 31 : 62);
            return n;
        }
    }

    private class ColumnDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private String columnNamePattern;

        public ColumnDatabaseIdentifierImpl() {
        }

        public ColumnDatabaseIdentifierImpl(String string, String string2, String string3, String string4) {
            super(string, string2, string3);
            this.columnNamePattern = string4;
        }

        public ColumnDatabaseIdentifierImpl(String string, String string2, String string3, boolean bl, boolean bl2, String string4) {
            super(string, string2, string3, bl, bl2);
            this.columnNamePattern = string4;
        }

        public String getColumnNamePattern() {
            return this.columnNamePattern;
        }

        @Override
        public boolean matches(DatabaseIdentifier databaseIdentifier) {
            if (!super.matches(databaseIdentifier)) {
                return false;
            }
            ColumnDatabaseIdentifierImpl columnDatabaseIdentifierImpl = (ColumnDatabaseIdentifierImpl)databaseIdentifier;
            if (null == this.columnNamePattern) {
                return false;
            }
            if (null == columnDatabaseIdentifierImpl.getColumnNamePattern()) {
                return false;
            }
            return StringUtil.matchesPerl5(columnDatabaseIdentifierImpl.getColumnNamePattern(), this.convert(this.columnNamePattern), MockDatabaseMetaData.this.caseSensitive);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            ColumnDatabaseIdentifierImpl columnDatabaseIdentifierImpl = (ColumnDatabaseIdentifierImpl)object;
            if (null != this.columnNamePattern && !this.columnNamePattern.equals(columnDatabaseIdentifierImpl.getColumnNamePattern())) {
                return false;
            }
            return null == columnDatabaseIdentifierImpl.getColumnNamePattern() || columnDatabaseIdentifierImpl.getColumnNamePattern().equals(this.columnNamePattern);
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            if (null != this.columnNamePattern) {
                n = 31 * n + this.columnNamePattern.hashCode();
            }
            return n;
        }
    }

    private class AttributesDatabaseIdentifierImpl
    extends DatabaseIdentifierImpl {
        private String attributeNamePattern;

        public AttributesDatabaseIdentifierImpl() {
        }

        public AttributesDatabaseIdentifierImpl(String string, String string2, String string3, String string4) {
            super(string, string2, string3);
            this.attributeNamePattern = string4;
        }

        public AttributesDatabaseIdentifierImpl(String string, String string2, String string3, boolean bl, boolean bl2, String string4) {
            super(string, string2, string3, bl, bl2);
            this.attributeNamePattern = string4;
        }

        public String getAttributeNamePattern() {
            return this.attributeNamePattern;
        }

        @Override
        public boolean matches(DatabaseIdentifier databaseIdentifier) {
            if (!super.matches(databaseIdentifier)) {
                return false;
            }
            AttributesDatabaseIdentifierImpl attributesDatabaseIdentifierImpl = (AttributesDatabaseIdentifierImpl)databaseIdentifier;
            if (null == this.attributeNamePattern) {
                return false;
            }
            if (null == attributesDatabaseIdentifierImpl.getAttributeNamePattern()) {
                return false;
            }
            return StringUtil.matchesPerl5(attributesDatabaseIdentifierImpl.getAttributeNamePattern(), this.convert(this.attributeNamePattern), MockDatabaseMetaData.this.caseSensitive);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            AttributesDatabaseIdentifierImpl attributesDatabaseIdentifierImpl = (AttributesDatabaseIdentifierImpl)object;
            if (null != this.attributeNamePattern && !this.attributeNamePattern.equals(attributesDatabaseIdentifierImpl.getAttributeNamePattern())) {
                return false;
            }
            return null == attributesDatabaseIdentifierImpl.getAttributeNamePattern() || attributesDatabaseIdentifierImpl.getAttributeNamePattern().equals(this.attributeNamePattern);
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            if (null != this.attributeNamePattern) {
                n = 31 * n + this.attributeNamePattern.hashCode();
            }
            return n;
        }
    }

    private class DatabaseIdentifierImpl
    implements DatabaseIdentifier {
        private boolean isGlobal;
        private String catalog;
        private String schema;
        private String table;
        private boolean useSchemaPattern;
        private boolean useTablePattern;

        public DatabaseIdentifierImpl() {
            this.isGlobal = true;
        }

        public DatabaseIdentifierImpl(String string, String string2, String string3) {
            this(string, string2, string3, false, false);
        }

        public DatabaseIdentifierImpl(String string, String string2, String string3, boolean bl, boolean bl2) {
            this.isGlobal = false;
            this.catalog = string;
            this.schema = string2;
            this.table = string3;
            this.useSchemaPattern = bl;
            this.useTablePattern = bl2;
        }

        public String getCatalog() {
            return this.catalog;
        }

        @Override
        public boolean isGlobal() {
            return this.isGlobal;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getTable() {
            return this.table;
        }

        protected String convert(String string) {
            if (string.indexOf(37) != -1) {
                string = StringUtil.replaceAll(string, "%", ".*");
            }
            if (string.indexOf(95) != -1) {
                string = StringUtil.replaceAll(string, "_", ".");
            }
            return string;
        }

        @Override
        public boolean matches(DatabaseIdentifier databaseIdentifier) {
            if (null == databaseIdentifier) {
                return false;
            }
            if (!databaseIdentifier.getClass().equals(this.getClass())) {
                return false;
            }
            DatabaseIdentifierImpl databaseIdentifierImpl = (DatabaseIdentifierImpl)databaseIdentifier;
            if (this.isGlobal != databaseIdentifierImpl.isGlobal()) {
                return false;
            }
            if (!this.matchesCatalog(databaseIdentifierImpl)) {
                return false;
            }
            if (!this.matchesSchema(databaseIdentifierImpl)) {
                return false;
            }
            return this.matchesTable(databaseIdentifierImpl);
        }

        private boolean matchesCatalog(DatabaseIdentifierImpl databaseIdentifierImpl) {
            if (null == this.getCatalog()) {
                return true;
            }
            if (this.catalog.length() == 0) {
                return databaseIdentifierImpl.getCatalog() == null || databaseIdentifierImpl.getCatalog().length() == 0;
            }
            if (databaseIdentifierImpl.getCatalog() == null) {
                return false;
            }
            return StringUtil.matchesExact(databaseIdentifierImpl.getCatalog(), this.catalog, MockDatabaseMetaData.this.caseSensitive);
        }

        private boolean matchesSchema(DatabaseIdentifierImpl databaseIdentifierImpl) {
            if (null == this.getSchema()) {
                return true;
            }
            if (this.schema.length() == 0) {
                return databaseIdentifierImpl.getSchema() == null || databaseIdentifierImpl.getSchema().length() == 0;
            }
            if (databaseIdentifierImpl.getSchema() == null) {
                return false;
            }
            if (!this.useSchemaPattern) {
                return StringUtil.matchesExact(databaseIdentifierImpl.getSchema(), this.schema, MockDatabaseMetaData.this.caseSensitive);
            }
            return StringUtil.matchesPerl5(databaseIdentifierImpl.getSchema(), this.convert(this.schema), MockDatabaseMetaData.this.caseSensitive);
        }

        private boolean matchesTable(DatabaseIdentifierImpl databaseIdentifierImpl) {
            if (null == this.table) {
                return false;
            }
            if (null == databaseIdentifierImpl.getTable()) {
                return false;
            }
            if (!this.useTablePattern) {
                return StringUtil.matchesExact(databaseIdentifierImpl.getTable(), this.table, MockDatabaseMetaData.this.caseSensitive);
            }
            return StringUtil.matchesPerl5(databaseIdentifierImpl.getTable(), this.convert(this.table), MockDatabaseMetaData.this.caseSensitive);
        }

        public boolean equals(Object object) {
            if (null == object) {
                return false;
            }
            if (!object.getClass().equals(this.getClass())) {
                return false;
            }
            DatabaseIdentifierImpl databaseIdentifierImpl = (DatabaseIdentifierImpl)object;
            if (this.isGlobal != databaseIdentifierImpl.isGlobal()) {
                return false;
            }
            if (null != this.catalog && !this.catalog.equals(databaseIdentifierImpl.getCatalog())) {
                return false;
            }
            if (null != databaseIdentifierImpl.getCatalog() && !databaseIdentifierImpl.getCatalog().equals(this.catalog)) {
                return false;
            }
            if (null != this.schema && !this.schema.equals(databaseIdentifierImpl.getSchema())) {
                return false;
            }
            if (null != databaseIdentifierImpl.getSchema() && !databaseIdentifierImpl.getSchema().equals(this.schema)) {
                return false;
            }
            if (null != this.table && !this.table.equals(databaseIdentifierImpl.getTable())) {
                return false;
            }
            return null == databaseIdentifierImpl.getTable() || databaseIdentifierImpl.getTable().equals(this.table);
        }

        public int hashCode() {
            int n = 17;
            if (null != this.catalog) {
                n = 31 * n + this.catalog.hashCode();
            }
            if (null != this.schema) {
                n = 31 * n + this.schema.hashCode();
            }
            if (null != this.table) {
                n = 31 * n + this.table.hashCode();
            }
            return n;
        }
    }

    private static interface DatabaseIdentifier {
        public boolean isGlobal();

        public boolean matches(DatabaseIdentifier var1);
    }
}

