/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.FileUtil;
import com.mockrunner.util.common.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileResultSetFactory
implements ResultSetFactory {
    private File file = null;
    private String delimiter = ";";
    private boolean firstLineContainsColumnNames = false;
    private boolean trim = true;
    private boolean useTemplates = false;
    private String templateMarker = null;
    private Map templates = null;

    public FileResultSetFactory(String string) {
        this(new File(string));
    }

    public FileResultSetFactory(File file) {
        this.file = file;
        this.setDefaultTemplateConfiguration();
    }

    public File getFile() {
        if (this.file.exists() && this.file.isFile()) {
            return this.file;
        }
        try {
            this.file = FileUtil.findFile(this.file.getPath());
            return this.file;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Could not find: " + this.file.getPath());
        }
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setFirstLineContainsColumnNames(boolean bl) {
        this.firstLineContainsColumnNames = bl;
    }

    public void setTrim(boolean bl) {
        this.trim = bl;
    }

    public void setUseTemplates(boolean bl) {
        this.useTemplates = bl;
    }

    public void setTemplateConfiguration(String string, Map map) {
        this.templates = map;
        this.templateMarker = string;
    }

    public void setDefaultTemplateConfiguration() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("defaultString", "");
        hashMap.put("defaultDate", "1970-01-01");
        hashMap.put("defaultInteger", "0");
        this.setTemplateConfiguration("$", hashMap);
    }

    @Override
    public MockResultSet create(String string) {
        String[] stringArray;
        MockResultSet mockResultSet = new MockResultSet(string);
        File file = this.getFile();
        List list = FileUtil.getLinesFromFile(file);
        int n = 0;
        if (this.firstLineContainsColumnNames) {
            String string2 = (String)list.get(n);
            ++n;
            stringArray = StringUtil.split(string2, this.delimiter, this.trim);
            for (int i = 0; i < stringArray.length; ++i) {
                mockResultSet.addColumn(stringArray[i]);
            }
        }
        for (int i = n; i < list.size(); ++i) {
            stringArray = (String[])list.get(i);
            Object[] objectArray = StringUtil.split((String)stringArray, this.delimiter, this.trim);
            if (this.useTemplates) {
                for (int j = 0; j < objectArray.length; ++j) {
                    if (null == objectArray[j] || !((String)objectArray[j]).startsWith(this.templateMarker) || !this.templates.containsKey(((String)objectArray[j]).substring(1))) continue;
                    objectArray[j] = (String)this.templates.get(((String)objectArray[j]).substring(1));
                }
            }
            mockResultSet.addRow(objectArray);
        }
        return mockResultSet;
    }
}

