/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsUtil {
    private static final Log log = LogFactory.getLog(GenericsUtil.class);

    public static <T> Class[] resolveParameterizedClass(Class<T> genericClass, Class<? extends T> descendantClass) throws IllegalArgumentException, IllegalStateException {
        if (genericClass == null) {
            throw new IllegalArgumentException("Argument 'genericsClass' (" + Class.class.getName() + ") is null");
        }
        if (descendantClass == null) {
            throw new IllegalArgumentException("Argument 'descendantClass'(" + Class.class.getName() + ") is null");
        }
        List<ParameterizedType> ancestorTypeList = GenericsUtil.getAncestorTypeList(genericClass, descendantClass);
        ParameterizedType parameterizedType = ancestorTypeList.get(ancestorTypeList.size() - 1);
        Type[] actualTypes = parameterizedType.getActualTypeArguments();
        Class[] actualClasses = new Class[actualTypes.length];
        for (int i = 0; i < actualTypes.length; ++i) {
            actualClasses[i] = GenericsUtil.resolveTypeVariable(actualTypes[i], ancestorTypeList);
        }
        return actualClasses;
    }

    public static <T> Class resolveParameterizedClass(Class<T> genericClass, Class<? extends T> descendantClass, int index) throws IllegalArgumentException, IllegalStateException {
        if (genericClass == null) {
            throw new IllegalArgumentException("Argument 'genericsClass' (" + Class.class.getName() + ") is null");
        }
        if (descendantClass == null) {
            throw new IllegalArgumentException("Argument 'descendantClass'(" + Class.class.getName() + ") is null");
        }
        List<ParameterizedType> ancestorTypeList = GenericsUtil.getAncestorTypeList(genericClass, descendantClass);
        ParameterizedType parameterizedType = ancestorTypeList.get(ancestorTypeList.size() - 1);
        Type[] actualTypes = parameterizedType.getActualTypeArguments();
        if (index < 0 || index >= actualTypes.length) {
            throw new IllegalArgumentException("Argument 'index'(" + Integer.toString(index) + ") is out of bounds of" + " generics parameters");
        }
        return GenericsUtil.resolveTypeVariable(actualTypes[index], ancestorTypeList);
    }

    protected static <T> List<ParameterizedType> getAncestorTypeList(Class<T> genericClass, Class<? extends T> descendantClass) throws IllegalStateException {
        Type type;
        ArrayList<ParameterizedType> ancestorTypeList = new ArrayList<ParameterizedType>();
        Class<T> clazz = descendantClass;
        boolean isInterface = genericClass.isInterface();
        while (clazz != null && !GenericsUtil.checkParameterizedType(type = clazz.getGenericSuperclass(), genericClass, ancestorTypeList)) {
            if (!isInterface) {
                clazz = clazz.getSuperclass();
                continue;
            }
            if (GenericsUtil.checkInterfaceAncestors(genericClass, ancestorTypeList, clazz)) break;
            clazz = clazz.getSuperclass();
        }
        if (ancestorTypeList.isEmpty()) {
            throw new IllegalStateException("Argument 'genericClass'(" + genericClass.getName() + ") does not declare type parameter");
        }
        ParameterizedType targetType = (ParameterizedType)ancestorTypeList.get(ancestorTypeList.size() - 1);
        if (!targetType.getRawType().equals(genericClass)) {
            throw new IllegalStateException("Class(" + descendantClass.getName() + ") is not concrete class of Class(" + genericClass.getName() + ")");
        }
        return ancestorTypeList;
    }

    protected static <T> boolean checkInterfaceAncestors(Class<T> genericClass, List<ParameterizedType> ancestorTypeList, Class clazz) {
        Type[] interfaceTypes;
        boolean genericTypeFound = false;
        for (Type interfaceType : interfaceTypes = clazz.getGenericInterfaces()) {
            Class<?>[] interfaces;
            genericTypeFound = GenericsUtil.checkParameterizedType(interfaceType, genericClass, ancestorTypeList);
            if (genericTypeFound) {
                return true;
            }
            for (Class<?> interfaceClass : interfaces = clazz.getInterfaces()) {
                if (!GenericsUtil.checkInterfaceAncestors(genericClass, ancestorTypeList, interfaceClass)) continue;
                return true;
            }
        }
        return false;
    }

    protected static <T> boolean checkParameterizedType(Type type, Class<T> genericClass, List<ParameterizedType> ancestorTypeList) {
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterlizedType = (ParameterizedType)type;
        if (!genericClass.isAssignableFrom((Class)parameterlizedType.getRawType())) {
            return false;
        }
        ancestorTypeList.add(parameterlizedType);
        return parameterlizedType.getRawType().equals(genericClass);
    }

    protected static Class resolveTypeVariable(Type type, List<ParameterizedType> ancestorTypeList) throws IllegalStateException {
        if (GenericsUtil.isNotTypeVariable(type)) {
            return GenericsUtil.getRawClass(type);
        }
        TypeVariable targetType = (TypeVariable)type;
        Type actualType = null;
        for (int i = ancestorTypeList.size() - 1; i >= 0; --i) {
            ParameterizedType ancestorType = ancestorTypeList.get(i);
            Object declaration = targetType.getGenericDeclaration();
            if (!(declaration instanceof Class)) {
                throw new IllegalStateException("TypeVariable(" + targetType.getName() + " is not declared at Class " + "(ie. is declared at Method or Constructor)");
            }
            Class declaredClass = (Class)declaration;
            if (declaredClass != ancestorType.getRawType()) continue;
            Object[] parameterTypes = declaredClass.getTypeParameters();
            int index = ArrayUtils.indexOf((Object[])parameterTypes, (Object)targetType);
            if (index == -1) {
                throw new IllegalStateException("Class(" + declaredClass.getName() + ") does not declare TypeValidable(" + targetType.getName() + ")");
            }
            actualType = ancestorType.getActualTypeArguments()[index];
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolved " + targetType.getName() + " -> " + actualType));
            }
            if (GenericsUtil.isNotTypeVariable(actualType)) {
                return GenericsUtil.getRawClass(actualType);
            }
            targetType = (TypeVariable)actualType;
        }
        throw new IllegalStateException("Concrete type of Type(" + type + ") was not found in ancestorList(" + ancestorTypeList + ")");
    }

    protected static boolean isNotTypeVariable(Type type) throws IllegalStateException {
        if (type instanceof Class) {
            return true;
        }
        if (type instanceof TypeVariable) {
            return false;
        }
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof GenericArrayType) {
            return true;
        }
        throw new IllegalStateException("Type(" + type + ") is not instance of " + TypeVariable.class.getName() + ", " + ParameterizedType.class.getName() + ", " + GenericArrayType.class.getName() + " nor " + Class.class.getName());
    }

    protected static Class getRawClass(Type type) throws IllegalStateException {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return GenericsUtil.getRawClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class componentClass = GenericsUtil.getRawClass(componentType);
            return Array.newInstance(componentClass, 0).getClass();
        }
        throw new IllegalStateException("Type(" + type + ") is not instance of " + ParameterizedType.class.getName() + ", " + GenericArrayType.class.getName() + " nor " + Class.class.getName());
    }
}

