////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) Microsoft Corporation.  All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "tinyhal.h"

//--//

#ifndef _RX62N_INTERNAL_FLASH
#define _RX62N_INTERNAL_FLASH 1

/******************************************************************************
Macro definitions
******************************************************************************/
#define FLD_ADDRESS 0x00100000
#define ROM_PE_ADDR 0xFFF80000

#define READ_MODE 0
#define ROM_PE_MODE 1
#define FLD_PE_MODE 2

#define BLANK_CHECK_8_BYTE       0  /* 'size' parameter for FlashFLDBlankCheck */
#define BLANK_CHECK_ENTIRE_BLOCK 1  /* 'size' parameter for FlashFLDBlankCheck */

#define	WAIT_MAX_ROM_WRITE	((INT32)(12000 * (50/2)))
#define	WAIT_MAX_DF_WRITE	((INT32)(5000 * (50/2)))
#define	WAIT_MAX_ERASE		((INT32)(300000 * (50/2)))

//--//

struct RX62N_INTERNAL_FLASH_Driver
{
    typedef UINT32 CHIP_WORD;

    static BOOL ChipInitialize( void* context );

    static BOOL ChipUnInitialize( void* context );

    static const BlockDeviceInfo* GetDeviceInfo( void* context );

    static BOOL Read( void* context, ByteAddress Address, UINT32 NumBytes, BYTE * pSectorBuff );

    static BOOL Write( void* context, ByteAddress Address, UINT32 NumBytes, BYTE * pSectorBuff, BOOL ReadModifyWrite );

    static BOOL Memset( void* context, ByteAddress Address, UINT8 Data, UINT32 NumBytes );

    static BOOL GetSectorMetadata(void* context, ByteAddress SectorStart, SectorMetadata* pSectorMetadata);

    static BOOL SetSectorMetadata(void* context, ByteAddress SectorStart, SectorMetadata* pSectorMetadata);

    static BOOL IsBlockErased( void* context, ByteAddress address, UINT32 blockLength );

    static BOOL EraseBlock( void* context, ByteAddress Sector );

    static void SetPowerState( void* context, UINT32 State );

    static UINT32 MaxSectorWrite_uSec( void* context );

    static UINT32 MaxBlockErase_uSec( void* context );

//--//
    static BOOL ChipReadOnly( void* context, BOOL On, UINT32 ProtectionKey );

    static BOOL ReadProductID( void* context, FLASH_WORD& ManufacturerCode, FLASH_WORD& DeviceCode );

private:
    static BOOL WriteX( void* context, ByteAddress StartSector, UINT32 NumSectors,BYTE * pSectorBuff, BOOL ReadModifyWrite, BOOL fIncrementDataPtr );
    static void Action_ReadID     ( void* context, FLASH_WORD& ManufacturerCode, FLASH_WORD& DeviceCode );
    static BOOL Action_EraseSector( void* context, volatile CHIP_WORD SectorStart                      );
    static BOOL Action_WriteFlash( void* context, volatile CHIP_WORD Address, CHIP_WORD Data, UINT16 numBytesWrite);
    static void Action_FLDAreaAccess(UINT8 read_mask, UINT8 write_mask                                  );
    static BOOL Action_EnterPEMode  (volatile CHIP_WORD BaseAddress                                 );
    static void Action_ExitPEMode   (volatile CHIP_WORD BaseAddress                                 );
};

//--//

#endif // _RX62N_INTERNAL_FLASH

