/************************************************************/
/*	FileName	: RX62N_GPIO.h							*/
/*	FUNC		: GPIO Register Header File				*/
/************************************************************/

/*
 *	  Copyright (C) Renesas Technology America,Ltd. 2009  All rights reserved.
 */
 
#ifndef	_RX62N_GPIO_H_
#define	_RX62N_GPIO_H_

#include "..\iodefine.h"

#define RX62N_MAX_GPIO		128

struct RX62N_GPIO
{
    static const UINT32 c_Pin_None  = 0xFFFFFFFF;
	// Port 0
	static const UINT32 c_P00		= 0x0000;
	static const UINT32 c_P01		= 0x0001;
	static const UINT32 c_P02		= 0x0002;
	static const UINT32 c_P03		= 0x0003;
	static const UINT32 c_P05		= 0x0005;
	static const UINT32 c_P07		= 0x0007;
	// Port 1
	static const UINT32 c_P10		= 0x0100;
	static const UINT32 c_P11		= 0x0101;
	static const UINT32 c_P12		= 0x0102;
	static const UINT32 c_P13		= 0x0103;
	static const UINT32 c_P14		= 0x0104;
	static const UINT32 c_P15		= 0x0105;
	static const UINT32 c_P16		= 0x0106;
	static const UINT32 c_P17		= 0x0107;
	// Port 2
	static const UINT32 c_P20		= 0x0200;
	static const UINT32 c_P21		= 0x0201;
	static const UINT32 c_P22		= 0x0202;
	static const UINT32 c_P23		= 0x0203;
	static const UINT32 c_P24		= 0x0204;
	static const UINT32 c_P25		= 0x0205;
	static const UINT32 c_P26		= 0x0206;
	static const UINT32 c_P27		= 0x0207;
	// Port 3
	static const UINT32 c_P30		= 0x0300;
	static const UINT32 c_P31		= 0x0301;
	static const UINT32 c_P32		= 0x0302;
	static const UINT32 c_P33		= 0x0303;
	static const UINT32 c_P34		= 0x0304;
	static const UINT32 c_P35		= 0x0305;
	// Port 4
	static const UINT32 c_P40		= 0x0400;
	static const UINT32 c_P41		= 0x0401;
	static const UINT32 c_P42		= 0x0402;
	static const UINT32 c_P43		= 0x0403;
	static const UINT32 c_P44		= 0x0404;
	static const UINT32 c_P45		= 0x0405;
	static const UINT32 c_P46		= 0x0406;
	static const UINT32 c_P47		= 0x0407;
	// Port 5
	static const UINT32 c_P50		= 0x0500;
	static const UINT32 c_P51		= 0x0501;
	static const UINT32 c_P52		= 0x0502;
	static const UINT32 c_P53		= 0x0503;
	static const UINT32 c_P54		= 0x0504;
	static const UINT32 c_P55		= 0x0505;
	static const UINT32 c_P56		= 0x0506;
	static const UINT32 c_P57		= 0x0507;
	// Port 6
	static const UINT32 c_P60		= 0x0600;
	static const UINT32 c_P61		= 0x0601;
	static const UINT32 c_P62		= 0x0602;
	static const UINT32 c_P63		= 0x0603;
	static const UINT32 c_P64		= 0x0604;
	static const UINT32 c_P65		= 0x0605;
	static const UINT32 c_P66		= 0x0606;
	static const UINT32 c_P67		= 0x0607;
	// Port 7
	static const UINT32 c_P70		= 0x0700;
	static const UINT32 c_P71		= 0x0701;
	static const UINT32 c_P72		= 0x0702;
	static const UINT32 c_P73		= 0x0703;
	static const UINT32 c_P74		= 0x0704;
	static const UINT32 c_P75		= 0x0705;
	static const UINT32 c_P76		= 0x0706;
	static const UINT32 c_P77		= 0x0707;
	// Port 8
	static const UINT32 c_P80		= 0x0800;
	static const UINT32 c_P81		= 0x0801;
	static const UINT32 c_P82		= 0x0802;
	static const UINT32 c_P83		= 0x0803;
	static const UINT32 c_P84		= 0x0804;
	static const UINT32 c_P85		= 0x0805;
	// Port 9
	static const UINT32 c_P90		= 0x0900;
	static const UINT32 c_P91		= 0x0901;
	static const UINT32 c_P92		= 0x0902;
	static const UINT32 c_P93		= 0x0903;
	static const UINT32 c_P94		= 0x0904;
	static const UINT32 c_P95		= 0x0905;
	static const UINT32 c_P96		= 0x0906;
	static const UINT32 c_P97		= 0x0907;
	// Port A
	static const UINT32 c_PA0		= 0x0A00;
	static const UINT32 c_PA1		= 0x0A01;
	static const UINT32 c_PA2		= 0x0A02;
	static const UINT32 c_PA3		= 0x0A03;
	static const UINT32 c_PA4		= 0x0A04;
	static const UINT32 c_PA5		= 0x0A05;
	static const UINT32 c_PA6		= 0x0A06;
	static const UINT32 c_PA7		= 0x0A07;
	// Port B
	static const UINT32 c_PB0		= 0x0B00;
	static const UINT32 c_PB1		= 0x0B01;
	static const UINT32 c_PB2		= 0x0B02;
	static const UINT32 c_PB3		= 0x0B03;
	static const UINT32 c_PB4		= 0x0B04;
	static const UINT32 c_PB5		= 0x0B05;
	static const UINT32 c_PB6		= 0x0B06;
	static const UINT32 c_PB7		= 0x0B07;
	// Port C
	static const UINT32 c_PC0		= 0x0C00;
	static const UINT32 c_PC1		= 0x0C01;
	static const UINT32 c_PC2		= 0x0C02;
	static const UINT32 c_PC3		= 0x0C03;
	static const UINT32 c_PC4		= 0x0C04;
	static const UINT32 c_PC5		= 0x0C05;
	static const UINT32 c_PC6		= 0x0C06;
	static const UINT32 c_PC7		= 0x0C07;
	// Port D
	static const UINT32 c_PD0		= 0x0D00;
	static const UINT32 c_PD1		= 0x0D01;
	static const UINT32 c_PD2		= 0x0D02;
	static const UINT32 c_PD3		= 0x0D03;
	static const UINT32 c_PD4		= 0x0D04;
	static const UINT32 c_PD5		= 0x0D05;
	static const UINT32 c_PD6		= 0x0D06;
	static const UINT32 c_PD7		= 0x0D07;
	// Port E
	static const UINT32 c_PE0		= 0x0E00;
	static const UINT32 c_PE1		= 0x0E01;
	static const UINT32 c_PE2		= 0x0E02;
	static const UINT32 c_PE3		= 0x0E03;
	static const UINT32 c_PE4		= 0x0E04;
	static const UINT32 c_PE5		= 0x0E05;
	static const UINT32 c_PE6		= 0x0E06;
	static const UINT32 c_PE7		= 0x0E07;
	// Port F
	static const UINT32 c_PF0		= 0x0F00;
	static const UINT32 c_PF1		= 0x0F01;
	static const UINT32 c_PF2		= 0x0F02;
	static const UINT32 c_PF3		= 0x0F03;
	static const UINT32 c_PF4		= 0x0F04;
	// Port G
	static const UINT32 c_PG0		= 0x1000;
	static const UINT32 c_PG1		= 0x1001;
	static const UINT32 c_PG2		= 0x1002;
	static const UINT32 c_PG3		= 0x1003;
	static const UINT32 c_PG4		= 0x1004;
	static const UINT32 c_PG5		= 0x1005;
	static const UINT32 c_PG6		= 0x1006;
	static const UINT32 c_PG7		= 0x1007;
};

struct RX62N_GPIO_Driver
{
	struct PIN_ISR_DESCRIPTOR
	{
		HAL_COMPLETION							m_completion;
		GPIO_INTERRUPT_SERVICE_ROUTINE			m_isr;
		void*									m_param;
		GPIO_PIN								m_pin;
		GPIO_INT_EDGE							m_intEdge;
		UINT8									m_flags;
		UINT8									m_status;

		//--//
		
		static const UINT8 c_Flags_Debounce		   = 0x01;
		static const UINT8 c_Flags_RequireLowEdge  = 0x02;
		static const UINT8 c_Flags_RequireHighEdge = 0x04;

		static const UINT8 c_Status_AllowLowEdge   = 0x01;
		static const UINT8 c_Status_AllowHighEdge  = 0x02;

		//--//

		static void Fire( void* arg );

		void HandleDebounce( BOOL edge );
	};

	static const UINT32 c_MaxPins			= RX62N_MAX_GPIO;
	static const UINT32 c_MaxPorts			= 17;

	static const INT32	c_MinDebounceTimeMs =	 1; // 1 ms
	static const INT32	c_MaxDebounceTimeMs = 5000; // 5  s

	// applies to all GPIO
	static const UINT8 c_NumberofResistorMode = 2;
	static const UINT8 c_GPIO_ResistorMode = (1<<RESISTOR_DISABLED) | (1<<RESISTOR_PULLUP);

	static const UINT8 c_NumberofInterruptMode = 5;
	static const UINT8 c_GPIO_InterruptMode = (1<<GPIO_INT_EDGE_LOW) | (1<<GPIO_INT_EDGE_HIGH ) | (1<<GPIO_INT_EDGE_BOTH) | (1<<GPIO_INT_LEVEL_HIGH) | (1<<GPIO_INT_LEVEL_LOW);


	PIN_ISR_DESCRIPTOR m_PinIsr			   [c_MaxPins ];
	UINT32			   m_PinReservationInfo[c_MaxPorts];
	UINT32			   m_DebounceTicks;	
		
	//--//

	static BOOL Initialize	();
	static BOOL Uninitialize();
	static UINT32 Attributes( GPIO_PIN Pin );
	static void DisablePin( GPIO_PIN Pin, GPIO_RESISTOR ResistorState, UINT32 direction, GPIO_ALT_MODE AltFunction );
	static void EnableOutputPin( GPIO_PIN Pin, BOOL InitialState );
	static BOOL EnableInputPin( GPIO_PIN Pin, BOOL GlitchFilterEnable, GPIO_INTERRUPT_SERVICE_ROUTINE ISR, void* ISR_Param, GPIO_INT_EDGE IntEdge, GPIO_RESISTOR ResistorState );
	static BOOL GetPinState( GPIO_PIN Pin );
	static void SetPinState( GPIO_PIN Pin, BOOL PinState );
	static void ISR();
	static void SetResistor( GPIO_PIN Pin, GPIO_RESISTOR ResistorState );
	static BOOL PinIsBusy( GPIO_PIN Pin );
	static BOOL ReservePin( GPIO_PIN Pin, BOOL fReserve );
	static UINT32 GetDebounce();
	static BOOL SetDebounce( INT64 debounceTimeMilliseconds );
	static void GetPinsMap( UINT8* pins, size_t size );
//	static void SetPinData( GPIO_PIN Pin, BOOL Value );
//	static unsigned short GetPinData( GPIO_PIN Pin);
	
private:

	static UINT32 PinToPort( GPIO_PIN pin )
	{
		return (pin >> 8) & 0xFF;
	}

	static UINT32 PinToBit( GPIO_PIN pin )
	{
		return pin & 0x0F;
	}

	static UINT32 BitToPin( UINT32 bit, UINT32 port )
	{
		return bit | (port << 8);
	}

	static UINT32 BitAttributes ( UINT32 bit, UINT32 port )
	{
		switch (port){
		case 0:
			if((bit != 4) && (bit != 6))
				return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
			break;
		case 1:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 2:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 3:
			if(bit <= 4)
				return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
			else if(bit <= 5)
				return GPIO_ATTRIBUTE_INPUT;
			break;
		case 4:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 5:
			if(bit != 3)
				return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
			else
				return GPIO_ATTRIBUTE_INPUT;
		case 6:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 7:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 8:
			if(bit <= 5)
				return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
			break;
		case 9:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 10:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 11:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 12:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 13:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 14:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		case 15:
			if(bit <= 4)
				return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
			break;
		case 16:
			return GPIO_ATTRIBUTE_OUTPUT | GPIO_ATTRIBUTE_INPUT;
		}

		return GPIO_ATTRIBUTE_NONE;
	}

	static void STUB_GPIOISRVector( GPIO_PIN Pin, BOOL PinState, void* Param );
	
	static void GPIO_ControlReg_Write (unsigned short port, unsigned char data)
	{
		switch (port){
		case 0:
			PORT0.DR.BYTE = data;
		case 1:
			PORT1.DR.BYTE = data;
		case 2:
			PORT2.DR.BYTE = data;
		case 3:
			PORT3.DR.BYTE = data;
		case 4:
			PORT4.DR.BYTE = data;
		case 5:
			PORT5.DR.BYTE = data;
		case 6:
			PORT6.DR.BYTE = data;
		case 7:
			PORT7.DR.BYTE = data;
		case 8:
			PORT8.DR.BYTE = data;
		case 9:
			PORT9.DR.BYTE = data;
		case 10:
			PORTA.DR.BYTE = data;
		case 11:
			PORTB.DR.BYTE = data;
		case 12:
			PORTC.DR.BYTE = data;
		case 13:
			PORTD.DR.BYTE = data;
		case 14:
			PORTE.DR.BYTE = data;
		case 15:
			PORTF.DR.BYTE = data;
		case 16:
			PORTG.DR.BYTE = data;
		}
	}

	static unsigned char GPIO_ControlReg_Read (unsigned short port)
	{
		unsigned char data;
		switch (port){
		case 0:
			data = PORT0.DR.BYTE;
		case 1:
			data = PORT1.DR.BYTE;
		case 2:
			data = PORT2.DR.BYTE;
		case 3:
			data = PORT3.DR.BYTE;
		case 4:
			data = PORT4.DR.BYTE;
		case 5:
			data = PORT5.DR.BYTE;
		case 6:
			data = PORT6.DR.BYTE;
		case 7:
			data = PORT7.DR.BYTE;
		case 8:
			data = PORT8.DR.BYTE;
		case 9:
			data = PORT9.DR.BYTE;
		case 10:
			data = PORTA.DR.BYTE;
		case 11:
			data = PORTB.DR.BYTE;
		case 12:
			data = PORTC.DR.BYTE;
		case 13:
			data = PORTD.DR.BYTE;
		case 14:
			data = PORTE.DR.BYTE;
		case 15:
			data = PORTF.DR.BYTE;
		case 16:
			data = PORTG.DR.BYTE;
		}
		return data;
	}	
		
	static void GPIO_IOReg_Write (unsigned short port, unsigned char data)
	{
		switch (port){
		case 0:
			PORT0.DDR.BYTE = data;
		case 1:
			PORT1.DDR.BYTE = data;
		case 2:
			PORT2.DDR.BYTE = data;
		case 3:
			PORT3.DDR.BYTE = data;
		case 4:
			PORT4.DDR.BYTE = data;
		case 5:
			PORT5.DDR.BYTE = data;
		case 6:
			PORT6.DDR.BYTE = data;
		case 7:
			PORT7.DDR.BYTE = data;
		case 8:
			PORT8.DDR.BYTE = data;
		case 9:
			PORT9.DDR.BYTE = data;
		case 10:
			PORTA.DDR.BYTE = data;
		case 11:
			PORTB.DDR.BYTE = data;
		case 12:
			PORTC.DDR.BYTE = data;
		case 13:
			PORTD.DDR.BYTE = data;
		case 14:
			PORTE.DDR.BYTE = data;
		case 15:
			PORTF.DDR.BYTE = data;
		case 16:
			PORTG.DDR.BYTE = data;
		}
	}

	static unsigned char GPIO_IOReg_Read (unsigned short port)
	{
		unsigned char data;
		switch (port){
		case 0:
			data = PORT0.DDR.BYTE;
		case 1:
			data = PORT1.DDR.BYTE;
		case 2:
			data = PORT2.DDR.BYTE;
		case 3:
			data = PORT3.DDR.BYTE;
		case 4:
			data = PORT4.DDR.BYTE;
		case 5:
			data = PORT5.DDR.BYTE;
		case 6:
			data = PORT6.DDR.BYTE;
		case 7:
			data = PORT7.DDR.BYTE;
		case 8:
			data = PORT8.DDR.BYTE;
		case 9:
			data = PORT9.DDR.BYTE;
		case 10:
			data = PORTA.DDR.BYTE;
		case 11:
			data = PORTB.DDR.BYTE;
		case 12:
			data = PORTC.DDR.BYTE;
		case 13:
			data = PORTD.DDR.BYTE;
		case 14:
			data = PORTE.DDR.BYTE;
		case 15:
			data = PORTF.DDR.BYTE;
		case 16:
			data = PORTG.DDR.BYTE;
		}
		return data;
	}
	
	static void GPIO_DataReg_Write (unsigned short port, unsigned short data)
	{
		switch (port){
		case 0:
			PORT0.PORT.BYTE = data;
		case 1:
			PORT1.PORT.BYTE = data;
		case 2:
			PORT2.PORT.BYTE = data;
		case 3:
			PORT3.PORT.BYTE = data;
		case 4:
			PORT4.PORT.BYTE = data;
		case 5:
			PORT5.PORT.BYTE = data;
		case 6:
			PORT6.PORT.BYTE = data;
		case 7:
			PORT7.PORT.BYTE = data;
		case 8:
			PORT8.PORT.BYTE = data;
		case 9:
			PORT9.PORT.BYTE = data;
		case 10:
			PORTA.PORT.BYTE = data;
		case 11:
			PORTB.PORT.BYTE = data;
		case 12:
			PORTC.PORT.BYTE = data;
		case 13:
			PORTD.PORT.BYTE = data;
		case 14:
			PORTE.PORT.BYTE = data;
		case 15:
			PORTF.PORT.BYTE = data;
		case 16:
			PORTG.PORT.BYTE = data;
		}
	}

	static unsigned char GPIO_DataReg_Read (unsigned short port)
	{
		unsigned char data;
		switch (port){
		case 0:
			data = PORT0.PORT.BYTE;
		case 1:
			data = PORT1.PORT.BYTE;
		case 2:
			data = PORT2.PORT.BYTE;
		case 3:
			data = PORT3.PORT.BYTE;
		case 4:
			data = PORT4.PORT.BYTE;
		case 5:
			data = PORT5.PORT.BYTE;
		case 6:
			data = PORT6.PORT.BYTE;
		case 7:
			data = PORT7.PORT.BYTE;
		case 8:
			data = PORT8.PORT.BYTE;
		case 9:
			data = PORT9.PORT.BYTE;
		case 10:
			data = PORTA.PORT.BYTE;
		case 11:
			data = PORTB.PORT.BYTE;
		case 12:
			data = PORTC.PORT.BYTE;
		case 13:
			data = PORTD.PORT.BYTE;
		case 14:
			data = PORTE.PORT.BYTE;
		case 15:
			data = PORTF.PORT.BYTE;
		case 16:
			data = PORTG.PORT.BYTE;
		}
		return data;
	}
};

#endif //_RX62N_GPIO_H_