/***********************************************************************
 *
 *	file: synth.c
 *
 *	؂疽ߗ𐶐
 *
 *	$Id: synth.c 114 2007-04-10 02:22:06Z chapuni $
 *
 */

#include <assert.h>
#include <limits.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "config.h"
#include "crypt64.h"
#include "desconst.h"
#include "synth.h"
#include "util.h"
#include "wdict.h"

static int g_tn = T_INV + 1;

static int n_lrq[11];
static struct ITREE **lrq[11];

/***************************************************************
 *
 *	IyR[hWJ
 *
 *	r	EAX, ECX, EDX, EBX
 *		SIB, EBP, ESI, EDI
 *
 */

/* ofs8(i)  ofs32(i) 𐶐 */
static
void
disp_rm(FILE *sfp,
		unsigned d,
		unsigned i,
		int32_t ofs)
{
  assert(i != 4);	/* SP ł͂Ȃ SIB ɂȂ */
  if (i != 5 && ofs == 0)
	{
	  /* ItZbgȗ
		 00 ddd sss */
	  putc(0000
		   | ((d << 3) & 0070)
		   | (i & 0007),
		   sfp);
	}
  else if (-128 <= ofs && ofs <= 127)
	{
	  /* short ofs
		 01 ddd sss [ofs.b] */
	  putc(0100
		   | ((d << 3) & 0070)
		   | (i & 0007),
		   sfp);
	  putc(ofs, sfp);
	}
  else
	{
	  /* long ofs
		 10 ddd sss [ofs.l] */
	  putc(0200
		   | ((d << 3) & 0070)
		   | (i & 0007),
		   sfp);
	  fwrite(&ofs, sizeof(ofs), 1, sfp);
	}
}

/* I_ł LR/RL ւ܂ */
#define PTR_LR	7	/* DI */
#define PTR_RL	5	/* BP */
#define PTR_T	6	/* SI */
#define OFS_T	(-16)

#ifdef USE_64	/* ALU 64 */

/*
 *	0x49 0xF7 11-010-ddd	not
 *	0x49 op   11-sss-ddd
 *
 *	0x4C op   rm
 *	0x4C 0x8B rm	load
 *	0x4C 0x89 rm	store
 *
 */

#define OP_MOV	0x8B
#define OP_STOR	0x89
#define OP_AND	0x23
#define	OP_OR	0x0B
#define OP_XOR	0x33

static
void
reg_op(FILE *sfp,
	   unsigned op,
	   unsigned d,
	   unsigned s)
{
  putc(0x4D, sfp);
  putc(op & 0xFD, sfp);
  /* 11 sss ddd */
  putc(0300
	   | ((s << 3) & 0070)
	   | (d & 0007),
	   sfp);
}

static
void
reg_not(FILE *sfp,
		unsigned d)
{
  putc(0x47, sfp);
  putc(0xF7, sfp);
  /* 11 010 ddd */
  putc(0320
	   | (d & 0007),
	   sfp);
}

static
void
reg_mem(FILE *sfp,
		unsigned op,
		unsigned d,
		unsigned i,
		long ofs)
{
  putc(0x4C, sfp);
  putc(op, sfp);
  disp_rm(sfp, d, i, ofs);
}

#else	/* MMX or XMM */

#define OP_MOV	0x6F
#define OP_STOR	0x7F	
#define OP_AND	0xDB
#define OP_ANDN	0xDF
#define	OP_OR	0xEB
#define OP_XOR	0xEF

static
void
reg_op(FILE *sfp,
	   unsigned op,
	   unsigned d,
	   unsigned s)
{
#ifndef USE_MMX
  putc(0x66, sfp);
#endif
  putc(0x0F, sfp);
  putc(op, sfp);
  /* 11 ddd sss */
  putc(0300
	   | ((d << 3) & 0070)
	   | (s & 0007),
	   sfp);
}

static
void
reg_mem(FILE *sfp,
		unsigned op,
		unsigned d,
		unsigned i,
		int ofs)
{
#ifndef USE_MMX
  putc(0x66, sfp);
#endif
  putc(0x0F, sfp);
  putc(op, sfp);
  disp_rm(sfp, d, i, ofs);
}

/* cO̒萔ƉZ */
static
void
reg_not(FILE *sfp,
		unsigned d)
{
  reg_mem(sfp,
		  OP_XOR,
		  d,
		  PTR_T,
		  sizeof(WS_T) * (OFS_T + T_INV));
}

#endif

static
void
reg_clr(FILE *sfp,
		unsigned d)
{
  reg_op(sfp, OP_XOR, d, d);
}

/***************************************************************
 *
 *	m[h쐬
 *
 */

#define ALLOC_LEAP	64	/* 2**n */

static
struct ITREE *
synth_mknod(enum NODE_ID id)
{
  struct ITREE *node;

  node = calloc(1, sizeof(struct ITREE));
  assert(node != NULL);
  node->opcode = id;
  node->tn = -1;
  node->n_alloc = sizeof(node->tops) / sizeof(*node->tops);
  node->ops = node->tops;
  return node;
}

struct ITREE *
synth_make_not(void)
{
  return synth_mknod(NI_NOT);
}

struct ITREE *
synth_make_and(void)
{
  return synth_mknod(NI_AND);
}

struct ITREE *
synth_make_or(void)
{
  return synth_mknod(NI_OR);
}

struct ITREE *
synth_make_xor(void)
{
  return synth_mknod(NI_XOR);
}

struct ITREE *
synth_add(struct ITREE *parent, ...)
{
  struct ITREE *node;
  va_list ap;
  va_start(ap, parent);
  while ((node = va_arg(ap, struct ITREE *)) != NULL)
	{
	  /* alloc ̊g */
	  if (parent->n_alloc == parent->n_ops)
		{
		  assert((ALLOC_LEAP & (ALLOC_LEAP - 1)) == 0);
		  parent->n_alloc = (parent->n_alloc + ALLOC_LEAP) & -ALLOC_LEAP;
		  assert(parent->n_alloc > parent->n_ops);
		  if (parent->ops == parent->tops)
			{
			  parent->ops = malloc(parent->n_alloc * sizeof(*parent->ops));
			  memcpy(parent->ops, parent->tops, sizeof(parent->tops));
			}
		  else
			parent->ops = realloc(parent->ops,
								  parent->n_alloc * sizeof(*parent->ops));
		}
	  parent->ops[parent->n_ops++] = node;
	  node->ref++;
	}
  va_end(ap);
  return parent;
}

/***************************************************************
 *
 *	m[h
 *	Rh͉Ȃ
 *
 */

static
void
synth_free(struct ITREE *node)
{
#if DEBUG>=2
  printf("free: node=%p opcode=%d ops=%d\n",
		 node,
		 node->opcode,
		 node->n_ops);
#endif

  if (node->ops != NULL
	  && node->ops != node->tops)
	free(node->ops);

  /* g폜 */
  free(node);
}

/***************************************************************
 *
 *	m[h؂藣
 *	ref == 0 ɂȂ烁폜č폜Ԃ
 *
 */

int
synth_unlink(struct ITREE *node)
{
  int i;
  int n = 0;

  assert(node->ref > 0);
  if (--node->ref > 0)
	return 0;

  assert(node->opcode != NI_DICT);

  /* }؂藎Ƃ */
  for (i = 0; i < node->n_ops; i++)
	n += synth_unlink(node->ops[i]);

  /* LR ̏ꍇAXg؂藣 */
  if (node->opcode == NI_LR)
	{
	  for (i = 0; i < n_lrq[node->lrn]; i++)
	  if (lrq[node->lrn][i] == node)
		{
		  memmove(&lrq[node->lrn][i],
				  &lrq[node->lrn][i + 1],
				  (--n_lrq[node->lrn] - i) * sizeof(*lrq[0][0]));
		  goto deleted;
		}
	  assert(!"XXX orphan node");
	deleted:
	  ;
	}

  /* g폜 */
  synth_free(node);

  return n + 1;
}

/***************************************************************
 *
 *	LRm[ho^
 *
 */

struct ITREE *
synth_make_lr(uint64_t bmp, int lrn)
{
  struct ITREE *node;
  int qa, qb;

  assert(1 <= lrn && lrn <= 10);
  assert(bmp != 0);

  /* }XN */
  if (lrn == 10)
	{
	  bmp &= 0x1111111111111111ULL;

	  /* i̍œK̂
		 always t ̃m[h͑SrbgĂĂ */
	  if (!(~bmp & 0x1111111111111111ULL))
		bmp = 0xFFFFFFFFFFFFFFFFULL;
	}

  assert(bmp != 0);

  /* LbVɂłɓo^Ă΂Ԃ
	 ̔łł̓ĥŃoCiT[`( */
  for (qa = 0, qb = n_lrq[lrn];
	   qb > 0;
	   qb >>= 1)
	{
	  int q = qa + (qb >> 1);
	  assert(lrq[lrn] != NULL);
	  assert(lrq[lrn][q] != NULL);
	  assert(lrq[lrn][q]->opcode == NI_LR);
	  if (bmp == lrq[lrn][q]->bmp)
		return lrq[lrn][q];
	  else if (bmp > lrq[lrn][q]->bmp)
		{
		  qa = q + 1;
		  qb--;
		}
	}

#if DEBUG>=1
  if (n_lrq[lrn] == 0)
	printf("%2d:%3d/%3d=---------------- %08X%08X\n",
		   lrn,
		   qa, n_lrq[lrn],
		   (unsigned)(bmp >> 32),
		   (unsigned)bmp);

  if (qa < n_lrq[lrn])
	printf("%2d:%3d/%3d=%08X%08X %08X%08X\n",
		   lrn,
		   qa, n_lrq[lrn],
		   (unsigned)(lrq[lrn][qa]->bmp >> 32),
		   (unsigned)(lrq[lrn][qa]->bmp),
		   (unsigned)(bmp >> 32),
		   (unsigned)bmp);
#endif

  node = calloc(1, sizeof(struct ITREE));
  assert(node != NULL);
  node->opcode = NI_LR;
  node->tn = -1;
  node->lrn = lrn;
  node->bmp = bmp;

  /* LbVɑ}o^ */
  if (lrq[lrn] == NULL)
	{
	  assert(n_lrq[lrn] == 0);
	  lrq[lrn] = malloc(sizeof(*lrq[lrn]));
	  n_lrq[lrn]++;
	  assert(qa == 0);
	}
  else
	{
	  int n = n_lrq[lrn];
	  lrq[lrn] = realloc(lrq[lrn], (n + 1) * sizeof(*lrq[lrn]));
	  memmove(&lrq[lrn][qa + 1], &lrq[lrn][qa], (n - qa) * sizeof(*lrq[lrn]));
	  n_lrq[lrn] = n + 1;
	}
  assert(lrq[lrn] != NULL);
  assert(qa < n_lrq[lrn]);
  lrq[lrn][qa] = node;

  return node;
}

/***************************************************************
 *
 *	ɒP˂
 *
 */

struct ITREE *synth_make_dict(int pos,
							  struct DICT_CHAR const *word)
{
  struct WDICT *pd;
  struct ITREE *node = NULL;

  /* ɒPo^
	 NULL ԂĂƂ͂łɂ鎫ɓo^ */
  pd = wdict_add(g_tn, pos, word);

  /* m[h */
  if (pd != NULL)
	{
	  node = synth_mknod(NI_DICT);
	  assert(node != NULL);
	  node->dict = pd;
	  node->tn = g_tn++;
	  wdict_setnode(pd, node);
	  return node;
	}
  else
	{
	  /* ǂɒǉłꍇ́AijԂȂ(̂?) */
	  return NULL;
	}
}

/***************************************************************
 *
 *	؂_v; for debug
 *
 */

static
void
synth_dump(int lv, struct ITREE const *node)
{
  int i;
  char const *t = &"\t\t\t\t\t\t\t\t\t\t"[10 - lv];
  static char const node_name[][4] = 
	{
	  "LR",	/* -256 */
	  "DIC",
	  "NOT",
	  "AND",
	  "OR",
	  "XOR",
	};

  if (!node)
	return;

  if (NI_LR <= node->opcode && node->opcode <= NI_XOR)
	printf("%s[%s] (n=%d) ref=%d tn=%d %p\n%s{\n",
		   t,
		   node_name[node->opcode - NI_LR],
		   node->n_ops, node->ref,
		   node->tn,
		   node,
		   t);
  else
	printf("%snode=%d (n=%d) ref=%d %p\n%s{\n",
		   t,
		   node->opcode, node->n_ops, node->ref,
		   node,
		   t);
  if (node->opcode == NI_LR)
	{
	  printf("%s\t%2d:", 
			 t,
			 node->lrn);
	  if (popcnt64(node->bmp) > 14)
		printf("%08X%08X\n",
			   (unsigned)(node->bmp >> 32),
			   (unsigned)(node->bmp));
	  else
		{
		  putchar('[');
		  for (i = 0; i < 64; i++)
			if (node->bmp & (1ULL << i))
			  putchar(C64[i]);
		  puts("]");
		}
	}
  else if (node->opcode == NI_DICT)
	{
	  assert(node->dict != NULL);
	  wdict_dump(lv, node->dict);
	  for (i = 0; i < node->n_ops; i++)
		{
		  printf("%s%d:\n", t, i);
		  synth_dump(lv + 1, node->ops[i]);
		}
	}
  else for (i = 0; i < node->n_ops; i++)
	{
	  printf("%s%d:\n", t, i);
	  synth_dump(lv + 1, node->ops[i]);
	}
  printf("%s}\n", t);
}

/***************************************************************
 *
 *	@WJ(̂悤Ȃ)
 *	WJԂ
 *
 */

static
int
synth_expand_terms(uint64_t *px,		/* WJ */
				   int maxpx,			/* E */
				   uint64_t const *cov,	/* 핢 */
				   int covn)			/* 핢 */
{
  int i, j, k;
  int pxi = 0;

  assert(covn >= 0);

  for (i = 0; i < covn; i++)
	{
	  uint64_t m = cov[i];
	  if (!m)
		continue;
#if DEBUG>=1
	  printf(" [Pass %d: pxi=%d]", i, pxi);
#endif
	  if (pxi)
		{
		  int oxi = pxi;
		  uint64_t b;
		  for (b = 1; b != 0; b <<= 1)
			if (m & b)
			  for (j = oxi - 1; j >= 0; j--)
				{
				  uint64_t u = px[j];
				  assert(u != 0);
				  u |= b;
				  for (k = oxi; k < pxi; k++)
					{
					  uint64_t t = px[k];
					  if ((t & u) == t)
						goto exp_dup;	/* ǉKv͂Ȃ */
					  else if ((t & u) == u)
						{
						  /* ꂽ̂폜 */
						  px[k--] = px[--pxi];
						  continue;
						}
					}
				  assert(pxi <= maxpx);
				  if (pxi == maxpx)
					  return INT_MAX;	/* ߂ĂׂĂ̍I΂ */
				  px[pxi++] = u;
				exp_dup:
				  ;
				}
		  if (pxi > oxi)
			{
			  pxi -= oxi;
			  memmove(&px[0], &px[oxi], pxi * sizeof(*px));
			}
		}
	  else
		{
		  /* ꍀpӂ */
		  px[pxi++] = cov[i];
		}
	}

  return pxi;
}

/***************************************************************
 *
 *	핢\@WĴŏo
 *	(Petrick @ɂ)
 *
 */

static
uint64_t
synth_extract_minterm(uint64_t const *cov,
					  int covn,
					  int etn)
{
  int i;
  int n;
  uint64_t m;
  int minc;
  uint64_t aterm[256];
  uint64_t *term;

  term = (etn <= sizeof(aterm) / sizeof(*aterm)
		  ? aterm
		  : malloc(etn * sizeof(*term)));
  assert(term != NULL);

  n = synth_expand_terms(term,	/* WJ */
						 etn,
						 cov,
						 covn);
#if DEBUG>=1
  printf("generated etn=%d(pon=%d)\n", n, covn);
#endif
  if (n == INT_MAX)
	return (uint64_t)-1;
  assert(n <= etn);
  assert(n >= 0);
#if DEBUG>=2
  for (i = 0; i < n; i++)
	printf("%3d: %08X%08X(%2d)\n", i, (unsigned)(term[i] >> 32), (unsigned)term[i], popcnt64(term[i]));
#endif

  m = 0;
  minc = INT_MAX;
  for (i = 0; i < n; i++)
	{
	  unsigned c = popcnt64(term[i]);
	  if (minc > c)
		{
		  minc = c;
		  m = term[i];
		}
	}
  assert(minc > 0);

#if DEBUG>=2
  for (i = 0; i < n; i++)
	printf("%3d: %08X%08X(%2d)\n", i, (unsigned)(term[i] >> 32), (unsigned)term[i], popcnt64(term[i]));
#endif
#if DEBUG>=1
  printf("MIN: %08X%08X(%2d)\n", (unsigned)(m >> 32), (unsigned)m, minc);
#endif

  if (term != aterm)
	free(term);

  return m;
}

/***************************************************************
 *
 *	Quine-McCluskey @ɂ bmp ȒP
 *	i̔핢WJ Petrick @ɂ
 *
 *	TZԂ
 *	߂Ƃ INT_MAX ԂAS區𐶐
 *
 *	aox ɐϘa`ɂ錋ʂԂ(m==0 terminated)
 *
 */

/* Œ 64 [hƎv */
#define QMX_BITS	6
#define QMX_LEN		(1U << QMX_BITS)
#define QMX_N_MASK	(QMX_LEN - 1)
struct QMX
{
  uint8_t m;	/* 6:  */
  uint8_t n;	/* 6: 0 ͕⍀ */
};
#define QMX_N_ELIM	0x80	/* QMX::n ɂ폜 */

static
int
synth_simplify_qm(struct QMX *aox,
				  int maxn,		/* ϘaWJ(œKx) */
				  uint64_t bmp,	/* ^l\ */
				  uint64_t dc)	/* 1 ̃rbg D/C */
{
  int i, j;
  uint64_t m;
  int tn;
  int pon, dcn, prn, pgn, etn, mtn;
  uint64_t cov[QMX_LEN];			/* 핢 */
  struct QMX pox[QMX_LEN];			/* ŏ */
  struct QMX atmx[256 * QMX_LEN];	/* 64k 𒴂Ȃ炢ڈ? */
  int max_tmx = sizeof(atmx) / sizeof(struct QMX);
  struct QMX *tmx = atmx;

  /* D/C 񋓂 */
  dcn = 0;
  for (i = 0; i < QMX_LEN; i++)
	if (dc & (1ULL << i))
	  {
		tmx[dcn  ].m = QMX_N_MASK;
		tmx[dcn++].n = i;
	  }

  /* ŏ(1 ̍)񋓂 */
  bmp &= ~dc;
  pon = 0;
  for (i = 0; i < QMX_LEN; i++)
	if (bmp & (1ULL << i))
	  {
		pox[pon  ].m = QMX_N_MASK;
		pox[pon++].n = i & QMX_N_MASK;
	  }
#if DEBUG>=1
  printf("%08X%08X/%08X%08X pon=%d dcn=%d\n",
		 (unsigned)(bmp >> 32), (unsigned)bmp,
		 (unsigned)(dc  >> 32), (unsigned)dc,
		 pon, dcn);
#endif

#define C(i,s) (tmx[i].m & (1 << (s)) ? (tmx[i].n & (1 << (s)) ? '1' : '0') : '-')

  /* ̈Ŏ區߂ */
  memcpy(&tmx[dcn], pox, pon * sizeof(struct QMX));
  prn = pon + dcn;
  do
	{
	  pgn = prn;

	  /* ߂̂區ƂĔo */
	  for (i = 0; i < prn; i++)
		for (j = i + 1; j < prn; j++)
		  {
			int k;
			unsigned x;
			if (tmx[i].m != tmx[j].m)
			  continue;
			x = (tmx[i].n ^ tmx[j].n) & tmx[i].m;
			assert(x != 0);	/* OXe[Wɂďς݂̃nY */
			if (x & (x - 1))
			  continue;
			/* n~O1Ȃ̂ō܂Ƃ߂
			   قȂrbg}XN𐶐 */
			x = QMX_N_MASK & ~x;
			/* ꍀ͍ĐȂ悤(ߖ) */
			for (k = prn; k < pgn; k++)
			  if (tmx[k].m == (tmx[i].m & x)
				  && tmx[k].n == (tmx[i].n & x))
				goto tmx_dup;
			/* Pcɓo^ */
			tmx[pgn  ].m = tmx[i].m & x;
			tmx[pgn++].n = tmx[i].n & x;
			assert (pgn <= max_tmx);
			if (pgn == max_tmx)
			  {
				/* tmx ̊g
				   [J̈͂ݏoq[v擾 */
				assert(max_tmx  < INT_MAX / sizeof(struct QMX) / 2);
				max_tmx *= 2;
				if (tmx == atmx)
				  {
					tmx = malloc(max_tmx * sizeof(struct QMX));
					memcpy(tmx, atmx, sizeof(atmx));
#if DEBUG>=1
					printf("allocated: %d->%d\n", pgn, max_tmx);
#endif
				  }
				else
				  {
					tmx = realloc(tmx, max_tmx * sizeof(struct QMX));
#if DEBUG>=1
					printf("extended: %d->%d\n", pgn, max_tmx);
#endif
				  }
			  }
		  tmx_dup:
			/* ܂Ƃ߂ꂽɍ폜(Ƃ肠MSB) */
			tmx[i].n |= QMX_N_ELIM;
			tmx[j].n |= QMX_N_ELIM;
		  }

	  /* oꂽ̂dĂ */
	  for (i = 0; i < pgn; i++)
		for (j = i + 1; j < pgn; j++)
		  if (tmx[i].m == tmx[j].m
			  && ((tmx[i].n ^ tmx[j].n) & QMX_N_MASK) == 0)
			{
			  tmx[i].n |= QMX_N_ELIM;
			  break;	/* next i */
			}

	  /* 폜ꂽ̂̂Ă
		 珇sŋl߂Ă */
	  for (i = j = 0; i < pgn; i++)
		if (!(tmx[i].n & QMX_N_ELIM))
		  {
			if (i != j)
			  tmx[j] = tmx[i];
			j++;
		  }
#if DEBUG>=1
	  printf("prn=%d pgn=%d j=%d\n", prn, pgn, j);
#endif
	  prn = j;
	}
  while (i != j);

#if DEBUG>=1
  /* K{𔲂o */
  for (i = 0; i < prn; i++)
	{
	  printf("%3d: %c%c%c%c%c%c: ", i, C(i,5), C(i,4), C(i,3), C(i,2), C(i,1), C(i,0));
	  for (j = 0; j < pon; j++)
		if ((pox[j].m & tmx[i].m) == tmx[i].m
			&& (pox[j].n & tmx[i].m) == (tmx[i].n & tmx[i].m))
		  printf("*");
		else
		  printf("-");
	  printf("\n");
	}
#endif

  /* 區64𒴂Ă܂ꍇA߂(}WJ) */
  if (prn > 64)
	return INT_MAX;

  /* eŏɂāA區ɂ핢\𐶐 */
  memset(cov, 0, pon * sizeof(*cov));
  for (i = 0; i < pon; i++)
	for (j = 0; j < prn; j++)
	  if ((pox[i].m & tmx[j].m) == tmx[j].m
		  && (pox[i].n & tmx[j].m) == (tmx[j].n & tmx[j].m))
		cov[i] |= 1ULL << j;

  /* 핢\̏d菜
	 [l̃Gg͖dlɂȂĂ */
  etn = 1;
  for (i = 0; i < pon; i++)
	{
	  for (j = i + 1; j < pon; j++)
		if (cov[i] == cov[j])
		  {
			cov[i] = 0;
			break;	/* next i */
		  }
	  if (cov[i])
		etn *= (popcnt32(cov[i] >> 32) + popcnt32(cov[i]));
	}

#if DEBUG>=1
  printf("pon=%d prn=%d etn=%d\n", pon, prn, etn);
#endif

#if DEBUG>=2
  for (i = 0; i < pon; i++)
	if (cov[i])
	  printf("%2d: %08X%08x\n", i, (unsigned)(cov[i] >> 32), (unsigned)cov[i]);
#endif

  /* ŏ핢̒o
	 (ŏȂ̂?) */
#if DEBUG>=2
  for (i = 0; i < pon; i++)
	printf("%2d: %08X%08x\n", i, (unsigned)(cov[i] >> 32), (unsigned)cov[i]);
#endif
  m = synth_extract_minterm(cov, pon, maxn);	/* ςȂSrbg1 */

  /* ʂWJ */
  mtn = popcnt64(m);
  m &= ((1ULL << prn) - 1);
  tn = mtn;
  j = 0;
  for (i = 0; i < prn; i++)
	if (m & (1ULL << i))
	  {
		tn += popcnt32(tmx[i].m);
		if (aox)
		  aox[j++] = tmx[i];
#if DEBUG>=1
		printf("%c%c%c%c%c%c:%3d\n", C(i,5), C(i,4), C(i,3), C(i,2), C(i,1), C(i,0), tn);
#endif
		assert(j <= QMX_LEN);
	  }

  /* ԂԐl */
  if (aox && j < QMX_LEN)
	aox[j].m = 0;

#if DEBUG>=1
  printf("nterm=%d j=%d\n", tn, j);
#endif
  
  /* tmx gĂꍇ̂Ƃ܂ */
  if (tmx != atmx)
	free(tmx);

  /* SWJĂ܂ꍇ */
  return (mtn > prn ? INT_MAX : tn);
}

/***************************************************************
 *
 *	𒼂ȃWX^蓖
 *
 */

#define REG_RELOAD	0	/* tĂn̍œK͂ނLQ */
#define N_INFLIGHT	1	/* Z݂ */

#define NREGS	8
static struct ITREE *a_regs[NREGS];
static int g_reggen, a_reggen[NREGS];

static
int
synth_reg_find(struct ITREE *node)
{
  int i;
  assert(node != NULL);
  assert(node->ref > 0);
  for (i = 0; i < NREGS; i++)
	if (a_regs[i]
		&& a_regs[i] == node)
	  {
		a_reggen[i] = g_reggen++;
		return i;
	  }
  return -1;
}

/* WX^T() */
static
int
synth_reg_alloc_vacant(void)
{
  int i;
  
  for (i = 0; i < NREGS; i++)
	if (a_regs[i] == NULL
		|| a_regs[i]->ref == 0)
	  return i;

  return -1;
}

static
int
synth_reg_alloc(struct ITREE *node)
{
  int i;
  int g, r;

  /* łɊ蓖ĂĂ΂Ԃ */
  i = synth_reg_find(node);
  if (i >= 0)
	return i;
  /* ALWX^T */
  r = -1;
  g = INT_MAX;
  for (i = 0; i < NREGS; i++)
	if (a_regs[i] != NULL
		&& a_regs[i]->ref > 0)
	  {
		/* ߂Ă */
		if (g > a_reggen[i]
			&& a_regs[i]->tn >= 0)
		  {
			g = a_reggen[i];
			r = i;
		  }
	  }
	else
	  {
		a_regs[i] = node;
		a_reggen[i] = g_reggen++;
		return i;
	  }

  /* XXX ǂꂩЂƂҔāAɂɊ蓖Ă̂͏ */
  assert(r >= 0);
  assert(a_regs[r]->tn >= 0);
  a_regs[r] = node;
  a_reggen[r] = g_reggen++;
  return r;
}

/***************************************************************
 *
 *	ߗ𐶐
 *
 */

struct LRX
{
  struct ITREE *node;
  int mtn;
  int otn;
  int src;
  struct QMX *xp;
  unsigned mtm;
};

#define MTM_NOT	0x100U

static
int
cmp_lrx(void const *pa, void const *pb)
{
  struct LRX const *a = pa;
  struct LRX const *b = pb;
  int r;
  assert(a->node != NULL);
  assert(b->node != NULL);
  if ((r = a->mtn - b->mtn)
	  || (r = a->mtn - b->mtn)
	  || (r = a->mtm - b->mtm)
	  || (r = (int)popcnt64(a->node->bmp) - (int)popcnt64(b->node->bmp))
	  || (r = (int)(a->node->bmp >> 32) - (int)(b->node->bmp >> 32)))
	return r;
  return (int)a->node->bmp - (int)b->node->bmp;
}

static
void
synth_load_lr(FILE *sfp, int pos, int i)
{
  int o = tr_fp[6 * pos + (5 - i)];
  if (o < 32)
	reg_mem(sfp,
			OP_MOV,
			i,
			PTR_LR,
			sizeof(WS_T) * (o - 16));
  else if (o < 64)
	reg_mem(sfp,
			OP_MOV,
			i,
			PTR_RL,
			sizeof(WS_T) * (o - 32 - 16));
  assert(o < 64);
}

static
int
synth_assemble_lr(FILE *sfp, int pos, struct ITREE **nodea, int noden)
{
  int i;
  uint64_t m;
  unsigned regs_loaded = 0;
  int rd;
  int maxtn = 0x400;
  int recon;
  struct LRX *lrx;
  struct QMX (*qmx)[QMX_LEN + 1];
  int nts_total = 0;
  int nts_reduced = 0;
  assert(noden <= 10000);
#if DEBUG>=1
  fprintf(stderr, "WELCOME! (noden=%d)\n", noden);
#endif
  recon = 0;

  if (noden == 0)
	return 0;

  assert(nodea != NULL);

  m = (pos < 10
	   ? 0x0000000000000000ULL
	   : 0xEEEEEEEEEEEEEEEEULL);

  /* [NGA */
  lrx = calloc(noden, sizeof(*lrx));
  assert(lrx != NULL);
  qmx = calloc(noden, sizeof(*qmx));
  assert(qmx != NULL);

  for (i = 0; i < noden; i++)
	{
	  int j, k;
	  unsigned opo, opa;
	  struct ITREE *node;
	  struct QMX *xp;
	  struct QMX const *px;

	  for (j = i; j < noden; j++)
		{
		  /* ŏ̃[vŒʂ͂ */
		  if (lrx[j].node == NULL)
			{
			  lrx[j].node = nodea[j];
			  lrx[j].xp = qmx[j];
			  lrx[j].mtn  = synth_simplify_qm(lrx[j].xp, maxtn,
											  lrx[j].node->bmp,
											  m);
			  lrx[j].otn = lrx[j].mtn;
			  lrx[j].mtm  = OP_MOV;
			  lrx[j].src = -256;	/* ă}b`Ȃ */
			}
		  if (recon && lrx[j].mtn == INT_MAX)
			{
			  lrx[j].mtn  = synth_simplify_qm(lrx[j].xp, maxtn,
											  lrx[j].node->bmp,
											  m);
			  lrx[j].otn = lrx[j].mtn;
			  assert(lrx[j].mtm == OP_MOV);
			}

		  /* 핢̔핢߂ */
		  for (k = 0; k < i; k++)
			{
			  int ttn;
			  struct QMX txp[QMX_LEN + 1];

			  if (!recon && k < i - 2)	/* vZKviV */
				continue;

			  if ((lrx[k].node->bmp & lrx[j].node->bmp) == lrx[k].node->bmp
				  && (ttn = synth_simplify_qm(txp, maxtn,
											  lrx[j].node->bmp,
											  m | lrx[k].node->bmp)) < INT_MAX)
				{
				  /* OR */
				  if (k != i - 1)	/* Ô̂łȂ1iRXg */
					ttn++;
				  if (lrx[j].mtn > ttn)
					{
					  lrx[j].mtn = ttn;
					  lrx[j].mtm = OP_OR;
					  lrx[j].src = k;
					  memcpy(lrx[j].xp, txp, sizeof(txp));
					}
				}

			  if ((lrx[k].node->bmp & lrx[j].node->bmp) == lrx[j].node->bmp
				  && (ttn = synth_simplify_qm(txp, maxtn,
											  lrx[j].node->bmp,
											  m | ~lrx[k].node->bmp)) < INT_MAX)
				{
				  /* AND */
				  ttn++;	/* [h̕Q */
				  if (lrx[j].mtn > ttn)
					{
					  lrx[j].mtn = ttn;
					  lrx[j].mtm = OP_AND;
					  lrx[j].src = k;
					  memcpy(lrx[j].xp, txp, sizeof(txp));
					}
				}

			  if ((~lrx[k].node->bmp & lrx[j].node->bmp) == ~lrx[k].node->bmp
				  && (ttn = synth_simplify_qm(txp, maxtn,
											  lrx[j].node->bmp,
											  m | ~lrx[k].node->bmp)) < INT_MAX)
				{
				  /* NOT OR */
				  if (k != i - 1)	/* Ô̂łȂ1iRXg */
					ttn++;
				  ttn += 1;	/* NOT */
				  if (lrx[j].mtn > ttn)
					{
					  lrx[j].mtn = ttn;
					  lrx[j].mtm = OP_OR | MTM_NOT;
					  lrx[j].src = k;
					  memcpy(lrx[j].xp, txp, sizeof(txp));
					}
				}

			  if ((~lrx[k].node->bmp & lrx[j].node->bmp) == lrx[j].node->bmp
				  && (ttn = synth_simplify_qm(txp, maxtn,
											  lrx[j].node->bmp,
											  m | lrx[k].node->bmp)) < INT_MAX)
				{
				  /* NOT AND (not ANDN) */
				  ttn += 3;	/* LOAD, NOT, AND */
				  if (lrx[j].mtn > ttn)
					{
					  lrx[j].mtn = ttn;
					  lrx[j].mtm = OP_AND | MTM_NOT;
					  lrx[j].src = k;
					  memcpy(lrx[j].xp, txp, sizeof(txp));
					}
				}
			}
		}

	  /* \[g */
	  recon = 0;
	  qsort(&lrx[i], noden - i, sizeof(*lrx), cmp_lrx);

	  if (lrx[i].mtn == INT_MAX)
		{
		  if (maxtn < 0x4000)
			{
			  maxtn <<= 2;
			  assert(maxtn > 0);
			  fprintf(stderr,
					  "%dڂɂăhc{Ƀn}蒆c\t(%d)\n",
					  pos,
					  maxtn);
#if DEBUG>=1
			  fprintf(stderr, "%4d: grow up to 0x%X\n", i, maxtn);
#endif
			  recon = 1;
			  i--; continue;	/* redo */
			}
		  else
			{
			  /* gave up! SłĂ܂ */
			  fprintf(stderr, "%dڂɂ͎Q!\n", pos);
			}
		}

#if DEBUG>=1
	  fprintf(stderr,
			  "%4d/%4d:n=%3d/%3d(mt=%c%02X:src=%4d) %08X%08X\n",
			  i, (noden - i),
			  lrx[i].mtn,
			  lrx[i].otn,
			  (lrx[i].mtm & MTM_NOT ? '!' : ' '),
			  lrx[i].mtm & 0xFF,
			  lrx[i].src,
			  (unsigned)(lrx[i].node->bmp >> 32),
			  (unsigned)lrx[i].node->bmp);
#endif
	  assert(lrx[i].mtn >= 0);
	  nts_total += lrx[i].mtn;
	  if (lrx[i].mtm && lrx[i].otn < INT_MAX)
		nts_reduced += lrx[i].otn - lrx[i].mtn;
	  node = lrx[i].node;
	  xp = lrx[i].xp;

	  /* [NGA蓖 */
	  node->tn = g_tn++;
	  assert(g_tn <= sizeof(((struct PARAM *)NULL)->t) / sizeof(SLICE));

	  switch (lrx[i].mtm)
		{
		case OP_OR | MTM_NOT:
		case OP_OR:	rd = 6; opo = OP_OR;	break;
		default:	rd = 7; opo = OP_MOV;	break;
		}

	  /* o̍𗘗pĉZ΂ */
	  if (opo != OP_MOV && lrx[i].src != i - 1)
		reg_mem(sfp,
				OP_MOV,
				7,
				PTR_T,
				sizeof(WS_T) * (OFS_T + lrx[lrx[i].src].node->tn));

	  if (lrx[i].mtm == (OP_OR | MTM_NOT))
		reg_not(sfp, 7);

	  if (!(node->bmp & ~m)
		  || !~(node->bmp | m))
		{
		  fprintf(stderr,
				  "[ %08X%08X\n",
				  (unsigned)(node->bmp >> 32),
				  (unsigned)node->bmp);
		  assert(!!(node->bmp & ~m));
		  assert(!!~(node->bmp | m));
		}

	  /* kꂽWJ */
	  for (px = xp; px->m; px++)
		{
		  int j;
		  unsigned mi, pi;

		  opa = OP_MOV;

		  /* ⍀; !a!b..!f => !(a+b+...+f) */
		  mi = px->m & ~px->n;
		  for (j = 0; j < 6; j++)
			if (mi & (1 << j))
			  {
				if (!(regs_loaded & (1 << j)))
				  {
					synth_load_lr(sfp, pos, j);
					regs_loaded |= (1 << j);
				  }
				reg_op(sfp, opa, rd, j);
				opa = OP_OR;
			  }

#ifdef OP_ANDN
		  if (opa == OP_OR)
			opa = OP_ANDN;
#else
		  if (opa == OP_OR)
			{
			  reg_not(sfp, rd);
			  opa = OP_AND;
			}
#endif
		  /* c̐ύ */
		  pi = px->m & px->n;
		  for (j = 0; j < 6; j++)
			if (pi & (1 << j))
			  {
				if (!(regs_loaded & (1 << j)))
				  {
					synth_load_lr(sfp, pos, j);
					regs_loaded |= (1 << j);
				  }
				reg_op(sfp, opa, rd, j);
				opa = OP_AND;
			  }

		  /* ⍀ꍇ̏ */
#ifdef OP_ANDN
		  if (opa == OP_ANDN)
			reg_not(sfp, rd);
#endif

		  /* aɒǉ */
		  if (rd != 7)
			reg_op(sfp, opo, 7, rd);
		  rd = 6;
		  opo = OP_OR;
		}

	  if (opo == OP_MOV)
		{
		  /* ϘaȂꍇ */
		  assert(lrx[i].mtm != OP_MOV);
		  assert(lrx[i].mtm != OP_OR);
		  assert(lrx[i].src >= 0);
		  if (lrx[i].src != i - 1)
			reg_mem(sfp,
					OP_MOV,
					7,
					PTR_T,
					sizeof(WS_T) * (OFS_T + lrx[lrx[i].src].node->tn));
		  if (lrx[i].mtm & MTM_NOT)
			reg_not(sfp, 7);
		}
	  else switch (lrx[i].mtm)	  /* oƂ̉Z */
		{
		case OP_AND | MTM_NOT:
		  reg_mem(sfp,
				  OP_MOV,
				  6,
				  PTR_T,
				  sizeof(WS_T) * (OFS_T + lrx[lrx[i].src].node->tn));
		  reg_not(sfp, 6);
		  reg_op(sfp, OP_AND, 7, 6);
		  break;
		case OP_AND:
		  reg_mem(sfp,
				  lrx[i].mtm,
				  7,
				  PTR_T,
				  sizeof(WS_T) * (OFS_T + lrx[lrx[i].src].node->tn));
		  break;
		}

	  /* ʂ̊i[ */
	  reg_mem(sfp,
			  OP_STOR,
			  7,
			  PTR_T,
			  sizeof(WS_T) * (OFS_T + node->tn));

	  a_regs[7] = node;	/* XXX Cx */
	}
#if DEBUG>=1
  {
	static int tt, tn;
	tt += nts_total;
	tn += nts_reduced;
	fprintf(stderr,
			"term=%d (reduced %d) total:%d%%(%d reduced=%d)\n",
			nts_total, nts_reduced,
			100 * tt / (tt + tn),
			tt, tn);
  }
#endif

  free(lrx);
  free(qmx);

  return 0;
}

static
int
synth_assemble(FILE *sfp, struct ITREE *node)
{
  int i;
  int m;
  int rd[N_INFLIGHT];
  unsigned op[N_INFLIGHT];
  unsigned opx;
  int f_dict = 0;

  assert(node != NULL);
  assert(node->opcode == NI_DICT || node->tn < 0);
  assert(node->n_ops > 0);
  assert(node->ops != NULL);

  switch (node->opcode)
	{
	default: assert(!"XXX not supported");
	case NI_DICT:opx = OP_AND; break;
	case NI_AND: opx = OP_AND; break;
	case NI_OR:  opx = OP_OR;  break;
	case NI_XOR: opx = OP_XOR; break;
	}

  /* ܂Ȃ */
  node->ref++;

  /* WX^蓖Ă̏ */
  for (m = 0; m < N_INFLIGHT; m++)
	{
	  op[m] = OP_MOV;
	  rd[m] = -1;
	}

  /* }W߂ */
  m = 0;
  for (i = 0; i < node->n_ops; i++)
	{
	  struct ITREE *leaf = node->ops[i];
	  int rs;

	  assert(leaf != NULL);
	  assert(leaf->ref > 0);

	  /* Qɓ˓OɁAʂ HIT_BOOL ɏ߂
		 ̂ւ̏͂ւAhzbN
		 Ȃ̂ INFLIGHT = 1 ł肢! */
	  if (!f_dict
		  && leaf->opcode == NI_DICT)
		{
		  int td;
		  if (i > 0
			  && node->ops[i - 1]->opcode != NI_DICT)
			{
			  assert(rd[m] >= 0);
			  td = rd[m];
			}
		  else
			{
			  /* vNA */
			  td = synth_reg_alloc_vacant();
			  assert(td >= 0);	/* ŋ󂢂ĂȂnYȂȁc */
			  reg_clr(sfp, td);
			}
		  reg_mem(sfp,
				  OP_STOR,
				  td,
				  PTR_T,
				  sizeof(WS_T) * (OFS_T + HIT_BOOL));
		  f_dict = 1;
		}

	  /* }𐶐
		 DICT ͐Ƀ[NtĂ */
	  if (leaf->opcode == NI_DICT)
		synth_assemble(sfp, leaf);

	  rs = (leaf->tn >= 0
			? synth_reg_find(leaf)
			: synth_assemble(sfp, leaf));

	  if (op[m] == OP_MOV)
		{
		  assert(rd[m] < 0);
		  if (rs >= 0)
			{
			  assert(a_regs[rs] != NULL);
			  assert(a_regs[rs] == leaf);
			  if (a_regs[rs]->ref > 1)
				{
				  /* QƂĂ郌WX^̓Rs[ */
				  rd[m] = synth_reg_alloc(node);
				  assert(rd[m] >= 0);
				  reg_op(sfp, OP_MOV, rd[m], rs);
				}
			  else
				{
				  /* QƂȂȂ̂ŏ */
				  rd[m] = rs;
				  a_regs[rd[m]] = node;
				}
			}
		  else
			{
			  /* WX^Ɋ蓖ĂĂȂꍇ[h */
			  assert(leaf->tn >= 0);
			  rs = synth_reg_alloc(leaf);
			  reg_mem(sfp,
					  op[m],
					  rs,
					  PTR_T,
					  sizeof(WS_T) * (OFS_T + leaf->tn));
#if REG_RELOAD
			  if (leaf->ref > 1)
				{
				  /* Rs[Ƃ */
				  rd[m] = synth_reg_alloc(node);
				  reg_op(sfp, OP_MOV, rd[m], rs);
				}
			  else
#endif
				{
				  /* č\Ȃ */
				  a_regs[rd[m] = rs] = node;
				}
			}

		  /*  MOV ł͂Ȃ */
		  assert(rd[m] >= 0);
		  op[m] = opx;
		}
	  else
		{
		  assert(rs >= 0 || leaf->tn >= 0);

		  /* Ƃ̂Ƃl?? 񃌃WX^蓖 */
#if REG_RELOAD
		  if (rs < 0 && leaf->ref > 1)
			{
			  rs = synth_reg_alloc(leaf);
			  reg_mem(sfp,
					  op[m],
					  rs,
					  PTR_T,
					  sizeof(WS_T) * (OFS_T + leaf->tn));
			}
#endif

		  if (rs >= 0)
			reg_op(sfp, op[m], rd[m], rs);
		  else
			reg_mem(sfp,
					op[m],
					rd[m],
					PTR_T,
					sizeof(WS_T) * (OFS_T + leaf->tn));
		}

	  /* QƐ炷 */
	  leaf->ref--;

	  /* z */
	  if (++m >= N_INFLIGHT)
		m = 0;
	}

  /* 󂾂[ɂ */
  if (op[0] == OP_MOV)
	{
	  rd[0] = synth_reg_alloc(node);
	  reg_clr(sfp, rd[0]);
	}
  else
	for (i = 1; i < N_INFLIGHT; i++)
	  {
		if (op[i] != OP_MOV)
		  reg_op(sfp, op[i], rd[0], rd[i]);
		if (rd[i] >= 0)
		  a_regs[rd[i]] = NULL;
	  }

  /* ͕KʂcKv */
  if (node->opcode == NI_DICT)
	assert(node->tn >= 0);

  /* AND ̋L^ */
  if (node->opcode == NI_OR
	  && !f_dict)
	reg_mem(sfp,
			OP_STOR,
			rd[0],
			PTR_T,
			sizeof(WS_T) * (OFS_T + HIT_BOOL));

  /* XgA */
  if (node->tn >= 0)
	reg_mem(sfp,
			OP_STOR,
			rd[0],
			PTR_T,
			sizeof(WS_T) * (OFS_T + node->tn));

  /* ܂Ȃ */
  node->ref--;

  return rd[0];
}

/***************************************************************
 *
 *	؂v`œKĂ݂eXg
 *	œKɂʂԂ
 *
 */

static
int
cmp_node(void const *pa, void const *pb)
{
  int r;
  struct ITREE *a = *(struct ITREE **)pa;
  struct ITREE *b = *(struct ITREE **)pb;
  if ((r = b->opcode - a->opcode)
	  || (r = a->tn - b->tn)
	  || (r = (char const *)pa - (char const *)pb))	/* Ȃ */
	return r;

  assert(!"XXX notreached");
  return 0;
}

static
int
synth_optimize(struct ITREE *node)
{
  int neff = 0;
  int i, j;
  int sort_needed = 0;

  /* Ɏ}œKĂ */
  for (i = 0; i < node->n_ops; i++)
	{
	  struct ITREE *child = node->ops[i];

	  /* ɁA}̍œKɒ */
	  neff += synth_optimize(child);

	  /* Ӗ̂Ȃm[h𗎂Ƃ */
	  if (child->opcode == NI_LR
		  && ((node->opcode == NI_AND && !~child->bmp)
			  || (node->opcode == NI_DICT && !~child->bmp)
			  || (node->opcode == NI_OR && ~child->bmp)))
		{
		  neff += 1 + synth_unlink(child);
		  memmove(&node->ops[i],
				  &node->ops[i + 1],
				  (--node->n_ops - i) * sizeof(*node->ops));
		  i--; goto redo_i;
		}

	  /* |C^͖ɗZł */
	  for (j = 0; j < i; j++)
		if (node->ops[j] == child)
		  {
			child->ref--;
			assert(child->ref >= 1);
			memmove(&node->ops[i],
					&node->ops[i + 1],
					(--node->n_ops - i) * sizeof(node->ops[i]));
			neff++;
			i--; goto redo_i;
		  }

	  /* ̉Z͗Z\ */
	  if (child->opcode == node->opcode
		  && child->tn < 0
		  && child->ref == 1)
		{
		  memmove(&node->ops[i],
				  &node->ops[i + 1],
				  (--node->n_ops - i) * sizeof(node->ops[i]));
		  if (node->n_alloc < node->n_ops + child->n_ops)
			{
			  node->n_alloc = 3 * (node->n_ops + child->n_ops) / 2;
			  if (node->ops == node->tops)
				{
				  node->ops = malloc(node->n_alloc * sizeof(node->ops[0]));
				  memcpy(node->ops, node->tops, sizeof(node->tops));
				}
			  else
				node->ops = realloc(node->ops,
									node->n_alloc * sizeof(node->ops[0]));
			}
		  memcpy(&node->ops[node->n_ops],
				 &child->ops[0],
				 child->n_ops * sizeof(child->ops[0]));
		  node->n_ops += child->n_ops;
		  synth_free(child);
		  neff++;
		  i--; goto redo_i;
		}

	  /* ݂̂wq𗎂Ƃ */
	  if (child->n_ops == 1
		  && child->ref == 1)
		{
		  assert(child->tn < 0);
		  node->ops[i] = child->ops[0];
		  child->n_ops--;
		  neff += 1 + synth_unlink(child);
		  i--; goto redo_i;
		}

	  if (i > 0
		  && node->ops[i - 1]->opcode == NI_DICT
		  && node->ops[i]->opcode != NI_DICT)
		sort_needed++;

	redo_i:
	  ;
	}

  /* AND->DICT ƂȂ悤Ƀ\[g */
  if (sort_needed)
	qsort(node->ops, node->n_ops, sizeof(*node->ops), cmp_node);

  return neff;
}

/***************************************************************
 *
 *	؂疽ߗ𐶐
 *
 */

int
synth_synthesize(FILE *sfp,
				 struct ITREE *node)
{
  int i;
  int r;
  off_t olr, ot;

  /* WJ */
  if (node)
	fprintf(stderr, "PWJc\n");
  wdict_setup_lr();

  if (node)
	{
	  fprintf(stderr, "؂v`œKĂ݂eXgc\n");
#if DEBUG>=2
	  synth_dump(0, node);
#endif
	  r = synth_optimize(node);
	  if (r > 0)
		fprintf(stderr, "_ %d ܂B\n", r);
	}

#if DEBUG>=1
  synth_dump(0, node);
#endif

  /* LR ߗ𐶐 */
  olr = ftell(sfp);
  if (node)
	fprintf(stderr, "ɒ풆c\n");
  for (i = 0; i < 11; i++)
	synth_assemble_lr(sfp, i, lrq[i], n_lrq[i]);
#if DEBUG>=1
  ot = ftell(sfp);
  olr = ot - olr;
  fprintf(stderr, "0x%08X(%d): LR size\n", (unsigned)olr, (unsigned)olr);
#endif

  /* ؂go[XĎc̖ߗ𐶐 */
  if (node)
	{
	  fprintf(stderr, "gݗĒc\n");
	  r = synth_assemble(sfp, node);
	}
  else
	{
	  fprintf(stderr,
			  "* s킹ɂ target.txt KvłB\n"
			  "  Ƀx`}[N[h(%drbg)ɓ˓܂B\n",
			  1 << N_STRIDE);
	  r = 7;
	  reg_clr(sfp, r);
	}

  /* ŏIʂ̊i[ */
  reg_mem(sfp,
		  OP_STOR,
		  r,
		  PTR_T,
		  sizeof(WS_T) * (OFS_T + HIT_ANY));

#if DEBUG>=1
  ot = ftell(sfp) - ot;
  fprintf(stderr,
		  "0x%08X(%d): TR size\ng_tn=%d g_reggen=%d\n",
		  (unsigned)ot, (unsigned)ot,
		  g_tn, g_reggen);
#endif

  return 0;
}

/*
 *	Local Variables:
 *		tab-width:	4
 *	End:
 *
 * EOF */
