/***********************************************************************
 *
 *	file: mty.c
 *
 *	܂A҂ĉB
 *
 *	$Id: mty.c 119 2007-04-13 03:09:02Z notanpe $
 *
 */

#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <malloc.h>
#include <limits.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#if defined(WIN32)

#include <windows.h>
#include <sys/timeb.h>

#elif defined(__GNUC__)

#include <sys/time.h>

#endif

#include "config.h"
#include "cp932.h"
#include "crypt64.h"
#include "desconst.h"
#include "expr_parse.h"
#include "scoreboard.h"
#include "synth.h"
#include "tr64.h"
#include "translate.h"
#include "wdict.h"

#if USE_DT
#include "dt4.h"
#endif

/*  */
unsigned char key[8 + 8];
unsigned char okey[8 + 8];

/* NX */
static
struct
{
  unsigned cls;
  unsigned map[256];
} kcls[8 + 8];


/* gNX */
#define KCLS_DT0 64
#define KCLS_DT1 128
#define KCLS_K2 256

#if USE_DT
/* LpCfNX */
struct DT *kd[8 + 8];

/* CfNX */
struct DT *dtidx[0x100 + 1];
#endif

/* w肳ꂽNXƓĂL[Aclassify s */
void
key_make_map(int n)
{
  int i, j;
  unsigned c = kcls[n].map[key[n]];

#if USE_DT
  if (3 <= n && n < 7 && kd[n - 3])
	{
	  /* ̃Pc̕BɃijLN^ */
	  c = kd[n - 3]->c[0];
	  if ((0x81 <= c && c <= 0x9F)
		  || (0xE0 <= c && c <= 0xFC))
		c = KCLS_K2;
	  else
		c = (cp932[256 * key[n]]
			 | cp932[256 * (key[n] ^ 0x80)]);
#if DEBUG>=1
	  printf("*n=%d, key=%02X, cls=%04X\n",
			 n,
			 key[n],
			 c);
#endif
	}
  else if (2 <= n && n < 6 && kd[n - 2])
	{
	  return;
	}
  else if (1 <= n && n < 5 && kd[n - 1])
	{
	  return;
	}
  else if (1 <= n && n < 5 && !kd[n - 1]
		   //&& (c & KCLS_K2)
		   && (c & KCLS_DT1))
	{
	  /* 2EĂ܂ */
#if DEBUG>=1
	  printf("(%d)%02X %02X(%02X:%02X:%02X:%02X)\n",
			 n, key[n - 1], key[n],
			 cp932[(256 * key[n - 1] + key[n])],
			 cp932[(256 * key[n - 1] + key[n]) ^ 0x0080],
			 cp932[(256 * key[n - 1] + key[n]) ^ 0x8000],
			 cp932[(256 * key[n - 1] + key[n]) ^ 0x8080]);
#endif
	  if (n != 1 && n != 2
		  && (cp932[(256 * key[n - 1] + key[n]) ^ 0x0080] & KCLS_DT1))
		key[n] ^= 0x80;
	  else if (n != 2 && n != 3
			   && (cp932[(256 * key[n - 1] + key[n]) ^ 0x8000] & KCLS_DT1))
		key[n - 1] ^= 0x80;
	  else if (n > 3 && (cp932[(256 * key[n - 1] + key[n]) ^ 0x8080] & KCLS_DT1))
		key[n - 1] ^= 0x80, key[n] ^= 0x80;
	  if (cp932[256 * key[n - 1] + key[n]] & KCLS_DT1)
		{
		  for (kd[n - 1] = dtidx[key[n - 1]];
			   kd[n - 1]->c[1] != key[n];
			   kd[n - 1]++)
			assert(kd[n - 1]->c[0] == key[n - 1]);
#if DEBUG>=1
		  printf("(%02X%02X:%02X%02X)%c%c%c%c\n",
				 kd[n - 1]->c[0],
				 kd[n - 1]->c[1],
				 kd[n - 1]->c[2],
				 kd[n - 1]->c[3],
				 kd[n - 1]->c[0],
				 kd[n - 1]->c[1],
				 kd[n - 1]->c[2],
				 kd[n - 1]->c[3]);
#endif
		  return;
		}
	}
  else if (n < 4 && (c & KCLS_DT0) && kd[n] == NULL)
	{
	  /* J^Jiߍ݂܂ */
	  assert(kd[n] == NULL);
#if DEBUG>=1
	  printf("n=%d, key=%02X\n", n, key[n]);
#endif
	  kd[n] = dtidx[key[n]];
	  if (!kd[n]
		  && !(n == 1 || n == 2)
		  && dtidx[key[n] ^ 0x80])
		{
		  key[n] ^= 0x80;
		  kd[n] = dtidx[key[n]];
		}
	  if (kd[n])
		return;
	}
  else
	{
	  kd[n] = NULL;
	}
#endif

  /* Ō̕ class map 𐶐KviV */
  if (n >= 6)
	return;

  for (i = 0; i < 256; i++)
	{
	  unsigned bm = 0;
#if 1
	  if (c & KCLS_K1)
		{
		  if (cp932[256 * key[n] + i] & KCLS_K1)
			bm |= KCLS_K2 | (cp932[256 * key[n] + i] & KCLS_DT1);
		  if (cp932[256 * (key[n] ^ 0x80) + i] & KCLS_K1)
			bm |= KCLS_K2 | (cp932[256 * (key[n] ^ 0x80) + i] & KCLS_DT1);
#if 0
		  bm |= ((cp932[256 * key[n] + i] & KCLS_K1)
				 || (cp932[256 * (key[n] ^ 0x80) + i] & KCLS_K1)
				 ? KCLS_K2 : 0);
#endif
		}
	  if (c & (KCLS_AN | KCLS_KA | KCLS_K2))
		for (j = 0; j < 256; j++)
		{
		  bm |= cp932[256 * i + j] & (KCLS_AN | KCLS_KA | KCLS_K1
									  | KCLS_DT0);
#if 0
		  if (j >= 127 && !(n == 0 || n == 1))
			break;
#endif
		}
	  kcls[n + 1].map[i] = bm;
#endif
	  if (i >= 128 && !(n == 0 || n == 1))
		kcls[n + 1].map[i - 128] |= kcls[n + 1].map[i];
	}

  if (n < 6)
	kcls[n + 1].map[0x00] = kcls[n + 1].map[0x80] = 0;
  if (n == 6)
	kcls[7].map[0x00] |= KCLS_AN;
}

#if USE_DT
unsigned
dt_get(int kdn,
	   int xn,
	   int n,
	   int ch)
{
  int i;
#if DEBUG>=1
  printf("*dt_get(%d)%c%c%c%c(%02X%02X:%02X%02X)->ch=%d",
		 n,
		 kd[kdn]->c[0], kd[kdn]->c[1], kd[kdn]->c[2], kd[kdn]->c[3],
		 kd[kdn]->c[0], kd[kdn]->c[1], kd[kdn]->c[2], kd[kdn]->c[3],
		 ch);
#endif
  /* ܂͐ */
  for (i = 0;
	   kd[kdn][i].c[xn] == kd[kdn]->c[xn];
	   i++)
	;
  assert(i > 0);
  kd[kdn] += ch % i;
#if DEBUG>=1
  printf("/%d\n dt_get:  %c%c%c%c(%02X%02X:%02X%02X)->ch=%d\n",
		 i,
		 kd[kdn]->c[0], kd[kdn]->c[1], kd[kdn]->c[2], kd[kdn]->c[3],
		 kd[kdn]->c[0], kd[kdn]->c[1], kd[kdn]->c[2], kd[kdn]->c[3],
		 ch);
#endif
  return kd[kdn]->c[n];
}
#endif

/* }bv當EăZbg */
unsigned
key_set(int n, unsigned ch)
{
  int cnt = 0, i;

#if USE_DT
  if (3 <= n && n < 7 && kd[n - 3])
	{
	  return dt_get(n - 3, 2, 3, ch);
	  return kd[n - 3]->c[3];
	}
  else if (2 <= n && n < 6 && kd[n - 2])
	{
	  return dt_get(n - 2, 1, 2, ch);
	  return kd[n - 2]->c[2];
	}
  else if (1 <= n && n < 5 && kd[n - 1])
	{
	  return dt_get(n - 1, 0, 1, ch);
	  return kd[n - 1]->c[1];
	}
#endif

#if DEBUG>=3
  if (cnt == 0)
	{
	  printf("n=%d, ch=%d, (n-1)=%02X\n", n, ch, key[n - 1]);
	  int j;
	  for (i = 0; i < 16; i++)
		{
		  printf("map[0x%02X] =", 16 * i);
		  for (j = 0; j < 16; j++)
			printf(" %03X", kcls[n].map[16 * i + j]);
		  printf("\n");
		}
	}
#endif
  for (i = 0; i < 256; i++)
	{
	  if (kcls[n].map[i])
		{
		  if (ch-- == 0)
			return i;
		  cnt++;
		}
	  if (n != 1 && n != 2 && i >= 127)
		break;
	}
  /* Ȃ̂ł؂ */
  assert(cnt > 0);
  ch %= cnt;
  for (i = 0; i < 256; i++)
	if (kcls[n].map[i])
	  {
		if (ch-- == 0)
		  return i;
	  }
  assert(!"not matched");
  return 0;
}

/* bitwise key Zbg */
static
void
key_set64(struct KEY *key64,
		  int n,
		  unsigned k,
		  unsigned vk,
		  unsigned sk)
{
  int i, j;
  if (!((vk | sk) & 0x7F))
	return;

  for (i = 0; i < 7; i++)
	{
	  if (n == 7 && i < N_STRIDE) continue;
	  if (sk & (1 << i))
		{
		  /* Zbg */
		  int o = tr_pc1[n][6 - i] - 1;
		  if (o < 28)
			{
			  assert(o >= 0);
			  for (j = 0; j < N_ALU; j++)
				key64->k[0][0][o].a[j]
				= key64->k[0][1][o].a[j]
				  = -!!(k & (1 << i));
			}
		  else
			{
			  assert(o >= 28);
			  assert(o < 56);
			  for (j = 0; j < N_ALU; j++)
				key64->k[1][0][o - 28].a[j]
				  = key64->k[1][1][o - 28].a[j]
				  = -!!(k & (1 << i));
			}
		}
	  else if (vk & (1 << i))
		{
		  /* ] */
		  int o = tr_pc1[n][6 - i] - 1;
		  if (o < 28)
			{
			  assert(o >= 0);
			  for (j = 0; j < N_ALU; j++)
			  key64->k[0][0][o].a[j]
				= key64->k[0][1][o].a[j]
				= ~key64->k[0][0][o].a[j];
			}
		  else
			{
			  assert(o >= 28);
			  assert(o < 56);
			  for (j = 0; j < N_ALU; j++)
				key64->k[1][0][o - 28].a[j]
				= key64->k[1][1][o - 28].a[j]
				= ~key64->k[1][0][o - 28].a[j];
			}
		}
	}
}

/* w肳ꂽNX̊JnlɃZbg
   Õ̕NXɔ */
int
key_reset(int n)
{
  if (n >= 8)
	return 1;
  if (n == 7)
	{
	  key[7] = 0;
	  return 1;
	}

  /* 0-2 ڂ̓_Ɍ߂
	 3 ڈȍ~͏l */
  if (n >= 3)
	key[n] = key_set(n, 0);
  else
	key[n] = key_set(n, rand());

#if DEBUG>=3
  printf("key[%d]=%02X ncls=%04X\n", n, key[n], kcls[n].map[key[n]]);
#endif

  /* ZbgꂽɁAL̕NX߂ */
  key_make_map(n);

  return key_reset(n + 1);
}

/* w肳ꂽԂ̒ŁAL[ЂƂi߂
   SɃCNgłꍇ true Ԃ */
static
int
key_inc(int n)
{
  if (n >= 8)
	return 0;
  else if (n == 7)
	{
	  /* Ō̃oCg */
	  key[7] = (key[7] + (1 << N_STRIDE)) & 0x7F;
	  if (key[7]) return 1;
	  else return 0;
	}
  else if (key_inc(n + 1)
		   /*
			&& key_inc(n + 1)
		   && key_inc(n + 1)
		   && key_inc(n + 1)*/
		   )
	return 1;

  /* Salt ̓CNgȂ񑩂ɂ */
  if (n == 1 || n == 2)
	return 1;

#if DEBUG>=3
  printf("key_inc(n=%d,ck=%02X)\n", n, key[n]);
#endif

#if USE_DT
  /* ̓CNgĂ񑩂ɂ */
  if (3 <= n && n < 7 && kd[n - 3])
	{
	  if ((key[n - 3] & 0x7F) == ((kd[n - 3] + 1)->c[0] & 0x7F)
		  && (key[n - 2] & 0x7F) == ((kd[n - 3] + 1)->c[1] & 0x7F)
		  && (key[n - 1] & 0x7F) == ((kd[n - 3] + 1)->c[2] & 0x7F))
		{
		  memcpy(&key[n - 3], &(++kd[n - 3])->c[0], 4);
#if DEBUG>=2
		  printf(">dt_get:%c%c%c%c(%02X%02X:%02X%02X)\n",
				 kd[n - 3]->c[0], kd[n - 3]->c[1], kd[n - 3]->c[2], kd[n - 3]->c[3],
				 kd[n - 3]->c[0], kd[n - 3]->c[1], kd[n - 3]->c[2], kd[n - 3]->c[3]);
#endif
		  return 1;
		}
	  else
		{
		  return 0;
		}
	}
  else if (2 <= n && n < 6 && kd[n - 2])
	{
	  if ((key[n - 2] & 0x7F) == ((kd[n - 2] + 1)->c[0] & 0x7F)
		  && (key[n - 1] & 0x7F) == ((kd[n - 2] + 1)->c[1] & 0x7F))
		{
		  memcpy(&key[n - 2], &(++kd[n - 2])->c[0], 4);
#if DEBUG>=2
		  printf(">dt_get:%c%c%c%c(%02X%02X:%02X%02X)\n",
				 kd[n - 2]->c[0], kd[n - 2]->c[1], kd[n - 2]->c[2], kd[n - 2]->c[3],
				 kd[n - 2]->c[0], kd[n - 2]->c[1], kd[n - 2]->c[2], kd[n - 2]->c[3]);
#endif
		  return 1;
		}
	  else
		{
		  return 0;
		}
	  if (kd[n - 2]->c[0] == key[n - 2])
		return 1;
	  else
		return 0;
	}
  else if (1 <= n && n < 5 && kd[n - 1])
	{
	  unsigned c2 = kd[n - 1]->c[0];
	  if ((0x81 <= c2 && c2 <= 0x9F)
		  || (0xE0 <= c2 && c2 <= 0xFC))
		{
		  kd[n - 1] = NULL;
#if 0
		  if (!(n == 1 && n == 2))
			key[n] &= 0x7F;
		  if (!(n == 2 && n == 3))
			key[n - 1] &= 0x7F;
#endif
		  key_make_map(n - 1);
		}
	  else if ((key[n - 1] & 0x7F) == ((kd[n - 1] + 1)->c[0] & 0x7F))
		{
		  memcpy(&key[n - 1], &(++kd[n - 1])->c[0], 4);
#if DEBUG>=2
		  printf(">dt_get:%c%c%c%c(%02X%02X:%02X%02X)\n",
				 kd[n - 1]->c[0], kd[n - 1]->c[1], kd[n - 1]->c[2], kd[n - 1]->c[3],
				 kd[n - 1]->c[0], kd[n - 1]->c[1], kd[n - 1]->c[2], kd[n - 1]->c[3]);
#endif
		  return 1;
		}
	  else
		{
		  return 0;
		}
#if 0
	  if (kd[n - 1]->c[0] == key[n - 1])
		return 1;
	  else
		return 0;
#endif
	}
  else if (n < 4 && kd[n])
	{
	  if (0 && kd[n]->c[0] == key[n])
		return 1;
	  kd[n] = NULL;
#if 0
	  if (!(n == 1 || n == 2))
		key[n] &= 0x7F;
#endif
	}
#endif

  /* ۂɑ₵Ă݂ */
  assert(n >= 3);
  for (;;)
	{
	  if (n <= 3
		  && !(key[n] & 0x80)
		  && kcls[n].map[key[n] ^ 0x80] & (KCLS_DT0))
		{
		  /* pJ^Ji1oCg */
		  key[n] ^= 0x80;
		}
	  else
		{
		  key[n] = (key[n] & 0x7F) + 1;
		  if (key[n] >= 0x80)
			return 0;
		}

	  if (kcls[n].map[key[n]])
		{
		  key_make_map(n);
		  key_reset(n + 1);
		  return 1;
		}
	}
  while (++key[n] < 0x80)
	{
	  if (kcls[n].map[key[n]])
		{
		  key_make_map(n);
		  key_reset(n + 1);
		  return 1;
		}
	}
  return 0;
}

/* SɃZbg
   SaltZbg */
static
void
key_init()
{
  int i, j;

#if USE_DT
  /* ACfNXȂ}bvɂ͂߂Ő
	 ̓R[hɕł̂Ƃ */
  for (i = 0; i < dtcnt; i++)
	{
	  unsigned c = dt[i].c[0];

	  assert(dt[i].c[0]
			 && dt[i].c[1]
			 && dt[i].c[2]
			 && dt[i].c[3]);

	  /* BSD Iłɂȕ͎cOȂ珜O */
	  assert((dt[i].c[0] & 0x7F)
			 && (dt[i].c[1] & 0x7F)
			 && (dt[i].c[2] & 0x7F)
			 && (dt[i].c[3] & 0x7F));

	  /* CfNX */
	  if (!dtidx[c])
		dtidx[c] = &dt[i];

	  if ((0x81 <= c && c <= 0x9F)
		  || (0xE0 <= c && c <= 0xFC))
		{
		  /* SpȂ̂ŁA2oCg܂_ŗĂ */
		  cp932[256 * c + dt[i].c[1]] |= KCLS_DT1;
		}
	  else if (0xA1 <= c && c <= 0xDF)
		{
		  /* pJi */
		  for (j = 0; j < 256; j++)
			cp932[256 * c + j] |= KCLS_DT0;
		}
	}
  /* PcAԐl */
  dtidx[0x100] = &dt[i];
#endif

  key[8] = 0;

  /* }bvg */
  for (i = 0; i < 256; i++)
	{
	  unsigned bm = 0;
	  kcls[0].map[i] = 0;
	  for (j = 0; j < 256; j++)
		bm |= cp932[256 * i + j];
	  kcls[0].map[i] = bm & (KCLS_AN | KCLS_KA | KCLS_K1
							 | KCLS_DT0
							 );
	  if (i >= 128)
		kcls[0].map[i - 128] |= kcls[0].map[i];
	}

  key_reset(0);
}

/***************************************************************
 *
 *	Salt ̃Zbg
 *	Iyh̃ItZbgĉĂ̂Œ
 *
 */

#if N_STRIDE == 6
#define C(c,i,j,o) (*(int8_t  *)((c) + (loo - crypt64_sta) + los[6 * (i) + (j) + (o)]))
#elif N_STRIDE == 7
#define C(c,i,j,o) (*(int32_t *)((c) + (loo - crypt64_sta) + los[6 * (i) + (j) + (o)]))
#endif

void
set_salt(signed char *code,
		 unsigned char const *k)
{
  int i, j;

  for (i = 0; i < 2; i++)
	{
	  unsigned s = k[1 + i] & 255;
	  if (s > 'z')
		s = 0;
	  else if (s >= 'a')
		s = s - 'a' + 2 + 10 + 26;
	  else if (s >= 'A')
		s = s - 'A' + 2 + 10;
	  else if (s >= '.')
		s = s - '.';
	  else
		s = 0;

#if DEBUG>=1
	  printf("Salt %d:%3o\n", i, s & 63);
#endif
	  for (j = 0; j < 6; j++)
		{
#if DEBUG>=2
		  //printf("Salt %d:%d %+3d:%+3d",
		  printf("Salt %d:%d %08lX:%08lX",
				 i, j,
				 C(code, i, j,  0),
				 C(code, i, j, 24));
#endif
		if (s & (1 << j))
		  {
			C(code, i, j,  0) = sizeof(WS_T) * (((4 * i + j + 15) & 31) - 16);
			C(code, i, j, 24) = sizeof(WS_T) * (((4 * i + j -  1) & 31) - 16);
		  }
		else
		  {
			C(code, i, j,  0) = sizeof(WS_T) * (((4 * i + j -  1) & 31) - 16);
			C(code, i, j, 24) = sizeof(WS_T) * (((4 * i + j + 15) & 31) - 16);
		  }
		C(code, i, j, 12) = sizeof(WS_T) * (((4 * i + j +  7) & 31) - 16);
		C(code, i, j, 36) = sizeof(WS_T) * (((4 * i + j + 23) & 31) - 16);
#if DEBUG>=2
		//printf(" => %+3d:%+3d\n",
		  printf(" => %08lX:%08lX\n",
				 C(code, i, j,  0),
				 C(code, i, j, 24));
#endif
		}
	}
}

static
unsigned long
usec()
{
#if !defined(WIN32)
  struct timeval tv;
  gettimeofday(&tv, NULL);
  return 100UL * tv.tv_sec + (tv.tv_usec / 10000);
#else
  struct timeb tm;
  ftime(&tm);
  return 100UL * tm.time + tm.millitm / 10;
#endif
}

static
int
log_printf(FILE *ofp, char const *fmt, ...)
{
  int r;
  va_list ap;
  va_start(ap, fmt);
  vfprintf(stdout, fmt, ap);
  r = vfprintf(ofp, fmt, ap);
  va_end(ap);
  if (r > 0)
	return r;
  perror("log_printf");
  exit(errno);
}

/***************************************************************
 *
 *	C[vƂ
 *
 */

/* 萔 */
#if N_STRIDE == 7
static SLICE const sk6[N_STRIDE] =
{
  {0xAAAAAAAAUL, 0xAAAAAAAAUL, 0xAAAAAAAAUL, 0xAAAAAAAAUL},
  {0xCCCCCCCCUL, 0xCCCCCCCCUL, 0xCCCCCCCCUL, 0xCCCCCCCCUL},
  {0xF0F0F0F0UL, 0xF0F0F0F0UL, 0xF0F0F0F0UL, 0xF0F0F0F0UL},
  {0xFF00FF00UL, 0xFF00FF00UL, 0xFF00FF00UL, 0xFF00FF00UL},
  {0xFFFF0000UL, 0xFFFF0000UL, 0xFFFF0000UL, 0xFFFF0000UL},
  {0x00000000UL, 0xFFFFFFFFUL, 0x00000000UL, 0xFFFFFFFFUL},
  {0x00000000UL, 0x00000000UL, 0xFFFFFFFFUL, 0xFFFFFFFFUL},
};
#elif N_STRIDE == 6
static SLICE const sk6[N_STRIDE] =
{
  {0xAAAAAAAAUL, 0xAAAAAAAAUL},
  {0xCCCCCCCCUL, 0xCCCCCCCCUL},
  {0xF0F0F0F0UL, 0xF0F0F0F0UL},
  {0xFF00FF00UL, 0xFF00FF00UL},
  {0xFFFF0000UL, 0xFFFF0000UL},
  {0x00000000UL, 0xFFFFFFFFUL},
};
#endif

ALIGN_PREFIX(16) struct KEY key64 ALIGN_SUFFIX(16);
ALIGN_PREFIX(16) struct PARAM param64 ALIGN_SUFFIX(16);

int
main(int argc, char *argv[])
{
  int i;
  int mincnt;
  int nblk_hit, nblk_total;
  int nap_hit, nap_total;
  signed char *code = NULL;
  FILE *ofp;
  FILE *sfp;	/* scoreboard */
  struct ITREE *root_expr;
  int cr;

  int xhash_loaded;

#define LOOP_FACTOR 100000UL	/* Ȃł */
#define UPDATE_INTERVAL 8	/* x\̊Ԋu b */
#define AVG_SPD 500000UL	/* ϑx̏l trips/s */
  struct status {
    unsigned long startTime;	/* Jn ~b */
    unsigned long lastTime;	/* Ōɕ\ ~b */
    double        lastLoopCnt;	/* Ōɕ\̃[v */
    unsigned long loop;		/* [v % LOOP_FACTOR */
    unsigned long mloop;	/* [v / LOOP_FACTOR */
  } status;
  unsigned long	upd_int = AVG_SPD * UPDATE_INTERVAL;
/*
 ϑx (trips/s) * UPDATE_INTERVAL  ULONG_MAX 𒴂ƔB
 ULONG_MAX = 4294967295, ϑx = 100Mtrips/s ȂA
 4294967295 / (100 * 1000 * 1000) = 42.949 b܂łɂ邱ƁB
 LOOP_FACTOR ϑx\΁AقڎwԊuɂȂB
 */

#if 0
  if (argc < 2)
	{
	  fprintf(stderr, "ڂ\n");
	  return 1;
	}
#endif

  assert((1 << N_STRIDE) == N_ALU * ALU_BITS);

  /* t[16] ́AZŎgpAall 1 Ă */
  for (i = 0; i < N_ALU; i++)
	param64.t[T_INV].a[i] = -1;

  /* ŒL[̃Rs[ */
  for (i = 0; i < N_STRIDE; i++)
	{
	  int o = tr_pc1[7][6 - i] - 1;
	  if (o < 28)
		{
		  key64.k[0][0][o] = key64.k[0][1][o] = sk6[i];
		}
	  else
		{
		  o -= 28;
		  key64.k[1][0][o] = key64.k[1][1][o] = sk6[i];
		}
	}

  /* L[XPW[ɉ߂Ă
	 ] crypt64.S Ŋ悤ɈĂ */
  for (i = 0; i < 28; i++)
	key64.ks[i].a[0] = sizeof(WS_T) * ks_ls[i];

  /* ^Qǂݍ */
  root_expr = expr_parse("target.txt");

  /* R[h𐶐EWJ */
  sfp = scoreboard_open();
  fwrite(crypt64_sta, 1, crypt64_end - crypt64_sta, sfp);	/* prologue */
  synth_synthesize(sfp, root_expr);
  fwrite(crypt64_ep, 1, crypt64_ep_end - crypt64_ep, sfp);	/* epilogue */

  /* R[hɓ\t */
  code = scoreboard_map(sfp);

  /* L[̏ */
  srand(time(NULL));
  key_init();
  set_salt(code, key);
  for (i = 0; i < 8; i++)
	key_set64(&key64, i, okey[i] = key[i], 0, 0x7F);

#if DEBUG>=1
  printf("key=%p param=%p\n", &key64, &param64);
#endif
  assert(!((ptrdiff_t)&key64 & (sizeof(WS_T) - 1)));
  assert(!((ptrdiff_t)&param64 & (sizeof(WS_T) - 1)));

  if ((ofp = fopen("log.txt", "at")) == NULL)
	{
	  perror("log.txt");
	  return errno;
	}

  setvbuf(ofp, NULL, _IONBF, BUFSIZ);	/* XXX MSVCRT ł _IOLBF Ғʂɓ삵Ȃ */

  mincnt = 0x7FFFFFFF;
  nblk_hit = nblk_total = 0;
  nap_hit = nap_total = 0;
  cr = 0;
  status.startTime = status.lastTime = usec();
  status.lastLoopCnt = 0;
  status.loop = 0;
  status.mloop = 0;
  /* T[v */
  for (;;)
	{
	  int32_t cnt;
	  int k, kk;

	  /* ̃Zbg */
	  for (i = 0; i < 8; i++)
		{
		  key_set64(&key64, i, key[i], key[i] ^ okey[i], 0);
		  okey[i] = key[i];
		}

	  /* Ă!
		 LR ́ATuW[ōsׂ
		 FASTCALL ɏĂяô߁A
		 zg͂낢냌WX^j󂳂nYcȂ񂾂B */
	  cnt = CALL_CRYPT64(code, key64.k, param64.lr);

#if DEBUG>=1
	  if (mincnt > cnt && cnt > 0)
		{
		  mincnt = cnt;
		  if (cr)
			fprintf(stderr, "\n");
		  cr = 0;
		  fprintf(stderr, "cycle=%d\n", (int)cnt);
		}
#endif

	  /* qbgƂ̏ */
	  xhash_loaded = 0;
	  for (kk = 0; kk < N_ALU; kk++)
		{
		  ALU_T t;
		  if (!(kk & (N_ALU / N_Q - 1)))
			nblk_total++, xhash_loaded = 0;

		  t = param64.t[HIT_ANY].a[kk];
		  if (!t)
			continue;

		  nap_total += ALU_BITS;

		  for (k = 0; k < ALU_BITS; k++)
			{
			  static uint64_t xhash[64];
			  char hash[16];
			  unsigned char buf[32];

			  if (!(t & ((ALU_T)1 << k)))
				continue;

			  nap_hit++;

			  /* ]u */
			  if (!xhash_loaded)
				{
				  nblk_hit++;
				  CALL_TR64(&param64.lr[0][0].q[kk / (N_ALU / N_Q)], xhash);
				  xhash_loaded = 1;
				}

			  /* 𒲂ׂ */
			  if (!((param64.t[HIT_BOOL].a[kk] & ((ALU_T)1 << k))
					|| wdict_ishit(param64.t,
								   kk, k,
								   xhash[(ALU_BITS * kk + k) & 0x3F])))
				continue;

			  for (i = 1; i < 11; i++)
				{
				  unsigned c = 0;
				  c = (xhash[(ALU_BITS * kk + k) & 63] >> (6 * (i - 1))) & 0x3F;	/* XXX */
				  hash[i - 1] = C64[c];
				}
			  hash[10] = 0;

			  memcpy(buf, key, 32);
			  buf[8] = buf[9] = 0;
			  buf[7] = (buf[7] & -(1 << N_STRIDE) & 0x7F) + ALU_BITS * kk + k;
			  if (translate(buf, 0, 1))
				{
				  if (cr)
					fprintf(stderr, "\n");
				  cr = 0;
				  log_printf(ofp,
							 "%s #%-10.10s(%02X %02X %02X %02X %02X %02X %02X %02X/%02X)\n",
							 hash,
							 buf,
							 buf[0], buf[1], buf[2], buf[3],
							 buf[4], buf[5], buf[6], buf[7],
							 buf[8]);
				}
			  else
				{
#if DEBUG>=1
				  if (cr)
					fprintf(stderr, "\n");
				  cr = 0;
				  log_printf(ofp,
							 "%s            (%02X %02X %02X %02X %02X %02X %02X %02X   )\n",
							 hash,
							 buf[0], buf[1], buf[2], buf[3],
							 buf[4], buf[5], buf[6], buf[7]);
#endif
				}
			}
		}

	  status.loop += N_ALU * ALU_BITS;
	  if ( status.loop >= upd_int )
		{
/* 
 ōXVԊũ`FbN΁A}VŃwȑx\ŏo
 ̂hB
 ƕʂ̃}VŃ_ usec() Ăяo邱ƂɂȂB
 ȂBĎ蔲ł͂ȂB
 */
		  time_t curTime;
		  int a, b;
		  double loopCnt, zoneCnt;

		  status.mloop += ( status.loop / LOOP_FACTOR );
		  status.loop %= LOOP_FACTOR;
		  curTime = usec();
		  loopCnt = (double)status.mloop * LOOP_FACTOR + status.loop;
		  zoneCnt = loopCnt - status.lastLoopCnt;
		  a = loopCnt * 100 / (curTime - status.startTime);
		  b = zoneCnt * 100 / (curTime - status.lastTime);
		  upd_int = b * UPDATE_INTERVAL;
#if DEBUG>=1
		  fprintf(stderr,
			  "%5d/%5d(%3d%%)",
			  nblk_hit, nblk_total, 100 * nblk_hit / nblk_total);
		  nblk_hit = nblk_total = 0;
		  if (nap_total)
			fprintf(stderr,
				"  %5d/%5d(%3d%%)",
				nap_hit, nap_total, 100 * nap_hit / nap_total);
		  else
			fprintf(stderr,
					"  -----/-----(---%%)");
		  nap_hit = nap_total = 0;
#endif
		  fprintf( stderr,
			"%6d.%03dktrips/s [%6d.%03dktrips/s]\r",
			a / 1000, a % 1000,
			b / 1000, b % 1000 );
		  status.lastTime = curTime;
		  status.lastLoopCnt = loopCnt;
		  cr++;
		}
#if 1
	  if (!key_inc(3))
		{
#if DEBUG>=2
		  printf("********************************\n");
#endif
		  key_reset(0);
		  set_salt(code, key);
		  for (i = 0; i < 8; i++)
			key_set64(&key64, i, okey[i] = key[i], 0, 0x7F);
		}
#endif
	}

  return 0;
}

/*
 *	Local Variables:
 *		tab-width:	4
 *	End:
 *
 * EOF */
