/**********************************************************-*-verilog-*-
 *
 *	7segp LED hCo
 *	$Id: leddrv4.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module leddrv4(clk, rst,
			   db, oe,
			   n0, n1, n2, n3,
			   d0, d1, d2, d3);
	input			clk;	// 300Hz ^Ƃ悢
	input 			rst;
	output [7:0] 	db;
	output [4:0] 	oe;
	input [3:0] 	n0, n1, n2, n3;	// 7-seg LED (to be encoded)
	input 			d0, d1, d2, d3;	// 7-seg LED dot

	// o͐
	reg [4:0] oe;

	// GR[hÔ
	reg [4:0] n;

	// Xe[g
	reg [1:0] st;

	assign 	  db = {~n[4], encode(n[3:0])};

	always @(posedge clk or posedge rst)
	  if (rst)
	  begin
		  oe <= 5'b00000;
		  st <= 0;
	  end
	  else
		case (st)
		  0:
			begin
				oe <= 5'b11110;
				n <= {d0, n0};
				st <= 1;
			end
		  1:
			begin
				oe <= 5'b11101;
				n <= {d1, n1};
				st <= 2;
			end
		  2:
			begin
				oe <= 5'b11011;
				n <= {d2, n2};
				st <= 3;
			end
		  3:
			begin
				oe <= 5'b10111;
				n <= {d3, n3};
				st <= 0;
			end
		endcase

	// 7-LED Encoder
	function [6:0] encode;
		input [3:0] n;
		case (n)
		  4'h0: encode = 7'b1000000;
		  4'h1: encode = 7'b1111001;
		  4'h2: encode = 7'b0100100;
		  4'h3: encode = 7'b0110000;

		  4'h4: encode = 7'b0011001;
		  4'h5: encode = 7'b0010010;
		  4'h6: encode = 7'b0000010;
		  4'h7: encode = 7'b1011000;
			
		  4'h8: encode = 7'b0000000;
		  4'h9: encode = 7'b0010000;
		  4'hA: encode = 7'b0001000;
		  4'hB: encode = 7'b0000011;

		  4'hC: encode = 7'b0100111;
		  4'hD: encode = 7'b0100001;
		  4'hE: encode = 7'b0000110;
		  4'hF: encode = 7'b0001110;
		endcase
	endfunction

endmodule // leddrv4

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
