/**********************************************************-*-verilog-*-
 *
 *	DES functions
 *	rbgтȂǂȏʂɂ邽߂
 *	EGfBAقȂ̂ŒӂB
 *	Ȃ킿A1AGfBA̓g(E)B
 *	$Id: func_des.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

/*
 *	F ̊g]u E
 *	crypt(3)12rbgSaltɂω邪
 *	̃W[ł́ASaltŒł\pIłB
 */
function [1:48] tr_e;
		input [1:32] n;
		tr_e = {n[32], n[ 1], n[ 2], n[ 3], n[ 4], n[ 5],
				n[ 4], n[ 5], n[ 6], n[ 7], n[ 8], n[ 9],
				n[ 8], n[ 9], n[10], n[11], n[12], n[13],
				n[12], n[13], n[14], n[15], n[16], n[17],
				n[16], n[17], n[18], n[19], n[20], n[21],
				n[20], n[21], n[22], n[23], n[24], n[25],
				n[24], n[25], n[26], n[27], n[28], n[29],
				n[28], n[29], n[30], n[31], n[32], n[ 1]};
endfunction

/*
 *	F ̓]u P
 */
function [1:32] tr_p;
		input [1:32] n;
		tr_p = {n[16], n[ 7], n[20], n[21],
				n[29], n[12], n[28], n[17],
				n[ 1], n[15], n[23], n[26],
				n[ 5], n[18], n[31], n[10],
				n[ 2], n[ 8], n[24], n[14],
				n[32], n[27], n[ 3], n[ 9],
				n[19], n[13], n[30], n[ 6],
				n[22], n[11], n[ 4], n[25]};
endfunction

/*
 *  P-1
 *	pCvC̃Xe[Wړ邽߂ɗpB
 */
function [1:32] ir_p;
		input [1:32] n;
		{ir_p[16], ir_p[ 7], ir_p[20], ir_p[21],
		 ir_p[29], ir_p[12], ir_p[28], ir_p[17],
		 ir_p[ 1], ir_p[15], ir_p[23], ir_p[26],
		 ir_p[ 5], ir_p[18], ir_p[31], ir_p[10],
		 ir_p[ 2], ir_p[ 8], ir_p[24], ir_p[14],
		 ir_p[32], ir_p[27], ir_p[ 3], ir_p[ 9],
		 ir_p[19], ir_p[13], ir_p[30], ir_p[ 6],
		 ir_p[22], ir_p[11], ir_p[ 4], ir_p[25]} = n;
		/*
		ir_p = {n[ 9], n[17], n[23], n[31],
				n[13], n[28], n[ 2], n[18],
				n[24], n[16], n[30], n[ 6],
				n[26], n[20], n[10], n[ 1],
				n[ 8], n[14], n[25], n[ 3],
				n[ 4], n[29], n[11], n[19],
				n[32], n[12], n[22], n[ 7],
				n[ 5], n[27], n[15], n[21]};
		 */
endfunction

/*
 *	PC2(L=C, R=D)
 *	L, RƗĂ̂~\B
 */
function [1:24] tr_pc2l;
		input [1:28] l;
		tr_pc2l = {l[14], l[17], l[11], l[24], l[ 1], l[ 5],
				   l[ 3], l[28], l[15], l[ 6], l[21], l[10],
				   l[23], l[19], l[12], l[ 4], l[26], l[ 8],
				   l[16], l[ 7], l[27], l[20], l[13], l[ 2]};
endfunction

function [25:48] tr_pc2r;
		input [29:56] r;
		tr_pc2r = {r[41], r[52], r[31], r[37], r[47], r[55],
				   r[30], r[40], r[51], r[45], r[33], r[48],
				   r[44], r[49], r[39], r[56], r[34], r[53],
				   r[46], r[42], r[50], r[36], r[29], r[32]};
endfunction

/*
 *	ŏI]u P-1
 */
function [1:64] fp;
		input [1:64] n;
		fp = {n[40], n[ 8], n[48], n[16], n[56], n[24], n[64], n[32],
			  n[39], n[ 7], n[47], n[15], n[55], n[23], n[63], n[31],
			  n[38], n[ 6], n[46], n[14], n[54], n[22], n[62], n[30],
			  n[37], n[ 5], n[45], n[13], n[53], n[21], n[61], n[29],
			  n[36], n[ 4], n[44], n[12], n[52], n[20], n[60], n[28],
			  n[35], n[ 3], n[43], n[11], n[51], n[19], n[59], n[27],
			  n[34], n[ 2], n[42], n[10], n[50], n[18], n[58], n[26],
			  n[33], n[ 1], n[41], n[ 9], n[49], n[17], n[57], n[25]};
endfunction

/*
 *	̏k]uPC1
 *	ȏ̂̂ƌ݊ł͂ȂB̕т
 *	vZɓŝ悤ɂĂB
 *	̓Iɂ́ASalt bit͏ʂɌł܂悤ɂĂB
 */
function [1:28] pc1_l;
		input [27:0] n;
		{pc1_l[ 7], pc1_l[15], pc1_l[23],	// SALT
		 pc1_l[ 6], pc1_l[14], pc1_l[22],	// SALT
		 pc1_l[ 8], pc1_l[16], pc1_l[24],
		 pc1_l[ 5], pc1_l[13], pc1_l[21],
		 pc1_l[ 4], pc1_l[12], pc1_l[20],
		 pc1_l[ 3], pc1_l[11], pc1_l[19],
		 pc1_l[ 2], pc1_l[10], pc1_l[18],
		 pc1_l[ 1], pc1_l[ 9], pc1_l[17],
		 pc1_l[28], pc1_l[27], pc1_l[26], pc1_l[25]} = n;
endfunction

function [29:56] pc1_r;
		input [27:0] n;
		{pc1_r[55], pc1_r[51], pc1_r[43], pc1_r[35],	// SALT
		 pc1_r[54], pc1_r[50], pc1_r[42], pc1_r[34],	// SALT
		 pc1_r[56], pc1_r[52], pc1_r[44], pc1_r[36],
		 pc1_r[53], pc1_r[49], pc1_r[41], pc1_r[33],
		 /********/ pc1_r[48], pc1_r[40], pc1_r[32],
		 /********/ pc1_r[47], pc1_r[39], pc1_r[31],
		 /********/ pc1_r[46], pc1_r[38], pc1_r[30],
		 /********/ pc1_r[45], pc1_r[37], pc1_r[29]} = n;
endfunction

function [1:56] pc1;
		input [55:0] n;
		pc1 = {pc1_l(n[27:0]), pc1_r(n[55:28])};
endfunction

/*
 *	̋t]u(PC1-1)
 *	pCvCŗpBpc1_l ̋tϊB
 */

/* KLp */
function [27:0] i_pc1_l;
		input [1:28] n;
		i_pc1_l = {n[ 7], n[15], n[23],		// SALT
				   n[ 6], n[14], n[22],		// SALT
				   n[ 8], n[16], n[24],
				   n[ 5], n[13], n[21],
				   n[ 4], n[12], n[20],
				   n[ 3], n[11], n[19],
				   n[ 2], n[10], n[18],
				   n[ 1], n[ 9], n[17],
				   n[28], n[27], n[26], n[25]};
endfunction

/*
 *	̋t]u(PC1-1)
 *	͂LITTLE ENDIAN, o͂BIG ENDIAN
 */
function [63:0] i_pc1;
		input [1:56] n;
		input salt;
		i_pc1 = {1'b0, n[ 8], n[16], n[24], n[56], n[52], n[44], n[36],
				 salt, n[ 7], n[15], n[23], n[55], n[51], n[43], n[35],
				 salt, n[ 6], n[14], n[22], n[54], n[50], n[42], n[34],
				 1'b0, n[ 5], n[13], n[21], n[53], n[49], n[41], n[33],
				 1'b0, n[ 4], n[12], n[20], n[28], n[48], n[40], n[32],
				 1'b0, n[ 3], n[11], n[19], n[27], n[47], n[39], n[31],
				 1'b0, n[ 2], n[10], n[18], n[26], n[46], n[38], n[30],
				 1'b0, n[ 1], n[ 9], n[17], n[25], n[45], n[37], n[29]};
endfunction

/*
 *	MUX
 *	Œ茮ƃWX^D
 */

function [55:0] kmux;
		input [55:0] m;
		input [55:0] fk;	// Œ茮
		input [55:0] k;		// R
		kmux = (k & m) | (fk & ~m);
endfunction

/*
 *	rotate left
 */
function [0:27] roln;
		input [0:27] d;
		input [4:0] n;
		case (n)
		  5'd01: roln = {d[ 1:27], d[0: 0]};
		  5'd02: roln = {d[ 2:27], d[0: 1]};
		  5'd03: roln = {d[ 3:27], d[0: 2]};
		  5'd04: roln = {d[ 4:27], d[0: 3]};
		  5'd05: roln = {d[ 5:27], d[0: 4]};
		  5'd06: roln = {d[ 6:27], d[0: 5]};
		  5'd07: roln = {d[ 7:27], d[0: 6]};
		  5'd08: roln = {d[ 8:27], d[0: 7]};
		  5'd09: roln = {d[ 9:27], d[0: 8]};
		  5'd10: roln = {d[10:27], d[0: 9]};
		  5'd11: roln = {d[11:27], d[0:10]};
		  5'd12: roln = {d[12:27], d[0:11]};
		  5'd13: roln = {d[13:27], d[0:12]};
		  5'd14: roln = {d[14:27], d[0:13]};
		  5'd15: roln = {d[15:27], d[0:14]};
		  5'd16: roln = {d[16:27], d[0:15]};
		  5'd17: roln = {d[17:27], d[0:16]};
		  5'd18: roln = {d[18:27], d[0:17]};
		  5'd19: roln = {d[19:27], d[0:18]};
		  5'd20: roln = {d[20:27], d[0:19]};
		  5'd21: roln = {d[21:27], d[0:20]};
		  5'd22: roln = {d[22:27], d[0:21]};
		  5'd23: roln = {d[23:27], d[0:22]};
		  5'd24: roln = {d[24:27], d[0:23]};
		  5'd25: roln = {d[25:27], d[0:24]};
		  5'd26: roln = {d[26:27], d[0:25]};
		  5'd27: roln = {d[27:27], d[0:26]};
		  default: roln = d;
		endcase
endfunction

/*
 *	DES p̌]
 *	\tgEFAƈႢA[vłȂꍇ
 *	Hardwired shift̕s悢B
 */
function [0:27] rolk;
		input [0:27] d;
		input [3:0] st;
		case (st)
		  4'hF: rolk = roln(d, 1);
		  4'h0: rolk = roln(d, 1);
		  4'h1: rolk = roln(d, 2);
		  4'h2: rolk = roln(d, 2);
		  4'h3: rolk = roln(d, 2);
		  4'h4: rolk = roln(d, 2);
		  4'h5: rolk = roln(d, 2);
		  4'h6: rolk = roln(d, 2);
		  4'h7: rolk = roln(d, 1);
		  4'h8: rolk = roln(d, 2);
		  4'h9: rolk = roln(d, 2);
		  4'hA: rolk = roln(d, 2);
		  4'hB: rolk = roln(d, 2);
		  4'hC: rolk = roln(d, 2);
		  4'hD: rolk = roln(d, 2);
		  4'hE: rolk = roln(d, 1);
		endcase
endfunction

// SBox ݊̂߂ conversion
function [5:0] sa;
		input [0:5] n;
		sa = {n[0], n[5], n[1:4]};
endfunction

function [0:47] sae;
		input [0:47] e;
		sae = {sa(e[ 0: 5]),
			   sa(e[ 6:11]),
			   sa(e[12:17]),
			   sa(e[18:23]),
			   sa(e[24:29]),
			   sa(e[30:35]),
			   sa(e[36:41]),
			   sa(e[42:47])};
endfunction

/*
 *	SBox ɃZbgAbvAhX邽߂̋tϊ
 */
function [0:5] ra;
		input [5:0] sa;
		{ra[0], ra[5], ra[1:4]} = sa;
endfunction

/*
 *	SBoxes
 *	Lq2iAт͋ȏʂB
 *	l̕ROMɂȂĂ肷̂Œ
 */
function [0:3] s1;
		input [0:5] n6;
		case (sa(n6))
		  6'b000000: s1 = 4'b1110;
		  6'b000001: s1 = 4'b0100;
		  6'b000010: s1 = 4'b1101;
		  6'b000011: s1 = 4'b0001;
		  6'b000100: s1 = 4'b0010;
		  6'b000101: s1 = 4'b1111;
		  6'b000110: s1 = 4'b1011;
		  6'b000111: s1 = 4'b1000;
		  6'b001000: s1 = 4'b0011;
		  6'b001001: s1 = 4'b1010;
		  6'b001010: s1 = 4'b0110;
		  6'b001011: s1 = 4'b1100;
		  6'b001100: s1 = 4'b0101;
		  6'b001101: s1 = 4'b1001;
		  6'b001110: s1 = 4'b0000;
		  6'b001111: s1 = 4'b0111;
		  6'b010000: s1 = 4'b0000;
		  6'b010001: s1 = 4'b1111;
		  6'b010010: s1 = 4'b0111;
		  6'b010011: s1 = 4'b0100;
		  6'b010100: s1 = 4'b1110;
		  6'b010101: s1 = 4'b0010;
		  6'b010110: s1 = 4'b1101;
		  6'b010111: s1 = 4'b0001;
		  6'b011000: s1 = 4'b1010;
		  6'b011001: s1 = 4'b0110;
		  6'b011010: s1 = 4'b1100;
		  6'b011011: s1 = 4'b1011;
		  6'b011100: s1 = 4'b1001;
		  6'b011101: s1 = 4'b0101;
		  6'b011110: s1 = 4'b0011;
		  6'b011111: s1 = 4'b1000;
		  6'b100000: s1 = 4'b0100;
		  6'b100001: s1 = 4'b0001;
		  6'b100010: s1 = 4'b1110;
		  6'b100011: s1 = 4'b1000;
		  6'b100100: s1 = 4'b1101;
		  6'b100101: s1 = 4'b0110;
		  6'b100110: s1 = 4'b0010;
		  6'b100111: s1 = 4'b1011;
		  6'b101000: s1 = 4'b1111;
		  6'b101001: s1 = 4'b1100;
		  6'b101010: s1 = 4'b1001;
		  6'b101011: s1 = 4'b0111;
		  6'b101100: s1 = 4'b0011;
		  6'b101101: s1 = 4'b1010;
		  6'b101110: s1 = 4'b0101;
		  6'b101111: s1 = 4'b0000;
		  6'b110000: s1 = 4'b1111;
		  6'b110001: s1 = 4'b1100;
		  6'b110010: s1 = 4'b1000;
		  6'b110011: s1 = 4'b0010;
		  6'b110100: s1 = 4'b0100;
		  6'b110101: s1 = 4'b1001;
		  6'b110110: s1 = 4'b0001;
		  6'b110111: s1 = 4'b0111;
		  6'b111000: s1 = 4'b0101;
		  6'b111001: s1 = 4'b1011;
		  6'b111010: s1 = 4'b0011;
		  6'b111011: s1 = 4'b1110;
		  6'b111100: s1 = 4'b1010;
		  6'b111101: s1 = 4'b0000;
		  6'b111110: s1 = 4'b0110;
		  6'b111111: s1 = 4'b1101;
		endcase
endfunction

function [0:3] s2;
		input [0:5] n6;
		case (sa(n6))
		  6'b000000: s2 = 4'b1111;
		  6'b000001: s2 = 4'b0001;
		  6'b000010: s2 = 4'b1000;
		  6'b000011: s2 = 4'b1110;
		  6'b000100: s2 = 4'b0110;
		  6'b000101: s2 = 4'b1011;
		  6'b000110: s2 = 4'b0011;
		  6'b000111: s2 = 4'b0100;
		  6'b001000: s2 = 4'b1001;
		  6'b001001: s2 = 4'b0111;
		  6'b001010: s2 = 4'b0010;
		  6'b001011: s2 = 4'b1101;
		  6'b001100: s2 = 4'b1100;
		  6'b001101: s2 = 4'b0000;
		  6'b001110: s2 = 4'b0101;
		  6'b001111: s2 = 4'b1010;
		  6'b010000: s2 = 4'b0011;
		  6'b010001: s2 = 4'b1101;
		  6'b010010: s2 = 4'b0100;
		  6'b010011: s2 = 4'b0111;
		  6'b010100: s2 = 4'b1111;
		  6'b010101: s2 = 4'b0010;
		  6'b010110: s2 = 4'b1000;
		  6'b010111: s2 = 4'b1110;
		  6'b011000: s2 = 4'b1100;
		  6'b011001: s2 = 4'b0000;
		  6'b011010: s2 = 4'b0001;
		  6'b011011: s2 = 4'b1010;
		  6'b011100: s2 = 4'b0110;
		  6'b011101: s2 = 4'b1001;
		  6'b011110: s2 = 4'b1011;
		  6'b011111: s2 = 4'b0101;
		  6'b100000: s2 = 4'b0000;
		  6'b100001: s2 = 4'b1110;
		  6'b100010: s2 = 4'b0111;
		  6'b100011: s2 = 4'b1011;
		  6'b100100: s2 = 4'b1010;
		  6'b100101: s2 = 4'b0100;
		  6'b100110: s2 = 4'b1101;
		  6'b100111: s2 = 4'b0001;
		  6'b101000: s2 = 4'b0101;
		  6'b101001: s2 = 4'b1000;
		  6'b101010: s2 = 4'b1100;
		  6'b101011: s2 = 4'b0110;
		  6'b101100: s2 = 4'b1001;
		  6'b101101: s2 = 4'b0011;
		  6'b101110: s2 = 4'b0010;
		  6'b101111: s2 = 4'b1111;
		  6'b110000: s2 = 4'b1101;
		  6'b110001: s2 = 4'b1000;
		  6'b110010: s2 = 4'b1010;
		  6'b110011: s2 = 4'b0001;
		  6'b110100: s2 = 4'b0011;
		  6'b110101: s2 = 4'b1111;
		  6'b110110: s2 = 4'b0100;
		  6'b110111: s2 = 4'b0010;
		  6'b111000: s2 = 4'b1011;
		  6'b111001: s2 = 4'b0110;
		  6'b111010: s2 = 4'b0111;
		  6'b111011: s2 = 4'b1100;
		  6'b111100: s2 = 4'b0000;
		  6'b111101: s2 = 4'b0101;
		  6'b111110: s2 = 4'b1110;
		  6'b111111: s2 = 4'b1001;
		endcase
endfunction

function [0:3] s3;
		input [0:5] n6;
		case (sa(n6))
		  6'b000000: s3 = 4'b1010;
		  6'b000001: s3 = 4'b0000;
		  6'b000010: s3 = 4'b1001;
		  6'b000011: s3 = 4'b1110;
		  6'b000100: s3 = 4'b0110;
		  6'b000101: s3 = 4'b0011;
		  6'b000110: s3 = 4'b1111;
		  6'b000111: s3 = 4'b0101;
		  6'b001000: s3 = 4'b0001;
		  6'b001001: s3 = 4'b1101;
		  6'b001010: s3 = 4'b1100;
		  6'b001011: s3 = 4'b0111;
		  6'b001100: s3 = 4'b1011;
		  6'b001101: s3 = 4'b0100;
		  6'b001110: s3 = 4'b0010;
		  6'b001111: s3 = 4'b1000;
		  6'b010000: s3 = 4'b1101;
		  6'b010001: s3 = 4'b0111;
		  6'b010010: s3 = 4'b0000;
		  6'b010011: s3 = 4'b1001;
		  6'b010100: s3 = 4'b0011;
		  6'b010101: s3 = 4'b0100;
		  6'b010110: s3 = 4'b0110;
		  6'b010111: s3 = 4'b1010;
		  6'b011000: s3 = 4'b0010;
		  6'b011001: s3 = 4'b1000;
		  6'b011010: s3 = 4'b0101;
		  6'b011011: s3 = 4'b1110;
		  6'b011100: s3 = 4'b1100;
		  6'b011101: s3 = 4'b1011;
		  6'b011110: s3 = 4'b1111;
		  6'b011111: s3 = 4'b0001;
		  6'b100000: s3 = 4'b1101;
		  6'b100001: s3 = 4'b0110;
		  6'b100010: s3 = 4'b0100;
		  6'b100011: s3 = 4'b1001;
		  6'b100100: s3 = 4'b1000;
		  6'b100101: s3 = 4'b1111;
		  6'b100110: s3 = 4'b0011;
		  6'b100111: s3 = 4'b0000;
		  6'b101000: s3 = 4'b1011;
		  6'b101001: s3 = 4'b0001;
		  6'b101010: s3 = 4'b0010;
		  6'b101011: s3 = 4'b1100;
		  6'b101100: s3 = 4'b0101;
		  6'b101101: s3 = 4'b1010;
		  6'b101110: s3 = 4'b1110;
		  6'b101111: s3 = 4'b0111;
		  6'b110000: s3 = 4'b0001;
		  6'b110001: s3 = 4'b1010;
		  6'b110010: s3 = 4'b1101;
		  6'b110011: s3 = 4'b0000;
		  6'b110100: s3 = 4'b0110;
		  6'b110101: s3 = 4'b1001;
		  6'b110110: s3 = 4'b1000;
		  6'b110111: s3 = 4'b0111;
		  6'b111000: s3 = 4'b0100;
		  6'b111001: s3 = 4'b1111;
		  6'b111010: s3 = 4'b1110;
		  6'b111011: s3 = 4'b0011;
		  6'b111100: s3 = 4'b1011;
		  6'b111101: s3 = 4'b0101;
		  6'b111110: s3 = 4'b0010;
		  6'b111111: s3 = 4'b1100;
		endcase
endfunction

function [0:3] s4;
		input [0:5] n6;
		case (sa(n6))
		  6'b000000: s4 = 4'b0111;
		  6'b000001: s4 = 4'b1101;
		  6'b000010: s4 = 4'b1110;
		  6'b000011: s4 = 4'b0011;
		  6'b000100: s4 = 4'b0000;
		  6'b000101: s4 = 4'b0110;
		  6'b000110: s4 = 4'b1001;
		  6'b000111: s4 = 4'b1010;
		  6'b001000: s4 = 4'b0001;
		  6'b001001: s4 = 4'b0010;
		  6'b001010: s4 = 4'b1000;
		  6'b001011: s4 = 4'b0101;
		  6'b001100: s4 = 4'b1011;
		  6'b001101: s4 = 4'b1100;
		  6'b001110: s4 = 4'b0100;
		  6'b001111: s4 = 4'b1111;
		  6'b010000: s4 = 4'b1101;
		  6'b010001: s4 = 4'b1000;
		  6'b010010: s4 = 4'b1011;
		  6'b010011: s4 = 4'b0101;
		  6'b010100: s4 = 4'b0110;
		  6'b010101: s4 = 4'b1111;
		  6'b010110: s4 = 4'b0000;
		  6'b010111: s4 = 4'b0011;
		  6'b011000: s4 = 4'b0100;
		  6'b011001: s4 = 4'b0111;
		  6'b011010: s4 = 4'b0010;
		  6'b011011: s4 = 4'b1100;
		  6'b011100: s4 = 4'b0001;
		  6'b011101: s4 = 4'b1010;
		  6'b011110: s4 = 4'b1110;
		  6'b011111: s4 = 4'b1001;
		  6'b100000: s4 = 4'b1010;
		  6'b100001: s4 = 4'b0110;
		  6'b100010: s4 = 4'b1001;
		  6'b100011: s4 = 4'b0000;
		  6'b100100: s4 = 4'b1100;
		  6'b100101: s4 = 4'b1011;
		  6'b100110: s4 = 4'b0111;
		  6'b100111: s4 = 4'b1101;
		  6'b101000: s4 = 4'b1111;
		  6'b101001: s4 = 4'b0001;
		  6'b101010: s4 = 4'b0011;
		  6'b101011: s4 = 4'b1110;
		  6'b101100: s4 = 4'b0101;
		  6'b101101: s4 = 4'b0010;
		  6'b101110: s4 = 4'b1000;
		  6'b101111: s4 = 4'b0100;
		  6'b110000: s4 = 4'b0011;
		  6'b110001: s4 = 4'b1111;
		  6'b110010: s4 = 4'b0000;
		  6'b110011: s4 = 4'b0110;
		  6'b110100: s4 = 4'b1010;
		  6'b110101: s4 = 4'b0001;
		  6'b110110: s4 = 4'b1101;
		  6'b110111: s4 = 4'b1000;
		  6'b111000: s4 = 4'b1001;
		  6'b111001: s4 = 4'b0100;
		  6'b111010: s4 = 4'b0101;
		  6'b111011: s4 = 4'b1011;
		  6'b111100: s4 = 4'b1100;
		  6'b111101: s4 = 4'b0111;
		  6'b111110: s4 = 4'b0010;
		  6'b111111: s4 = 4'b1110;
		endcase
endfunction

function [0:3] s5;
		input [0:5] n6;
		case (sa(n6))
		  6'b000000: s5 = 4'b0010;
		  6'b000001: s5 = 4'b1100;
		  6'b000010: s5 = 4'b0100;
		  6'b000011: s5 = 4'b0001;
		  6'b000100: s5 = 4'b0111;
		  6'b000101: s5 = 4'b1010;
		  6'b000110: s5 = 4'b1011;
		  6'b000111: s5 = 4'b0110;
		  6'b001000: s5 = 4'b1000;
		  6'b001001: s5 = 4'b0101;
		  6'b001010: s5 = 4'b0011;
		  6'b001011: s5 = 4'b1111;
		  6'b001100: s5 = 4'b1101;
		  6'b001101: s5 = 4'b0000;
		  6'b001110: s5 = 4'b1110;
		  6'b001111: s5 = 4'b1001;
		  6'b010000: s5 = 4'b1110;
		  6'b010001: s5 = 4'b1011;
		  6'b010010: s5 = 4'b0010;
		  6'b010011: s5 = 4'b1100;
		  6'b010100: s5 = 4'b0100;
		  6'b010101: s5 = 4'b0111;
		  6'b010110: s5 = 4'b1101;
		  6'b010111: s5 = 4'b0001;
		  6'b011000: s5 = 4'b0101;
		  6'b011001: s5 = 4'b0000;
		  6'b011010: s5 = 4'b1111;
		  6'b011011: s5 = 4'b1010;
		  6'b011100: s5 = 4'b0011;
		  6'b011101: s5 = 4'b1001;
		  6'b011110: s5 = 4'b1000;
		  6'b011111: s5 = 4'b0110;
		  6'b100000: s5 = 4'b0100;
		  6'b100001: s5 = 4'b0010;
		  6'b100010: s5 = 4'b0001;
		  6'b100011: s5 = 4'b1011;
		  6'b100100: s5 = 4'b1010;
		  6'b100101: s5 = 4'b1101;
		  6'b100110: s5 = 4'b0111;
		  6'b100111: s5 = 4'b1000;
		  6'b101000: s5 = 4'b1111;
		  6'b101001: s5 = 4'b1001;
		  6'b101010: s5 = 4'b1100;
		  6'b101011: s5 = 4'b0101;
		  6'b101100: s5 = 4'b0110;
		  6'b101101: s5 = 4'b0011;
		  6'b101110: s5 = 4'b0000;
		  6'b101111: s5 = 4'b1110;
		  6'b110000: s5 = 4'b1011;
		  6'b110001: s5 = 4'b1000;
		  6'b110010: s5 = 4'b1100;
		  6'b110011: s5 = 4'b0111;
		  6'b110100: s5 = 4'b0001;
		  6'b110101: s5 = 4'b1110;
		  6'b110110: s5 = 4'b0010;
		  6'b110111: s5 = 4'b1101;
		  6'b111000: s5 = 4'b0110;
		  6'b111001: s5 = 4'b1111;
		  6'b111010: s5 = 4'b0000;
		  6'b111011: s5 = 4'b1001;
		  6'b111100: s5 = 4'b1010;
		  6'b111101: s5 = 4'b0100;
		  6'b111110: s5 = 4'b0101;
		  6'b111111: s5 = 4'b0011;
		endcase
endfunction

function [0:3] s6;
		input [0:5] n6;
		case (sa(n6))
		  6'b000000: s6 = 4'b1100;
		  6'b000001: s6 = 4'b0001;
		  6'b000010: s6 = 4'b1010;
		  6'b000011: s6 = 4'b1111;
		  6'b000100: s6 = 4'b1001;
		  6'b000101: s6 = 4'b0010;
		  6'b000110: s6 = 4'b0110;
		  6'b000111: s6 = 4'b1000;
		  6'b001000: s6 = 4'b0000;
		  6'b001001: s6 = 4'b1101;
		  6'b001010: s6 = 4'b0011;
		  6'b001011: s6 = 4'b0100;
		  6'b001100: s6 = 4'b1110;
		  6'b001101: s6 = 4'b0111;
		  6'b001110: s6 = 4'b0101;
		  6'b001111: s6 = 4'b1011;
		  6'b010000: s6 = 4'b1010;
		  6'b010001: s6 = 4'b1111;
		  6'b010010: s6 = 4'b0100;
		  6'b010011: s6 = 4'b0010;
		  6'b010100: s6 = 4'b0111;
		  6'b010101: s6 = 4'b1100;
		  6'b010110: s6 = 4'b1001;
		  6'b010111: s6 = 4'b0101;
		  6'b011000: s6 = 4'b0110;
		  6'b011001: s6 = 4'b0001;
		  6'b011010: s6 = 4'b1101;
		  6'b011011: s6 = 4'b1110;
		  6'b011100: s6 = 4'b0000;
		  6'b011101: s6 = 4'b1011;
		  6'b011110: s6 = 4'b0011;
		  6'b011111: s6 = 4'b1000;
		  6'b100000: s6 = 4'b1001;
		  6'b100001: s6 = 4'b1110;
		  6'b100010: s6 = 4'b1111;
		  6'b100011: s6 = 4'b0101;
		  6'b100100: s6 = 4'b0010;
		  6'b100101: s6 = 4'b1000;
		  6'b100110: s6 = 4'b1100;
		  6'b100111: s6 = 4'b0011;
		  6'b101000: s6 = 4'b0111;
		  6'b101001: s6 = 4'b0000;
		  6'b101010: s6 = 4'b0100;
		  6'b101011: s6 = 4'b1010;
		  6'b101100: s6 = 4'b0001;
		  6'b101101: s6 = 4'b1101;
		  6'b101110: s6 = 4'b1011;
		  6'b101111: s6 = 4'b0110;
		  6'b110000: s6 = 4'b0100;
		  6'b110001: s6 = 4'b0011;
		  6'b110010: s6 = 4'b0010;
		  6'b110011: s6 = 4'b1100;
		  6'b110100: s6 = 4'b1001;
		  6'b110101: s6 = 4'b0101;
		  6'b110110: s6 = 4'b1111;
		  6'b110111: s6 = 4'b1010;
		  6'b111000: s6 = 4'b1011;
		  6'b111001: s6 = 4'b1110;
		  6'b111010: s6 = 4'b0001;
		  6'b111011: s6 = 4'b0111;
		  6'b111100: s6 = 4'b0110;
		  6'b111101: s6 = 4'b0000;
		  6'b111110: s6 = 4'b1000;
		  6'b111111: s6 = 4'b1101;
		endcase
endfunction

function [0:3] s7;
		input [0:5] n6;
		case (sa(n6))
		  6'b000000: s7 = 4'b0100;
		  6'b000001: s7 = 4'b1011;
		  6'b000010: s7 = 4'b0010;
		  6'b000011: s7 = 4'b1110;
		  6'b000100: s7 = 4'b1111;
		  6'b000101: s7 = 4'b0000;
		  6'b000110: s7 = 4'b1000;
		  6'b000111: s7 = 4'b1101;
		  6'b001000: s7 = 4'b0011;
		  6'b001001: s7 = 4'b1100;
		  6'b001010: s7 = 4'b1001;
		  6'b001011: s7 = 4'b0111;
		  6'b001100: s7 = 4'b0101;
		  6'b001101: s7 = 4'b1010;
		  6'b001110: s7 = 4'b0110;
		  6'b001111: s7 = 4'b0001;
		  6'b010000: s7 = 4'b1101;
		  6'b010001: s7 = 4'b0000;
		  6'b010010: s7 = 4'b1011;
		  6'b010011: s7 = 4'b0111;
		  6'b010100: s7 = 4'b0100;
		  6'b010101: s7 = 4'b1001;
		  6'b010110: s7 = 4'b0001;
		  6'b010111: s7 = 4'b1010;
		  6'b011000: s7 = 4'b1110;
		  6'b011001: s7 = 4'b0011;
		  6'b011010: s7 = 4'b0101;
		  6'b011011: s7 = 4'b1100;
		  6'b011100: s7 = 4'b0010;
		  6'b011101: s7 = 4'b1111;
		  6'b011110: s7 = 4'b1000;
		  6'b011111: s7 = 4'b0110;
		  6'b100000: s7 = 4'b0001;
		  6'b100001: s7 = 4'b0100;
		  6'b100010: s7 = 4'b1011;
		  6'b100011: s7 = 4'b1101;
		  6'b100100: s7 = 4'b1100;
		  6'b100101: s7 = 4'b0011;
		  6'b100110: s7 = 4'b0111;
		  6'b100111: s7 = 4'b1110;
		  6'b101000: s7 = 4'b1010;
		  6'b101001: s7 = 4'b1111;
		  6'b101010: s7 = 4'b0110;
		  6'b101011: s7 = 4'b1000;
		  6'b101100: s7 = 4'b0000;
		  6'b101101: s7 = 4'b0101;
		  6'b101110: s7 = 4'b1001;
		  6'b101111: s7 = 4'b0010;
		  6'b110000: s7 = 4'b0110;
		  6'b110001: s7 = 4'b1011;
		  6'b110010: s7 = 4'b1101;
		  6'b110011: s7 = 4'b1000;
		  6'b110100: s7 = 4'b0001;
		  6'b110101: s7 = 4'b0100;
		  6'b110110: s7 = 4'b1010;
		  6'b110111: s7 = 4'b0111;
		  6'b111000: s7 = 4'b1001;
		  6'b111001: s7 = 4'b0101;
		  6'b111010: s7 = 4'b0000;
		  6'b111011: s7 = 4'b1111;
		  6'b111100: s7 = 4'b1110;
		  6'b111101: s7 = 4'b0010;
		  6'b111110: s7 = 4'b0011;
		  6'b111111: s7 = 4'b1100;
		endcase
endfunction

function [0:3] s8;
		input [0:5] n6;
		case (sa(n6))
		  6'b000000: s8 = 4'b1101;
		  6'b000001: s8 = 4'b0010;
		  6'b000010: s8 = 4'b1000;
		  6'b000011: s8 = 4'b0100;
		  6'b000100: s8 = 4'b0110;
		  6'b000101: s8 = 4'b1111;
		  6'b000110: s8 = 4'b1011;
		  6'b000111: s8 = 4'b0001;
		  6'b001000: s8 = 4'b1010;
		  6'b001001: s8 = 4'b1001;
		  6'b001010: s8 = 4'b0011;
		  6'b001011: s8 = 4'b1110;
		  6'b001100: s8 = 4'b0101;
		  6'b001101: s8 = 4'b0000;
		  6'b001110: s8 = 4'b1100;
		  6'b001111: s8 = 4'b0111;
		  6'b010000: s8 = 4'b0001;
		  6'b010001: s8 = 4'b1111;
		  6'b010010: s8 = 4'b1101;
		  6'b010011: s8 = 4'b1000;
		  6'b010100: s8 = 4'b1010;
		  6'b010101: s8 = 4'b0011;
		  6'b010110: s8 = 4'b0111;
		  6'b010111: s8 = 4'b0100;
		  6'b011000: s8 = 4'b1100;
		  6'b011001: s8 = 4'b0101;
		  6'b011010: s8 = 4'b0110;
		  6'b011011: s8 = 4'b1011;
		  6'b011100: s8 = 4'b0000;
		  6'b011101: s8 = 4'b1110;
		  6'b011110: s8 = 4'b1001;
		  6'b011111: s8 = 4'b0010;
		  6'b100000: s8 = 4'b0111;
		  6'b100001: s8 = 4'b1011;
		  6'b100010: s8 = 4'b0100;
		  6'b100011: s8 = 4'b0001;
		  6'b100100: s8 = 4'b1001;
		  6'b100101: s8 = 4'b1100;
		  6'b100110: s8 = 4'b1110;
		  6'b100111: s8 = 4'b0010;
		  6'b101000: s8 = 4'b0000;
		  6'b101001: s8 = 4'b0110;
		  6'b101010: s8 = 4'b1010;
		  6'b101011: s8 = 4'b1101;
		  6'b101100: s8 = 4'b1111;
		  6'b101101: s8 = 4'b0011;
		  6'b101110: s8 = 4'b0101;
		  6'b101111: s8 = 4'b1000;
		  6'b110000: s8 = 4'b0010;
		  6'b110001: s8 = 4'b0001;
		  6'b110010: s8 = 4'b1110;
		  6'b110011: s8 = 4'b0111;
		  6'b110100: s8 = 4'b0100;
		  6'b110101: s8 = 4'b1010;
		  6'b110110: s8 = 4'b1000;
		  6'b110111: s8 = 4'b1101;
		  6'b111000: s8 = 4'b1111;
		  6'b111001: s8 = 4'b1100;
		  6'b111010: s8 = 4'b1001;
		  6'b111011: s8 = 4'b0000;
		  6'b111100: s8 = 4'b0011;
		  6'b111101: s8 = 4'b0101;
		  6'b111110: s8 = 4'b0110;
		  6'b111111: s8 = 4'b1011;
		endcase
endfunction

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
