/*
todo
*/
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <ctype.h>
#include <libgen.h>

#include "triplib.h"

#define   IGNORE_FILE_NAME   "ignore.txt"	/* gbvƂėLłȂ̏o͐ */

#define   MHCMARK   "#MHC"	/* mhc p̃}[N */

#define   MAX_LINE_LEN   1000	/* s̍ő */

#define   MINTARG_DEF     7	/* ^[Qbg̍ŏ̃ftHg */
#define   MINTARG_MIN     1	/* ^[Qbg̍ŏ̍ŏ */
#define   MINTARG_MAX    10	/* ^[Qbg̍ŏ̍ő */

#define   MAXTARG_DEF    10	/* ^[Qbg̍ő啶̃ftHg */
#define   MAXTARG_MIN     1	/* ^[Qbg̍ő啶̍ŏ */
#define   MAXTARG_MAX    10	/* ^[Qbg̍ő啶̍ő */

#define   MINTANGO_DEF    3	/* PƂ݂Ȃŏ̃ftHg */
#define   MINTANGO_MIN    1	/* PƂ݂Ȃŏ̍ŏ */
#define   MINTANGO_MAX   10	/* PƂ݂Ȃŏ̍ő */

#define   MINIC_MIN          1	/* IɋʂȂɂŏ̍ŏ */
#define   MINIC_MAX         10	/* IɋʂȂɂŏ̍ő */

int	pattern;	/* WJw */
int	location;	/* ʒuw */
int	headUpper;	/* ŏ̃At@xbg啶ɁAȍ~͏ */
int	tobiMode;	/* Ζ */
int	yamaMode;	/* RF */
int	sourenMode;	/* oA */
int	makeIgnore;	/* gbvƂėLłȂ̏o */
int	noSlash;	/* / 󔒂Ƃ݂Ȃ */
int	noDot;		/* . 󔒂Ƃ݂Ȃ */
int	verbose;	/* `ヂ[h */
int	minTarg;	/* ^[Qbg̍ŏ */
int	maxTarg;	/* ^[Qbg̍ő啶 */
int	minTango;	/* PƂ݂Ȃŏ */
int	minIC;		/* IɋʂȂɂŏ 999 Ȃ疳 */
int	yokiMode;	/* < >, <->, <'> Ȃǂ悫ɂ͂炤 */
int	doorMode;	/* ./ ߂́AS啶݂̂ */
int	inwall;		/* wallChar ň͂ */
int	wallChar;	/* ݂͂Ɏg */
int	reverse;	/* tǂ */
int	mhcMark;	/* mhc p}[N̕t */
int	repeatUme;	/* Ō̕Ŗ Baka -> Bakaaaaa */

unsigned char	*inputFileName;
FILE	*inputFile;

FILE	*ignoreFile;

int	lineNo;

#define   MAX_MARK_PI_LEN   100
unsigned char	mark[MAX_MARK_PI_LEN];
unsigned char	postit[MAX_MARK_PI_LEN];

#define   TOSEEK     0
#define   TOTARGET   1
#define   TOL2R      2
int	kind;

void
usage()
{
  switch ( kind ) {
   case TOSEEK:
    fprintf( stderr, "word2seek 1.9\n" );
    fprintf( stderr, "w2s [-e num] [-c num] [-w num] [-g num] [-u] [-s {2|4|5}] [-/] [-f] [-i] [-t] [-r] [-n] [-y] [-d {/|.}] [-m mark] [-p postit] [-R] [-k] [-v] [-h] [-?] [ifile]\n" );
    break;
   case TOTARGET:
    fprintf( stderr, "word2target 1.8\n" );
    fprintf( stderr, "w2t [-e num] [-c num] [-w num] [-g num] [-u] [-s {2|4|5}] [-/] [-f] [-i] [-t] [-r] [-n] [-y] [-d {/|.}] [-a] [-m mark] [-M] [-R] [-k] [-v] [-h] [-?] [ifile]\n" );
    break;
   case TOL2R:
    fprintf( stderr, "word2l2r 1.4\n" );
    fprintf( stderr, "w2l [-e num] [-c num] [-w num] [-u] [-s {2|4|5}] [-/] [-f] [-r] [-n] [-y] [-d {/|.}] [-R] [-k] [-v] [-h] [-?] [ifile]\n" );
    break;
  }
  fprintf( stderr, "IvVw肵ȂꍇA擪wŊSv + 3 p^[WJƂȂ܂B\n" );
  fprintf( stderr, " -e num : ^[Qbg̍ŏ (%d ` %d AftHg %d)\n",
          MINTARG_MIN, MINTARG_MAX, MINTARG_DEF );
  fprintf( stderr, " -c num : ^[Qbg̍ő啶 (%d ` %d AftHg %d)\n",
          MAXTARG_MIN, MAXTARG_MAX, MAXTARG_DEF );
  fprintf( stderr, " -w num : PƂ݂Ȃŏ (%d ` %d AftHg %d)\n",
          MINTANGO_MIN, MINTANGO_MAX, MINTANGO_DEF );
  if ( kind != TOL2R ) {
   fprintf( stderr, " -g num : IɋʂȂɂŏ (%d ` %d AftHgł͂Ȃ)\n",
           MINIC_MIN, MINIC_MAX );
  }
  fprintf( stderr, " -u : 擪̃At@xbg啶ɁAc\n" );
  fprintf( stderr, " -s 2 : Ζ\n" );
  fprintf( stderr, " -s 4 : RF\n" );
  fprintf( stderr, " -s 5 : oA\n" );
  fprintf( stderr, " -/ : P / ň͂\n" );
  fprintf( stderr, " -. : P . ň͂\n" );
  fprintf( stderr, " ( -/  -. ͔r)\n" );
  fprintf( stderr, " -f : Sv\n" );
  if ( kind != TOL2R ) {
   fprintf( stderr, " -i : 啶ʂȂ\n" );
   fprintf( stderr, " -t : w\n" );
  }
  fprintf( stderr, " -r : ʒuwȂ\n" );
  fprintf( stderr, " -n : gbvƂėLłȂ %s ɏo\n", IGNORE_FILE_NAME );
  fprintf( stderr, " -y : 1 Gg / 1 sƂ݂ȂāA낢Ƃ悫ɂ͂炤\n" );
  fprintf( stderr, " -d / : ǂݍ / 󔒂Ƃ݂Ȃ\n" );
  fprintf( stderr, " -d . : ǂݍ . 󔒂Ƃ݂Ȃ\n" );
  if ( kind == TOTARGET ) {
   fprintf( stderr, " -a : ./ Ŗ߂́AS啶݂̂\n" );
  }
  if ( kind == TOSEEK ) {
   fprintf( stderr, " -m mark : Unified Tripper Ή̃}[N\n" );
   fprintf( stderr, " -p postit : Unified Tripper Ή̕t\n" );
  }
  if ( kind == TOTARGET ) {
   fprintf( stderr, " -m mark : ܂A҂ĉBO}l[WΉ̃}[N\n" );
   fprintf( stderr, " -M : ܂A҂ĉBqbg`FbJ[p}[Nt\n" );
  }
  fprintf( stderr, " -R : tǂ\n" );
  fprintf( stderr, " -k : Ō̕JԂ\n" );
  fprintf( stderr, " -v : `ヂ[h\n" );
  fprintf( stderr, " -h : \\n" );
  fprintf( stderr, " -? : \\n" );
  fprintf( stderr, " ifile : Pt@C (ȗɂ́AW͂)\n" );
}

void
getOption( ac, av )
int	ac;
char	*av[];
{
  extern char	*optarg;
  extern int	optind, opterr, optopt;
  int	optChar;

  pattern = PAT_3;
  location = LOC_HEAD;
  minTarg = MINTARG_DEF;
  maxTarg = MAXTARG_DEF;
  headUpper = TL_FALSE;
  tobiMode = TL_FALSE;
  yamaMode = TL_FALSE;
  sourenMode = TL_FALSE;
  minTango = MINTANGO_DEF;
  verbose = TL_FALSE;
  makeIgnore = TL_FALSE;
  noSlash = TL_FALSE;
  noDot = TL_FALSE;
  yokiMode = TL_FALSE;
  doorMode = TL_FALSE;
  inwall = TL_FALSE;
  wallChar = ' ';
  reverse = TL_FALSE;
  mark[0] = '\0';
  postit[0] = '\0';
  minIC = 999;
  mhcMark = TL_FALSE;
  repeatUme = TL_FALSE;
  while ( (optChar = getopt(ac, av, "e:c:w:g:us:/.fitrnyd:am:Mp:Rkvh?")) != EOF ) {
   switch ( optChar ) {
    case 'e':
     minTarg = atoi( optarg );
     if ( minTarg < MINTARG_MIN || minTarg > MINTARG_MAX ) {
      usage();
      exit( 1 );
     }
     break;
    case 'c':
     maxTarg = atoi( optarg );
     if ( maxTarg < MAXTARG_MIN || maxTarg > MAXTARG_MAX ) {
      usage();
      exit( 1 );
     }
     break;
    case 'w':
     minTango = atoi( optarg );
     if ( minTango < MINTANGO_MIN || minTango > MINTANGO_MAX ) {
      usage();
      exit( 1 );
     }
     break;
    case 'g':
     minIC = atoi( optarg );
     if ( minIC < MINIC_MIN || minIC > MINIC_MAX ) {
      usage();
      exit( 1 );
     }
     if ( kind == TOL2R ) {
      usage();
      exit( 1 );
     }
     break;
    case 'u': headUpper = TL_TRUE; break;
    case 's':
     switch ( optarg[0] ) {
      case '2': tobiMode = TL_TRUE; break;
      case '4': yamaMode = TL_TRUE; break;
      case '5': sourenMode = TL_TRUE; break;
      default:
       usage();
       exit( 1 );
     }
     break;
    case '/':
     if ( wallChar == '.' ) {
      usage();
      exit( 1 );
     }
     inwall = TL_TRUE;
     wallChar = '/';
     break;
    case '.':
     if ( wallChar == '/' ) {
      usage();
      exit( 1 );
     }
     inwall = TL_TRUE;
     wallChar = '.';
     break;
    case 'f': pattern = PAT_PERF; break;
    case 'i':
     pattern = PAT_ANY;
     if ( kind == TOL2R ) {
      usage();
      exit( 1 );
     }
     break;
    case 't':
     location = LOC_TAIL;
     if ( kind == TOL2R ) {
      usage();
      exit( 1 );
     }
     break;
    case 'r': location = LOC_ANY; break;
    case 'n': makeIgnore = TL_TRUE; break;
    case 'y': yokiMode = TL_TRUE; break;
    case 'd':
     switch ( optarg[0] ) {
      case '/': noSlash = TL_TRUE; break;
      case '.': noDot = TL_TRUE; break;
     }
     break;
    case 'a':
     if ( kind != TOTARGET ) {
      usage();
      exit( 1 );
     }
     doorMode = TL_TRUE;
     break;
    case 'm':
     if ( kind != TOSEEK && kind != TOTARGET ) {
      usage();
      exit( 1 );
     }
     strcpy( mark, optarg );
     break;
    case 'M':
     if ( kind != TOTARGET ) {
      usage();
      exit( 1 );
     }
     mhcMark = TL_TRUE;
     break;
    case 'p':
     if ( kind != TOSEEK ) {
      usage();
      exit( 1 );
     }
     strcpy( postit, optarg );
     break;
    case 'R': reverse = TL_TRUE; break;
    case 'k': repeatUme = TL_TRUE; break;
    case 'v': verbose = TL_TRUE; break;
    case 'h': case '?': usage(); exit( 0 ); break;
   }
  }

  switch ( ac - optind) {
   case 0:
    inputFileName = NULL;
    break;
   case 1:
    inputFileName = av[optind];
    break;
   default:
    usage();
    exit( 1 );
  }

  if ( verbose ) {
   fprintf( stderr, "^[Qbg̍ŏ : %d\n", minTarg );
   fprintf( stderr, "^[Qbg̍ő啶 : %d\n", maxTarg );
   fprintf( stderr, "PƂ݂Ȃŏ : %d\n", minTango );
   if ( headUpper ) {
    fprintf( stderr, "擪啶Acɕϊ\n" );
   }
   if ( tobiMode ) {
    fprintf( stderr, "Ζ\n" );
   }
   if ( yamaMode ) {
    fprintf( stderr, "RF\n" );
   }
   if ( sourenMode ) {
    fprintf( stderr, "oA\n" );
   }
   switch ( pattern ) {
    case PAT_PERF: fprintf( stderr, "Sv\n" );  break;
    case PAT_ANY:  fprintf( stderr, "啶ʂȂ\n" ); break;
    case PAT_3:    fprintf( stderr, "Sv + 3 p^[WJ\n" );  break;
   }
   switch ( location ) {
    case LOC_HEAD: fprintf( stderr, "擪w\n" );  break;
    case LOC_ANY:  fprintf( stderr, "ʒuwȂ\n" ); break;
    case LOC_TAIL: fprintf( stderr, "w\n" );  break;
   }
   if ( kind == TOSEEK || kind == TOTARGET ) {
    if ( mark[0] != '\0' ) {
     fprintf( stderr, "}[NƂāA%s gp\n", mark );
    }
    if ( postit[0] != '\0' ) {
     fprintf( stderr, "tⳂƂāA%s gp\n", postit );
    }
    if ( mhcMark ) {
     /* target ̏ꍇ݂̂ǁAseek Ȃ mhcMark ͋UȂ̂ł */
     fprintf( stderr, "mhc p}[Nt\n" );
    }
   }
   if ( makeIgnore ) {
    fprintf( stderr, "gbvƂėLłȂ́A%s t@C֏o\n",
            IGNORE_FILE_NAME );
   }
   if ( noSlash ) {
    fprintf( stderr, "ǂݍ / ͋󔒂Ƃ݂Ȃ\n" );
   }
   if ( noDot ) {
    fprintf( stderr, "ǂݍ . ͋󔒂Ƃ݂Ȃ\n" );
   }
   if ( yokiMode ) {
    fprintf( stderr, "ǂݍ񂾋󔒂 -  ' K؂ɏ\n" );
   }
   if ( doorMode ) {
    fprintf( stderr, "./ Ŗ߂ɂ́AS啶݂̂\n" );
   }
   if ( inwall ) {
    fprintf( stderr, "%c ň͂\n", wallChar );
   }
   if ( reverse ) {
    fprintf( stderr, "tǂ (}jA)\n" );
   }
   if ( repeatUme ) {
    fprintf( stderr, "Ō̕JԂ\n" );
   }
  }
}

void
writeL2r( word )
unsigned char	*word;
{
  static int	firstCall = TL_TRUE;
  static unsigned char	head[2];

  if ( firstCall ) {
   firstCall = TL_FALSE;
   head[1] = '\0';
   switch ( location ) {
    case LOC_HEAD:
      switch ( pattern ) {
       case PAT_PERF: head[0] = '&'; break;
       case PAT_3:    head[0] = '^'; break;
      }
      break;
    case LOC_ANY:
      switch ( pattern ) {
       case PAT_PERF: head[0] = '@'; break;
       case PAT_3:    head[0] = '\0'; break;
      }
      break;
   }
  }

  printf( "%s%s\n", head, word );
}

void
writeSeek( word )
unsigned char	*word;
{
  static int	firstCall = TL_TRUE;
  static unsigned char	loc[2], pat[2];
  int	wordLen;

  if ( firstCall ) {
   firstCall = TL_FALSE;
   loc[1] = '\0';
   switch ( location ) {
    case LOC_HEAD: loc[0] = '^';  break;
    case LOC_ANY:  loc[0] = '\0'; break;
    case LOC_TAIL: loc[0] = '>';  break;
   }
   pat[1] = '\0';
   switch ( pattern ) {
    case PAT_PERF: pat[0] = '*';  break;
    case PAT_ANY:  pat[0] = '\0'; break;
    case PAT_3:    pat[0] = '+';  break;
   }
  }

  wordLen = strlen( word );
  if ( minIC <= wordLen ) {
   printf( "%s%s", loc, word );
  } else {
   printf( "%s%s%s", loc, word, pat );
  }
  if ( mark[0] != '\0' ) {
   printf( "\t/M%s", mark );
  }
  if ( postit[0] != '\0' ) {
   printf( "\t/P%s", postit );
  }
  printf( "\n" );
}

void
writeTarget( word )
unsigned char	*word;
{
  static int	firstCall = TL_TRUE;
  static unsigned char	head[2], tail[2];
  unsigned char	*threePat[3];
  int	wordLen;
  int	i;
  int	needTailCheck;
  unsigned char	tailChar;

  if ( firstCall ) {
   firstCall = TL_FALSE;
   head[1] = '\0';
   tail[1] = '\0';
   switch ( location ) {
    case LOC_HEAD: head[0] = '^';  tail[0] = '\0'; break;
    case LOC_ANY:  head[0] = '\0'; tail[0] = '\0'; break;
    case LOC_TAIL: head[0] = '\0'; tail[0] = '$';  break;
   }
  }

  wordLen = strlen( word );
  tailChar = word[wordLen - 1];
  needTailCheck = (location == LOC_TAIL || wordLen == TRIP_LEN);

  if ( minIC <= wordLen || pattern == PAT_ANY ) {
   /* ʂȂ */
   if ( needTailCheck && !istailic[word[wordLen - 1]] ) {
    return;
   }
   printf( "%s", head );
   for ( i = 0; i < wordLen - 1; i++ ) {
    if ( isalpha( word[i] ) ) {
     printf( "[%c%c]", tolower( word[i] ), toupper( word[i] ) );
    } else {
     putchar( word[i] );
    }
   }
   /* Ō̈ꕶ́Aǂŏς */
   if ( needTailCheck ) {
    if ( istail[tolower( tailChar )] ) {
     putchar( tolower( tailChar ) );
    } else {
     putchar( toupper( tailChar ) );
    }
   } else {
    if ( isalpha( tailChar ) ) {
     printf( "[%c%c]", tolower( tailChar ), toupper( tailChar ) );
    } else {
     putchar( tailChar );
    }
   }
   printf( "%s", tail );
   if ( mark[0] != '\0' ) {
    printf( "\t#%s", mark );
   }
   if ( mhcMark ) {
    printf( "\t%s", MHCMARK );
   }
   printf( "\n" );
  } else if ( pattern == PAT_PERF ) {
   /* S */
   if ( (needTailCheck && istail[tailChar]) || !needTailCheck ) {
    printf( "%s%s%s", head, word, tail );
    if ( mark[0] != '\0' ) {
     printf( "\t#%s", mark );
    }
    if ( mhcMark ) {
     printf( "\t%s", MHCMARK );
    }
    printf( "\n" );
   }
  } else if ( pattern == PAT_3 ) {
   /* 3 p^[ */
   /* IWiS/S/̂ǂꂩȂo͂Ȃ */
   /* SƂ܂Ƃ߂ꍇ邯ǁA܂ */
   if ( !doorMode ) {
    if ( (needTailCheck && istail[tailChar]) || !needTailCheck ) {
     if ( reverse ) {
      make3PatternR( word, threePat );
     } else {
      make3Pattern( word, threePat );
     }
     for ( i = 0; i < 3; i++ ) {
      if ( threePat[i] == NULL ) {
       goto NEXT;
      }
     }
     printf( "%s%s%s", head, word, tail );
     if ( mark[0] != '\0' ) {
      printf( "\t#%s", mark );
     }
     if ( mhcMark ) {
      printf( "\t%s", MHCMARK );
     }
     printf( "\n" );
    }
    NEXT:
    /* 9[aA]bcd : ŏɌAt@xbĝݑ召Ac菬 */
    /* tǂ݂̏ꍇ́AŌɌ(r */
    if ( (needTailCheck && istail[tolower(tailChar)]) || !needTailCheck ) {
     int	alphaIdx;
     printf( "%s", head );
     if ( reverse ) {
      for ( alphaIdx = wordLen - 1; alphaIdx >= 0; alphaIdx-- ) {
       if ( isalpha( word[alphaIdx] ) ) { break; }
      }
     } else {
      for ( alphaIdx = 0; alphaIdx < wordLen; alphaIdx++ ) {
       if ( isalpha( word[alphaIdx] ) ) { break; }
      }
     }
     for ( i = 0; i < wordLen; i++ ) {
      if ( i == alphaIdx ) {
       putchar( '[' );
       putchar( tolower( word[i] ) );
       putchar( toupper( word[i] ) );
       putchar( ']' );
      } else {
       putchar( tolower( word[i] ) );
      }
     }
     printf( "%s", tail );
     if ( mark[0] != '\0' ) {
      printf( "\t#%s", mark );
     }
     if ( mhcMark ) {
      printf( "\t%s", MHCMARK );
     }
     printf( "\n" );
    }
   }
   /* ABCD : S */
   if ( (needTailCheck && istail[toupper(tailChar)]) || !needTailCheck ) {
    printf( "%s", head );
    for ( i = 0; i < wordLen; i++ ) {
     putchar( toupper( word[i] ) );
    }
    printf( "%s", tail );
    if ( mark[0] != '\0' ) {
     printf( "\t#%s", mark );
    }
    if ( mhcMark ) {
     printf( "\t%s", MHCMARK );
    }
    printf( "\n" );
   }
  }
}

void
writeIt( word )
unsigned char	*word;
{
  unsigned char	tmpWord[MAX_LINE_LEN];
  int	wordLen;

  strcpy( tmpWord, word );
  tmpWord[maxTarg] = '\0';
  wordLen = strlen( tmpWord );
  if ( wordLen == TRIP_LEN ) {
   if ( pattern == PAT_PERF ) {
    if ( !istail[tmpWord[TRIP_LEN - 1]] ) {
     return;
    }
   } else {
    if ( !istailic[tmpWord[TRIP_LEN - 1]] ) {
     return;
    }
   }
  }

  switch ( kind ) {
   case TOSEEK:
    writeSeek( tmpWord );
    break;
   case TOTARGET:
    writeTarget( tmpWord );
    break;
   case TOL2R:
    writeL2r( tmpWord );
    break;
  }
}

void
ume( line, delim )
unsigned char	*line;
unsigned char	delim;
{
  int	i;
  unsigned char	ume[MAX_LINE_LEN];

  for ( i = 0; line[i] != '\0'; i++ ) {
   ume[i] = line[i];
  }
  for ( ; i < minTarg; i++ ) {
   ume[i] = delim;
  }
  ume[i] = '\0';
  writeIt( ume );
}

void
tobi( line, delim )
unsigned char	*line;
unsigned char	delim;
{
  int	i, j;
  unsigned char	tobi1[MAX_LINE_LEN], tobi2[MAX_LINE_LEN];

  j = 0;
  for ( i = 0; line[i] != '\0'; i++ ) {
   tobi1[j] = delim;
   tobi2[j] = line[i];
   j++;
   tobi1[j] = line[i];
   tobi2[j] = delim;
   j++;
  }
  tobi2[j] = '\0';
  tobi1[j++] = delim;
  tobi1[j] = '\0';
  tobi1[10] = '\0';
  ume( tobi1, delim );
  if ( delim != '/' ) {
   ume( tobi2, delim );
  } else {
   if ( strlen( line ) <= 4 ) {
    j = 0;
    for ( i = 0; line[i] != '\0'; i++ ) {
     tobi1[j++] = line[i];
     tobi1[j++] = '.';
     tobi1[j++] = '.';
    }
    tobi1[j] = '\0';
    tobi1[10] = '\0';
    ume( tobi1, delim );
   }
  }
}

void
yamaSub( yama )
unsigned char	*yama;
{
  ume( yama, '.' );
  if ( strlen( yama ) < minTarg ) {
   ume( yama, '/' );
  }
}

void
yama( line )
unsigned char	*line;
{
  unsigned char	yama[MAX_LINE_LEN];
  int	wordLen;

  strcpy( yama, line );
  strcat( yama, line );
  yamaSub( yama );

  wordLen = strlen( line );
  switch ( wordLen ) {
   case 2:
    strcpy( yama, line );
    strcat( yama, line );
    strcat( yama, line );
    strcat( yama, line );
    yamaSub( yama );
    break;
   case 3:
    strcpy( yama, line );
    strcat( yama, line );
    strcat( yama, line );
    yamaSub( yama );
    break;
  }
}

void
souren( line )
unsigned char	*line;
{
  int	i, j;
  unsigned char	souren[MAX_LINE_LEN];

  j = 0;
  for ( i = 0; line[i] != '\0'; i++ ) {
   souren[j++] = line[i];
   souren[j++] = line[i];
  }
  souren[j] = '\0';
  ume( souren, '.' );
  if ( strlen( souren ) < minTarg ) {
   ume( souren, '/' );
  }
}

void
addWord( word )
unsigned char	*word;
{
  int	i;
  int	wordLen;

  wordLen = strlen( word );
  if ( wordLen < minTango || wordLen > TRIP_LEN ) {
   if ( makeIgnore ) {
    fprintf( ignoreFile, "%d : %s ()\n", lineNo, word );
   }
   return;
  }
  if ( wordLen == TRIP_LEN ) {
   if ( pattern == PAT_PERF ) {
    if ( !istail[word[TRIP_LEN - 1]] ) {
     if ( makeIgnore ) {
      fprintf( ignoreFile, "%d : %s ()\n", lineNo, word );
     }
     return;
    }
   } else {
    if ( !istailic[word[TRIP_LEN - 1]] ) {
     if ( makeIgnore ) {
      fprintf( ignoreFile, "%d : %s ()\n", lineNo, word );
     }
     return;
    }
   }
  }

  if ( headUpper ) {
   for ( i = 0; word[i] != '\0'; i++ ) {
    if ( isalpha( word[i] ) ) {
     word[i] = toupper( word[i] );
     break;
    }
   }
   i++;
   for ( ; word[i] != '\0'; i++ ) {
    word[i] = tolower( word[i] );
   }
  }
  if ( tobiMode || yamaMode || sourenMode ) {
   if ( wordLen <= (TRIP_LEN / 2) ) {
    if ( tobiMode ) {
     tobi( word, '.' );
     tobi( word, '/' );
    }
    if ( yamaMode ) {
     yama( word );
    }
    if ( sourenMode ) {
     souren( word );
    }
   }
  } else {
   if ( wordLen < minTarg ) {
    if ( repeatUme ) {
     ume( word, word[wordLen - 1] );
    } else {
     ume( word, '.' );
     ume( word, '/' );
    }
   } else {
    writeIt( word );
   }
  }
}

void
makeIt()
{
  int	i, j, wordIndex1, wordIndex3;
  int	toUpper;
  int	lineLen;
  unsigned char	line[MAX_LINE_LEN], tmpLine[MAX_LINE_LEN],
                tmpWord[MAX_LINE_LEN],
                word1[MAX_LINE_LEN], word2[MAX_LINE_LEN], word3[MAX_LINE_LEN];
  unsigned char	*linePtr, *strHead;

  if ( inputFileName == NULL ) {
   inputFile = stdin;
  } else {
   if ( (inputFile = fopen( inputFileName, "r" )) == NULL ) {
    fprintf( stderr, "%s ǂ߂܂B\n", inputFileName );
    exit( 1 );
   }
  }
  if ( makeIgnore ) {
   if ( (ignoreFile = fopen( IGNORE_FILE_NAME, "w" )) == NULL ) {
    fprintf( stderr, "%s ɏ܂B\n", IGNORE_FILE_NAME );
    exit( 1 );
   }
  }

  lineNo = 0;
  while ( fgets( line, MAX_LINE_LEN, inputFile ) != NULL ) {
   lineNo++;
   if ( line[0] == '#' ) {
    /* 擪 # ̍s̓RgƂĖ */
    continue;
   }
   lineLen = delCr( line );

   /*
    擪̋󔒂̂ĂAA󔒂ɂ܂Ƃ߂āA̋󔒂̂Ă
    */
   i = 0;
   j = 0;
   while ( i < lineLen ) {
    if ( line[i] == ' ' || line[i] == '\t' ) {
     tmpLine[j++] = ' ';
#if 0
     if ( j != 0 ) {
      if ( tmpLine[j-1] != '.' ) {
       tmpLine[j++] = ' ';
      }
     }
#endif /* 0 */
     while ( line[i] == ' ' || line[i] == '\t' ) {
      i++;
     }
    } else {
     tmpLine[j++] = line[i++];
    }
   }
   if ( tmpLine[j-1] == ' ' ) {
    j--;
   }
   tmpLine[j] = '\0';
   strcpy( line, tmpLine );
   lineLen = j;
#ifdef OLDDEBUG
   printf( "line = <%s>, lineLen = %d\n", line, lineLen );
   exit( 0 );
#endif /* DEBUG */

   if ( reverse ) {
    unsigned char	work;
#ifdef OLDDEBUG
    printf( "reverse before : <%s>\n", line );
#endif /* DEBUG */
/*
 abc 0,2
 abcd 0,3 1,2
*/
    for ( i = 0; i < lineLen / 2; i++ ) {
     work = line[i];
     line[i] = line[lineLen - i - 1];
     line[lineLen - i - 1] = work;
    }
#ifdef OLDDEBUG
    printf( "reverse after : <%s>\n", line );
#endif /* DEBUG */
   }
   if ( inwall ) {
    line[lineLen+1] = wallChar;
    line[lineLen+2] = '\0';
    for ( i = lineLen; i > 0; i-- ) {
     line[i] = line[i-1];
    }
    line[0] = wallChar;
    lineLen += 2; 
   }
#ifdef OLDDEBUG
   printf( "line = <%s>\n", line );
#endif /* DEBUG */
   if ( yokiMode ) {
    int	needYoki;
    needYoki = TL_FALSE;
    for ( i = 0; i < lineLen; i++ ) {
     if ( line[i] == '-' || line[i] == ' ' ||
          line[i] == '\'' || line[i] == ',' ) {
      needYoki = TL_TRUE;
      break;
     } else {
      if ( !istrip[line[i]] ) {
       fprintf( stderr, "gbvƂėLłȂ (%c)  %d sڂɁB\n",
                line[i], lineNo );
       needYoki = TL_TRUE;
       break;
      }
     }
    }
    if ( needYoki ) {
     /* '  , ͎̂ĂB. ̌̃Xy[X̂ĂB!istrip[] ȕ̂Ă */
     wordIndex1 = 0;
     for ( i = 0; line[i] != '\0'; i++ ) {
      if ( line[i] != '\'' && line[i] != ',' ) {
       if ( line[i] == ' ' ) {
        if ( wordIndex1 != 0 ) {
         if ( tmpWord[wordIndex1-1] != '.' ) {
          tmpWord[wordIndex1] = line[i];
          wordIndex1++;
         }
        }
       } else {
        if ( istrip[line[i]] ) {
         tmpWord[wordIndex1] = line[i];
         wordIndex1++;
        }
       }
      }
     }
     tmpWord[wordIndex1] = '\0';
#ifdef OLDDEBUG
     printf( "after del <'> : tmpWord = <%s>\n", tmpWord );
#endif /* DEBUG */
     /* <->, < > : . /  () */
     wordIndex1 = wordIndex3 = 0;
     toUpper = TL_TRUE;
     for ( i = 0; tmpWord[i] != '\0'; i++ ) {
      if ( tmpWord[i] == '-' || tmpWord[i] == ' ' ) {
       word1[wordIndex1] = '.';
       word2[wordIndex1] = '/';
       wordIndex1++;
       toUpper = TL_TRUE;
      } else {
       if ( toUpper ) {
        word1[wordIndex1] = toupper( tmpWord[i] );
        word2[wordIndex1] = toupper( tmpWord[i] );
        word3[wordIndex3] = toupper( tmpWord[i] );
        toUpper = TL_FALSE;
       } else {
        word1[wordIndex1] = tmpWord[i];
        word2[wordIndex1] = tmpWord[i];
        word3[wordIndex3] = tmpWord[i];
       }
       wordIndex1++;
       wordIndex3++;
      }
     }
     word1[wordIndex1] = '\0';
     word2[wordIndex1] = '\0';
     word3[wordIndex3] = '\0';
     addWord( word1 );
     if ( strcmp( word1, word2 ) != 0 ) {
      addWord( word2 );
      addWord( word3 );
     }
#ifdef OLDDEBUG
     printf( "word1 = <%s>, word2 = <%s>, word3 = <%s>\n",
             word1, word2, word3 );
#endif /* DEBUG */
    } else {
     addWord( line );
    }
   } else {
    for ( linePtr = line + lineLen - 1; linePtr >= line; linePtr-- ) {
     if ( !istrip[*linePtr] ) {
      *linePtr = '\0';
     }
     if ( noSlash && *linePtr == '/' ) {
      *linePtr = '\0';
     }
     if ( noDot && *linePtr == '.' ) {
      *linePtr = '\0';
     }
    }
    for ( i = 0; i < lineLen; i++ ) {
     if ( line[i] != '\0' ) {
#ifdef OLDDEBUG
      printf( "word = <%s>\n", line + i );
#endif /* DEBUG */
      addWord( line + i );
      for ( ; i < lineLen; i++ ) {
       if ( line[i] == '\0' ) {
        break;
       }
      }
     }
    }
   }
  }

  if ( makeIgnore ) {
   fclose( ignoreFile );
  }
  fclose( inputFile );
}

main( ac, av )
int	ac;
char	*av[];
{
  char	*myName;

  myName = basename( av[0] );
  switch ( myName[2] ) {
   case 't': /* w2t */
    kind = TOTARGET; break;
   case 's': /* w2s */
    kind = TOSEEK; break;
   case 'l': /* w2l */
    kind = TOL2R; break;
   default:
    fprintf( stderr, "͂H킽͂ǂH\n" );
    exit( 1 );
  }
#ifdef OLDDEBUG
  printf( "myName = <%s>, kind = %d\n", myName, kind );
#endif /* DEBUG */

  getOption( ac, av );

  makeIt();

  exit( 0 );
}
