/**********************************************************-*-verilog-*-
 *
 *	Salt̏
 *
 *	$Id: func_salt.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

/*
 *	01234567 -- Salt ̂Ђ݂
 *	./012345 0
 *	6789ABCD 1
 *	EFGHIJKL 2
 *	MNOPQRST 3
 *	UVWXYZab 4
 *	cdefghij 5
 *	klmnopqr 6
 *	stuvwxyz 7
 *
 *
 *	VǏSaltϊ\
 *	(ÍA0x2E-0x7AȊO . ɂȂ)
 *
 *	0123456789ABCDEF --- Region 0(22-22; 0x2E ȍ~͌݊)
 *
 *	GHIJKLMNOPQRSTUV	0
 *	WXYZabcdefghijkl	1
 *	mnopqrstuvwxyz./	2
 *	0123456789ABCDEF	3
 *	G					4
 *
 *	0123456789ABCDEF --- Region 1(14-53; ݊)
 *
 *	 ABCDEFGHIJKLMNO	4
 *	PQRSTUVWXYZabcde	5
 *	f					6
 *
 *	0123456789ABCDEF --- Region 2(46-04; 0x7B܂ł͌݊)
 *
 *	 abcdefghijklmno	6
 *	pqrstuvwxyz./012	7 (0x7F(04) ͏os)
 *
 *	0123456789ABCDEF --- Region 3(22-21; Region 0 ƘA)
 *
 *	GHIJKLMNOPQRSTUV	8
 *	WXYZabcdefghijkl	9
 *	mnopqrstuvwxyz./	A
 *	0123456789ABCDEF	B
 *	GHIJKLMNOPQRSTUV	C
 *	WXYZabcdefghijkl	D
 *	mnopqrstuvwxyz./	E
 *	0123456789ABCDEF	F
 */

/*
 *	̈ꕔSaltrbg肾
 *	̓gbvL̎dlłB
 *	Ă̌!!!
 */

function [5:0] mksalt;
		input [7:0] n;
		if (n < 8'h2E
			|| 8'h7A < n
			|| n == 8'h3C
			|| n == 8'h3E)
		  mksalt = 6'o00;	// Idl
		else if (8'h61 <= n && n <= 8'h7F)
		  mksalt = n - (8'h61 - 6'o46);
		else if (8'h41 <= n && n < 8'h61)
		  mksalt = n - (8'h41 - 6'o14);
		else
		  mksalt = n - 8'h2E;
endfunction

/*
 *	Saltrbgɉărbg̓ւs
 */
function salt_mux0;
		input salt;
		input e0;
		input e1;
		salt_mux0 = (salt ? e1 : e0);
endfunction

function salt_mux1;
		input salt;
		input e0;
		input e1;
		salt_mux1 = (salt ? e0 : e1);
endfunction

function [0:47] add_salt;
		input [11:0] salt;
		input [0:47] e;
		add_salt = {salt_mux0(salt[ 0], e[ 0], e[24]),
					salt_mux0(salt[ 1], e[ 1], e[25]),
					salt_mux0(salt[ 2], e[ 2], e[26]),
					salt_mux0(salt[ 3], e[ 3], e[27]),
					salt_mux0(salt[ 4], e[ 4], e[28]),
					salt_mux0(salt[ 5], e[ 5], e[29]),
					salt_mux0(salt[ 6], e[ 6], e[30]),
					salt_mux0(salt[ 7], e[ 7], e[31]),
					salt_mux0(salt[ 8], e[ 8], e[32]),
					salt_mux0(salt[ 9], e[ 9], e[33]),
					salt_mux0(salt[10], e[10], e[34]),
					salt_mux0(salt[11], e[11], e[35]),
					e[12:23],
					salt_mux1(salt[ 0], e[ 0], e[24]),
					salt_mux1(salt[ 1], e[ 1], e[25]),
					salt_mux1(salt[ 2], e[ 2], e[26]),
					salt_mux1(salt[ 3], e[ 3], e[27]),
					salt_mux1(salt[ 4], e[ 4], e[28]),
					salt_mux1(salt[ 5], e[ 5], e[29]),
					salt_mux1(salt[ 6], e[ 6], e[30]),
					salt_mux1(salt[ 7], e[ 7], e[31]),
					salt_mux1(salt[ 8], e[ 8], e[32]),
					salt_mux1(salt[ 9], e[ 9], e[33]),
					salt_mux1(salt[10], e[10], e[34]),
					salt_mux1(salt[11], e[11], e[35]),
					e[36:47]};
endfunction

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
