/**********************************************************-*-verilog-*-
 *
 *	Utility functions
 *
 *	$Id: func_util.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

/***************************************************************
 *
 *	nbVclassifŷ߂ɕKvɂȂ邩ȂB
 *	
 *	0 ./012345
 *	1 6789ABCD
 *	2 EFGHIJKL
 *	3 MNOPQRST
 *	4 UVWXYZab
 *	5 cdefghij
 *	6 klmnopqr
 *	7 stuvwxyz
 *
 */

/*
 *	6+1rbgɃGR[h
 */
function [6:0] enc64;
		input c;
		case (c)
		  ".": enc64 = 7'o00;
		  "/": enc64 = 7'o01;
		  "0": enc64 = 7'o02;
		  "1": enc64 = 7'o03;
		  "2": enc64 = 7'o04;
		  "3": enc64 = 7'o05;
		  "4": enc64 = 7'o06;
		  "5": enc64 = 7'o07;
		  "6": enc64 = 7'o10;
		  "7": enc64 = 7'o11;
		  "8": enc64 = 7'o12;
		  "9": enc64 = 7'o13;
		  "A": enc64 = 7'o14;
		  "B": enc64 = 7'o15;
		  "C": enc64 = 7'o16;
		  "D": enc64 = 7'o17;
		  "E": enc64 = 7'o20;
		  "F": enc64 = 7'o21;
		  "G": enc64 = 7'o22;
		  "H": enc64 = 7'o23;
		  "I": enc64 = 7'o24;
		  "J": enc64 = 7'o25;
		  "K": enc64 = 7'o26;
		  "L": enc64 = 7'o27;
		  "M": enc64 = 7'o30;
		  "N": enc64 = 7'o31;
		  "O": enc64 = 7'o32;
		  "P": enc64 = 7'o33;
		  "Q": enc64 = 7'o34;
		  "R": enc64 = 7'o35;
		  "S": enc64 = 7'o36;
		  "T": enc64 = 7'o37;
		  "U": enc64 = 7'o40;
		  "V": enc64 = 7'o41;
		  "W": enc64 = 7'o42;
		  "X": enc64 = 7'o43;
		  "Y": enc64 = 7'o44;
		  "Z": enc64 = 7'o45;
		  "a": enc64 = 7'o46;
		  "b": enc64 = 7'o47;
		  "c": enc64 = 7'o50;
		  "d": enc64 = 7'o51;
		  "e": enc64 = 7'o52;
		  "f": enc64 = 7'o53;
		  "g": enc64 = 7'o54;
		  "h": enc64 = 7'o55;
		  "i": enc64 = 7'o56;
		  "j": enc64 = 7'o57;
		  "k": enc64 = 7'o60;
		  "l": enc64 = 7'o61;
		  "m": enc64 = 7'o62;
		  "n": enc64 = 7'o63;
		  "o": enc64 = 7'o64;
		  "p": enc64 = 7'o65;
		  "q": enc64 = 7'o66;
		  "r": enc64 = 7'o67;
		  "s": enc64 = 7'o70;
		  "t": enc64 = 7'o71;
		  "u": enc64 = 7'o72;
		  "v": enc64 = 7'o73;
		  "w": enc64 = 7'o74;
		  "x": enc64 = 7'o75;
		  "y": enc64 = 7'o76;
		  "z": enc64 = 7'o77;
		  default: enc64 = 7'o177;
		endcase
endfunction

/*
 *	case insensitivep
 *	ABcdEFgh ̂悤ɕϊ
 *	2rbgȂčςނłB
 */
function [5:0] toupper;
		input [5:0] d;
		case (d)
//		  6'o01: toupper = 6'o00;	// / -> .

		  6'o46: toupper = 6'o14;	// A
		  6'o47: toupper = 6'o15;	// B
		  6'o16: toupper = 6'o50;	// c
		  6'o17: toupper = 6'o51;	// d
		  
		  6'o52: toupper = 6'o20;	// E
		  6'o53: toupper = 6'o21;	// F
		  6'o22: toupper = 6'o54;	// g
		  6'o23: toupper = 6'o55;	// h
		  
		  6'o56: toupper = 6'o24;	// I
		  6'o57: toupper = 6'o25;	// J
		  6'o26: toupper = 6'o60;	// k
		  6'o27: toupper = 6'o61;	// l
		  
		  6'o62: toupper = 6'o30;	// M
		  6'o63: toupper = 6'o31;	// N
		  6'o32: toupper = 6'o64;	// o
		  6'o33: toupper = 6'o65;	// p
		  
		  6'o66: toupper = 6'o34;	// Q
		  6'o67: toupper = 6'o35;	// R
		  6'o36: toupper = 6'o70;	// s
		  6'o37: toupper = 6'o71;	// t
		  
		  6'o72: toupper = 6'o40;	// U
		  6'o73: toupper = 6'o41;	// V
		  6'o42: toupper = 6'o74;	// w
		  6'o43: toupper = 6'o75;	// x
		  
		  6'o76: toupper = 6'o44;	// Y
		  6'o77: toupper = 6'o45;	// Z

		  default: toupper = d;
		endcase
endfunction

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
