/**********************************************************-*-verilog-*-
 *
 *	}XNrXbg
 *	X comparator.v ƂO
 *
 *	$Id: cmp10.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module cmp10(regclk, rst,
			 blk,
			 matched,
			 wen, txd);
	input			regclk;
	input 			rst;

	input [0:65] 	blk;
	output 			matched;

	input 			wen;	// ݃pX
	input [7:0] 	txd;	// WX^ɃZbgĂl

	// reLXg̃WX^
	reg [0:65] 		txt;
	reg [0:10] 		msk;

	// ̔ŕALN^ƂɈv}XNB
	wire [6:0] 		rtxd;
	assign 			rtxd = {txd[7], txd[5:0]};

	always @(posedge regclk or posedge rst)
	  if (rst)
	  begin
		  // Ԃł́A̕ZbgĂ
		  txt <= 66'b0;	// _̃p^[ݒ肵ˁB
		  msk <= 11'b0_1111111111;
	  end
	  else
	  begin
		  // WX^̃Zbg
		  if (wen)
		  begin
			  txt <= {txt[6:65], txd[5:0]};
			  msk <= {msk[1:10], txd[7]};
		  end
	  end

	assign matched = ((   !msk[ 1] || txt[ 6:11] == blk[ 6:11])
					  && (!msk[ 2] || txt[12:17] == blk[12:17])
					  && (!msk[ 3] || txt[18:23] == blk[18:23])
					  && (!msk[ 4] || txt[24:29] == blk[24:29])
					  && (!msk[ 5] || txt[30:35] == blk[30:35])
					  && (!msk[ 6] || txt[36:41] == blk[36:41])
					  && (!msk[ 7] || txt[42:47] == blk[42:47])
					  && (!msk[ 8] || txt[48:53] == blk[48:53])
					  && (!msk[ 9] || txt[54:59] == blk[54:59])
					  && (!msk[10] || txt[60:63] == blk[60:63]));
endmodule

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
