/***********************************************************************
 *
 *	file: mty.c
 *
 *	܂A҂ĉB
 *
 *	$Id: mty.c 263 2011-07-04 09:42:05Z notanpe $
 *
 */

#include <assert.h>
#include <stddef.h>
#include <stdio.h>
#include <time.h>
#include <sys/timeb.h>

#if defined(WIN32)

#include <windows.h>
#include <process.h>

#elif defined(__GNUC__)

#include <sys/time.h>

#endif

#include "desconst.h"
#include "expr_parse.h"
#include "hit.h"
#include "key.h"
#include "log.h"
#include "scoreboard.h"
#include "synth.h"
#include "util.h"
#include "makai.h"

#ifdef WIN32
/* Dx */
#define PRIO_MIN  0
#define PRIO_NORM 0
#define PRIO_BELO 1
#define PRIO_IDLE 2
#define PRIO_MAX  2
#define PRIO_DEF  2
#endif /* WIN32 */

/* Xbh CPU  */
#define THREAD_MIN  1
#define THREAD_MAX 32
int	availCPU;	/* usage() Ŏĝőϐ */

#define STS_SPAN 5000	/* x\̊Ԋu (~b) */

/* ΂肮 */
#define GEAR_MAX 10
#define GEAR_MIN  1
#define GEAR_DEF 10
#define GEAR_SLEEP 10
#define YOUSUMI 6	/* STS_PAN * YOUSUMI blq */
int	lCntMax;

/* Œ */
char	fixedSalt[3];	/* log_print Ŏĝőϐ */
#define NUMSC 64	/* ̕퐔 */
static char	saltChar[NUMSC] = "abcdefghijklmnopqrstuvwxyz"
                              "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                              "0123456789./";

static HANDLE mutex_key;

/* CRYPT64 Lqq */
static
struct CRYPT64_DESC const *const crypt64_descs[] =
{
  &crypt64_desc,
};

/* x]p */
static int n_cpus;
static uint64_t loop_cpu[1024];

#define USEC_SEC 1000	/* 1b */

static
uint64_t
usec(void)
{
  uint32_t sec, msec;

#if !defined(WIN32)
  struct timeval tv;
  gettimeofday(&tv, NULL);
  sec = tv.tv_sec;
  msec = tv.tv_usec / (1000000 / USEC_SEC);
#else
  struct timeb tm;
  ftime(&tm);
  sec = tm.time;
  msec = tm.millitm / (1000 / USEC_SEC);
#endif

  return (uint64_t)USEC_SEC * sec + msec;
}

/***************************************************************
 *
 *	CPU capabilities 擾
 *	[XXX] ܂ɂÂvZbT̂Ƃ͍lȂB
 *
 *	a[4] = {EAX,EBX,ECX,EDX}
 *
 */

#if defined(__GNUC__)

#define cpuid(n,a,b,c,d)	\
	asm("cpuid"		\
		: "=a"(a), "=b"(b), "=c"(c), "=d"(d)	\
		: "a"(n))

#elif defined(WIN32)

#define cpuid(n,a,b,c,d)	\
	do {int r[4]; __cpuid(r,n);	\
	(a) = r[0]; (b) = r[1]; (c) = r[2]; (d) = r[3];} while (0)

#endif

static
unsigned
cpuid_getfflags(void)
{
  unsigned a, b, c, d;
  cpuid(1, a, b, c, d);
  return d;
}

static
int
cpuid_issupported(void)
{
  unsigned m = REQUIRED_CAPS;
  return !((cpuid_getfflags() ^ m) & m);
}

/***************************************************************
 *
 *	ob`ppPbg
 *
 */

static
struct PACKET_CRYPT64 *
packet_create(int n,	/* pPbg */
			  int tn,	/* vfɂĕKvȃ[N */
			  uint8_t const *ini_key)
{
  int i;
  int siz;
  void *p;
  intptr_t a = 128;
  struct PACKET_CRYPT64 *pkts;
  assert(IS_POWER2(sizeof(struct PACKET_CRYPT64)));
  assert(n >= 1);

  siz = (a - 1
		 + (n - 1) * sizeof(struct PACKET_CRYPT64)
		 + offsetof(struct PACKET_CRYPT64, param64.hit[tn]));
  p = calloc(siz, 1);
  /* o_킹 */
  pkts = (struct PACKET_CRYPT64 *)(((intptr_t)p
									+ a - 1)
								   & -a);
#if DEBUG>=1
  fprintf(stderr,
		  "packet(n=%d,tn=%d) %d allocated; %p aligned to %p\n",
		  n, tn,
		  siz, p, pkts);
#endif

  /* ̏
	 Rs[ĉ̂́Aɂ
	 ŏIvf̃PcjĂ܂ƂɂȂ̂
	 ǂxvȂx^R[h */
  for (i = 0; i < n; i++)
	{
	  int j, k;

	  /* t[16] ́AZŎgpAall 1 Ă */
	  memset(&pkts[i].param64.t[T_INV], -1, sizeof(SLICE));

	  /* ŒL[̐ */
	  key_init_sk(&pkts[i].key64);

	  /* L[XPW[ɉ߂Ă
		 ] crypt64.S Ŋ悤ɈĂ */
	  for (j = 0; j < 28; j++)
		for (k = 0; k < N_ALU; k++)
		  pkts[i].key64.ks[j].a[k] = sizeof(WS_T) * ks_ls[j];

	  /* Ô߁AŗĂ(sv?) */
	  for (j = 0; j < 8; j++)
		key_set64(&pkts[i].key64, j, pkts[i].uk.key[j] = ini_key[j], 0, 0x7F);
	}

  return pkts;
}

/***************************************************************
 *
 *	thread
 *
 */

#if defined(__GNUC__)

typedef int32_t ATOMWORD_T;

#define LOCK_INC(p)	\
asm volatile ("lock incl %0"	\
			  : "=m"(*(p))	\
			  : /*nil*/		\
			  : "memory")

#define LOCK_DEC(p)	\
asm volatile ("lock decl %0"	\
			  : "=m"(*(p))	\
			  : /*nil*/		\
			  : "memory")

#define LOCK_CAS(pd,s,r)	\
({	ATOMWORD_T a;							\
	asm volatile ("lock cmpxchg %2,%1"		\
				  : "=a"(a)					\
				  : "m"(*(pd)), "r"(s), "0"(r)	\
				  : "memory");a;})

#define LOCK_CASP(pd,s,r)	\
({	void *a;								\
	asm volatile ("lock cmpxchg %2,%1"		\
				  : "=a"(a)					\
				  : "m"(*(pd)), "r"(s), "0"(r)	\
				  : "memory");a;})

#elif defined(WIN32)

typedef LONG ATOMWORD_T;

#define LOCK_INC(p) InterlockedIncrement((LONG *)(p))
#define LOCK_DEC(p) InterlockedDecrement((LONG *)(p))
#define LOCK_CAS(pd,s,r) InterlockedCompareExchange((LONG *)(pd), s, r)
#define LOCK_CASP(pd,s,r) InterlockedCompareExchangePointer((PVOID *)(pd), (PVOID)(s), (PVOID)r)

#else
#error "configuration not implemented"
#endif

#if defined(WIN32)

typedef DWORD THREAD_TIMEOUT_T;

#define THREAD_INFINITE INFINITE

typedef HANDLE THREAD_TH_T;

#define thread_sleep(n) Sleep(n)
#define thread_create(th, proc, arg) {(th) = (HANDLE)_beginthread(proc, 8192, arg);}
#define thread_get_tid()	GetCurrentThread()
#define thread_set_priority(tid,n)	SetThreadPriority(tid, n)
#define thread_set_affinity(tid,m)	SetThreadAffinityMask(tid, (DWORD_PTR)1 << (m))

#elif defined(_POSIX_SOURCE)

#include <pthread.h>
#include <unistd.h>

typedef int THREAD_TIMEOUT_T;

#define THREAD_INFINITE	INT_MAX

#if defined(THREAD_PRIORITY_BELOW_NOROMAL) || defined(THREAD_PRIORITY_IDLE)
#error "unsupported implementation"
#endif

#define THREAD_PRIORITY_NORMAL	14
#define THREAD_PRIORITY_BELOW_NORMAL	15
#define THREAD_PRIORITY_IDLE	16

typedef pthread_t THREAD_TH_T;

#define thread_sleep(n) (usleep(1000 * (n)) != EINVAL || sleep((n) / 1000))
#define thread_create(th, proc, arg) thread_create_p(&(th), proc, arg)

static
void
thread_create_p(pthread_t *th, NORETURN (*proc)(void *), void *param)
{
  pthread_create(th, NULL, (void *(*)(void *))proc, param);
}

#if defined(__linux__)

/* ftHgXPW[O|V[ł
   Dxݒ肵AChXbhNĂ
   낭Ȃ̂ŁÂւ͍̌ۑB */

#include <linux/unistd.h>
#ifdef _syscall0
 _syscall0(pid_t,gettid)
 #define thread_get_tid() gettid()
#else /* _syscall0 */
 #include <sys/syscall.h>
 #define thread_get_tid() (pid_t)syscall(SYS_gettid)
#endif /* _syscall0 */

static
int thread_set_affinity(pid_t tid, int i)
{
  cpu_set_t m;
  CPU_ZERO(&m);
  CPU_SET(i, &m);
  return sched_setaffinity(tid, sizeof(m), &m);
}

#else

/* POSIX ł́AXbhPʂ̃XPW[OɉłȂB */

#endif

#else
#error "configuration not supported"
#endif

struct THREAD_PARAM
{
  /* ȉ͋ʏ̃Rs[ */
  CODE_T *code;
  long code_cmp;
  unsigned seed;

  /* ȉ̓XbhŗL */
#ifdef thread_set_priority
  int pri;
#endif
};

static
uint64_t
thread_avail(void)
{
#if !USE_MT

  return 0x1U;

#elif defined(WIN32)	/* Win32 API */
  DWORD_PTR mask, mask_s;
  if (!GetProcessAffinityMask(GetCurrentProcess(),
							  &mask,
							  &mask_s)
	  || !mask
	  || !mask_s)
	return 0x1U;
#if DEBUG>=1
  fprintf(stderr,
		  "m=%08X s=%08X\n",
		 (unsigned)mask,
		 (unsigned)mask_s);
#endif
#if 0
  if (popcnt64(mask_s) == 1)
	/* ܂ */;
  else if (mask == mask_s)
	fprintf(stderr,
			"ʏ%d{Ƃ͂悭̂łB\n",
			popcnt64(mask));
  else
	fprintf(stderr,
			"ō͂%g{̗͂łĂƂɂ΂B\n",
			(double)popcnt64(mask) / popcnt64(mask_s));
#endif /* 0 */
  return mask;

#elif defined(__linux__)	/* sched.h g */

  int i;
  uint64_t m = 0;
  cpu_set_t am;
  if (sched_getaffinity(getpid(), sizeof(am), &am) < 0)
	return 0x1U;

  for (i = 0; i < 64 && i < CPU_SETSIZE; i++)
	if (CPU_ISSET(i, &am))
	  m |= 1ULL << i;

  return m;
#else

  /* XXX vZbT𒲂׏グĂ */
  return 0x01U;

#endif
}

static
NORETURN
thread_crypt64_new(void *a_param)
{
	struct THREAD_PARAM *param = a_param;
	CODE_T *code = param->code;
	CODE_T *cmp = code + param->code_cmp;
	struct KS_KEY key;
	struct PACKET_CRYPT64 *pkt = packet_create(16, 1024, key.key);
	uint64_t *ploop;
	THREAD_TH_T th = thread_get_tid();
	int	lc;

	WaitForSingleObject(mutex_key, INFINITE);

	OLDPRINT( "n_cpus %d\n", n_cpus );
	ploop = &loop_cpu[n_cpus++];
	lc = 0;

	OLDPRINT( "(unsigned)th %u\n", (unsigned)th );
	OLDPRINT( "param->seed %u\n", param->seed );
	/* th ̓XbhĂlɂȂĂ */
	srand(usec() ^ param->seed ^ (unsigned)th);
	key_init(&key);

	ReleaseMutex(mutex_key);

#ifdef thread_set_priority
	thread_set_priority(th, param->pri);
#endif

  if ( fixedSalt[0] != '\0' ) {
   int	ki;
 
   key.key[1] = fixedSalt[0];
   key.key[2] = fixedSalt[1];
   set_salt(code, crypt64_descs[0], key.key);
   key.key[7] = '\0';
   key.key[8] = '\0';
   for ( ;; ) {
    for ( ki = 0; ki < 4; ki++ ) {
     key.key[ki] = rand() % 0x7f + 1;
     key_set64(&pkt->key64, ki, key.key[ki], key.key[ki] ^ pkt->uk.key[ki], 0);
     pkt->uk.key[ki] = key.key[ki];
    }
    for ( key.key[4] = 0x01; key.key[4] <= 0x7f; key.key[4]++ ) {
     key_set64(&pkt->key64, 4, key.key[4], key.key[4] ^ pkt->uk.key[4], 0);
     pkt->uk.key[4] = key.key[4];
     for ( key.key[5] = 0x01; key.key[5] <= 0x7f; key.key[5]++ ) {
      key_set64(&pkt->key64, 5, key.key[5], key.key[5] ^ pkt->uk.key[5], 0);
      pkt->uk.key[5] = key.key[5];
      for ( key.key[6] = 0x01; key.key[6] <= 0x7f; key.key[6]++ ) {
       key_set64(&pkt->key64, 6, key.key[6], key.key[6] ^ pkt->uk.key[6], 0);
       pkt->uk.key[6] = key.key[6];
       CALL_CRYPT64(code, &pkt->key64, &pkt->param64);
       CALL_CMP64(cmp, pkt->param64.hit, pkt->param64.lr);
       check_hit(pkt, pkt->param64.hit);
       (*ploop)++;
#ifdef ENABLE_GEAR
			lc++;
			if ( lCntMax != 0 ) {
			 if ( lc > lCntMax ) {
			  OLDPRINT( "before %I64u\n", usec() );
			  Sleep( (DWORD)GEAR_SLEEP );
			  OLDPRINT( "after %I64u\n", usec() );
			  lc = 0;
			 }
			}
#endif /* ENABLE_GEAR */
      }
     }
    }
   }
  }

	for (;;)
	{
		do
		{
			int j;
			for (j = 0; j < 8; j++)
			{
				key_set64(&pkt->key64, j, key.key[j], key.key[j] ^ pkt->uk.key[j], 0);
				pkt->uk.key[j] = key.key[j];
			}
			CALL_CRYPT64(code,
						 &pkt->key64,
						 &pkt->param64);
			CALL_CMP64(cmp,
					   pkt->param64.hit,
					   pkt->param64.lr);
			check_hit(pkt, pkt->param64.hit);
			(*ploop)++;
#ifdef ENABLE_GEAR
			lc++;
			if ( lCntMax != 0 ) {
			 if ( lc > lCntMax ) {
			  OLDPRINT( "before %I64u\n", usec() );
			  Sleep( (DWORD)GEAR_SLEEP );
			  OLDPRINT( "after %I64u\n", usec() );
			  lc = 0;
			 }
			}
#endif /* ENABLE_GEAR */
		}
		while (key_inc(&key, 6, 8) || key_inc(&key, KEY_SHUFFLE_POS, 8));
		OLDPRINT( "saaaaalt chaaaaange\n" );

		WaitForSingleObject(mutex_key, INFINITE);
		key_reset(&key, 0);
		ReleaseMutex(mutex_key);
	}

	/* notreached */
}

char
*bname( char *path )
{
  char	*p;

  OLDPRINT( "path <%s>\n", path );

  for ( p = path; *p != '\0'; p++ )
   ;
  while ( *p != '/' && *p != '\\' && p != path ) {
   if ( *p == '.' ) {
    *p = '\0';
   }
   p--;
  }
  if ( p != path ) {
   p++;
  }

  OLDPRINT( "p <%s>\n", p );

  return( p );
}

void
usage( path )
char	*path;
{
  char	*myName;

  myName = bname( path );
  printf( "܂A҂ĉB (%s)\n", KIND );
  printf( "%s [-h] [-v] [-p num] [-t num|-m mask] [-g num] [-z]\n", myName );
  printf( " -h : \\n" );
  printf( " -v : 璷bZ[W\n" );
  printf( " -p num : Dx̐ݒ ( %d  num  %d, ftHg %d )\n",
          PRIO_MIN, PRIO_MAX, PRIO_DEF );
  printf( "    %d : ʏ\n", PRIO_NORM );
  printf( "    %d : ʏȉ\n", PRIO_BELO );
  printf( "    %d : \n", PRIO_IDLE );
  printf( "  -t  -m ͔r (Ƃw肵قL)\n" );
  printf( "  -m Ŏwł̂͗LȘ_ CPU ܂\n" );
  printf( " -t num : Xbh ( %d  num  %d, ftHg %d )\n",
          THREAD_MIN, availCPU, availCPU );
  printf( " -m mask : s CPU w肷}XN ( 1 rbg  mask ̃rbg  %d rbg )\n",
          THREAD_MAX );
  printf( " -g num : ΂肮 ( %d (CȂ)  num  %d (tp[), ftHǵA%d )\n", GEAR_MIN, GEAR_MAX, GEAR_DEF );
  printf( " -z : Sԃ[h\n" );
}

/***************************************************************
 *
 *	C[vƂ
 *
 */

int
main(int argc, char *argv[])
{
  int i;
  CODE_T *code = NULL;
  long code_cmp;
  FILE *sfp;	/* scoreboard */
  struct ITREE *root_expr;
  uint64_t proc_mask;
  int	nThread;
  struct THREAD_PARAM *threads = NULL;
  int nthreads;
  int tn;
  int	aveSpeed, spanSpeed, bestSpeed;
  int	gear;
  int	sCnt;
  int	tmplCntMax;
  int	maxSrchCnt;
  int	verbose;
  DWORD	priority;

  /*  */
  struct KS_KEY key;

#define UPDATE_INTERVAL 8	/* x\̊Ԋu b */
  struct status {
    uint64_t startTime;	/* Jn ~b */
    uint64_t lastTime;	/* Ōɕ\ ~b */
    uint64_t loop;		/*  */
    uint64_t lastloop;	/* Ōɕ\ loop */
  } status;
  uint64_t curTime;

#ifdef USECTEST
{
  int	i;
  for ( i = 0; i < USECTEST; i++ ) {
   printf( "%I64u\n", usec() );
  }
}
#endif /* USECTEST */

  if (!cpuid_issupported())
	{
	  fprintf(stderr, "̊ő点邱Ƃz肳Ă܂B\n");
	  exit(1);
	}

{
  int	optChar;
  extern char	*optarg;
  extern int	optind;
  char	*chPtr;
  uint64_t	availMask;
  uint64_t	pmask;

  availMask = thread_avail();	/* Lȃ}XN */
  availCPU = popcnt64( availMask );	/* L CPU  */

  priority = PRIO_DEF;
  nThread = 0;
  pmask = 0;
  verbose = 0;
  gear = GEAR_DEF;
  fixedSalt[0] = fixedSalt[1] = fixedSalt[2] = '\0';

  /* abcdef  ijkl no qrs u wxy  gp */
  /*       gh    m  p   t v   z gpς */
  while ( (optChar = getopt(argc, argv, "g:hm:p:t:vz")) != EOF ) {
   switch ( optChar ) {
    case 'g':
#ifdef ENABLE_GEAR
     gear = atoi( optarg );
     if ( gear < GEAR_MIN || gear > GEAR_MAX ) {
      usage( argv[0] );
      exit( 1 );
     }
#else /* ENABLE_GEAR */
	 printf( "-g IvV͖Ă܂\n" );
#endif /* ENABLE_GEAR */
     break;
    case 'h':
     usage( argv[0] );
     exit( 0 );
     break;
    case 'm':
     nThread = 0;	/* XbhƂ͔r */
     if ( strlen( optarg ) > THREAD_MAX ) {
      usage( argv[0] );
      exit( 1 );
     }
     for ( chPtr = optarg; *chPtr != '\0'; chPtr++ ) {
      pmask <<= 1;
      switch ( *chPtr ) {
       case '0': /* ȂɂȂ */ break;
       case '1': pmask |= 1; break;
       default:
        usage( argv[0] );
        exit( 1 );
        break;
      }
     }
     if ( pmask == 0 ) {
      usage( argv[0] );
      exit( 1 );
     }
     break;
    case 'p':
     priority = atoi( optarg );
     if ( priority < PRIO_MIN || priority > PRIO_MAX ) {
      usage( argv[0] );
      exit( 1 );
     }
     break;
    case 't':
     pmask = 0;	/* }XNƂ͔r */
     nThread = atoi( optarg );
     if ( nThread < THREAD_MIN || nThread > availCPU ) {
      usage( argv[0] );
      exit( 1 );
     }
     break;
    case 'v':
     verbose = 1;
     break;
    case 'z':
     srand( usec() );
     fixedSalt[0] = saltChar[rand() % NUMSC];
     fixedSalt[1] = saltChar[rand() % NUMSC];
     break;
    default:
     usage( argv[0] );
     exit( 1 );
   }
  }

#ifdef MAKEY
  fprintf(stderr, "L[ԃo[WɂAVEgɂ͂߂łȂB\n\n");
#endif /* MAKEY */

  if ( pmask == 0 && nThread == 0 ) {
   /* w肪Ȃ΁Ag CPU S */
   proc_mask = availMask;
  }

  if ( pmask != 0 ) {
   /* }XNŎw̏ꍇÂ܂ */
   if ( (availMask & pmask) != pmask ) {
    printf( " CPU ͂˂I\n" );
    exit( 1 );
   }
   proc_mask = pmask;
  }

  if ( nThread != 0 ) {
   /* Xbh̏ꍇA}XNɕϊ */
   proc_mask = 0;	/* Ô */
   for ( i = 0; i < THREAD_MAX; i++ ) {
    if ( availMask & 1ULL<<i ) {
     if ( nThread > 0 ) {
      proc_mask |= 1ULL<<i;
     }
     nThread--;
    }
   }
  }

  if ( gear != GEAR_MAX ) {
   /* CPU gp悤ɁAEĂ݂ */
   TIMECAPS	tc;
   if ( timeGetDevCaps( &tc, sizeof( TIMECAPS ) ) == MMSYSERR_NOERROR ) {
    timeBeginPeriod( tc.wPeriodMin );
   }
  }

  nThread = popcnt64( proc_mask );
  printf( "%d ̌XbhN\n", nThread );
}

  assert((1 << N_STRIDE) == N_ALU * ALU_BITS);

  mutex_key = CreateMutex(NULL, FALSE, NULL);

#ifdef SPECIAL
  initSpecial();
#endif /* SPECIAL */

  /* ^Qǂݍ */
  root_expr = expr_parse("target.txt");

  if ( verbose ) {
   int	i;
   printf( "Dx" );
   switch ( priority ) {
    case PRIO_NORM : printf( "ʏ" ); break;
    case PRIO_BELO : printf( "ʏȉ" ); break;
    case PRIO_IDLE : printf( "" ); break;
   }
   printf( "ɐݒ\n" );
   printf( "CPU : " );
   for ( i = 0; i < THREAD_MAX; i++ ) {
    if ( proc_mask & 1ULL<<i ) {
     printf( "%d ", i );
    }
   }
   printf( "gp\n" );
   if ( gear == GEAR_MAX ) {
    printf( "CPU  100%% gp\n" );
   } else {
    printf( "CPU  %d 炢gp\n", gear );
   }
   if ( fixedSalt[0] != '\0' ) {
    printf( "Sԃ[h (salt:%c%c)\n", fixedSalt[0], fixedSalt[1] );
   }
#ifdef KEYLOG
   if ( keyLog == MAKAI_TRUE ) {
    printf( "L[Ԃ̃MO\n" );
    initMutexKeylog();
   }
#endif /* KEYLOG */
#ifdef SPECIAL
   dispSpecial();
#else /* SPECIAL */
   printf( "ꌟ͖Ă܂\n" );
#endif /* SPECIAL */
  }

#ifdef WIN32
  /* yӁzpriority ㏑Ă */
  switch ( priority ) {
   case PRIO_NORM : priority = NORMAL_PRIORITY_CLASS;       break;
   case PRIO_BELO : priority = BELOW_NORMAL_PRIORITY_CLASS; break;
   case PRIO_IDLE : priority = IDLE_PRIORITY_CLASS;         break;
  }
  SetPriorityClass( GetCurrentProcess(), priority );
#endif

  /* R[h𐶐EWJ
	 N\Xbhɉ
	 R[hς */
  sfp = scoreboard_open();
  fwrite(crypt64_descs[0]->pro, 1, crypt64_descs[0]->cmp_pro - crypt64_descs[0]->pro, sfp);	/* prologue & RA[v */

#if 0
  if (0&&proc_mask == 1U)
	{
	  /* single */
	  code_cmp = 0;
	}
  else
#endif
	{
	  /* multi */
	  fwrite(crypt64_descs[0]->ep, 1, crypt64_descs[0]->ep_end - crypt64_descs[0]->ep, sfp);	/* epilogue */

	  /* r݂̂𐶐(O) */
	  code_cmp = ftell(sfp);
	  fseek(sfp, (-code_cmp) & 63, SEEK_CUR);
	  code_cmp = ftell(sfp);
	  fwrite(crypt64_descs[0]->pro, 1, crypt64_descs[0]->crypt - crypt64_descs[0]->pro, sfp);	/* prologue */
	}

  /* r𐶐 */
  fwrite(crypt64_descs[0]->cmp_pro, 1, crypt64_descs[0]->cmp_ep - crypt64_descs[0]->cmp_pro, sfp);	/* r폀 */
  tn = synth_synthesize(sfp, root_expr);
  fwrite(crypt64_descs[0]->cmp_ep, 1, crypt64_descs[0]->ep_end - crypt64_descs[0]->cmp_ep, sfp);	/* epilogue */

  /* R[hɓ\t */
  code = scoreboard_map(sfp);

  /* salt ݒ肷邽߂Ƀ_~[̃L[쐬 (ăbN̂ ?) */
  WaitForSingleObject(mutex_key, INFINITE);
  key.key[1] = 'z' + 1;
  key.key[2] = 'z' + 1;
  ReleaseMutex(mutex_key);
  set_salt(code, crypt64_descs[0], key.key);

  if (log_open("log.txt") != 0) return 1;

  WaitForSingleObject(mutex_key, INFINITE);

  /* ʎY */
  nthreads = 0;
  if (code_cmp)
	{
	  THREAD_TH_T h;
	  int ots = -1;
	  threads = calloc(2 * popcnt64(proc_mask), sizeof(*threads));
	  for (i = 0; i < 64; i++)
		if (proc_mask & (1ULL << i))
		  {
			if (0&&ots < 0)
			  {
				/* g̃XPW[O
				   [[ñAv͒߂ɐݒ肷̂g() */
#ifdef WIN32
				h = GetCurrentProcess();
				SetPriorityClass(h, BELOW_NORMAL_PRIORITY_CLASS);
#endif
#if defined(thread_set_priority)
				/* ŠԂ߂܂ */
				threads[nthreads].code = code;
				threads[nthreads].code_cmp = code_cmp;
				threads[nthreads].seed = rand();
				threads[nthreads].pri = THREAD_PRIORITY_IDLE;
				thread_create(h, thread_crypt64_new, &threads[nthreads]);
				nthreads++;
#endif
				if (!code_cmp)
				  break;

				/* g̎c̐ݒAƂł */
				ots = i;
			  }
			else
			  {
				/* Xbh́A߂̗DxŁB */
				threads[nthreads].code = code;
				threads[nthreads].code_cmp = code_cmp;
				threads[nthreads].seed = rand();
#ifdef thread_set_priority
				//threads[nthreads].pri = THREAD_PRIORITY_BELOW_NORMAL;
				threads[nthreads].pri = THREAD_PRIORITY_LOWEST;
#endif
				thread_create(h, thread_crypt64_new, &threads[nthreads]);
#ifdef thread_get_tid
				thread_set_affinity(h, i);
#endif
				nthreads++;
#if 0
				/* IDLE */
				threads[nthreads].code = code;
				threads[nthreads].code_cmp = code_cmp;
				threads[nthreads].seed = rand();
#ifdef thread_set_priority
				threads[nthreads].pri = THREAD_PRIORITY_IDLE;
#endif
				thread_create(h, thread_crypt64_new, &threads[nthreads]);
#ifdef thread_get_tid
				SetThreadAffinityMask(h, proc_mask);
#endif
				nthreads++;
#endif
			  }
		  }
#ifdef thread_get_tid
	  if (ots)
		thread_set_affinity(thread_get_tid(), ots);
#endif
	}

  fprintf(stderr, "Jn!\n");
  ReleaseMutex(mutex_key);

  memset( &status, 0, sizeof( struct status ) );
  status.startTime = status.lastTime = usec();

  bestSpeed = 0;
  sCnt = 0;
  lCntMax = 0;
  maxSrchCnt = 0;
  for ( ;; ) {
	  uint64_t diffTime;
	  uint64_t spanLoop;

	  Sleep(STS_SPAN);

	  #ifdef OLDEBUG
	  putchar( '\n' );
	  #endif /* DEBUG */
	  status.loop = 0;
	  for (i = 0; i < n_cpus; i++) {
	   OLDPRINT( "loop_cpu[%d] %d\n", i, loop_cpu[i] );
	   status.loop += loop_cpu[i];
	  }
	  status.loop *= N_ALU * ALU_BITS;

	  spanLoop = status.loop - status.lastloop;
	  if ( spanLoop > maxSrchCnt ) {
	   maxSrchCnt = spanLoop;
	  }

	  curTime = usec();

	  /* ʎZ (P trips/usec = ktrips/sec) */
	  diffTime = curTime - status.startTime;
	  aveSpeed = status.loop / diffTime;

	  /*  (P trips/usec = ktrips/sec) */
	  diffTime = curTime - status.lastTime;
	  spanSpeed = spanLoop / diffTime;

	  /* ő */
	  if ( spanSpeed > bestSpeed ) {
	   bestSpeed = spanSpeed;
	   if ( gear != GEAR_MAX ) {
	    tmplCntMax = ((maxSrchCnt / (N_ALU * ALU_BITS)) * gear / 10) / ((STS_SPAN - (STS_SPAN * gear / 10)) / GEAR_SLEEP) / nThread;
	   }
	  }

	  if ( gear != GEAR_MAX ) {
	   if ( sCnt == YOUSUMI && lCntMax == 0 ) {
	    if ( tmplCntMax < 1 ) {
	     lCntMax = 1;
	    } else {
	     lCntMax = tmplCntMax;
	    }
	    OLDPRINT( "lCntMax = %d\n", lCntMax );
	    printf( "\nCPU gp[hJn\n" );
	   }
	  }
	  sCnt++;

	  status.lastTime = curTime;
	  status.lastloop = status.loop;

	  fprintf(stderr,
			  "ʎZ %dktrips/s [ %dktrips/s] {ő %dktrips/s}\r",
			  aveSpeed, spanSpeed, bestSpeed );
	}

  return 0;
}

/*
 *	Local Variables:
 *		tab-width:	4
 *	End:
 *
 * EOF */
