/***********************************************************************
 *
 *	file: simplify.c
 *
 *	_̊ȒP(Quine-Mucluskey @)
 *
 *	$Id: simplify.c 185 2007-12-25 06:56:46Z chapuni $
 *
 */

#include <assert.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "debug.h"
#include "simplify.h"
#include "util.h"

/***************************************************************
 *
 *	K{區O֗悤Ƀ\[g
 *
 */

static
int
cmp_minterm_cov(void const *va, void const *vb)
{
  uint64_t a = *(uint64_t const *)va;
  uint64_t b = *(uint64_t const *)vb;
  return popcnt64(a) - popcnt64(b);
}

/***************************************************************
 *
 *	핢\ŏ핢o
 *
 *	cov[]  1 [haƂ݂Ȃ
 *	eX 1 rbgÂEƂTOB
 *
 *	łɏEꂽrbg(cand)܂ލ̓XLbv\B
 *
 */

static 
uint64_t
extract_mincov(uint64_t const *cov,	/* 핢\ */
			   int covn,			/* 핢\vf */
			   uint64_t cand,		/* 肵Ă핢 */
			   int min)				/* ŏL^ */
{
  int candn;
  int candni;
  uint64_t c;
  uint64_t b;
  uint64_t r = ~0ULL;

  /* cand ̍́Arbĝ */
  candn = popcnt64(cand);

  /* cand Ɋ܂܂ĂAȂ킿łɌ₪鍀
	 ς݂Ƃ݂Ȃ̂ŃXLbv */
  do
	{
	  /* \̃Pc܂łȂ߂画 */
	  if (covn == 0)
		  return (min > candn
				  ? cand
				  : r);
	}
  while (--covn, ((c = *cov++) & cand));

  /* ȍ~́A₩獀ЂƂA
	 Ȃ킿rbgЂƂ̂ */
  candni = candn + 1;

  for (b = 1ULL; b; b <<= 1)
	{
	  int n;
	  uint64_t m;

	  if (!(c & b))
		continue;

	  /* ŏL^XVłȂƔfꍇ */
	  if (min <= candni)
		return r;

	  /* ̏͏ȂĂ\ȂA
		 ċA[xƂa炰AɂȂ */
	  if (covn == 0)
		return cand | b;

	  /* ivZĂ݂B
		 min XVłȂꍇ ~0ULL Ԃ */
	  m = extract_mincov(cov, covn, cand | b, min);
	  n = popcnt64(m);
	  if (min > n)
		{
		  /* L^XV */
		  min = n;
		  r = m;
		}
	}

  /* L^XVłȂ ~0ULL Ԃ邱ƂɂȂ */
  return r;
}

/***************************************************************
 *
 *	Quine-McCluskey @ɂ bmp ȒP
 *
 *	TZԂ
 *	߂Ƃ INT_MAX ԂAS區𐶐
 *
 *	aox ɐϘa`ɂ錋ʂԂ(m==0 terminated)
 *
 */

#define QMX_N_ELIM	0x80	/* QMX::n ɂ폜 */

int
simplify_qm(struct QMX *aox,
			uint64_t bmp,	/* ^l\ */
			uint64_t dc)	/* 1 ̃rbg D/C */
{
  int i, j;
  uint64_t m;
  int n_dcs;					/* D/C ̌ */

  /* ߂l: TZo͍ */
  int n_estimated_terms;

  /* ŏ */
  int n_minterms;
  struct QMX minterms[QMX_LEN];
  uint64_t minterm_cov[QMX_LEN];	/* 핢 */
  uint64_t covered_minterms;		/* K{區핢ŏ */

  /* 區 */
  int n_pterms;
  struct QMX atmx[256 * QMX_LEN];	/* 64k 𒴂Ȃ炢ڈ? */
  int max_pterms = sizeof(atmx) / sizeof(struct QMX);
  struct QMX *pterms = atmx;

  /* K{區т̔핢 */
  uint64_t essential_pterms;	/* K{區 */
  int n_essential_pterms;		/* K{區 */

  /* 區Zop, D/C 񋓂 */
  n_dcs = 0;
  for (i = 0; i < QMX_LEN; i++)
	if (dc & (1ULL << i))
	  {
		pterms[n_dcs  ].m = QMX_N_MASK;
		pterms[n_dcs++].n = i;
	  }

  /* ŏ(1 ̍)񋓂 */
  bmp &= ~dc;
  n_minterms = 0;
  for (i = 0; i < QMX_LEN; i++)
	if (bmp & (1ULL << i))
	  {
		minterms[n_minterms  ].m = QMX_N_MASK;
		minterms[n_minterms++].n = i & QMX_N_MASK;
	  }

  debug_printf(2, F016LLX"/"F016LLX" n_minterms=%d n_dcs=%d\n",
			   A016LLX(bmp),
			   A016LLX(dc),
			   n_minterms, n_dcs);

#define C(i,s) (pterms[i].m & (1 << (s)) ? (pterms[i].n & (1 << (s)) ? '1' : '0') : '-')

  /* ̈Ŏ區߂ */
  memcpy(&pterms[n_dcs], minterms, n_minterms * sizeof(struct QMX));
  n_pterms = n_minterms + n_dcs;
  do
	{
	  int pterm_idx = n_pterms;

	  /* ߂̂區ƂĔo */
	  for (i = 0; i < n_pterms; i++)
		for (j = i + 1; j < n_pterms; j++)
		  {
			int k;
			unsigned x;
			if (pterms[i].m != pterms[j].m)
			  continue;
			x = (pterms[i].n ^ pterms[j].n) & pterms[i].m;
			assert(x != 0);	/* OXe[Wɂďς݂̃nY */
			if (!IS_POWER2(x))
			  continue;
			/* n~O1Ȃ̂ō܂Ƃ߂
			   قȂrbg}XN𐶐 */
			x = QMX_N_MASK & ~x;
			/* ꍀ͍ĐȂ悤(ߖ) */
			for (k = n_pterms; k < pterm_idx; k++)
			  if (pterms[k].m == (pterms[i].m & x)
				  && pterms[k].n == (pterms[i].n & x))
				goto tmx_dup;
			/* Pcɓo^ */
			pterms[pterm_idx  ].m = pterms[i].m & x;
			pterms[pterm_idx++].n = pterms[i].n & x;
			assert (pterm_idx <= max_pterms);
			if (pterm_idx == max_pterms)
			  {
				/* pterms ̊g
				   [J̈͂ݏoq[v擾 */
				assert(max_pterms  < INT_MAX / sizeof(struct QMX) / 2);
				max_pterms *= 2;
				if (pterms == atmx)
				  {
					pterms = malloc(max_pterms * sizeof(struct QMX));
					memcpy(pterms, atmx, sizeof(atmx));
					debug_printf(1, "allocated: %d->%d\n", pterm_idx, max_pterms);
				  }
				else
				  {
					pterms = realloc(pterms, max_pterms * sizeof(struct QMX));
					debug_printf(1, "extended: %d->%d\n", pterm_idx, max_pterms);
				  }
			  }
		  tmx_dup:
			/* ܂Ƃ߂ꂽɍ폜(Ƃ肠MSB) */
			pterms[i].n |= QMX_N_ELIM;
			pterms[j].n |= QMX_N_ELIM;
		  }

	  /* oꂽ̂dĂ */
	  for (i = 0; i < pterm_idx; i++)
		for (j = i + 1; j < pterm_idx; j++)
		  if (pterms[i].m == pterms[j].m
			  && ((pterms[i].n ^ pterms[j].n) & QMX_N_MASK) == 0)
			{
			  pterms[i].n |= QMX_N_ELIM;
			  break;	/* next i */
			}

	  /* 폜ꂽ̂̂Ă
		 珇sŋl߂Ă */
	  for (i = j = 0; i < pterm_idx; i++)
		if (!(pterms[i].n & QMX_N_ELIM))
		  {
			if (i != j)
			  pterms[j] = pterms[i];
			j++;
		  }

	  debug_printf(2, "n_pterms=%d pterm_idx=%d j=%d\n", n_pterms, pterm_idx, j);
	  n_pterms = j;
	}
  while (i != j);

  /* eŏɂāA區ɂ핢\𐶐
	 K{區oAK{區핢L^ */
  memset(minterm_cov, 0, n_minterms * sizeof(*minterm_cov));
  assert(n_minterms <= 64);
  assert(n_pterms <= 64);
  essential_pterms = 0;
  covered_minterms = 0;
  for (i = 0; i < n_minterms; i++)
	{
	  int ep = -1;	/* K{區̏ꏊ */
	  for (j = 0; j < n_pterms; j++)
		if ((minterms[i].m & pterms[j].m) == pterms[j].m
			&& (minterms[i].n & pterms[j].m) == (pterms[j].n & pterms[j].m))
		  minterm_cov[i] |= 1ULL << (ep = j);

	  if (ep >= 0
		  && IS_POWER2(minterm_cov[i]))
		{
		  /* K{區핢̂}[LO */
		  for (j = 0; j < n_minterms; j++)
			if ((minterms[j].m & pterms[ep].m) == pterms[ep].m
				&& (minterms[j].n & pterms[ep].m) == (pterms[ep].n & pterms[ep].m))
			  {
				essential_pterms |= 1ULL << ep;
				covered_minterms |= 1ULL << j;
			  }
		}
	}

  /* 區-ŏ}gNX̃_v; for debug */
#if DEBUG>=1
  printf("             ");
  for (j = 0; j < n_minterms; j++)
	if (IS_POWER2(minterm_cov[j]))
	  printf("*");
	else if (covered_minterms & (1ULL << j))
	  printf("+");
	else
	  printf("#");
  printf("\n");

  for (i = 0; i < n_pterms; i++)
	{
	  printf("%3d: %c%c%c%c%c%c: ",
			 i,
			 C(i,5), C(i,4), C(i,3), C(i,2), C(i,1), C(i,0));
	  for (j = 0; j < n_minterms; j++)
		if (minterm_cov[j] & (1ULL << i))
		  {
			if (IS_POWER2(minterm_cov[j]))
			  {
				assert(covered_minterms & (1ULL << j));
				printf("*");
			  }
			else if (covered_minterms & (1ULL << j))
			  printf("+");
			else
			  printf("#");
		  }
		else
		  {
			printf("-");
		  }
	  printf("\n");
	}
#endif

  /* 區64𒴂Ă܂ꍇA߂(}WJ) */
  if (n_pterms > 64)
	return INT_MAX;

  /* 핢\̏d菜 */
  n_estimated_terms = 1;
  for (i = 0; i < n_minterms; i++)
	{
	  for (j = i + 1; j < n_minterms; j++)
		if (minterm_cov[i] == minterm_cov[j])
		  {
			minterm_cov[j] = minterm_cov[--n_minterms];
			j--; continue;	/* redo */
		  }
	  if (minterm_cov[i])
		n_estimated_terms *= popcnt64(minterm_cov[i]);
	}

  debug_printf(2,
			   "n_minterms=%d n_pterms=%d n_estimated_terms=%d\n",
			   n_minterms, n_pterms, n_estimated_terms);

#if DEBUG>=2
  for (i = 0; i < n_minterms; i++)
	if (minterm_cov[i])
	  printf("%2d: "F016LLX"\n", i, A016LLX(minterm_cov[i]));
#endif

  /* rbg̏̂(==K{區O)
	 \[g邱ƂɂAvZƊyɂȂ(nY) */
  qsort(minterm_cov, n_minterms, sizeof(*minterm_cov), cmp_minterm_cov);

  /* ŏ핢̒o
	 (ŏȂ̂?)
	 ςȂS區IԂƂȂ */
  m = extract_mincov(minterm_cov,
					 n_minterms,
					 0ULL,
					 64);
#if DEBUG>=1
  debug_printf(1,
			   "ess:"F016LLX" cov:"F016LLX" all:"F016LLX"\n",
			   A016LLX(essential_pterms),
			   A016LLX(m & ~essential_pterms),
			   A016LLX(m));
assert((m & essential_pterms) == essential_pterms);
#endif
  essential_pterms = m;

  /* ʂWJ */
  n_estimated_terms = n_essential_pterms = popcnt64(essential_pterms);
  essential_pterms &= ((1ULL << n_pterms) - 1);
  j = 0;
  for (i = 0; i < n_pterms; i++)
	if (essential_pterms & (1ULL << i))
	  {
		n_estimated_terms += popcnt32(pterms[i].m);
		if (aox)
		  aox[j++] = pterms[i];

		debug_printf(2, "%c%c%c%c%c%c:%3d\n",
					 C(i,5), C(i,4), C(i,3), C(i,2), C(i,1), C(i,0),
					 n_estimated_terms);

		assert(j <= QMX_LEN);
	  }

  /* ԂԐl */
  if (aox && j < QMX_LEN)
	aox[j].m = 0;

  debug_printf(1, "nterm=%d j=%d\n", n_estimated_terms, j);

#if DEBUG>=1
  if (aox)
	{
	  /* ꂽ̌Z */
	  static const uint64_t a6[] =
		{
		  0xAAAAAAAAAAAAAAAAULL,
		  0xCCCCCCCCCCCCCCCCULL,
		  0xF0F0F0F0F0F0F0F0ULL,
		  0xFF00FF00FF00FF00ULL,
		  0xFFFF0000FFFF0000ULL,
		  0xFFFFFFFF00000000ULL,
		};
	  uint64_t o = 0;
	  for (i = 0; aox[i].m; i++)
		{
		  uint64_t a = 0xFFFFFFFFFFFFFFFFULL;
		  for (j = 0; j < 6; j++)
			if (aox[i].m & (1 << j))
			  a &= (aox[i].n & (1 << j)
					? a6[j]
					: ~a6[j]);
		  o |= a;
		}
	  debug_eprintf(1, "bmp="F016LLX", o="F016LLX", dc="F016LLX"\n",
					A016LLX(bmp),
					A016LLX(o),
					A016LLX(dc));
	  assert(((bmp ^ o) & ~dc) == 0);
	}
#endif

  /* pterms gĂꍇ̂Ƃ܂ */
  if (pterms != atmx)
	free(pterms);

  /* SWJĂ܂ꍇ */
  return (n_essential_pterms > n_pterms ? INT_MAX : n_estimated_terms);
}

/*
 *	Local Variables:
 *		tab-width:	4
 *	End:
 *
 * EOF */
