/*
  =============================================================================
  
   Class : 待機ステータスによるマルチタスクとスレッド切り替えのサンプル
   
  =============================================================================
*/
#include "nos.h"
#include <stdio.h>
#include <time.h>

/*
  -----------------------------------------------------------------------------
  
   Define : スレッド
   
  -----------------------------------------------------------------------------
*/

static boolean task1Thread1(void);
static boolean task1Thread2(void);
    
/*
  -----------------------------------------------------------------------------
  
  Method : タスク１／スレッド１
		  
  Param	 : void
  
  Return : true
 
  -----------------------------------------------------------------------------
*/
#define TIME_WAIT_SEC 1

static boolean task1Thread1(void)
{
    printf("TASK1\n");

    sleepTask(TIME_WAIT_SEC);   /* 一時停止停止 */
    nextThread(&task1Thread2);

    return false;
}

/*
  -----------------------------------------------------------------------------
  
  Method : タスク１／スレッド２
		  
  Param	 : void
  
  Return : ture
 
  -----------------------------------------------------------------------------
*/
static boolean task1Thread2(void)
{
    struct Nos_Msg *m;

    m = recvMsg(MSG_BOX_NOS);
    if (NOS_WAIT != m) {
        /* メッセージ受信 ? */

        printf("TASK1: send message\n");
        sendMsg(MSG_BOX_TASK2, m);
        nextThread(&task1Thread1);
        return true;
    }
    return false;
}

/*
  -----------------------------------------------------------------------------
  
  Method : タスク２／スレッド１
		  
  Param	 : void
  
  Return : true
 
  -----------------------------------------------------------------------------
*/
static boolean task2Thread1(void)
{
    struct Nos_Msg *m;

    m = recvMsg(MSG_BOX_TASK2); /* メッセージの受信 */
    if (m != NOS_WAIT) {
        /* 待機要求ではない ? */

        printf("TASK2: recv message\n");
        sendMsg(m->own, m);     /* オーナーに送り返す */
        return true;
    } else {
        /* 待機要求 */

        printf("TASK2: wait message\n");
        return false;
    }
}


/*
  -----------------------------------------------------------------------------
  
  Method : MAIN
		  
  Param	 :
  
  Return :
 
  -----------------------------------------------------------------------------
*/
int main(int pl, char *ps[])
{
    time_t t;                   /* Time */
  	initNos();                  /* init system */

	runTask(&task1Thread1, 15); /* Low Pri task */
	runTask(&task2Thread1, 10);   /* Hi Pri task */

    for (time(&t); true; runSched()) {

        time_t n;               /* Timer, Now */

        if (t != time(&n)) {

            t = n;
            nos_timer++;        /* タイマー割り込みの代わり */
        }
        nos_tick--;             /*            ”            */
    }
}

