﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Linq;
using myBuiltInMethod;

namespace geckoFXbrowser
{
    public partial class Form_main : Form
    {
        Dictionary<string , ToolStripMenuItem> menuitemList;



        private void loadSettings(string EXEPath)
        {
            menuitemList = new Dictionary<string, ToolStripMenuItem>();

            fileman = new FileMan(EXEPath);

            LoadFavorites();


            ////個別コマンドをリストに加える必要あり！！
            //menuitemList.Add(@"コマンド\情報をストックする", this.情報をストックするToolStripMenuItem);

            var menus = new Dictionary<string, ToolStripMenuItem>();
            //menus = getMenuItems(this.コマンドToolStripMenuItem);

            foreach (var item in menus)
            {
                ToolStripMenuItem menu = (ToolStripMenuItem)item.Value;
                menuitemList.Add(@"コマンド\" + menu.Text, menu);
            }


        }



        private void saveSettings()
        {
            ////３つめの引数は、スキップ指定。
            ////固定メニューとしてデザイナで作成済であれば、指定する
            saveMenuInfo(this.MenuItem_favorites,  fileman.FilePath_Favorites , new string[] { "編集" , "このページを追加" });
        }







        /// <summary>
        /// お気に入りを登録する。
        /// CSVファイルには、表示名,URLという形式で保存されている。
        /// 表示名に、￥が含まれているときはサブメニューとなる。
        /// CSVファイルは、表示名でソートされて保存されているものとする
        /// （サブメニューを持つフォルダが先に出現する）
        /// </summary>
        private void LoadFavorites()
        {
            MakeMenu(fileman.FilePath_Favorites , MenuItem_favorites, MenuItem_navi_Click);
        }



        private void saveMenuInfo(ToolStripMenuItem menuitem , string Filename, string[] skipword)
        {
            string temp = "";
            var menus = getMenuItems(menuitem);

            foreach(var item in menus)
            {
                ToolStripMenuItem menu = (ToolStripMenuItem)item.Value;
                string path = item.Key;

                //スキップ指定されていたら、処理しない
                if(skipword.Any(x => x == path))  continue;

                if(menu.Tag == null) menu.Tag = "";
                temp += path + delim + menu.Tag.ToString() + Environment.NewLine;
            }
            using(StreamWriter sw = new StreamWriter(Filename, false, Encoding.Default))
            {
                sw.Write(temp);
                sw.Dispose();
            }
        }


        private Dictionary<string, ToolStripMenuItem> getMenuItems(ToolStripMenuItem top)
        {
            var menus = new Dictionary<string, ToolStripMenuItem>() ;
            getChildMenuItem(top,"",menus);
            return menus;
        }


        private Dictionary<string, ToolStripMenuItem> getChildMenuItem(ToolStripMenuItem parentMenu, string itemPath, Dictionary<string, ToolStripMenuItem> menus)
        {
            string pre = "";

            if (itemPath != "")
            {
                menus.Add(itemPath, parentMenu);
                pre = itemPath + @"\";
            }

            foreach (ToolStripItem child in parentMenu.DropDownItems)
            {
                //メニューじゃないもの（セパレータとか）があったら、はじく
                if (child is ToolStripMenuItem)
                {
                    getChildMenuItem((ToolStripMenuItem)child, pre + ((ToolStripMenuItem)child).Text,menus);
                }
            }
            return menus;
        }



        private void MakeMenu(string FileName, ToolStripMenuItem rootmenu, EventHandler eventhandler)
        {
            Dictionary<string, ToolStripMenuItem> list = new Dictionary<string,ToolStripMenuItem>();

            //まず、階層は考慮せずに、ToolStripMenuItemを作成
            using (var sr = new StreamReader(FileName, Encoding.Default))
            {
                string s;
                while ((s = sr.ReadLine()) != null)
                {
                    string[] parameters = s.Split(delim);
                    ToolStripMenuItem item = null;

                    //長さ2でないときは抜ける
                    if (parameters.Length < 2) continue;

                    //parameters[0] → 表示名　parameters[1]～　→ タグにセットする値
                    string[] strs = parameters[0].Split('\\');
                    item = new ToolStripMenuItem(strs[strs.Length - 1]);

                    //
                    if (parameters[1] != "")
                    {
                        //表示名の後ろ（[1]～[last]）を連結して、tagにセットする
                        item.Tag =   string.Join(delim.ToString(), parameters, 1, parameters.Length - 1);
                        item.Click += eventhandler;
                    }
                    //System.Diagnostics.Debug.WriteLine(parameters[0]);

                    //リストに追加しておく
                    list.Add(parameters[0], item);
                }
            }//using

            //階層を構築する
            //￥を含んでいたら親階層があるということなので、親階層のDropDownItemsに自分を追加する。
            foreach (var item in list)
            {
                ToolStripMenuItem temp = item.Value;

                if (item.Key.Contains(@"\"))
                {
                    string s = item.Key.Substring(0, item.Key.LastIndexOf(@"\"));
                    list[s].DropDownItems.Add(temp);
                }
                else
                {
                    rootmenu.DropDownItems.Add(temp);
                }
            }//foreach

            //後で参照するため、リストに追加しておく。
            foreach (var item in list)
            {
                if (menuitemList.ContainsKey(rootmenu.Text + @"\" + item.Key))
                {
                    continue;
                }
                menuitemList.Add(rootmenu.Text + @"\" + item.Key, item.Value);
            }

        }//private void MakeMenu


    }//class
}