﻿
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using Gecko;
using System.Text.RegularExpressions;
using WeifenLuo.WinFormsUI.Docking;

namespace geckoFXbrowser
{

    /// <summary>
    /// testでつかうクラス。
    /// マウスポインタの下にある要素を保持する前提
    /// </summary>
    public class mouseOverelement
    {
        public string style { get; set; }
        public GeckoElement element { get; set; }
        public mouseOverelement(GeckoElement ele, string style)
        {
            this.element = ele;
            this.style = style;
        }
    }

    public partial class browserDoc : DockContent
    {

        private Stack<mouseOverelement> mouseOverelementsStack = new Stack<mouseOverelement>();


        private void geckoWebBrowser1_DomClick(object sender, GeckoDomEventArgs e)
        {
            string s = weblib.getXpathFromElement(e.Target) + Environment.NewLine + Environment.NewLine;
            s += weblib.GetOuterHtml(e.Target);
            System.Diagnostics.Debug.WriteLine(s);
        }


        private void geckoWebBrowser1_DomMouseOver(object sender, GeckoDomMouseEventArgs e)
        {
            if(this.geckoWebBrowser1.Document == null)
                return;

            string s = "id      :" + e.Target.Id + Environment.NewLine +
                       "Tagname :" + e.Target.TagName + Environment.NewLine;

            if(b_swicthHighlightByMouse == false)
                return;


            mouseOverelementsStack.Push(new mouseOverelement(e.Target, e.Target.GetAttribute("style")));
            e.Target.SetAttribute("style", "background-color: green;opacity: 0.5;");


        }

        private void geckoWebBrowser1_DomMouseOut(object sender, GeckoDomMouseEventArgs e)
        {
            if(this.geckoWebBrowser1.Document == null)
                return;

            if(b_swicthHighlightByMouse == false)
                return;

            if(mouseOverelementsStack != null && mouseOverelementsStack.Count != 0)
            {
                mouseOverelement org = mouseOverelementsStack.Pop();
                e.Target.SetAttribute("style", org.style);

                if(mouseOverelementsStack.Count != 0)
                {
                    org = mouseOverelementsStack.Peek();
                    org.element.SetAttribute("style", "background-color: green;opacity: 0.5");//border: 1px red solid;
                }
            }

        }


    }//class
}//namespace

