﻿#region License
/* **********************************************************************************
 * Copyright (c) Roman Ivantsov
 * This source code is subject to terms and conditions of the MIT License
 * for Irony. A copy of the license can be found in the License.txt file
 * at the root of this distribution. 
 * By using this source code in any fashion, you are agreeing to be bound by the terms of the 
 * MIT License.
 * You must not remove this notice from this software.
 * **********************************************************************************/
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Irony.Ast;
using Irony.Parsing;

namespace Irony.Interpreter.Ast
{

    public class SuspendNode : AstNode
    {

        public override void Init(AstContext context , ParseTreeNode treeNode)
        {
            base.Init(context , treeNode);

            AsString = "Suspend";
        }

        protected override object DoEvaluate(ScriptThread thread)
        {
            thread.CurrentNode = this;  //standard prolog
            //ブロック
            thread.App.manualEvent_script.Reset();
            thread.App.manualEvent_script.WaitOne();


            thread.CurrentNode = Parent; //standard epilog
            return thread;
        }//method

    }//class

}//namespace
