﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace EditFavorite
{
    public partial class EditableWindow
    {
        private ToolStripMenuItem RootMenu;// { get; set; }
        public EventHandler Handler { get; set; }

        private string separatorConst;
        private char delim ;
        private string[] skipwords;
        private string title;

        public EditableWindow(ToolStripMenuItem rootmenu , EventHandler Handler)
        {
            this.RootMenu = rootmenu;
            if (Handler == null)
            {
                this.Handler = GeneralEventHandler;

            }
            else
            {
                this.Handler = Handler;
            }
        }


        /// <summary>
        /// メニューアイテム編集ウィンドウを表示する
        /// </summary>
        /// <param name="title">タイトル</param>
        /// <param name="skipwords">編集対象外（非表示）とするメニュー</param>
        /// <param name="delim">返却時の区切り文字。メニュー名と説明（tagにセット）の区切り</param>
        public void showWindow(string title = null , string[] skipwords  = null , char delim = '\t' , string separatorConst = "------")
        {
            if (title == null)
                title = RootMenu.Text;

            this.title = title;
            this.skipwords = skipwords;
            this.delim = delim;
            this.separatorConst = separatorConst;

            var win = new Form_EditFavorites(RootMenu , title , skipwords , delim , separatorConst );
            DialogResult ret = win.ShowDialog();
            win.Close();
            //保存するボタンを押した場合は、RootMenuのタグにデータがセットされている
            //s += item.FullPath
            //        + delim + item.Tag.ToString()
            //        + Environment.NewLine;
            BuildMenu();
        }


        //
        private void GeneralEventHandler(object o , EventArgs e)
        {
            var menu = o as ToolStripMenuItem;

            if (menu != null)
            {
                if (menu.Tag != null)
                    MessageBox.Show(menu.Tag.ToString());
            }
        }



    }

}