

package java.lang;

import java.lang.reflect.*;
import java.util.jar.*;

/**
 * w肳ꂽNX main() \bhsXbh ipbP[WvCx[gNXj
 */
final class VMMainThread
    extends Thread
{

  /**
   * class name or jar file name.
   */
  String className;

  /**
   * arguments.
   */
  String[] args;

  /**
   * -jar option
   */
  boolean jarOption;

  int nonDaemonThreadsCount;

  public VMMainThread(String classname, String[] args)
  {
    this(classname, args, false);
  }

  public VMMainThread(String classname, String[] args, boolean jar)
  {
    super(null, // VMThread
          "main", // thread name
          Thread.NORM_PRIORITY, // priority
          false); // non-daemon thread.

    // main thread's ThreadGroup
    this.group = new ThreadGroup(ThreadGroup.root, // parent is system thread
                                                   // group
                                 "main"); // thread group name

    this.className = classname;
    this.args = (String[]) args.clone();
    this.jarOption = jar;
  }

  /**
   * get non-daemon thread count.
   */
  public synchronized int getNonDaemonThreadsCount()
  {
    return this.nonDaemonThreadsCount;
  }

  /**
   * f[XbȟωۂɁAJVMĂяoB
   */
  public synchronized void notifyNonDaemonThreadsCountChanged(int count)
  {
    this.nonDaemonThreadsCount = count;
    notifyAll();
  }

  /**
   * R\[\
   */
  static native void showConsole();

  public void run()
  {
    // t@CiCUXbhX^[g
    VMFinalizeThread fthread = VMFinalizeThread.getInstance();
    fthread.start();

    // VXbh쐬āAmain()s
    Thread t = new Thread()
    {
      public void run()
      {
        try
          {
            // classpath[h(Version0.3.6)
            VMRuntime.nativeLoad("classpath", null);
            String cname = null;
            Method mainMethod = null;
            // VXeNX[_gpăNX[h
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            if (jarOption)
              {
                // jarIvVw肳ĂꍇAclassname̓e
                // Main-ClassAgr[g擾
                JarFile jarFile = new JarFile(className);
                Manifest mf = jarFile.getManifest();
                if (mf == null)
                  {
                    throw new Exception("No manifest in " + jarFile.getName());
                  }
                Attributes attr = mf.getMainAttributes();
                cname = attr.getValue(Attributes.Name.MAIN_CLASS);
                if (cname == null)
                  {
                    throw new Exception("No Main-Class attribute in "
                                        + jarFile.getName());
                  }

                // ToDo: Class-pathAgr[gꍇ́ANX[_ɒǉ

              }
            else
              {
                cname = className;
              }
            Class found = cl.loadClass(cname);
            mainMethod = found.getMethod("main",
                                         new Class[] { args.getClass() });

            // C\bhN
            mainMethod.invoke(null, new Object[] { args });

          }
        catch (Throwable t)
          {
            Throwable cause = null;
            if (t instanceof InvocationTargetException)
              {
                cause = t.getCause();
              }
            if (cause == null)
              {
                cause = t;
              }
            cause.printStackTrace();
            
            // R\[I[v
            showConsole();
          }
      }
    };
    t.start();

    /*
     * // Todo:f[XbhɂȂ̂҂ // ɓ synchronized (this) { while
     * (getNonDaemonThreadsCount() > 0) { wait(); } } // Vbg_EtbNs
     * Runtime.getRuntime().runShutdownHooks(); // f[XbhɂȂ܂ő҂
     * synchronized (this) { while (getNonDaemonThreadsCount() > 0) { wait(); }
     * }
     */
  }
}
