/* WCESynthesizer.java -- MIDI synthesizer for Windows Mobile.
   Copyright (C) 2009 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.javax.sound.midi.wce;

import java.io.File;
import java.io.InputStream;
import java.io.IOException;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiDevice.Info;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;

public class WCESynthesizer implements Synthesizer
{
  private static final WCESynthesizer INSTANCE = new WCESynthesizer();

  private boolean explicitOpen;
  private boolean opened;

  /**
   * MIDI output port
   */
  private WCEMidiOutputPort outputPort = WCEMidiOutputPort.getInstance();

  /**
   * Receiver class.
   */
  class SynthesizerReceiver implements Receiver
  {
    public void send(MidiMessage message, long timeStamp)
    {
      throw new UnsupportedOperationException("Not implemented");
    }

    public void close()
    {
      if (! explicitOpen)
      {
        WCESynthesizer.this.close();
      }
    }

    public WCEMidiOutputPort getOutputPort()
    {
      return outputPort;
    }
  }

  protected WCESynthesizer()
  {
    // open MIDI output port.
    this.outputPort.open();
  }

  /**
   * returns an instance.
   */
  public static WCESynthesizer getInstance()
  {
    return INSTANCE;
  }

  public MidiDevice.Info getDeviceInfo()
  {
    return WCEMidiDeviceProvider.SYNTHESIZER_INFO;
  }

  public synchronized void open()
          throws MidiUnavailableException
  {
    if (! isOpen())
    {
      this.explicitOpen = true;
      this.opened = true;
    }
  }

  public synchronized void close()
  {
    if (isOpen())
    {
      this.opened = false;
      this.explicitOpen = false;
    }
  }

  public boolean isOpen()
  {
    return this.opened;
  }

  public long getMicrosecondPosition()
  {
    return -1L;
  }

  public int getMaxReceivers()
  {
    return -1;
  }

  public int getMaxTransmitters()
  {
    return 0;
  }

  public Receiver getReceiver()
  {
    return new SynthesizerReceiver();
  }

  public Transmitter getTransmitter()
                           throws MidiUnavailableException
  {
    throw new MidiUnavailableException();
  }

  public int getMaxPolyphony()
  {
    return 0;
  }

  public long getLatency()
  {
    return 0L;
  }

  public MidiChannel[] getChannels()
  {
    return new MidiChannel[0];
  }

  public VoiceStatus[] getVoiceStatus()
  {
    return new VoiceStatus[0];
  }

  public boolean isSoundbankSupported(Soundbank soundbank)
  {
    return false;
  }

  public boolean loadInstrument(Instrument instrument)
  {
    return false;
  }

  public void unloadInstrument(Instrument instrument)
  {
    // do nothing
  }

  public boolean remapInstrument(Instrument from,
                        Instrument to)
  {
    return false;
  }

  public Soundbank getDefaultSoundbank()
  {
    return null;
  }

  public Instrument[] getAvailableInstruments()
  {
    return new Instrument[0];
  }

  public Instrument[] getLoadedInstruments()
  {
    return new Instrument[0];
  }

  public boolean loadAllInstruments(Soundbank soundbank)
  {
    return false;
  }

  public void unloadAllInstruments(Soundbank soundbank)
  {
    // do nothing.
  }

  public boolean loadInstruments(Soundbank soundbank,
                        Patch[] patchList)
  {
    return false;
  }

  public void unloadInstruments(Soundbank soundbank,
                       Patch[] patchList)
  {
    // do nothing.
  }

}
