/* gnu_java_awt_peer_wce_WCEComponentPeer.c
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <tchar.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEComponentPeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    setNativeBounds
 * Signature: (IIIII)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_setNativeBounds(JNIEnv *env, jobject peer_obj, int windowHandle, int x, int y, int width, int height) {
	set_bounds(env, (HWND) windowHandle, x, y, width, height);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    setNativeVisible
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_setNativeVisible(JNIEnv *env, jobject peer_obj, int windowHandle, jboolean visible) {
	set_visible(env, (HWND) windowHandle, visible);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    setNativeForeground
 * Signature: (IIII)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_setNativeForeground(JNIEnv *env, jobject peer_obj, jint windowHandle, jint rgb) {
	set_foreground(env, peer_obj, (HWND) windowHandle, rgb);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    setNativeBackground
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_setNativeBackground(JNIEnv *env, jobject peer_obj, jint windowHandle, jint rgb) {
	set_background(env, peer_obj, (HWND) windowHandle, rgb);
}


/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    setFont
 * Signature: (Ljava/awt/Font;)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_setFont(JNIEnv *env, jobject peer_obj, jobject font) {
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    disposeNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_disposeNative(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	dispose(env, peer_obj, (HWND) windowHandle);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    getNativeLocationOnScreen
 * Signature: (I)Ljava/awt/Point;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_getNativeLocationOnScreen(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	return get_location_on_screen(env, (HWND) windowHandle);
}

/**
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    getNativeText
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT jstring JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_getNativeText(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	jstring str;
	HWND hwnd = (HWND) windowHandle;
	DWORD length = GetWindowTextLength(hwnd) + 1;
	_TCHAR* buff = (_TCHAR*) malloc(sizeof(_TCHAR) * length);
	if (! buff) {
		throw_AWTError(env, "Failed to allocate a buffer.");
		return NULL;
	}
	SendMessage(hwnd, WM_GETTEXT, (WPARAM) length, (LPARAM) buff);

	str = (*env)->NewString(env, buff, _tcslen(buff));
	free(buff);

	return str;
}

/**
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    setNativeText
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_setNativeText(JNIEnv *env, jobject peer_obj, jint windowHandle, jstring str) {
	HWND hwnd = (HWND) windowHandle;
	if (str == NULL || (*env)->GetStringLength(env, str) == 0) {
		SendMessage(hwnd, WM_SETTEXT, 0, 0);
	} else {
		_TCHAR* text = get_string_chars(env, str);
		SendMessage(hwnd, WM_SETTEXT, 0, (LPARAM) text);
		free(text);
	}
}

/**
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    setNativeParent
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_setNativeParent(JNIEnv *env, jobject peer_obj, jint windowHandle, jint newParentWindowHandle) {
	SetParent((HWND) windowHandle, (HWND) newParentWindowHandle);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    setNativeEnabled
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_setNativeEnabled(JNIEnv *env, jobject peer_obj, jint windowHandle, jboolean enabled) {
	set_enabled(env, (HWND) windowHandle, (enabled == JNI_TRUE) ? TRUE : FALSE);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    setNativeCursor
 * Signature: (IIIII)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_setNativeCursor(JNIEnv *env, jobject peer_obj, int windowHandle, int type)
{
  set_cursor((HWND) windowHandle, type);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    setNativeFontHandle
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_setNativeFontHandle(JNIEnv *env, jobject peer_obj, jint windowHandle, jint fontHandle) {
	set_font((HWND) windowHandle, (HFONT) fontHandle);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    requestNativeFocus
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_requestNativeFocus(JNIEnv *env, jobject peer_obj, jint windowHandle) {
/* !!!! Mod PeteC 2006-06-20 */
//	SetFocus((HWND) windowHandle);
	set_focus((HWND) windowHandle);
/* !!!! End Mod PeteC 2006-06-20 */
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEComponentPeer
 * Method:    hasNativeFocus
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_gnu_java_awt_peer_wce_WCEComponentPeer_hasNativeFocus(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	// ToDo: 
	return get_focus() == (HWND) windowHandle;
}
