/* jawt.c -- Windows CE implementation of the AWT Native Interface
   Copyright (C) 2005, 2006, 2007, 2008, 2009 Free Software Foundation, Inc.

   This file is part of GNU Classpath.

   GNU Classpath is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Classpath is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Classpath; see the file COPYING.  If not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301 USA.

   Linking this library statically or dynamically with other modules is
   making a combined work based on this library.  Thus, the terms and
   conditions of the GNU General Public License cover the whole
   combination.

   As a special exception, the copyright holders of this library give you
   permission to link this library with independent modules to produce an
   executable, regardless of the license terms of these independent
   modules, and to copy and distribute the resulting executable under
   terms of your choice, provided that you also meet, for each linked
   independent module, the terms and conditions of the license of that
   module.  An independent module is a module which is not derived from
   or based on this library.  If you modify this library, you may extend
   this exception to your version of the library, but you are not
   obligated to do so.  If you do not wish to do so, delete this
   exception statement from your version. */

#include <jni.h>
#include <jawt.h>
#include "jawt_md.h"

#ifndef __GNUC__
#define __attribute__(x)	/* nothing */
#endif

static jint (JNICALL _Jv_Lock) (JAWT_DrawingSurface * surface);
static void (JNICALL _Jv_Unlock) (JAWT_DrawingSurface * surface);
static JAWT_DrawingSurfaceInfo *(JNICALL _Jv_GetDrawingSurfaceInfo)
  (JAWT_DrawingSurface * surface);
static void (JNICALL _Jv_FreeDrawingSurfaceInfo)
  (JAWT_DrawingSurfaceInfo * surface_info);
static JAWT_DrawingSurface *(JNICALL _Jv_GetDrawingSurface) (JNIEnv * env,
							     jobject canvas);
static void (JNICALL _Jv_FreeDrawingSurface) (JAWT_DrawingSurface * surface);
static void (JNICALL _Jv_AWTLock) (JNIEnv *);
static void (JNICALL _Jv_AWTUnlock) (JNIEnv *);

JNIEXPORT jboolean JNICALL
JAWT_GetAWT (JNIEnv * env __attribute__ ((unused)), JAWT * awt)
{
  if (awt->version > JAWT_VERSION_1_4)
    {
      return JNI_FALSE;
    }

  awt->GetDrawingSurface = _Jv_GetDrawingSurface;
  awt->FreeDrawingSurface = _Jv_FreeDrawingSurface;
  awt->Lock = _Jv_AWTLock;
  awt->Unlock = _Jv_AWTUnlock;

  return JNI_TRUE;
}

/* JAWT_DrawingSurface functions */

static jint
  (JNICALL _Jv_Lock) (JAWT_DrawingSurface * surface __attribute__ ((unused)))
{
  // ɉȂ
  return 0;
}

static void
  (JNICALL _Jv_Unlock) (JAWT_DrawingSurface * surface
			__attribute__ ((unused)))
{
  // ɉȂ
}

static JAWT_DrawingSurfaceInfo *
  (JNICALL _Jv_GetDrawingSurfaceInfo) (JAWT_DrawingSurface * surface)
{
  JAWT_DrawingSurfaceInfo *surface_info;
  JAWT_Win32DrawingSurfaceInfo *surface_info_w32;
  int windowHandle;
  RECT rect;
  JNIEnv *env = surface->env;
  jclass clazz, lwp_class;
  jmethodID mid, getParent_mid;
  jobject peerobj, compobj;

  if (surface == NULL || surface->target == NULL)
    {
      return NULL;
    }

  surface_info =
    (JAWT_DrawingSurfaceInfo *) malloc (sizeof (JAWT_DrawingSurfaceInfo));
  if (surface_info == NULL)
    {
      return NULL;
    }
  surface_info->platformInfo = malloc (sizeof (JAWT_Win32DrawingSurfaceInfo));
  if (surface_info->platformInfo == NULL)
    {
      free(surface_info);
      return NULL;
    }

  // Component.getPeer()ComponentPeer擾
  clazz = (*env)->FindClass (env, "java/awt/Component");
  if (!clazz)
    {
      free(surface_info->platformInfo);
      free(surface_info);
      return NULL;
    }
  mid =
    (*env)->GetMethodID (env, clazz, "getPeer",
			 "()Ljava/awt/peer/ComponentPeer;");
  if (!mid)
    {
      free(surface_info->platformInfo);
      free(surface_info);
      return NULL;
    }
  peerobj = (*env)->CallObjectMethod (env, surface->target, mid);
  if (! peerobj)
    {
      free(surface_info->platformInfo);
      free(surface_info);
      return NULL;
    }
  lwp_class = (*env)->FindClass (env, "java/awt/peer/LightweightPeer");
  if (!lwp_class)
    {
      free(surface_info->platformInfo);
      free(surface_info);
      return NULL;
    }
  getParent_mid =
    (*env)->GetMethodID (env, clazz, "getParent", "()Ljava/awt/Container;");
  if (!getParent_mid)
    {
      free(surface_info->platformInfo);
      free(surface_info);
      return NULL;
    }

  compobj = surface->target;
  while ((*env)->IsInstanceOf (env, peerobj, lwp_class))
    {
      compobj = (*env)->CallObjectMethod (env, compobj, getParent_mid);
      if (!compobj)
	{
          free(surface_info->platformInfo);
          free(surface_info);
	  return NULL;
	}
      peerobj = (*env)->CallObjectMethod (env, compobj, mid);
    }

  // getWindowHandle() HWND擾
  mid =
    (*env)->GetMethodID (env, (*env)->GetObjectClass (env, peerobj),
			 "getWindowHandle", "()I");
  if (!mid)
    {
      free(surface_info->platformInfo);
      free(surface_info);
      return NULL;
    }
  windowHandle = (*env)->CallIntMethod (env, peerobj, mid);

  surface_info_w32 =
    (JAWT_Win32DrawingSurfaceInfo *) surface_info->platformInfo;
  surface_info_w32->hwnd = (HWND) windowHandle;
  surface_info_w32->hdc = GetWindowDC (surface_info_w32->hwnd);
  surface_info_w32->hpalette = NULL;

  GetWindowRect (surface_info_w32->hwnd, &rect);
  surface_info->bounds.x = rect.left;
  surface_info->bounds.y = rect.top;
  surface_info->bounds.width = (rect.right - rect.left);
  surface_info->bounds.height = (rect.bottom - rect.top);
  surface_info->clipSize = 0;

  return surface_info;
}

static void
  (JNICALL _Jv_FreeDrawingSurfaceInfo) (JAWT_DrawingSurfaceInfo *
					surface_info)
{
  JAWT_Win32DrawingSurfaceInfo *surface_info_w32;

  if (surface_info == NULL)
    return;

  surface_info_w32 =
    (JAWT_Win32DrawingSurfaceInfo *) surface_info->platformInfo;

  ReleaseDC (surface_info_w32->hwnd, surface_info_w32->hdc);
  surface_info_w32->hwnd = NULL;
  surface_info_w32->hdc = NULL;

  free (surface_info->platformInfo);
  free (surface_info);
  surface_info = NULL;
}

/* JAWT functions */

static JAWT_DrawingSurface *
  (JNICALL _Jv_GetDrawingSurface) (JNIEnv * env, jobject canvas)
{
  JAWT_DrawingSurface *surface;

  surface = (JAWT_DrawingSurface *) malloc (sizeof (JAWT_DrawingSurface));

  if (surface == NULL)
    return NULL;

  surface->env = env;
  surface->target = canvas;

  /* initialize function pointers */
  surface->GetDrawingSurfaceInfo = _Jv_GetDrawingSurfaceInfo;
  surface->FreeDrawingSurfaceInfo = _Jv_FreeDrawingSurfaceInfo;

  surface->Lock = _Jv_Lock;
  surface->Unlock = _Jv_Unlock;

  return surface;
}

static void (JNICALL _Jv_FreeDrawingSurface) (JAWT_DrawingSurface * surface)
{
  free (surface);
}

static void (JNICALL _Jv_AWTLock) (JNIEnv * env __attribute__ ((unused)))
{
  // ɉȂ
}

static void (JNICALL _Jv_AWTUnlock) (JNIEnv * env __attribute__ ((unused)))
{
  // ɉȂ
}
