/* arguments.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#ifndef ARGUMENTS_H_INCLUDED
#define ARGUMENTS_H_INCLUDED

/**
 * System property.
 */
struct property
{
  _TCHAR key[256];
  _TCHAR value[256];
};

/**
 * Verify mode
 */
enum VerifyMode
{
  /**
   * No verify.
   */
  VERIFY_MODE_NONE,

  /**
   * Verify all classes.
   */
  VERIFY_MODE_ALL,
};

/**
 * Annotation mode.
 */
enum AnnotationMode
{
  /**
   * Discards annotations.
   */
  ANNOTATION_DISCARD,

  /**
   * Retains "visible" annotations.
   */
  ANNOTATION_VISIBLE_ONLY,

  /**
   * Retains all annotations. ("visible" and "invisible" annotations)
   */
  ANNOTATION_ALL
};

/**
 * JVMN̈
 */
struct arguments
{
  /**
   * NXpX
   */
  // _TCHAR classpath[256];
  // NXpXTCY͉ςƂ(Bug #12863)
  _TCHAR* classpath;
	
  /**
   * u[gNXpX
   */
  _TCHAR boot_classpath[256];

  union
  {
    /**
     * sNX
     */
    _TCHAR class_name[256];

    /**
     * jart@C
     */
    _TCHAR jar_file_name[MAX_PATH + 1];
  };

  /**
   * Maximum heap size (in bytes)
   */
  int max_heap_size;

  /**
   * Java stack size (in bytes)
   */
  int java_stack_size;

  /**
   * Native stack size (in bytes)
   */
  int native_stack_size;

  /**
   * Command line arguments.
   */
  _TCHAR* argv;

  /**
   * -verbose:gc
   */
  bool verbose_gc;

  /**
   * -verbose:class
   */
  bool verbose_class;

  /**
   * -verbose:jni
   */
  bool verbose_jni;

  /**
   * File name of -Xloggc:
   */
  _TCHAR loggc[256];

  /**
   * assertion
   */
  bool enableAssertions;

  /**
   * Show console.
   */
  bool show_console;

  /**
   * Hides VM window
   */
  bool hide_vm_window;

  /**
   * Use stdio/stderr
   */
  bool use_stdio;

  /**
   * File name of console log.
   */
  _TCHAR	logfile[MAX_PATH + 1];
	
  /**
  * -jar
   */
  bool jar;

  /**
   * Number of system properties.
   */
  int properties_count;

  /**
   * System properties.
   */
  property* properties;

  /**
   * Verify options.
   */
  VerifyMode verify_mode;

  /**
   * Current directory
   */
  _TCHAR current_directory[MAX_PATH];

  /**
   * Shows current heap usage.
   */
  bool show_current_heap_usage; 

  /**
   * Annotation support level.
   */
  AnnotationMode annotation_mode;

};

/**
 * ɊւԂ
 */
void init_arguments_settings();

/**
 * 쐬
 */
arguments* arguments_create();

/**
 * Ɋ蓖Ăꂽ폜
 */
void arguments_delete(arguments* args);

/**
 * w肳ꂽɁA𐶐
 */
arguments* arguments_load(const _TCHAR* params);

/**
 * w肳ꂽobt@ɁA𕶎ɕϊāAw肳ꂽt@Cɏo͂
 */
int arguments_store(arguments* args, FILE* file);

/**
 * vpeBݒ肷
 */
void arguments_put_property(arguments* args, const _TCHAR* key, const _TCHAR* value);

/**
 * ׂẴvpeBNA
 */
void arguments_clear_all_properties(arguments* args);

/**
 * vpeB̃L[Ԃ
 */
const _TCHAR* arguments_get_property_key(arguments* args, int index);

/**
 * w肳ꂽL[ɑΉvpeBlԂ
 */
const _TCHAR* arguments_get_property(arguments* args, const _TCHAR* key);

#endif