#include <windows.h>
#include <jni.h>
#include <assert.h>
#include "wcesound.h"
#include "gnu_javax_sound_sampled_wce_WCEMixer.h"

/*
 * Class:     gnu_javax_sound_sampled_wce_WCEMixer
 * Method:    getNativeSourceLineFormats
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_sound_sampled_wce_WCEMixer_getNativeSourceLineFormats
(JNIEnv *env, jobject mixer)
{
  WAVEOUTCAPS caps = {0};
  MMRESULT mmresult = waveOutGetDevCaps(WAVE_MAPPER, &caps, sizeof(WAVEOUTCAPS));
  if (MMSYSERR_NOERROR != mmresult)
  {
    throw_MMRESULT_Exception(env, mmresult);
  }
  return (jint) caps.dwFormats;
}

/*
 * Class:     gnu_javax_sound_sampled_wce_WCEMixer
 * Method:    getNativeTargetLineFormats
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_sound_sampled_wce_WCEMixer_getNativeTargetLineFormats
(JNIEnv *env, jobject mixer)
{
  WAVEINCAPS caps = {0};
  MMRESULT mmresult = waveInGetDevCaps(WAVE_MAPPER, &caps, sizeof(WAVEINCAPS));
  if (MMSYSERR_NOERROR != mmresult)
  {
    throw_MMRESULT_Exception(env, mmresult);
  }
  return (jint) caps.dwFormats;
}

