#include "stdafx.h"
#include "SSLEngine.h"

// ֐e[u
PSecurityFunctionTable    SSLEngine::pFunctions;



/**
 * InitializeSecurityContext()/AcceptSecurityContext()̈
 */
#define ISC_ATTRIBUTES  (ISC_REQ_SEQUENCE_DETECT   | \
                         ISC_REQ_REPLAY_DETECT     | \
                         ISC_REQ_CONFIDENTIALITY   | \
                         ISC_REQ_EXTENDED_ERROR    | \
                         ISC_REQ_ALLOCATE_MEMORY   | \
                         ISC_REQ_STREAM)
#define ASC_ATTRIBUTES  (ASC_REQ_SEQUENCE_DETECT | \
                         ASC_REQ_REPLAY_DETECT   | \
                         ASC_REQ_CONFIDENTIALITY | \
                         ASC_REQ_EXTENDED_ERROR  | \
                         ASC_REQ_ALLOCATE_MEMORY | \
                         ASC_REQ_STREAM)

static LPSTR g_server_cert_usage[] =
{
  szOID_PKIX_KP_SERVER_AUTH,
  szOID_SERVER_GATED_CRYPTO,
  szOID_SGC_NETSCAPE
};

static LPSTR g_client_cert_usage[] =
{
  szOID_PKIX_KP_CLIENT_AUTH,
};


#ifdef DEBUG
static void
hexDump(const _TCHAR* header, unsigned char* buffer, DWORD length)
{
  static const _TCHAR num_chars[]=_T("0123456789ABCDEF");

  OutputDebugString(header);
  OutputDebugString(_T("\r\n"));

  DWORD pos = 0;
  while (length > 0)
  {
    _TCHAR line[128];
    _stprintf(line, _T("%4.4x: "), pos);
    _TCHAR* work = line + 6;
    
    DWORD count = (length > 16) ? 16 : length;
    DWORD i;
    for (i = 0; i < count; i++)
    {
      *work++ = num_chars[buffer[i] >> 4];
      *work++ = num_chars[buffer[i] & 0x0f];
      if(i == 7)
      {
        *work++ = ':';
      } 
      else
      {
        *work++ = ' ';
      }
    }
    while (i < 16)
    {
      *work++ = ' ';
      *work++ = ' ';
      *work++ = ' ';
      i++;
    }

    *work++ = ' ';

    for (i = 0; i < count; i++)
    {
      if (buffer[i] < 32 || buffer[i] > 126) 
      {
        *work++ = '.';
      } 
      else
      {
        *work++ = buffer[i];
      }
    }
          
    *work++ = _T('\0');

    OutputDebugString(line);
    OutputDebugString(_T("\r\n"));
    
    pos += count;
    buffer += count; 
    length -= count;
  }
}

#define DUMP(t,b,l) hexDump((t),(unsigned char*)(b),(l))
#define DBG(s) OutputDebugString(s)
#else

#define DUMP(t,b,l)
#define DBG(s)

#endif

/**
 * ؖ`F[𓾂
 */
static BOOL getCertificateChain(PCCERT_CONTEXT cert, PCCERT_CHAIN_CONTEXT* ppChain, LPSTR* usage, DWORD usage_count)
{
    CERT_CHAIN_PARA chain_para = { sizeof(CERT_CHAIN_PARA) };
    chain_para.RequestedUsage.dwType = USAGE_MATCH_TYPE_OR;
    chain_para.RequestedUsage.Usage.rgpszUsageIdentifier = usage;
    chain_para.RequestedUsage.Usage.cUsageIdentifier = usage_count;
    return CertGetCertificateChain(NULL,             // hChainEngine
                                   cert,             // pCertContext
                                   NULL,             // pTime
                                   cert->hCertStore, // hAdditionalStore
                                   &chain_para,      // pChainPara
                                   0,                // dwFlags
                                   NULL,             // pvReserved
                                   ppChain);         // ppChainContext
}

SSLEngine::SSLEngine(const _TCHAR* host)
          : 
            peerHost(NULL),
            clientMode(true),
            outboundDone(false),
            inboundDone(false),
            phCredential(NULL),
            phContext(NULL),
            handshakeStatus(NOT_HANDSHAKING),
            lastHandshakeTrigger(HELLO_REQUEST),
            enabledProtocols(SP_PROT_SSL3|SP_PROT_TLS1),
            pLocalCertificate(NULL),
            pLocalCertificateChain(NULL),
            pPeerCertificate(NULL),
            pPeerCertificateChain(NULL),
            protocolVersion(0x0000),
            sessionIDLength(0),
            sessionID(NULL),
            cipherSuiteCode(0x0000),
            delegatedTaskCount(0),
            peerCertificateChainLoaded(false),
            clientAuthLevel(0)
{
  // bN쐬
  InitializeCriticalSection(&this->criticalSection);

  if (host)
  {
    size_t len = _tcslen(host);
    _TCHAR* tmp = new _TCHAR[len + 1];
    _tcscpy(tmp, host);
    this->peerHost = tmp;
  }

  // ֐e[u
  if (! pFunctions)
  {
    pFunctions = InitSecurityInterface();
  }

  memset(this->securityContextOutput, 0, sizeof(this->securityContextOutput));            
  memset(&this->streamSizes, 0, sizeof(this->streamSizes));
}

SSLEngine::~SSLEngine()
{
  DeleteCriticalSection(&this->criticalSection);

  _TCHAR* tmp = const_cast<_TCHAR*>(this->peerHost);
  this->peerHost = NULL;
  delete tmp;

  // o̓obt@폜
  if (this->securityContextOutput[0].pvBuffer)
  {
    FreeContextBuffer(this->securityContextOutput[0].pvBuffer);
    this->securityContextOutput[0].pvBuffer = NULL;
  }

  // ؖ`F[폜
  if (this->pPeerCertificateChain)
  {
    CertFreeCertificateChain(this->pPeerCertificateChain);
    this->pPeerCertificateChain = NULL;
  }

  // ؖ폜
  if (this->pPeerCertificate)
  {
    CertFreeCertificateContext(this->pPeerCertificate);
    this->pPeerCertificate = NULL;
  }

  // [Jؖ`F[폜
  if (this->pLocalCertificateChain)
  {
    CertFreeCertificateChain(this->pLocalCertificateChain);
    this->pLocalCertificateChain = NULL;
  }

  if (this->pLocalCertificate)
  {
    // CertDuplicateCertificateContext()ĂяoĂȂ̂ŁA
    // sv
//    CertFreeCertificateContext(this->pLocalCertificate);
    this->pLocalCertificate = NULL;
  }

  // CtxtHandle폜
  if (this->phContext)
  {
    SECURITY_STATUS ss = DeleteSecurityContext(this->phContext);
    delete this->phContext;
    this->phContext = NULL;
  }

  // CredHandle폜
  if (this->phCredential)
  {
    SECURITY_STATUS ss = FreeCredentialsHandle(this->phCredential);
    delete this->phCredential;
    this->phCredential = NULL;
  }

  if (this->sessionID)
  {
    delete this->sessionID;
    this->sessionID = NULL;
  }

  // bNJ
  DeleteCriticalSection(&this->criticalSection);
}

/**
 * 葤̏ؖ`F[擾
 */
bool
SSLEngine::loadPeerCertificateChain()
{
  bool result = false;

  if (this->pPeerCertificate)
  {
    // ؖ`F[𓾂
    // NCAg[h̏ꍇ́AT[oؖF؂
    // T[o[h̏ꍇ́ANCAgؖF؂
    LPSTR* usage = getUseClientMode() ? g_server_cert_usage : g_client_cert_usage;
    const DWORD usage_count = getUseClientMode() ? (sizeof(g_server_cert_usage) / sizeof(LPSTR))
                                                 : (sizeof(g_client_cert_usage) / sizeof(LPSTR));

    if (! getCertificateChain(this->pPeerCertificate,
                              &this->pPeerCertificateChain,
                              usage,
                              usage_count))
    {
      // ؖ`F[擾̂s
      // FreeContextBuffer(this->pPeerCertificate);
      // this->pPeerCertificate = NULL;
      goto END;
    }

    // ؖ،ʂ́ASSLEngine.getSession()Ăяoꂽ_ŊmF
  }

  result = true;

END:
  this->peerCertificateChainLoaded = true;
  return result;
}

/**
 * ǂ̏ؖ`F[Ԃ
 */
PCCERT_CHAIN_CONTEXT
SSLEngine::getLocalCertificateChain()
{
  if (this->pLocalCertificate && (! this->pLocalCertificateChain))
  {
    // ؖ`F[𓾂
    // NCAg[h̏ꍇ́AprɁuNCAgؖv
    // T[o[h̏ꍇ́AprɁuT[oؖv
    // ꂼw肷
    LPSTR* usage = getUseClientMode() ? g_client_cert_usage : g_server_cert_usage;
    const DWORD usage_count = getUseClientMode() ? (sizeof(g_client_cert_usage) / sizeof(LPSTR))
                                                 : (sizeof(g_server_cert_usage) / sizeof(LPSTR));

    getCertificateChain(this->pLocalCertificate,
                        &this->pLocalCertificateChain,
                        usage,
                        usage_count);
  }
  return this->pLocalCertificateChain;
}

void
SSLEngine::encryptApplicationData(void* srcbuff, int srclen, void* destbuff, int destlen)
{
  assert(this->phContext);
  assert(this->streamSizes.cBuffers >= 4);

  // http://msdn.microsoft.com/en-us/library/aa925742.aspx
  // Buffer Type   	    Description
  // SECBUFFER_STREAM_HEADER  Used internally. No initialization required.
  // SECBUFFER_DATA           Contains the plaintext message to be encrypted.
  // SECBUFFER_STREAM_TRAILER Used internally. No initialization required.
  // SECBUFFER_EMPTY          Used internally. No initialization required. Size can be zero. 

  // ̓f[^̍ő咷vZ
  // http://support.microsoft.com/?scid=kb%3Ben-us%3B262403&x=21&y=16
  // ̏ɊÂA
  // cbHeader + cbMaximumMessage + cbTrailer
  // *ł͂Ȃ*
  // cbMaximumMessage - (cbHeader + cbTrailer)
  // obt@TCYƂĂ
  // LURL̏Pocket PĈ̂ł͂ȂAÔ߂Ă
  const size_t max_data = this->streamSizes.cbMaximumMessage
                              - (this->streamSizes.cbHeader + this->streamSizes.cbTrailer);

  // ̓f[^肷
  const size_t data_len = min((size_t) srclen, max_data);

  if (srclen <= 0)
  {
    // o̓f[^Ȃ
    this->wrapResult.setValues(OK,
                               getHandshakeStatus(),
                               0,
                               0);
  }
  else if ((size_t) destlen < this->streamSizes.cbHeader + data_len + this->streamSizes.cbTrailer)
  {
    this->wrapResult.setValues(BUFFER_OVERFLOW,
                               getHandshakeStatus(),
                               0,
                               0);
  }
  else
  {
    memcpy((char*) destbuff + this->streamSizes.cbHeader,
           srcbuff,
           data_len);

    SecBuffer buffers[4];

    // header
    buffers[0].BufferType = SECBUFFER_STREAM_HEADER;
    buffers[0].cbBuffer = this->streamSizes.cbHeader;
    buffers[0].pvBuffer = destbuff;

    buffers[1].BufferType = SECBUFFER_DATA;
    buffers[1].cbBuffer = data_len;
    buffers[1].pvBuffer = (char*) destbuff + this->streamSizes.cbHeader;

    // trailer
    buffers[2].BufferType = SECBUFFER_STREAM_TRAILER;
    buffers[2].cbBuffer = this->streamSizes.cbTrailer;
    buffers[2].pvBuffer = (char*) destbuff + this->streamSizes.cbHeader + data_len;

    // empty
    buffers[3].BufferType = SECBUFFER_EMPTY;
    buffers[3].cbBuffer = 0;
    buffers[3].pvBuffer = NULL;

    SecBufferDesc msg;
    msg.ulVersion = SECBUFFER_VERSION;
    msg.cBuffers = 4;
    msg.pBuffers = buffers;

    SECURITY_STATUS ss
      = pFunctions->EncryptMessage(
                        this->phContext,  // phContext
                        0,                // fQOP
                        &msg,             // pMessage
                        0                 // MessageSeqNo
                        );
    switch (ss)
    {
    case SEC_E_OK:
      {
        const size_t copy_len = buffers[0].cbBuffer
                                + buffers[1].cbBuffer
                                + buffers[2].cbBuffer;
        if (copy_len > (size_t) destlen)
        {
          // ͔Ȃi͂j
          assert(false);
        }
        this->wrapResult.setValues(OK,
                                   getHandshakeStatus(),
                                   data_len,
                                   copy_len);
      }
      break;

    case SEC_I_RENEGOTIATE:
      // ToDo: ălSVG[g
      assert(false);
      this->wrapResult.setError(ss);
      break;

    default:
      assert(false);
      this->wrapResult.setError(ss);
      break;
    }
  }
}

/**
 * close_notifyA[g𐶐
 */
void
SSLEngine::wrapCloseNotify()
{
  // ApplyControlToken()SCHANNEL_SHUTDOWNn
  // Vbg_EJn
  DWORD dwType = SCHANNEL_SHUTDOWN;
  SecBuffer inBuff[1];
  inBuff[0].pvBuffer   = &dwType;
  inBuff[0].BufferType = SECBUFFER_TOKEN;
  inBuff[0].cbBuffer   = sizeof(dwType);

  SecBufferDesc sbdIn;
  sbdIn.cBuffers  = 1;
  sbdIn.pBuffers  = inBuff;
  sbdIn.ulVersion = SECBUFFER_VERSION;

  this->securityStatus = pFunctions->ApplyControlToken(this->phContext, &sbdIn);
  if (FAILED(this->securityStatus)) 
  {
    // Vbg_EJnłȂ
    assert(false);
    return;
  }

  SecBuffer inBuffer[2];
  inBuffer[0].pvBuffer   = NULL;
  inBuffer[0].cbBuffer   = 0;
  inBuffer[0].BufferType = SECBUFFER_EMPTY;
  inBuffer[1].pvBuffer   = NULL;
  inBuffer[1].cbBuffer   = 0;
  inBuffer[1].BufferType = SECBUFFER_EMPTY;

  sbdIn.ulVersion = SECBUFFER_VERSION;
  sbdIn.cBuffers  = 2;
  sbdIn.pBuffers  = inBuffer;

  this->securityContextOutput[0].cbBuffer   = 0;
  this->securityContextOutput[0].BufferType = SECBUFFER_TOKEN;
  this->securityContextOutput[0].pvBuffer   = NULL;

  SecBufferDesc sbdOut;
  sbdOut.ulVersion = SECBUFFER_VERSION;
  sbdOut.cBuffers  = 1;
  sbdOut.pBuffers  = this->securityContextOutput;

  TimeStamp tsExpiry;
  unsigned long uAttrOut;
  if (getUseClientMode())
  {
    this->securityStatus
      = pFunctions->InitializeSecurityContext(this->phCredential,
                                  this->phContext,
                                  const_cast<SEC_WCHAR*>(getPeerHost()),
                                  ISC_ATTRIBUTES,
                                  0,
                                  SECURITY_NETWORK_DREP,
                                  &sbdIn,
                                  0,
                                  this->phContext,
                                  &sbdOut,
                                  &uAttrOut,
                                  &tsExpiry);
  }
  else
  {
    this->securityStatus
      = pFunctions->AcceptSecurityContext(this->phCredential,
                                this->phContext,
                                &sbdIn,
                                ASC_ATTRIBUTES,
                                SECURITY_NATIVE_DREP,
                                this->phContext,
                                &sbdOut,
                                &uAttrOut,
                                &tsExpiry);
    // eXgp
#ifdef DEBUG
    {
      LONG result = uAttrOut & ASC_RET_MUTUAL_AUTH;
      result = result;
    }
#endif

  }

  if (SEC_E_OK != this->securityStatus)
  {
    // close_notifyA[g̐s
    assert(false);
  }
}

/**
 * o͂N[Y
 */
void
SSLEngine::closeOutbound()
{
  if (isOutboundDone())
  {
    // łɏo͂Ă
    return;
  }

  if (! this->phContext || ! this->phCredential)
  {
    // ܂ĂȂ
    return;
  }

  const SSLEngineHandshakeTrigger lht = getLastHandshakeTrigger();
  if (lht == CLOSE_NOTIFY_RECEIVED || lht == OUTBOUND_CLOSED)
  {
    // o͂͐Ă邪AI
    return;
  }

  // close_notifyA[g𐶐
  wrapCloseNotify();

  // nhVF[NJnݒ
  setLastHandshakeTrigger(OUTBOUND_CLOSED);

  // nhVF[NԂXV
  updateHandshakeStatus();

  // nhVF[NXe[^X NEED_WRAP ̂͂
  assert(NEED_WRAP == this->handshakeStatus);
}

/**
 * ͂N[Y
 */
bool
SSLEngine::closeInbound()
{
  if (isInboundDone())
  {
    // łɓ͕͂Ă
    return true;
  }
  
  // ͂
  setInboundDone(true);

  if (! this->phContext || ! this->phCredential)
  {
    // ĂȂɕ
    return true;
  }

  // close_alert𑗐M܂͎MĂ邩mF
  SSLEngineHandshakeTrigger lht = getLastHandshakeTrigger();
  if (lht != CLOSE_NOTIFY_RECEIVED && lht != OUTBOUND_CLOSED)
  {
    // truncate attack 󂯂Ă\
    return false;
  }

  return true;
}

const SSLEngineResult&
SSLEngine::wrap(void* srcbuff, int srclen, void* destbuff, int destlen)
{
  // bN擾
  acquireLock();

  if (isOutboundDone())
  {
    // o͂N[YĂ
    this->wrapResult.setValues(CLOSED, getHandshakeStatus(), 0, 0);
    goto END;
  }
 
  SSLEngineHandshakeStatus hs = getHandshakeStatus();
  SSLEngineHandshakeTrigger lht = getLastHandshakeTrigger();

  if (! this->phCredential && HELLO_REQUEST == lht)
  {
    // nhVF[NJn
    HRESULT result = beginHandshake();
    if (FAILED(result))
    {
      // nhVF[NJns
      this->wrapResult.setError(result);
      goto END;
    }
  }

  hs = getHandshakeStatus();
  lht = getLastHandshakeTrigger();
  if (NEED_WRAP == hs)
  {
    // NEED_WRAP

    if (! this->phContext)
    {
      /// ReLXg̏s
      assert(getUseClientMode());

      // InitializeSecurityContext()̏Ăяo
      this->phContext = new CtxtHandle();
      if (! this->phContext)
      {
        this->wrapResult.setError(E_OUTOFMEMORY);
        goto END;
      }
      firstInitializeSecurityContext(destbuff, destlen);
    }
    else if (CLOSE_NOTIFY_RECEIVED == lht)
    {
      // close_notifyɑ΂ԓƂāAclose_notify𐶐
#if 0
      // http://msdn.microsoft.com/en-us/library/aa923704.aspx
      // Ɉȉ̋LqB
      // When you use the Schannel SSP, the DecryptMessage  function returns SEC_I_CONTEXT_EXPIRED when the message sender has shut down the connection. After receiving this return value, your application must complete the following steps:
      //    1. Call EncryptMessage, passing in an empty input buffer.
      //    2. Send the output buffers from the EncryptMessage call to the remote party (the sender of the decrypted message).
      //    3. Delete the security context by calling the DeleteSecurityContext function. 
      // Ȁo͕@ł́AEncryptMessage()SEC_E_CONTEXT_EXPIREDԂĂ邽߁A
      // hLǧƎvB
      // AcceptControlToken()/InitializeSecurityContext()Ő̂
      if ((unsigned int) destlen < (this->streamSizes.cbHeader + this->streamSizes.cbTrailer))
      {
        // o̓obt@TCYȂ
        this->wrapResult.setValues(BUFFER_UNDERFLOW,
                                   getHandshakeStatus(),
                                   0,
                                   0);
      }
      else
      {
        // TCY0̃obt@w肵āAEncryptMessage()Ăяo
        SecBuffer buffers[4];
        buffers[0].BufferType = SECBUFFER_STREAM_HEADER;
        buffers[0].cbBuffer = this->streamSizes.cbHeader;
        buffers[0].pvBuffer = destbuff;

        buffers[1].BufferType = SECBUFFER_DATA;
        buffers[1].cbBuffer = 0;  // TCY0
        buffers[1].pvBuffer = (char*) destbuff + this->streamSizes.cbHeader;

        buffers[2].BufferType = SECBUFFER_STREAM_TRAILER;
        buffers[2].cbBuffer = this->streamSizes.cbTrailer;
        buffers[2].pvBuffer = (char*) destbuff + this->streamSizes.cbHeader + 0;

        buffers[3].BufferType = SECBUFFER_EMPTY;
        buffers[3].cbBuffer = 0;
        buffers[3].pvBuffer = NULL;

        SecBufferDesc msg;
        msg.ulVersion = SECBUFFER_VERSION;
        msg.cBuffers = 4;
        msg.pBuffers = buffers;

        this->securityStatus
          = pFunctions->EncryptMessage(
                              this->phContext,  //phContext
                              0,                // fQOP
                              &msg,             // pMessage
                              0                 // MessageSeqNo
                              );

        // o̓f[^͂ꂪŌ
        setOutboundDone(true);

        // nhVF[NԂXViG[͖j
        updateHandshakeStatus();

        int bytesProduced = 0;
        if (SUCCEEDED(this->securityStatus))
        {
          bytesProduced = buffers[0].cbBuffer + buffers[1].cbBuffer + buffers[2].cbBuffer;
        }
        this->wrapResult.setValues(CLOSED,                // o̓f[^Ȃ
                                   getHandshakeStatus(),
                                   0,                     // f[^Ȃ
                                   bytesProduced);        // close_notify̒
      }
#endif
      // close_notify 𐶐
      wrapCloseNotify();

      // ȏo͂f[^͂Ȃ
      setOutboundDone(true);

      // f[^o͂
      // ̊֐̒ wrapResult ݒ肳
      wrapSecurityContext(destbuff, destlen);
    }
    else
    {
      assert(lht == HELLO_REQUEST || lht == OUTBOUND_CLOSED);

      // InitializeSecurityContext() / AcceptSecurityContext() ̌ʂo͂
      wrapSecurityContext(destbuff, destlen);
    }
    // nhVF[N\
    DUMP(_T("NEED_WRAP:output"), destbuff, this->wrapResult.bytesProduced());
  }
  else if (NEED_UNWRAP == hs)
  {
    // o̓f[^Ȃ
    this->wrapResult.setValues(OK, hs, 0, 0);
  }
  else
  {
    // nhVF[Nł͂Ȃ̂ŁAAvP[Vf[^Í
    encryptApplicationData(srcbuff, srclen, destbuff, destlen);
  }

END:
  // bNJ
  releaseLock();
  return this->wrapResult;
}

void
SSLEngine::decryptPacketData(void* srcbuff, int srclen, void* destbuff, int destlen)
{
  // ̓f[^TCY`FbN
#if 0
  // ȉ̃`FbN͌Ă邱Ƃ
  // wb_TCY+g[TCY 菬ĂADecryptMessage()͐
  if (srclen < 0 || ((size_t) srclen < this->streamSizes.cbHeader + this->streamSizes.cbTrailer))
  {
    // ̓f[^iwb_ƃg[瑶݂Ȃj
    this->unwrapResult.setValues(BUFFER_UNDERFLOW,
                                 getHandshakeStatus(),
                                 0,
                                 0);
    return;
  }
#endif

  if (srclen <= 0)
  {
    // Ώۃf[^Ȃ
    this->unwrapResult.setValues(BUFFER_UNDERFLOW,
                                 getHandshakeStatus(),
                                 0,
                                 0);
    goto END;
  }

  // őf[^TCY肷
  // http://support.microsoft.com/?scid=kb%3Ben-us%3B300562&x=13&y=13
  // ɂƁAcbMaximumMessage̒ĺASSL̎dlł163845oCgȒl16379
  // ԂĂvbgtH[B
  // LURLɂPocket PC܂܂ĂȂAPocket PC 2003 SEł͓l̖肪B
  // ŁAcbMaximuMessage̒l16384ꍇɂ16384őlƂ݂Ȃ悤ɂB
  // EncryptMessage()Ŗ肪\邽߁Aoϐ͏Ȃj
  unsigned long cbMaximumMessage = this->streamSizes.cbMaximumMessage;
  if (cbMaximumMessage < 16384)
  {
    cbMaximumMessage = 16384;
  }

  const size_t max_packet_len = this->streamSizes.cbHeader
                               + cbMaximumMessage
                               + this->streamSizes.cbTrailer;
            
  const size_t data_len = min((size_t) srclen, max_packet_len);
  SecBuffer sbuffers[4];
  assert(this->streamSizes.cBuffers >= 4);

  sbuffers[0].BufferType = SECBUFFER_DATA;
  sbuffers[0].cbBuffer = data_len;
  sbuffers[0].pvBuffer = srcbuff;

  sbuffers[1].BufferType = SECBUFFER_EMPTY;
  sbuffers[2].BufferType = SECBUFFER_EMPTY;
  sbuffers[3].BufferType = SECBUFFER_EMPTY;

  SecBufferDesc msg;
  msg.cBuffers = 4;
  msg.pBuffers = sbuffers;
  msg.ulVersion = SECBUFFER_VERSION;

  ULONG qop;
  SECURITY_STATUS ss
    = pFunctions->DecryptMessage(this->phContext,
                                       &msg,
                                       0,
                                       &qop);
  bool closeNotifyReceived = false;
  size_t pushback_len = 0;
  switch (ss)
  {
  case SEC_E_OK:
    {
      int copy_len = 0;
      for (int i = 0; i < 4; ++i)
      {
        const unsigned long type = sbuffers[i].BufferType;
        const size_t len = sbuffers[i].cbBuffer;
        if (SECBUFFER_DATA == type)
        {
          // ʂRs[
          memcpy((char*) destbuff + copy_len, sbuffers[i].pvBuffer, len);
          copy_len += len;
        }
        else if (SECBUFFER_EXTRA == type)
        {
          // ̃oCg
          pushback_len += len;
        }

      }
      assert(copy_len <= destlen);

      // http://msdn.microsoft.com/en-us/library/aa375348%28VS.85%29.aspx
      // The message sender has finished using the connection and has initiated a shutdown.
      // For information about initiating or recognizing a shutdown, see Shutting Down an Schannel Connection.
      // Used with the Schannel SSP.
      // Windows 2000 Professional: Schannel returns SEC_E_OK instead of SEC_I_CONTEXT_EXPIRED.
      // If the length of the output buffer is zero and the first byte of the encrypted packet is 0x15,
      // the application can safely assume that the message was a close_notify message and change the return value
      // to SEC_I_CONTEXT_EXPIRED.
      if (! copy_len && 0x15 == *(char*) srcbuff)
      {
        // 葤 close_notify 󂯎
        closeNotifyReceived = true;
      }
      else
      {
        this->unwrapResult.setValues(OK,
                                     getHandshakeStatus(),
                                     data_len - pushback_len,
                                     copy_len);
      }
    }
    break;

  case SEC_E_BUFFER_TOO_SMALL:
  case SEC_E_INCOMPLETE_MESSAGE:
    {
      // ̓obt@
      this->unwrapResult.setValues(BUFFER_UNDERFLOW,
                                   getHandshakeStatus(),
                                   0,
                                   0);
    }
    break;

  case SEC_I_RENEGOTIATE:
    // ToDo: ălSVG[V
    this->unwrapResult.setError(ss);
    break;

  case SEC_I_CONTEXT_EXPIRED:
    // 葤 close_notify M
    closeNotifyReceived = true;
    break;

  default:
    this->unwrapResult.setError(ss);
    break;
  }

  if (closeNotifyReceived)
  {
    // close_notify̏
    setLastHandshakeTrigger(CLOSE_NOTIFY_RECEIVED);
    this->inboundDone = true;
    // nhVFCNXe[^XXV
    updateHandshakeStatus();
    this->unwrapResult.setValues(CLOSED,
                                 getHandshakeStatus(),
                                 data_len - pushback_len,
                                 0);
  }

END:
  return;
}


/**
 * Íꂽf[^𕜍B
 */
const SSLEngineResult&
SSLEngine::unwrap(void* srcbuff, int srclen, void* destbuff, int destlen)
{
  // bN
  acquireLock();

  if (this->inboundDone)
  {
    // ͂N[YĂ
    this->unwrapResult.setValues(CLOSED, getHandshakeStatus(), 0, 0);
    goto END;
  }

  SSLEngineHandshakeStatus hs = getHandshakeStatus();
  if (! this->phCredential)
  {
    // nhVF[NJn
    HRESULT result = beginHandshake();
    if (FAILED(result))
    {
      // nhVF[NJns
      this->unwrapResult.setError(result);
      goto END;
    }
  }

  hs = getHandshakeStatus();
  if (NEED_WRAP == hs)
  {
    // Xe[^XႤ
    this->unwrapResult.setValues(OK, hs, 0, 0);
    goto END;
  }
  else if (NEED_UNWRAP == hs)
  {
    // NEED_UNWRAP
    if (! this->phContext)
    {
      /// ReLXg̏s
      assert(! getUseClientMode());

      // AcceptSecurityContext()̏Ăяo
      this->phContext = new CtxtHandle();
      if (! this->phContext)
      {
        this->wrapResult.setError(E_OUTOFMEMORY);
        return this->wrapResult;
      }
      firstAcceptSecurityContext(srcbuff, srclen);
    }
    else if (getLastHandshakeTrigger() == OUTBOUND_CLOSED)
    {
      // close_notify𑗐Mς݂Ȃ̂ŁA葤 close_notify ǂ
      decryptPacketData(srcbuff, srclen, destbuff, destlen);
      if (srclen > 0)
      {
        assert(isInboundDone());
        assert(NOT_HANDSHAKING == this->handshakeStatus);
      }
    }
    else
    {
      // InitializeSecurityContext()/AcceptSecurityContext()Ƀf[^n
      unwrapSecurityContext(srcbuff, srclen);
    }

    DUMP(_T("NEED_UNRAP:input"), srcbuff, srclen);
  }
  else
  {
    // nhVFCN͊Ă̂ŁADecryptMessage() ŃbZ[W𕜍
    decryptPacketData(srcbuff, srclen, destbuff, destlen);
  }

END:
  releaseLock();
  return this->unwrapResult;
}

/**
 * 1ڂInitializeSecurityContext()Ăяos
 */
void
SSLEngine::firstInitializeSecurityContext(void* destbuff, int destlen)
{
  assert(! this->securityContextOutput[0].cbBuffer);

  SecBufferDesc sbdOut;
  
  this->securityContextOutput[0].cbBuffer   = 0;
  this->securityContextOutput[0].BufferType = SECBUFFER_TOKEN;
  this->securityContextOutput[0].pvBuffer   = NULL;

  sbdOut.ulVersion = SECBUFFER_VERSION;
  sbdOut.cBuffers  = 1;
  sbdOut.pBuffers  = this->securityContextOutput;

  unsigned long uAttrOut;
  TimeStamp tsExpiry;

  this->securityStatus
    = pFunctions->InitializeSecurityContext(this->phCredential,
                                NULL,
                                const_cast<SEC_WCHAR*>(this->peerHost),
                                ISC_ATTRIBUTES,
                                0,
                                SECURITY_NETWORK_DREP,
                                NULL,
                                0,
                                this->phContext, 
                                &sbdOut,
                                &uAttrOut,
                                &tsExpiry);

  if (SEC_I_CONTINUE_NEEDED != this->securityStatus)
  {
    this->wrapResult.setError(this->securityStatus);
    return;
  }

  if (this->securityContextOutput[0].pvBuffer && this->securityContextOutput[0].cbBuffer)
  {
    // lo͂
    wrapSecurityContext(destbuff, destlen);
  }
}

/**
 * 1ڂAcceptSecurityContext()Ăяos
 */
void
SSLEngine::firstAcceptSecurityContext(void* srcbuff, int srclen)
{
  assert(! this->securityContextOutput[0].cbBuffer);
  assert(this->handshakeStatus == NEED_UNWRAP);

  // o̓obt@
  SecBufferDesc sbdOut;
  this->securityContextOutput[0].cbBuffer   = 0;
  this->securityContextOutput[0].BufferType = SECBUFFER_TOKEN;
  this->securityContextOutput[0].pvBuffer   = NULL;

  sbdOut.ulVersion = SECBUFFER_VERSION;
  sbdOut.cBuffers  = 1;
  sbdOut.pBuffers  = this->securityContextOutput;

  // ̓obt@
  SecBufferDesc   sbdIn;
  SecBuffer       sbIn[2];
  sbIn[0].pvBuffer   = srcbuff;
  sbIn[0].cbBuffer   = srclen;
  sbIn[0].BufferType = SECBUFFER_TOKEN;
  sbIn[1].pvBuffer   = NULL;
  sbIn[1].cbBuffer   = 0;
  sbIn[1].BufferType = SECBUFFER_EMPTY;

  sbdIn.ulVersion = SECBUFFER_VERSION;
  sbdIn.cBuffers  = 2;
  sbdIn.pBuffers  = sbIn;
  
  TimeStamp tsExpiry;
  unsigned long uAttrIn = ASC_ATTRIBUTES;
  if (getWantClientAuth() || getNeedClientAuth())
  {
    // NCAgF
    uAttrIn |= ASC_REQ_MUTUAL_AUTH;
  }
  unsigned long uAttrOut;
  this->securityStatus
    = pFunctions->AcceptSecurityContext(this->phCredential,
                                              NULL,
                                              &sbdIn,
                                              uAttrIn,
                                              SECURITY_NETWORK_DREP,
                                              this->phContext, 
                                              &sbdOut,
                                              &uAttrOut,
                                              &tsExpiry);
#ifdef DEBUG
  {
    LONG flag = uAttrOut & ASC_RET_MUTUAL_AUTH;
    flag = uAttrOut & ASC_RET_EXTENDED_ERROR;
    flag = flag;
  }
#endif

  if (SEC_I_CONTINUE_NEEDED != this->securityStatus)
  {
    this->unwrapResult.setError(this->securityStatus);
    return;
  }
  
  int bytesConsumed = srclen;
  int extra_len = 0;
  if (SECBUFFER_EXTRA == sbIn[1].BufferType)
  {
    // obt@ɂ܂̃f[^
    extra_len = sbIn[1].cbBuffer;
    bytesConsumed -= extra_len;
  }

  if (this->securityContextOutput[0].pvBuffer && this->securityContextOutput[0].cbBuffer)
  {
    assert(! extra_len);
    if (extra_len)
    {
      // ToDo:
      // ݂̎ł́A̓obt@ɖ̃f[^Ԃ
      // o̓f[^邱ƂłȂ
      this->unwrapResult.setError(HRESULT_FROM_WIN32(ERROR_INTERNAL_ERROR));
      return;
    }

  }

  // Cipher suiteR[h擾
  if (! getUseClientMode())
  {
    // f[^Server helloǂ𒲂ׂ
    parseServerHello(this->securityContextOutput[0].pvBuffer, this->securityContextOutput[0].cbBuffer);
  }
  
  updateHandshakeStatus();
  this->unwrapResult.setValues((SEC_E_INCOMPLETE_MESSAGE == this->securityStatus)
                               ? BUFFER_UNDERFLOW : OK,
                               getHandshakeStatus(),
                               bytesConsumed,
                               0
                               );
                              
}

/**
 * InitializeSecurityContext()̏o̓f[^obt@ɃRs[
 */
void
SSLEngine::wrapSecurityContext(void* destbuff, int destlen)
{
  assert(this->securityContextOutput[0].pvBuffer && this->securityContextOutput[0].cbBuffer);

  if (destlen < (int) this->securityContextOutput[0].cbBuffer)
  {
    // o̓obt@Ȃ
    // NEED_WRAP
    setHandshakeStatus(NEED_WRAP);
    this->wrapResult.setValues(BUFFER_OVERFLOW, // status
                               NEED_WRAP,       // handshakeStatus
                               0,               // bytesConsumed
                               0                // bytesProduced
                               );
  }
  else
  {
    // o̓obt@ɃRs[
    memcpy(destbuff, this->securityContextOutput[0].pvBuffer, this->securityContextOutput[0].cbBuffer);

    const int bytesProduced = this->securityContextOutput[0].cbBuffer;

    // o̓obt@NA
    FreeContextBuffer(this->securityContextOutput[0].pvBuffer);
    memset((void*) this->securityContextOutput, 0, sizeof(this->securityContextOutput));

    // nhVF[NԂXV
    if (! updateHandshakeStatus())
    {
      this->wrapResult.setError(this->securityStatus);
      return;
    }
    
    // ʂݒ
    SSLEngineStatus stat = getLastHandshakeTrigger() == OUTBOUND_CLOSED ? CLOSED : OK;
    this->wrapResult.setValues(stat,
                               getHandshakeStatus(),      // nhVF[NXe[^X
                               0,                         // ̓obt@̓e͓ǂłȂ
                               bytesProduced              // oCg
                               );

  }
}

/**
 * 2ڈȍ~InitializeSecurityContext()/AcceptSecurityContext()Ăяos
 */
void
SSLEngine::unwrapSecurityContext(void* srcbuff, int srclen)
{
  // o̓obt@ɂ͉cĂȂ͂
  assert(!this->securityContextOutput[0].cbBuffer);

  char* buff = (char*) srcbuff;
  int len = srclen;

  unsigned long iscAttributes = ISC_ATTRIBUTES;
  unsigned long uAttrOut;
  TimeStamp tsExpiry;

  int bytesConsumed = 0;
  for (;;)
  {
    SecBuffer inBuffer[2];
    inBuffer[0].pvBuffer   = buff;
    inBuffer[0].cbBuffer   = len;
    inBuffer[0].BufferType = SECBUFFER_TOKEN;
    inBuffer[1].pvBuffer   = NULL;
    inBuffer[1].cbBuffer   = 0;
    inBuffer[1].BufferType = SECBUFFER_EMPTY;

    SecBufferDesc sbdIn;
    sbdIn.ulVersion = SECBUFFER_VERSION;
    sbdIn.cBuffers  = 2;
    sbdIn.pBuffers  = inBuffer;

    this->securityContextOutput[0].cbBuffer   = 0;
    this->securityContextOutput[0].BufferType = SECBUFFER_TOKEN;
    this->securityContextOutput[0].pvBuffer   = NULL;

    SecBufferDesc sbdOut;
    sbdOut.ulVersion = SECBUFFER_VERSION;
    sbdOut.cBuffers  = 1;
    sbdOut.pBuffers  = this->securityContextOutput;

    if (getUseClientMode())
    {
      this->securityStatus
        = pFunctions->InitializeSecurityContext(this->phCredential,
                                    this->phContext,
                                    const_cast<SEC_WCHAR*>(getPeerHost()),
                                    iscAttributes,
                                    0,
                                    SECURITY_NETWORK_DREP,
                                    &sbdIn,
                                    0,
                                    this->phContext,
                                    &sbdOut,
                                    &uAttrOut,
                                    &tsExpiry);
      if (! (ISC_RET_CONFIDENTIALITY & uAttrOut))
      {
        // ʐMeÍłĂȂ
        this->securityStatus = SEC_E_SECURITY_QOS_FAILED;
        break;
      }
    }
    else
    {
      unsigned long uAttrIn = ASC_ATTRIBUTES;
      if (getWantClientAuth() || getNeedClientAuth())
      {
        uAttrIn |= ASC_REQ_MUTUAL_AUTH;
      }
      this->securityStatus
        = pFunctions->AcceptSecurityContext(this->phCredential,
                                  this->phContext,
                                  &sbdIn,
                                  uAttrIn,
                                  SECURITY_NETWORK_DREP,
                                  this->phContext,
                                  &sbdOut,
                                  &uAttrOut,
                                  &tsExpiry);
      if (! (ASC_RET_CONFIDENTIALITY & uAttrOut))
      {
        // ʐMeÍłĂȂ
        this->securityStatus = SEC_E_SECURITY_QOS_FAILED;
        break;
      }
    }
    if (FAILED(this->securityStatus))
    {
      break;
    }

    // Cipher suiteR[h擾
    if (getUseClientMode())
    {
      // Mf[^Server helloǂ𒲂ׂ
      parseServerHello(buff, len);
    }

    int extra_len = 0;
    if (SECBUFFER_EXTRA == inBuffer[1].BufferType)
    {
      // obt@ɂ܂̃f[^
      extra_len = inBuffer[1].cbBuffer;
    }
    // obt@̃f[^
    bytesConsumed += (len - extra_len);
    
    if (this->securityContextOutput[0].pvBuffer && this->securityContextOutput[0].cbBuffer)
    {
      assert(! extra_len);
      if (extra_len)
      {
        // ToDo:
        // ݂̎ł́A̓obt@ɖ̃f[^Ԃ
        // o̓f[^邱ƂłȂ
        this->unwrapResult.setError(HRESULT_FROM_WIN32(ERROR_INTERNAL_ERROR));
        return;
      }
      updateHandshakeStatus();
      this->unwrapResult.setValues(OK,
                                   getHandshakeStatus(),
                                   bytesConsumed,
                                   0
                                   );
      return;
    }

    // o̓f[^Ȃ
    if (SEC_I_CONTINUE_NEEDED == this->securityStatus)
    {
      // nhVFCNp
      if (extra_len)
      {
        // obt@̖f[^ēx InitializeSecurityContext()/AcceptSecurityContext() ɓn
        buff += (len - extra_len);
        len = extra_len;
      }
      else
      {
        break;
      }
    }
    else if (SEC_I_INCOMPLETE_CREDENTIALS == this->securityStatus && getUseClientMode())
    {
      // NCAgF؂vĂ
      // x InitializeSecurityContext() ĂяôŁAobt@̃f[^ʂ
      // ɖ߂
      bytesConsumed -= (len - extra_len);

      // [JؖꍇACredentials Handleč쐬
      if (this->pLocalCertificate)
      {
        // ݂CredentialsHandleJ
        assert(this->phCredential);
        FreeCredentialsHandle(this->phCredential);

        SCHANNEL_CRED sslCred = {0};
        sslCred.dwVersion = SCHANNEL_CRED_VERSION;

        // [Jؖݒ肷
        sslCred.cCreds = 1;
        sslCred.paCred = &this->pLocalCertificate;

        // NCAgF؂AT[oؖ̎؂Ȃ
        sslCred.dwFlags = SCH_CRED_USE_DEFAULT_CREDS | 
                            SCH_CRED_MANUAL_CRED_VALIDATION;

        // T|[gvgR
        sslCred.grbitEnabledProtocols = this->enabledProtocols;

        // SSPI NfV̎擾
        TimeStamp tsExpiry;
        this->securityStatus
          = pFunctions->AcquireCredentialsHandle(
                                    NULL, 
                                    UNISP_NAME, 
                                    SECPKG_CRED_OUTBOUND,
                                    NULL, 
                                    &sslCred, 
                                    NULL,
                                    NULL,
                                    this->phCredential,
                                    &tsExpiry);
        if (FAILED(this->securityStatus))
        {
          break;
        }
      }
      else
      {
        // InitializeSecurityContext()ɓntO ISC_REQ_USE_SUPPLIED_CREDSǉ
        // ------------------------------------------------------------------------------
        // http://www.derkeiler.com/Newsgroups/microsoft.public.platformsdk.security/2004-08/0187.html
        // #2
        // It can skip finding a client certificate, and just call
        // InitializeSecurityContext back, passing in the ISC_REQ_USE_SUPPLIED_CRED
        // flag. This will tell schannel to send the client certificate associated with
        // the passed in cred handle, regardless of whether the cred handle actually
        // contains a client certificate or not. If the credential doesn't contain a
        // client certificate, then the handshake is completed without sending it. 
        // ------------------------------------------------------------------------------
        // ÃtOǉȂĂ Windows Mobile 5.0͐ɓ삷
        iscAttributes |= ISC_REQ_USE_SUPPLIED_CREDS;

      }
    }
    else
    {
      break;
    }
  }

  // nhVF[NXe[^XXV
  if (! updateHandshakeStatus())
  {
    this->unwrapResult.setError(this->securityStatus);
  }
  else
  {
    this->unwrapResult.setValues((SEC_E_INCOMPLETE_MESSAGE == this->securityStatus) ? BUFFER_UNDERFLOW : OK,
                                 getHandshakeStatus(),
                                 bytesConsumed,
                                 0);
  }
}

/**
 * nhVFCNԂXV
 */
bool
SSLEngine::updateHandshakeStatus()
{
  // o͂ƂɕĂ܂
  if (isOutboundDone() && isInboundDone())
  {
    setHandshakeStatus(NOT_HANDSHAKING);
    return true;
  }

  if (! this->pPeerCertificate)
  {
    // ؖ𓾂
    SECURITY_STATUS ss
      = pFunctions->QueryContextAttributes(this->phContext,
                                SECPKG_ATTR_REMOTE_CERT_CONTEXT,
                                &this->pPeerCertificate);
    if (this->pPeerCertificate)
    {
      // ؖ̌؂KvȂ̂ŁANEED_TASKݒ肷
      this->delegatedTaskCount = 1;
      setHandshakeStatus(NEED_TASK);
      return true;
    }
  }

  // ނׂf[^ۗԂɂȂĂ
  if (this->securityContextOutput[0].pvBuffer && this->securityContextOutput[0].cbBuffer)
  {
    setHandshakeStatus(NEED_WRAP);
    return true;
  }

  SSLEngineHandshakeTrigger lht = getLastHandshakeTrigger();
  switch (lht)
  {
  case OUTBOUND_CLOSED:
    // 葤 close_notify 𑗐M
    {
      // ̎_ŏo̓f[^݂͂ȂȂĂ
      // (close_notify𑗐Mj
      setOutboundDone(true);

      if (isInboundDone())
      {
        // ̓f[^݂Ȃ̂ŁAnhVF[NI
        setHandshakeStatus(NOT_HANDSHAKING);
      }
      else
      {
        // ͂͐Ă̂ŁAclose_notify M
        setHandshakeStatus(NEED_UNWRAP);
      }
    }
    return true;

  case CLOSE_NOTIFY_RECEIVED:
    // close_notifyM
    {
      if (isOutboundDone())
      {
        // łɏo͂Ă邽߁AI
        // (close_notifyMς݁j
        setHandshakeStatus(NOT_HANDSHAKING);
      }
      else
      {
        // close_notify𑗂
        setHandshakeStatus(NEED_WRAP);
      }
    }
    return true;

  case HELLO_REQUEST:
    {
      // OInitializeSecurityContext() / AcceptSecurityContext() Ăяoʂ画f
      const SECURITY_STATUS ss = this->securityStatus;

      // I
      if (SEC_E_OK == ss)
      {
        // nhVFCN
        setHandshakeStatus(FINISHED);

        // Xg[TCY擾
        pFunctions->QueryContextAttributes(this->phContext, 
                                                     SECPKG_ATTR_STREAM_SIZES, 
                                                     &this->streamSizes);

        if (! this->peerCertificateChainLoaded)
        {
          // 葤݂̏ؖȂ
          if (! getUseClientMode() && ! getNeedClientAuth())
          {
            // ͕ؖsv
            return true;
          }
          else
          {
            // ؖK{Ȃ̂ɑ݂Ȃ
            this->securityStatus = SEC_E_INCOMPLETE_CREDENTIALS;
            return false;
          }
        }
        else
        {
          return true;
        }
      }

      if (SEC_I_INCOMPLETE_CREDENTIALS == ss)
      {
        // ̏Ԃ͑zO(unwrap()ŏłĂ͂j
        return false;
      }

      if (SEC_E_INCOMPLETE_MESSAGE == ss)
      {
        // lbg[Nf[^ǂޕKv
        setHandshakeStatus(NEED_UNWRAP);
        return true;
      }

      if (FAILED(ss))
      {
        // G[N
        return false;
      }

      // LȊȌꍇ́Albg[Nf[^ǂݍޕKv̂
      // NEED_UNWRAPݒ肷
      setHandshakeStatus(NEED_UNWRAP);
    }
    return true;
  
  default:
    assert(false);
    return false;
  }
}

/**
 * nhVF[NJn
 */
HRESULT
SSLEngine::beginHandshake()
{
  if (getHandshakeStatus() != NOT_HANDSHAKING || this->phCredential)
  {
    // nhVF[N͂łɊJnĂi܂͊Ăj
    return S_OK;
  }

  // CredHandleĂ
  this->phCredential = new CredHandle();
  SCHANNEL_CRED sslCred = {0};
  sslCred.dwVersion = SCHANNEL_CRED_VERSION;

  // [Jؖݒ肷
  if (! getUseClientMode() && this->pLocalCertificate)
  {
    sslCred.cCreds = 1;
    sslCred.paCred = &this->pLocalCertificate;
  }

  if (getUseClientMode())
  {
    // NCAgF؂ȂAT[oؖ̎؂Ȃ
    sslCred.dwFlags = SCH_CRED_NO_DEFAULT_CREDS | 
                      SCH_CRED_MANUAL_CRED_VALIDATION;
  }

  // T|[gvgR
  sslCred.grbitEnabledProtocols = this->enabledProtocols;

  // SSPI NfV̎擾
  TimeStamp tsExpiry;
  SECURITY_STATUS ss
    = pFunctions->AcquireCredentialsHandle(
                              NULL, 
                              UNISP_NAME, 
                              getUseClientMode() ? SECPKG_CRED_OUTBOUND : SECPKG_CRED_INBOUND,
                              NULL, 
                              &sslCred, 
                              NULL,
                              NULL,
                              this->phCredential,
                              &tsExpiry);

  if (SUCCEEDED(ss))
  {
    if (getUseClientMode())
    {
      // T[oClient hello𑗐MKv
      setHandshakeStatus(NEED_WRAP);
    }
    else
    {
      // NCAgClient helloMKv
      setHandshakeStatus(NEED_UNWRAP);
    }
  }
  else
  {
    // CredHandle폜
    ::FreeCredentialsHandle(this->phCredential);
    delete this->phCredential;
    this->phCredential = NULL;
  }

  return ss;
}

/**
 * Ϗ^XN݂邩Ԃ
 */
bool
SSLEngine::hasDelegatedTask() 
{
  return this->delegatedTaskCount > 0;
}

/**
 * Ϗ^XNꍇÃ^XNs
 */
SSLEngineTaskStatus
SSLEngine::executeDelegatedTask()
{
  if (! hasDelegatedTask())
  {
    // Ϗ^XN݂Ȃ
    assert(false);
    return TASK_ILLEGAL_STATE_ERROR;
  }

  acquireLock();

  // Ϗ^XNs
  // ̂Ƃ1ނ^XNȂ̂ŁAŒڎsĂ܂
  this->delegatedTaskCount = 0;

  // ؖ؂
  bool result = loadPeerCertificateChain();
  // nhVFCNXe[^XXV
  updateHandshakeStatus();


  releaseLock();

  if (! result)
  {
    return TASK_CERTIFICATE_VERIFY_ERROR;
  }

  return TASK_OK;
}

/**
 * w肳ꂽf[^Server hellołꍇA
 * Cipher suite킷R[h𒊏o
 */
bool
SSLEngine::parseServerHello(void* buff, int len)
{
  bool result = false;
  char* work = (char*) buff;
  if (len > 5)
  {
    if ((char) 0x16 == *work)
    {
      // handshake
      work += 3;
      unsigned short fragment_length = ((unsigned short) *work << 8) | (*(work+1) & 0xff);
      if (len >= 5 + fragment_length)
      {
        work += 2;
        if (0x02 == *work)
        {
          // server hello

          work += 4;  // Skip length (high, mid, low)
          this->protocolVersion = ((unsigned short) *work << 8) | (*(work + 1) & 0xff);

          work += 2 + 4 + 28;  // Skip gmt_unix_time and server_random.

          // Get session ID.
          this->sessionIDLength = (unsigned char) *work++;
          this->sessionID = new unsigned char[this->sessionIDLength];
          if (this->sessionID)
          {
            memcpy(this->sessionID, work, this->sessionIDLength);
          }

          work += this->sessionIDLength;

          // cipherSuite code.
          this->cipherSuiteCode = ((unsigned short) *work << 8) | (*(work + 1) & 0xff);

          result = true;
        }
      }
    }
  }
  return result;
}

/**
 * Ǒ̏ؖݒ肷
 */
void
SSLEngine::setLocalCertificate(PCCERT_CONTEXT localCert)
{
  // ͍쐬Ȃ
  this->pLocalCertificate = localCert;
}