/* common_funcs.cpp
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#include "StdAfx.h"
#include "common_funcs.h"

/**
 * JVM̃o[W
 */
static LARGE_INTEGER g_jvm_version;

/**
 * Temporary directory.
 */
static _TCHAR g_temp_dir[MAX_PATH + 1];

/**
 * vIȃG[Ƃ_CAO{bNX\A
 * vOI
 */
void
fatal_error (const _TCHAR * msg)
{
  if (msg == FATAL_ERROR_NO_MEMORY)
    {
      SHShowOutOfMemory (NULL, 0);
    }
  else
    {
      MessageBox (NULL, msg, _T ("Mysaifu JVM fatal error"), MB_OK);
    }
  exit (1);
}

/**
 * JVM̃o[WԂ
 */
LARGE_INTEGER
get_jvm_version ()
{
  if (!g_jvm_version.QuadPart)
    {
      // JVM̐mȃo[W擾
      HMODULE hModule = GetModuleHandle (NULL);
      _TCHAR filename[MAX_PATH + 1];
      GetModuleFileName (hModule, filename, MAX_PATH);
      DWORD cbBlock = GetFileVersionInfoSize (filename, 0);
      BYTE *pbBlock = (BYTE *) malloc (sizeof (BYTE) * cbBlock);
      if (pbBlock)
	{
	  GetFileVersionInfo (filename, 0, cbBlock, pbBlock);

	  LPVOID pvBuf = NULL;
	  UINT uLen = 0;
	  VerQueryValue ((const LPVOID) pbBlock, _T ("\\"), &pvBuf, &uLen);

	  VS_FIXEDFILEINFO *vfi = (VS_FIXEDFILEINFO *) pvBuf;

	  if (vfi->dwSignature == 0xfeef04bd)
	    {
	      g_jvm_version.HighPart = vfi->dwProductVersionMS;
	      g_jvm_version.LowPart = vfi->dwProductVersionLS;
	    }
	  free (pbBlock);
	}
    }
  return g_jvm_version;
}

/**
 * e|fBNgԂ
 */
const _TCHAR* get_temp_dir()
{
  if (g_temp_dir[0] == _T('\0'))
  {
    // Note : first call is not thread-safe.
    _TCHAR dir[MAX_PATH + 1];
    if (! GetTempPath (MAX_PATH, dir))
    {
      _tcscpy(g_temp_dir, _T("\\"));
    }
    else
    {
      _tcscpy(g_temp_dir, dir);
      int len = _tcslen (dir);
      if (len && dir[len - 1] != _T ('\\'))
      {
        g_temp_dir[len - 1] = _T ('\\');
      }
      _tcscat (g_temp_dir, _T ("Mysaifu JVM"));
      LONG attr = GetFileAttributes(g_temp_dir);
      if (-1 == attr || (! (attr & FILE_ATTRIBUTE_DIRECTORY)))
      {
        // create a directory
        if (! CreateDirectory (g_temp_dir, NULL))
        {
          _tcscpy(g_temp_dir, dir);
        }
      }
    }
  }
  return g_temp_dir;
}

//--- PermanentHeap
/**
 * Ǘp\
 *
 * permanent_heap_block
 *
   +-------+
   | next  |--------> +----+ 
   +-------+          |next| --> ...
   | limit |-----+    +----+
   +-------+     |    | 
   |current|-+   |
   +-------+ |   |
   |elem1  | |   |
   +-------+ |   |
   |elem2  | |   |
   +-------+ |   |
   |   <-+   |
   |       |     |
   +-------+<----+

 * {I header 1݂A󂫗̈悪Ԃɖ߂ĂA󂫗̈ɓȂꍇ
 * V header A`F[B
 * `F[Ȃ̂h߁AubNTCYȏ̃TCYvꂽꍇ́Amalloc()Ŋmۂʂ̂܂ܕԂ
 * ݂̂̊mۂsA`F[ȂB
 * ܂A󂫗̈悪setMinimumAllocationSize()Ŏw肵lȉɂȂubŃAΏۂ͂B
 * (̗̈悩烁͊mۂȂj
 */
struct permanent_heap_block
{
  permanent_heap_block *next;
  char *limit;
  char *current;
  // ̒Ƀf[^i[Ă
};

/**
 * OoCg̃TCYw肳ꂽꍇɕԂAhXpϐ
 */
static char g_zero_size_data;

/**
 * ؂グ
 */
#define ALIGN_UP(p, s) ((((p) % (s)) == 0) ? (p) : ((p) + ((s) - ((p) % (s)))))

/**
 * ubN̋󂫃TCYԂ
 * iɂȂ\邱ƂɒӁj
 */
#define REMAINS_IN_BLOCK(b) ((int) (b->limit - b->current + 1))

PermanentHeap::PermanentHeap (size_t blockSize):head (NULL),
minimumAllocationSize (0)
{
  this->blockSize = blockSize;
}

PermanentHeap::~PermanentHeap ()
{
  // PermanentHeap͊JłȂ
}

/**
 * v[p̃ubNmۂ
 */
permanent_heap_block *
PermanentHeap::allocateBlock ()
{
  permanent_heap_block *block =
    (permanent_heap_block *) calloc (1, this->getBlockSize ());
  block->next = NULL;
  block->limit = ((char *) block) + getBlockSize () - 1;
  block->current = (char *) (block + 1);

  return block;
}

/**
 * w肳ꂽTCỸmۂ
 */
void *
PermanentHeap::allocate (size_t size)
{
  char *result = NULL;

  if (size == 0)
    {
      // 0oCgmۂ̏ꍇɂ͏ɓ̃|C^Ԃ邪
      // ̌J͍sȂߖ͂Ȃi͂j
      return &g_zero_size_data;
    }
  if (size >= getBlockSize ())
    {
      // TCY傫̂ŁAmalloc()Œڊmۂ
      // iubN̊mۂ͍sȂj
      result = (char *) malloc (size);
    }
  else
    {
      // 󂫗̈TĂ
      if (!this->head)
	{
	  this->head = allocateBlock ();
	}
      permanent_heap_block *block = this->head;
      permanent_heap_block *prev_block = NULL;
      while (true)
	{
	  if (REMAINS_IN_BLOCK (block) >= (int) size)
	    {
	      // ubNmۂ
	      result = block->current;
	      block->current += ALIGN_UP (size, 8);	// 8oCgPʂɐ؂グ
	      if (REMAINS_IN_BLOCK (block) <
		  ((int) getMinimumAllocationSize ()))
		{
		  // trs߁Asize_t  int ɃLXgĂ
		  // 󂫗̈悪Ȃ̂ŁAΏۊOɂ
		  if (block == this->head)
		    {
		      // 擪ubN̏ꍇ
		      this->head = block->next;
		    }
		  else
		    {
		      assert (prev_block);
		      prev_block->next = block->next;
		    }

		}
	      break;
	    }
	  else
	    {
	      permanent_heap_block *next = block->next;
	      if (!next)
		{
		  // VubNm
		  next = allocateBlock ();
		  if (!next)
		    {
		      break;
		    }
		  block->next = next;
		}
	      prev_block = block;
	      block = next;
	    }
	}
    }
  return result;
}

