/* gnu_java_awt_peer_wce_WCERobotPeer.c
   Copyright (C) 2009 Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCERobotPeer.h>

#define InputEvent_BUTTON1_MASK 16
#define InputEvent_BUTTON2_MASK 8
#define InputEvent_BUTTON3_MASK 4

/*
 * Class:     gnu_java_awt_peer_wce_WCERobotPeer
 * Method:    mouseMove
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCERobotPeer_mouseMove
  (JNIEnv *env, jobject peer, jint x, jint y)
{
  mouse_event(MOUSEEVENTF_ABSOLUTE | MOUSEEVENTF_MOVE, x, y, 0, 0);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCERobotPeer
 * Method:    mousePress
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCERobotPeer_mousePress
  (JNIEnv *env, jobject peer, jint buttons)
{
  DWORD dwFlags = 0;
  if (buttons & InputEvent_BUTTON1_MASK)
  {
    dwFlags |= MOUSEEVENTF_LEFTDOWN;
  }
  if (buttons & InputEvent_BUTTON2_MASK)
  {
    dwFlags |= MOUSEEVENTF_RIGHTDOWN;
  }
  if (buttons & InputEvent_BUTTON3_MASK)
  {
    dwFlags |= MOUSEEVENTF_MIDDLEDOWN;
  }
  mouse_event(dwFlags, 0, 0, 0, 0);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCERobotPeer
 * Method:    mouseRelease
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCERobotPeer_mouseRelease
  (JNIEnv *env, jobject peer, jint buttons)
{
  DWORD dwFlags = 0;
  if (buttons & InputEvent_BUTTON1_MASK)
  {
    dwFlags |= MOUSEEVENTF_LEFTUP;
  }
  if (buttons & InputEvent_BUTTON2_MASK)
  {
    dwFlags |= MOUSEEVENTF_RIGHTUP;
  }
  if (buttons & InputEvent_BUTTON3_MASK)
  {
    dwFlags |= MOUSEEVENTF_MIDDLEUP;
  }
  mouse_event(dwFlags, 0, 0, 0, 0);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCERobotPeer
 * Method:    mouseWheel
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCERobotPeer_mouseWheel
  (JNIEnv *env, jobject peer, jint wheelAmt)
{
  mouse_event(MOUSEEVENTF_WHEEL, 0, 0, wheelAmt * WHEEL_DELTA, 0);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCERobotPeer
 * Method:    keyPress
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCERobotPeer_keyPress
  (JNIEnv *env, jobject peer, jint keycode)
{
  BYTE vk = convert_to_VK(keycode);
  if (vk == 255)
  {
    // invalid code
    jclass clazz = env->FindClass("java/lang/IllegalArgumentException");
    env->ThrowNew(clazz, "Invalid key code");
  }
  else
  {
    keybd_event(vk, 0, 0, 0);
  }
}

/*
 * Class:     gnu_java_awt_peer_wce_WCERobotPeer
 * Method:    keyRelease
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCERobotPeer_keyRelease
  (JNIEnv *env, jobject peer, jint keycode)
{
  BYTE vk = convert_to_VK(keycode);
  if (vk == 255)
  {
    // invalid code
    jclass clazz = env->FindClass("java/lang/IllegalArgumentException");
    env->ThrowNew(clazz, "Invalid key code");
  }
  else
  {
    keybd_event(vk, 0, KEYEVENTF_KEYUP, 0);
  }
}

/*
 * Class:     gnu_java_awt_peer_wce_WCERobotPeer
 * Method:    getRGBPixel
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCERobotPeer_getRGBPixel
  (JNIEnv *env, jobject, jint x, jint y)
{
  HDC hdcScreen = GetDC(NULL);
  if (! hdcScreen)
  {
    throw_AWTError_with_error_code(env, "GetDC(NULL) failed.", GetLastError());
    return 0;
  }

  COLORREF cref = GetPixel(hdcScreen, x, y);
  // COLORREF : 0x00bbggrr
  // Color    : 0xaarrggbb 
  jint result = (((cref & 0xff) << 16) & 0x00ff0000) | (cref & 0x0000ff00) | ((cref >> 16) & 0x000000ff) | 0xff000000;
  return result;
}

/*
 * Class:     gnu_java_awt_peer_wce_WCERobotPeer
 * Method:    getNativeRGBPixels
 * Signature: (IIII)[I
 */
JNIEXPORT jintArray JNICALL Java_gnu_java_awt_peer_wce_WCERobotPeer_getNativeRGBPixels
  (JNIEnv *env, jobject peer, jint x, jint y, jint width, jint height)
{
  // get the screen device context
  HDC hdcScreen = GetDC(NULL);
  if (! hdcScreen)
  {
    throw_AWTError_with_error_code(env, "GetDC(NULL) failed.", GetLastError());
    return NULL;
  }
  
  // create DIB section to capture screen image.
  BITMAPINFO bi = {0};
  bi.bmiHeader.biSize         = sizeof(BITMAPINFOHEADER);
  bi.bmiHeader.biBitCount     = 32;
  bi.bmiHeader.biCompression  = BI_RGB;
  bi.bmiHeader.biPlanes       = 1;
  bi.bmiHeader.biWidth        = width;
  bi.bmiHeader.biHeight       = -height;	// top down DIB
  BYTE* bits;
  HBITMAP bmp = CreateDIBSection(hdcScreen, &bi, DIB_RGB_COLORS, (VOID**) &bits, NULL, 0);
  if (! bmp)
  {
    throw_AWTError_with_error_code(env, "CreateCompatibleBitmap() failed.", GetLastError());
    ReleaseDC(NULL, hdcScreen);
    return NULL;
  }
  HDC hdcDest = CreateCompatibleDC(hdcScreen);
  if (! hdcDest)
  {
    throw_AWTError_with_error_code(env, "CreateCompatibleDC() failed.", GetLastError());
    DeleteObject(bmp);
    ReleaseDC(NULL, hdcScreen);
    return NULL;
  }

  // copy screen image to the bitmap.
  HGDIOBJ hOldBmp = SelectObject(hdcDest, bmp);
  BOOL bitBltResult = BitBlt(hdcDest, 0, 0, width, height, hdcScreen, 0, 0, SRCCOPY);
  if (! bitBltResult)
  {
    throw_AWTError_with_error_code(env, "BitBlt() failed.", GetLastError());
    DeleteObject(SelectObject(hdcDest, hOldBmp));
    ReleaseDC(NULL, hdcScreen);
    DeleteDC(hdcDest);
    return NULL;
  }
  SelectObject(hdcDest, hOldBmp);
  DeleteDC(hdcDest);
  
  // copy bitmap to the int array.
  int arraySize = width * height;
  jintArray result = env->NewIntArray(arraySize);
  if (result)
  {
    jint* p = env->GetIntArrayElements(result, NULL);
    if (p)
    {
      memcpy(p, bits, sizeof(jint) * arraySize);
      env->ReleaseIntArrayElements(result, p, 0);
    }
  }
  DeleteObject(bmp);
  ReleaseDC(NULL, hdcScreen);

  return result;
}

/*
 * Class:     gnu_java_awt_peer_wce_WCERobotPeer
 * Method:    dispose
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCERobotPeer_dispose
  (JNIEnv *env, jobject peer)
{
  // Do nothing
}