/* jvm.cpp
   Copyright (C) 2005, 2006 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#include <windows.h>
#include <stdio.h>
#include <commctrl.h>
#include <sipapi.h>
#include "stdafx.h"
#include "resource.h"
#include "class_loader.h"
#include "ClassFile.h"
#include "instruction.h"
#include "class_loader.h"
#include "monitor.h"
#include "java_utf8.h"
#include "jni_funcs.h"
#include "java_thread.h"
#include "common_funcs.h"
#include "console.h"
#include "arguments.h"
#include <Commdlg.h>
#include "folder_dialog.h"
#include "java_object.h"
#include "Profiler.h"

/**
 * V[gJbgfBNg
 */
#define SHORTCUT_DIRECTORY_FORMAT	_T("%s\\..\\recent")

/**
 * Rg[EChẼEChENX
 */
#define	CONTROLLER_WINDOW_CLASS_NAME	_T("Mysaifu JVM")

/**
 * Rg[EChEp̃bZ[W
 */
#define JVM_MESSAGE_START_JVM	(WM_APP+1)
#define JVM_MESSAGE_PREPARE		(WM_APP+2)

/**
 * ܂NĂȂƂɁAControllerWindowɐݒ肷^Cg
 */
#define	NOT_STARTED_TITLE	_T("Mysaifu JVM")

/**
 * arguments_CAO{bNX̃^Cg
 */
#define ARGUMENTS_DIALOG_TITLE	_T("Mysaifu JVM")

/**
 * CX^X
 */
static HINSTANCE g_hInstance;

/**
 * VMRuntime.exit()sς݂H
 */
static bool g_VMRuntime_exit_done;

/**
 * Rg[EChẼnh
 */
static HWND g_hwndController;

/**
 * Vbg_EtbNsꂽ
 */
static LONG g_shutdown_hooks_executed;

/**
 * CXbh
 */
DWORD WINAPI main_routine (LPVOID pvarg);

/**
 * argumentsV[gJbgfBNgǂݍ
 */
static int load_recent_arguments (const _TCHAR * shortcut_dir,
				  arguments *** args);
static arguments *load_arguments_from (const _TCHAR * filename);

/**
 * w肳ꂽ arguments V[gJbgƂĕۑ
 */
bool save_arguments (const _TCHAR * shortcut_dir, arguments * config);

/**
 * vOIɎsnh
 */
static void exit_handler ();

/**
 * ̓_CAO\
 */
static int show_arguments_dialog (HWND hwndOwner, arguments ** args);

/**b
 * Vbg_EtbNs
 */
static bool run_shutdown_hooks ();

/**
 * w肳ꂽXgr[ɁAVXevpeBǉ
 * ̃L[słɑ݂ĂꍇAeu
 */
static void put_system_property (HWND hwndListView, _TCHAR * key,
				 _TCHAR * value);

static void show_options_dialog (HWND hwndParent, arguments * args);

/**
 * t@C̊֘At
 */
static void init_file_associations ();

/**
 * ut@CJv_CAO\
 */
static BOOL get_open_file_name (OPENFILENAME * ofn);

/**
 * ut@Cۑv_CAO\
 */
static BOOL get_save_file_name (OPENFILENAME * ofn);

/**
 * R[obN֐
 */
LRESULT CALLBACK ControllerWindowProc (HWND hWnd, UINT message, WPARAM wParam,
				       LPARAM lParam);
LRESULT CALLBACK ArgumentsDialogProc (HWND hDlg, UINT message, WPARAM wParam,
				      LPARAM lParam);
LRESULT CALLBACK SystemPropertyEditorDialogProc (HWND hDlg, UINT message,
						 WPARAM wParam,
						 LPARAM lParam);
LRESULT CALLBACK JVMListDialogProc (HWND hDlg, UINT message, WPARAM wParam,
				    LPARAM lParam);
LRESULT CALLBACK AboutDialogProc (HWND hWnd, UINT message, WPARAM wParam,
				  LPARAM lParam);
BOOL CALLBACK EnumControllerWindowsProc (HWND hwnd, LPARAM lParam);

// Options_CAÕvpeBV[gy[W
LRESULT CALLBACK GeneralDialogProc (HWND hDlg, UINT message, WPARAM wParam,
				    LPARAM lParam);
LRESULT CALLBACK MemoryDialogProc (HWND hDlg, UINT message, WPARAM wParam,
				   LPARAM lParam);
LRESULT CALLBACK PropertiesDialogProc (HWND hDlg, UINT message, WPARAM wParam,
				       LPARAM lParam);
LRESULT CALLBACK VerifierDialogProc (HWND hDlg, UINT message, WPARAM wParam,
				     LPARAM lParam);
LRESULT CALLBACK MiscDialogProc (HWND hDlg, UINT message, WPARAM wParam,
				 LPARAM lParam);

// OptionsvpeBV[g̃R[obN
int PropSheetProc (HWND hwnd, UINT uMsg, LPARAM lParam);

/**
 * JVḾuRg[EChEṽnhԂ
 */
HWND get_JVM_controller_window ();

/**
 * VMRuntime.exit()̎sʒm
 */
void notify_VMRuntime_exit ();

/**
 * t@ĆuŏIXVtvr֐
 */
static int compare_last_write_time (WIN32_FIND_DATA * data1,
				    WIN32_FIND_DATA * data2);

#include <Cmnintrin.h>

/**
 * WinMain
 */
int WINAPI
WinMain (HINSTANCE hInstance,
	 HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
{
  // ̃_CAOI[vĂꍇ́ÃEChEɐ؂ւăAvP[VI
  {
    HWND hwndOtherJVM = FindWindow (_T ("Dialog"), ARGUMENTS_DIALOG_TITLE);
    if (hwndOtherJVM)
      {
	SetForegroundWindow (hwndOtherJVM);
	return 0;
      }
  }

  // hInstanceۑ
  g_hInstance = hInstance;

  // RRg[
  InitCommonControls ();

  // ̓_CAOSIPPREFRg[gpĂ邽߁AŏĂ
  SHInitExtraControls ();

  // gq .mysaifu ̃t@CɊ֘At
  init_file_associations ();

  // Rg[EChE쐬AbZ[W[vɓ
  WNDCLASS wc = { 0 };
  wc.lpfnWndProc = (WNDPROC) ControllerWindowProc;
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH);
  wc.hInstance = g_hInstance;
  wc.lpszClassName = CONTROLLER_WINDOW_CLASS_NAME;
  wc.hIcon = LoadIcon (g_hInstance, MAKEINTRESOURCE (IDI_MYSAIFU));

  if (!RegisterClass (&wc))
    {
      MessageBox (NULL,
		  _T ("Failed to register window class"),
		  _T ("Error"), MB_OK | MB_ICONERROR);
      return -1;
    }
  g_hwndController = CreateWindow (CONTROLLER_WINDOW_CLASS_NAME,
				   NOT_STARTED_TITLE,
				   WS_VISIBLE,
				   CW_USEDEFAULT,
				   CW_USEDEFAULT,
				   CW_USEDEFAULT,
				   CW_USEDEFAULT,
				   NULL, NULL, g_hInstance, NULL);

  if (g_hwndController == NULL)
    {
      MessageBox (NULL,
		  _T ("Failed to create controller window"),
		  _T ("Error"), MB_OK | MB_ICONERROR);
      return -1;
    }

  // JnbZ[W𑗂
  PostMessage (g_hwndController,
	       JVM_MESSAGE_PREPARE, NULL, (LPARAM) lpCmdLine);
  // bZ[W[v
  MSG msg;
  // bZ[W[v
  while (GetMessage (&msg, NULL, 0, 0) > 0)
    {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
    }
  return msg.wParam;
}


/**
 * w肳ꂽt@CNp[^[h
 */
static arguments *
load_arguments_from (const _TCHAR * filename)
{
  FILE *file = _tfopen (filename, _T ("r"));
  if (file)
    {
      // ő 4096 oCg܂œǂݍ߂
      _TCHAR target[4096];
      _fgetts (target, sizeof (target) / sizeof (*target), file);
      fclose (file);
      arguments *a = arguments_load (target);
      return a;
    }
  return NULL;
}

/**
 * argumentsrecentfBNgǂݍ
 */
static int
load_recent_arguments (const _TCHAR * recent_dir, arguments *** args)
{
  _TCHAR filename[MAX_PATH + 1];
  _stprintf (filename, _T ("%s\\*.mysaifujvm"), recent_dir);

  WIN32_FIND_DATA all_files[128];	// ő128̃t@C܂ŃT|[g
  WIN32_FIND_DATA find_data;
  HANDLE hFind = FindFirstFile (filename, &find_data);
  int count = 0;
  if (hFind != INVALID_HANDLE_VALUE)
    {
      do
	{
	  all_files[count] = find_data;
	  count++;
	}
      while (FindNextFile (hFind, &find_data)
	     && count < (sizeof (all_files) / sizeof (all_files[0])));
    }
  CloseHandle (hFind);


  // t@C̃^CX^vtɃ\[g
  qsort (all_files,
	 count,
	 sizeof (all_files[0]),
	 (int (*)(const void *, const void *)) compare_last_write_time);
  *args = (arguments **) realloc (*args, sizeof (arguments *) * (count + 1));
  int pos = 0;
  for (int i = 0; i < count; ++i)
    {
      WIN32_FIND_DATA find_data = all_files[i];
      _stprintf (filename, _T ("%s\\%s"), recent_dir, find_data.cFileName);
      arguments *a = load_arguments_from (filename);
      if (a)
	{
	  *(*args + pos) = a;
	  pos++;
	}
    }

  return pos;
}

/**
 * w肳ꂽ arguments recentfBNgzɕۑ
 */
static bool
save_arguments (const _TCHAR * recent_dir, arguments * args)
{
  // recent_dir ݂Ȃꍇ͍쐬
  WIN32_FIND_DATA find_data;
  HANDLE hFind = FindFirstFile (recent_dir, &find_data);
  if (hFind == INVALID_HANDLE_VALUE)
    {
      CreateDirectory (recent_dir, NULL);
    }
  CloseHandle (hFind);

  {
    // Version 0.1.0 ȑOł́A.lnk t@CƂč쐬ĂB
    // ̃t@C폜
    _TCHAR shortcut_name[MAX_PATH + 1];
    _sntprintf (shortcut_name,
		sizeof (shortcut_name) / sizeof (*shortcut_name),
		_T ("%s\\%s.lnk"), recent_dir, args->class_name);
    shortcut_name[MAX_PATH] = _T ('\0');
    DeleteFile (shortcut_name);
  }

  // ۑp̃t@C쐬
  // jart@C̎sw肳ꂽꍇAargs->class_name '\' ܂܂Ă
  // ̓t@Cɂ͎gȂ̂ _ Œu
  _TCHAR class_name[MAX_PATH + 1];
  _tcscpy (class_name, args->class_name);
  _TCHAR *work = class_name;
  while (*work)
    {
      if (*work == _T ('\\'))
	{
	  *work = _T ('_');
	}
      work++;
    }

  _TCHAR paramfile_name[MAX_PATH + 1];
  _sntprintf (paramfile_name,
	      sizeof (paramfile_name) / sizeof (*paramfile_name),
	      _T ("%s\\%s.mysaifujvm"), recent_dir, class_name);
  paramfile_name[MAX_PATH] = _T ('\0');
  // ̃t@C͍폜
  DeleteFile (paramfile_name);

  // t@Cɕۑ
  FILE *file = _tfopen (paramfile_name, _T ("w"));
  arguments_store (args, file);
  fclose (file);

  return true;
}

/**
 * RtBOʂ\
 */
static int
show_arguments_dialog (HWND hwndOwner, arguments ** args)
{
  // RtBO_CAO𐶐
  return DialogBoxParam (g_hInstance,
			 MAKEINTRESOURCE (IDD_CONFIG),
			 hwndOwner,
			 (DLGPROC) ArgumentsDialogProc, (LPARAM) args);

}

/**
 * Rg[EChE񋓃vV[W
 */
BOOL CALLBACK
EnumControllerWindowsProc (HWND hwnd, LPARAM lParam)
{
  _TCHAR classname[256];
  if (GetClassName
      (hwnd, classname, sizeof (classname) / sizeof (classname[0])))
    {
      if (_tcscmp (classname, CONTROLLER_WINDOW_CLASS_NAME) == 0)
	{
	  _TCHAR text[256];
	  // Rg[EChȄꍇAEChẼ^CgeLXg擾āA
	  // Xg{bNXɒǉ
	  // iRg[EChẼ^CǵACNX̖OɂȂĂj
	  if (SendMessage
	      (hwnd, WM_GETTEXT, (WPARAM) (sizeof (text) / sizeof (text[0])),
	       (LPARAM) text))
	    {
	      if (_tcscmp (text, NOT_STARTED_TITLE) != 0)
		{
		  HWND hwndList = (HWND) lParam;
		  // Xgr[ɃACeǉ
		  _TCHAR hwndstr[12];
		  _itot ((int) hwnd, hwndstr, 10);

		  LVITEM item = { 0 };
		  item.mask = LVIF_TEXT;
		  item.pszText = hwndstr;
		  SendMessage (hwndList, LVM_INSERTITEM, 0, (LPARAM) & item);

		  item.iSubItem = 1;
		  item.pszText = text;
		  SendMessage (hwndList, LVM_SETITEM, 0, (LPARAM) & item);
		}
	    }
	}
    }
  return TRUE;
}

/**
 * Xg{bNXőIĂJVM̃Rg[EChEɃbZ[W𑗂
 */
static void
send_message_to_controller_window (HWND hDlg, UINT message)
{
  HWND hwndList = GetDlgItem (hDlg, IDC_JVMLIST);
  int index = -1;
  while ((index = SendMessage (hwndList, LVM_GETNEXTITEM,	// Xg̃ACe
			       index,	// Jnʒu
			       LVNI_SELECTED)) != -1)
    {				// IĂACe
      LVITEM item = { 0 };
      item.mask = LVIF_TEXT;
      item.iItem = index;
      _TCHAR buff[256];
      item.pszText = buff;
      item.cchTextMax = sizeof (buff) / sizeof (*buff);
      if (SendMessage (hwndList, LVM_GETITEM, 0, (LPARAM) & item))
	{
	  SetCursor (LoadCursor (NULL, IDC_WAIT));
	  // bZ[W𑗂
	  HWND hwndController = (HWND) _ttoi (item.pszText);
	  if (hwndController)
	    {
	      SendMessage (hwndController, message, 0, 0);
	    }
	  SetCursor (NULL);
	}
    }
  // Xgr[XV
  SendMessage (hDlg, WM_COMMAND, (WPARAM) IDC_REFRESH, 0);
}

/**
 * JavaXbhJnASJavaXbh̏Iҋ@Xbh
 */
DWORD WINAPI
main_routine (LPVOID pvarg)
{
  arguments *config = (arguments *) pvarg;

  char main_class_name[256];
  class_loader *loader = get_bootstrap_class_loader ();
  if (config->jar)
    {
      convert_to_utf8 (config->jar_file_name, -1, main_class_name,
		       sizeof (main_class_name) /
		       sizeof (main_class_name[0]));
    }
  else
    {
      convert_to_utf8 (config->class_name, -1, main_class_name,
		       sizeof (main_class_name) /
		       sizeof (main_class_name[0]));
    }

  if (start_main_thread (main_class_name, config->argv, config->jar))
    {
      // f[XbhɂȂ܂ő҂
      HANDLE hTerminate = get_terminate_handle ();
      WaitForSingleObject (hTerminate, INFINITE);

    }
  else
    {
      // G[
      MessageBox (NULL,
		  _T ("Could not start main thread"),
		  _T ("Error"), MB_OK | MB_ICONERROR);
    }

  // Rg[EChEj
//      DestroyWindow(g_hwndController);
  SendMessage (g_hwndController, WM_CLOSE, 0, 0);

  return 0;
}

/**
 * exit()Ɏs
 */
static void
exit_handler ()
{
  // R\[N[Ŷ҂
  console_wait_for_close ();
}

/**
 * Vbg_EtbNsXbhs
 */
static bool
run_shutdown_hooks ()
{
  if (InterlockedCompareExchange
      (&g_shutdown_hooks_executed, (LONG) TRUE, (LONG) FALSE) == TRUE)
    {
      // łɎsς݂̏ꍇ͉Ƀ^[
      return false;
    }

  class_loader *loader = get_bootstrap_class_loader ();
  if (!loader)
    {
      return false;
    }

  // Vbg_EXbh쐬
  frame *frm = alloc_root_frame (NULL);
  if (!frm)
    {
      return false;
    }
  ClassFile *cfile = find_ClassFile (frm,
				     intern_utf8
				     ("java/lang/VMShutdownHookThread"));
  free_root_frame (frm);
  if (cfile == NULL)
    {
      return false;
    }

  // [gt[쐬
  frame *new_frame = alloc_root_frame (cfile);
  if (!new_frame)
    {
      return false;
    }

  // mۂAX^bNɐς
  jobject ref = alloc_object (cfile, new_frame);
  DUP_STACK (new_frame);	// RXgN^sp

  // RXgN^s
  jmethodID constructor = get_method_id (cfile,
					 intern_utf8 ("<init>"),
					 intern_utf8 ("()V"));
  method_info *constructor_info = get_method_info (cfile, constructor);
  invoke_method (new_frame, ref, cfile, constructor_info);

  // start() s
  jmethodID mid = get_method_id (cfile,
				 intern_utf8 ("start"),
				 intern_utf8 ("()V"));
  method_info *minfo = get_method_info (cfile, mid);
  cfile = minfo->declaring_ClassFile;
  invoke_method (new_frame, ref, cfile, minfo);
  if (exception_occurred (new_frame))
    {
      return false;
    }
  free_root_frame (new_frame);

  return true;
}

/**
 * Format heap memory usage
 */
static void
format_heap_usage (_TCHAR * buff, size_t bufflen, unsigned int max_heap_size,
		   bool show_heap_usage)
{
  _TCHAR *unit;
  unsigned int value;

  if (max_heap_size > 1024 * 1024)
    {
      unit = _T ("MB");
      value = max_heap_size / 1024 / 1024;
    }
  else if (max_heap_size > 1024)
    {
      unit = _T ("KB");
      value = max_heap_size / 1024;
    }
  else
    {
      unit = _T ("");
      value = max_heap_size;
    }

  _sntprintf (buff, bufflen, _T ("%d%s"), value, unit);
  if (show_heap_usage)
    {
      double max_memory = gc_get_max_memory ();
      double free_memory = gc_get_free_memory ();
      int usage = (int) ((max_memory - free_memory) * 100.0 / max_memory);
      _sntprintf (buff, bufflen, _T ("%d%s (%d%% used)"), value, unit, usage);
    }
}

/**
 * Rg[EChẼvV[W
 */
LRESULT CALLBACK
ControllerWindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  static HWND hwndMessage, hwndInformation;
  static SHACTIVATEINFO sai;
  static int max_heap_size_item_id;
  static unsigned int max_heap_size;
  static bool show_heap_usage;

  switch (message)
    {
    case WM_CREATE:
      {
	// Xe[^X\GA
	hwndMessage = CreateWindow (_T ("STATIC"),
                                    _T ("Initializing"),
                                    WS_CHILD | WS_VISIBLE,
                                    0, 50,	// ʒu
				    320,
                                    30,
                                    hWnd,
                                    0,
                                    g_hInstance,
                                    NULL);
	hwndInformation = CreateWindow (WC_LISTVIEW,
					_T (""),
					WS_VISIBLE | WS_BORDER | WS_CHILD |
					LVS_REPORT, 0, 90, 200, 100, hWnd, 0,
					g_hInstance, NULL);
	RECT rect;
	GetWindowRect (hwndInformation, &rect);
	LVCOLUMN lc = { 0 };
	lc.mask = LVCF_WIDTH | LVCF_TEXT;
	lc.cx = (rect.right - rect.left) / 2;
	lc.pszText = _T ("Name");
	ListView_InsertColumn (hwndInformation, 0, &lc);
	lc.cx = (rect.right - rect.left) - lc.cx;
	lc.pszText = _T ("Value");
	ListView_InsertColumn (hwndInformation, 1, &lc);
	sai.cbSize = sizeof (SHACTIVATEINFO);
      }
      break;

    case WM_SIZE:
      {
	// eR|[lg̃TCY𒲐
	RECT rectWindow;
	GetWindowRect (hWnd, &rectWindow);

	// bZ[W\GA
	RECT rectMessage;
	GetWindowRect (hwndMessage, &rectMessage);
	SetWindowPos (hwndMessage,
		      NULL,
		      0,
		      0,
		      (rectWindow.right - rectWindow.left),
		      rectMessage.bottom - rectMessage.top,
		      SWP_NOMOVE | SWP_NOZORDER);

	// \GA
	RECT rectInformation;
	GetWindowRect (hwndInformation, &rectInformation);
	POINT point;
	point.x = 0;
	point.y = rectMessage.bottom;
	ScreenToClient (hWnd, &point);
	SetWindowPos (hwndInformation, NULL, 0, point.y, (rectWindow.right - rectWindow.left), (rectWindow.bottom - rectMessage.bottom),	// bZ[WEChE̒ɒu
		      SWP_NOZORDER);

      }
      break;

    case WM_PAINT:
      {
	PAINTSTRUCT ps;
	HDC hDC = BeginPaint (hWnd, &ps);
	// Paint an Icon
	//HICON hIcon = LoadIcon (g_hInstance, MAKEINTRESOURCE (IDI_MYSAIFU));
	//DrawIcon (hDC, 10, 10, hIcon);
	//DestroyIcon (hIcon);

	// Paint a Bitmap
	HBITMAP hBitmap =
	  LoadBitmap (g_hInstance, MAKEINTRESOURCE (IDB_TITLE));
	BITMAP bmp;
	GetObject (hBitmap, sizeof (BITMAP), &bmp);
	HDC hCompatible = CreateCompatibleDC (hDC);
	SelectObject (hCompatible, hBitmap);
	BitBlt (hDC,
		46,
		10, bmp.bmWidth, bmp.bmHeight, hCompatible, 0, 0, SRCCOPY);
	DeleteDC (hCompatible);
	DeleteObject (hBitmap);
	EndPaint (hWnd, &ps);
      }
      break;

    case WM_ACTIVATE:
      SHHandleWMActivate (hWnd, wParam, lParam, &sai, FALSE);
      break;

    case WM_SETTINGCHANGE:
      SHHandleWMSettingChange (hWnd, wParam, lParam, &sai);
      break;

    case JVM_MESSAGE_PREPARE:
      // 
      {
	const _TCHAR *lpCmdLine = (const _TCHAR *) lParam;
	// arguments
	arguments *args;
	init_arguments_settings ();

	// p[X
	if (_tcslen (lpCmdLine) == 0)
	  {
	    // Ȃ̏ꍇɂ́ARtBOʂ\
	    if (!show_arguments_dialog (g_hwndController, &args))
	      {
		// I
		DestroyWindow (hWnd);
		break;
	      }
	  }
	else
	  {
	    if (_tcsncmp (lpCmdLine, _T ("-Xconfig "), 9) == 0)
	      {
		// -XconfigIvV
		// ̈RtBOt@C
		lpCmdLine += 9;
		args = load_arguments_from (lpCmdLine);
	      }
	    else
	      {
		args = arguments_load (lpCmdLine);
	      }

	    if (!args)
	      {
		MessageBox (NULL,
			    _T ("Invalid arguments."),
			    _T ("Mysaifu JVM error"), MB_OK | MB_ICONERROR);
		DestroyWindow (hWnd);
		break;
	      }
	  }

	// -jar IvVw肳ꂽꍇACLASSPATHjart@Cݒ肷
	if (args->jar)
	  {
	    size_t jar_file_name_len = _tcslen (args->jar_file_name);
	    args->classpath =
	      (_TCHAR *) realloc (args->classpath,
				  sizeof (_TCHAR) * (jar_file_name_len + 1));
	    _tcscpy (args->classpath, args->jar_file_name);
	  }

	// R\[
	console_init (g_hInstance, hWnd, args->use_stdio);


	// JVMJnControllerWindowɎw
	PostMessage (g_hwndController,
		     JVM_MESSAGE_START_JVM, NULL, (LPARAM) args);
      }
      break;

    case JVM_MESSAGE_START_JVM:
      {
	arguments *config = (arguments *) lParam;

	// Jgargumentsݒ肷
	set_current_arguments (config);

	// ControllerWindow̃^CgύX
	SetWindowText (hWnd, config->class_name);

	// EChE̕\^\肷
	if (config->hide_vm_window)
	  {
	    ShowWindow (hWnd, SW_HIDE);
	  }
	else
	  {
	    // j[o[쐬
	    SHMENUBARINFO mbi = { 0 };
	    mbi.cbSize = sizeof (SHMENUBARINFO);
	    mbi.hwndParent = hWnd;
	    mbi.nToolBarId = IDR_MAINMENUBAR;
	    mbi.hInstRes = g_hInstance;
	    mbi.dwFlags = SHCMBF_HMENU;

	    if (SHCreateMenuBar (&mbi))
	      {
		RECT rc;
		RECT rcMenuBar;
		GetWindowRect (hWnd, &rc);
		GetWindowRect (mbi.hwndMB, &rcMenuBar);
		rc.bottom -= (rcMenuBar.bottom - rcMenuBar.top);
		MoveWindow (hWnd,
			    rc.left,
			    rc.top,
			    rc.right - rc.left, rc.bottom - rc.top, FALSE);
	      }

	    ShowWindow (hWnd, SW_SHOW);
	    UpdateWindow (hWnd);
	    SetForegroundWindow (hWnd);
	  }

	// Ot@C쐬
	if (_tcslen (config->logfile) > 0)
	  {
	    HANDLE hFile = CreateFile (config->logfile,
				       GENERIC_WRITE,
				       FILE_SHARE_READ | FILE_SHARE_WRITE,
				       NULL,
				       OPEN_ALWAYS,
				       0,
				       NULL);
	    if (hFile == INVALID_HANDLE_VALUE)
	      {
		// t@CI[vs
		MessageBox (hWnd,
			    _T ("Failed to open logfile"),
			    _T ("Mysaifu JVM error"), MB_OK | MB_ICONERROR);
	      }
	    else
	      {
		if (GetLastError () != ERROR_ALREADY_EXISTS)
		  {
		    // t@C擪ɃoCgI[_[}[No͂
		    _TCHAR bom = (_TCHAR) 0xFEFF;
		    DWORD count;
		    WriteFile (hFile, &bom, sizeof (bom), &count, NULL);
		  }
		console_set_logfile (hFile);
	      }
	  }

	// R\[\
	if (config->show_console)
	  {
	    console_set_visible (true);
	  }
	SendMessage (hwndMessage, WM_SETTEXT, 0, NULL);

	// JVM̏Jn
	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing..."));

	// UTF-8Ɋւ
	// iԐɏĂKvj
	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing utf8 settings"));
        UpdateWindow(hwndMessage);
	init_utf8_settings ();

	// ̑̏{
	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing thread settings"));
        UpdateWindow(hwndMessage);
	init_thread_settings (config->native_stack_size);

	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing boot classpath"));
        UpdateWindow(hwndMessage);
	init_boot_classpath (config->boot_classpath);

	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing system classpath"));
        UpdateWindow(hwndMessage);
        init_system_classpath (config->classpath);

	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing heap"));
        UpdateWindow(hwndMessage);
        initialize_heap (config->max_heap_size);

	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing ClassFile settings"));
        UpdateWindow(hwndMessage);
        init_ClassFile_settings ();

	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing ClassLoader"));
        UpdateWindow(hwndMessage);
        init_class_loader_settings (config->verify_mode,
				    config->annotation_mode);

        SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing monitor"));
        UpdateWindow(hwndMessage);
	init_monitor_settings ();

	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing instruction settings"));
        UpdateWindow(hwndMessage);
        init_instruction_settings ();

	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing JNI functions"));
        UpdateWindow(hwndMessage);
        init_jni_funcs ();

	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing Java frame"));
        UpdateWindow(hwndMessage);
        init_frame_settings (config->java_stack_size);

	// assertion̗L^ݒ肷
	set_assertion_status (config->enableAssertions);

	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing GC"));
        UpdateWindow(hwndMessage);
	if (!init_gc ())
	  {
	    // Kx[WRN^̏Ɏs
	    DBG (_T ("Failed to initialize GC.\n"));
	    MessageBox (NULL,
			_T ("Failed to initialize GC."),
			_T ("Error"), MB_OK | MB_ICONERROR);
	    DestroyWindow (hWnd);
	    return 0;		// s
	  }

	// -verbose:gcIvVݒ
	gc_set_verbose (config->verbose_gc);

	// Kx[WRN^Ot@Cݒ
	set_loggc_filename (config->loggc);

	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("Initializing Finalizer"));
        UpdateWindow(hwndMessage);
	if (!init_finalizer ())
	  {
	    // t@CiCȔɎs
	    DBG (_T ("Failed to initialize finalizer thread.\n"));
	    MessageBox (NULL,
			_T ("Failed to initialize finalizer thread."),
			_T ("Error"), MB_OK | MB_ICONERROR);

	    DestroyWindow (hWnd);
	    return 0;		// s
	  }

	// OutOfMemoryErrorStackOverflowError쐬Ă
	if (!prepare_OutOfMemoryError () || !prepare_StackOverflowError ())
	  {
	    // Ɏs
	    DBG (_T ("Failed to prepare OutOfMemoryError.\n"));
	    MessageBox (NULL,
			_T
			("Faild to create a instance of OutOfMemoryError.\n"),
			_T ("Error"), MB_OK | MB_ICONERROR);
	    DestroyWindow (hWnd);
	    return 0;		// s
	  }

	// CXbhJn
	CreateThread (NULL, 0, main_routine, config, 0, NULL);

	// JVM̑sJnƂ\
	SendMessage (hwndMessage, WM_SETTEXT, 0,
		     (LPARAM) _T ("JVM is running"));
	UpdateWindow (hwndMessage);

	// exit()nho^
	atexit (exit_handler);

	// sNX̏\
	LVITEM item = { 0 };
	item.mask = LVIF_TEXT;

	// NXi܂jart@C)
	item.iSubItem = 0;
	if (config->jar)
	  {
	    item.pszText = _T ("Jar file");
	  }
	else
	  {
	    item.pszText = _T ("Class name");
	  }
	ListView_InsertItem (hwndInformation, &item);

	item.iSubItem = 1;
	item.pszText = config->class_name;
	ListView_SetItem (hwndInformation, &item);

	// R}hC
	item.iItem++;
	item.iSubItem = 0;
	item.pszText = _T ("Command line");
	ListView_InsertItem (hwndInformation, &item);

	item.iSubItem = 1;
	item.pszText = config->argv;
	ListView_SetItem (hwndInformation, &item);

	// Classpath
	if (!config->jar)
	  {
	    item.iItem++;
	    item.iSubItem = 0;
	    item.pszText = _T ("Classpath");
	    ListView_InsertItem (hwndInformation, &item);

	    item.iSubItem = 1;
	    item.pszText = config->classpath;
	    ListView_SetItem (hwndInformation, &item);
	  }

	// JgfBNg
	item.iItem++;
	item.iSubItem = 0;
	item.pszText = _T ("Current directory");
	ListView_InsertItem (hwndInformation, &item);

	item.iSubItem = 1;
	item.pszText = config->current_directory;
	ListView_SetItem (hwndInformation, &item);

	// őq[vTCY
	item.iItem++;
	item.iSubItem = 0;
	item.pszText = _T ("Max heap size");
	ListView_InsertItem (hwndInformation, &item);

	max_heap_size_item_id = item.iItem;
	max_heap_size = config->max_heap_size;
	show_heap_usage = config->show_current_heap_usage;

	item.iSubItem = 1;
	_TCHAR buff[32];
	format_heap_usage (buff, sizeof (buff) / sizeof (buff[0]),
			   max_heap_size, show_heap_usage);
	item.pszText = buff;
	ListView_SetItem (hwndInformation, &item);

	// JTCY߂
	ListView_SetColumnWidth (hwndInformation, 0, LVSCW_AUTOSIZE);
	ListView_SetColumnWidth (hwndInformation, 1, LVSCW_AUTOSIZE);

	if (config->show_current_heap_usage)
	  {
	    SetTimer (hWnd, 1, 1000, NULL);
	  }
      }
      break;

    case WM_TIMER:
      {
	// Update current memory usage
	_TCHAR buff[32];
	format_heap_usage (buff, sizeof (buff) / sizeof (buff[0]),
			   max_heap_size, show_heap_usage);
	ListView_SetItemText (hwndInformation, max_heap_size_item_id, 1,
			      buff);
      }
      break;

    case WM_CLOSE:
      {
	if (g_VMRuntime_exit_done)
	  {
	    // Rg[EChEj
	    DestroyWindow (hWnd);
	  }
	else
	  {
	    // Vbg_EtbNs
	    run_shutdown_hooks ();
	  }
      }
      break;

    case WM_DESTROY:
      {
#ifdef ENABLE_PROFILER
        Profiler::writeAllProfiles();
#endif
	// exit process.
	PostQuitMessage (0);
      }
      break;

    case WM_COMMAND:
      {
	switch (LOWORD (wParam))
	  {
	  case IDC_SHOWCONSOLE:
	    {
	      // R\[\
	      console_set_visible (true);
	    }
	    break;
	  case IDC_EXITJVM:
	    {
	      // mF_CAO\AOK^bvꂽ_JVMI
	      if (IDOK == MessageBox (hWnd,
				      _T ("Exit JVM?"),
				      _T ("Confirm"),
				      MB_OKCANCEL | MB_ICONQUESTION))
		{
//                                              DestroyWindow(hWnd);
		  PostMessage (hWnd, WM_CLOSE, 0, 0);
		}
	    }
	    break;

	  case IDM_ABOUT:
	    {
	      // About_CAO\
	      DialogBox (g_hInstance,
			 MAKEINTRESOURCE (IDD_ABOUT),
			 hWnd, (DLGPROC) AboutDialogProc);
	    }
	    break;
	  }
      }
      break;

    default:
      return DefWindowProc (hWnd, message, wParam, lParam);
    }

  return 1;
}

/**
 * JVMXg_CAÕvV[W
 */
LRESULT CALLBACK
JVMListDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message)
    {
    case WM_INITDIALOG:
      {
	// _CAO{bNXő剻
	SHINITDLGINFO shidi = { 0 };
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags =
	  SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN |
	  SHIDIF_EMPTYMENU;
	shidi.hDlg = hDlg;
	SHInitDialog (&shidi);

	// Xgr[
	HWND hwndListView = GetDlgItem (hDlg, IDC_JVMLIST);
	HDC hDC = GetDC (hwndListView);

	SIZE size;
	GetTextExtentPoint (hDC, _T ("0000000000"), 10, &size);
	ReleaseDC (hwndListView, hDC);
	RECT rect;
	GetClientRect (hwndListView, &rect);

	LVCOLUMN lc = { 0 };
	lc.mask = LVCF_WIDTH | LVCF_TEXT;
	lc.cx = size.cx;
	lc.pszText = _T ("ID");
	SendMessage (hwndListView, LVM_INSERTCOLUMN, 0, (LPARAM) & lc);
	lc.cx = (rect.right - rect.left) - size.cx - 2;
	lc.pszText = _T ("Class name");
	SendMessage (hwndListView, LVM_INSERTCOLUMN, 1, (LPARAM) & lc);


	// Rg[EChE񋓂āAXgɒǉ
	HWND hwndList = GetDlgItem (hDlg, IDC_JVMLIST);
	EnumWindows (EnumControllerWindowsProc, (LPARAM) hwndList);

      }
      return TRUE;

    case WM_NOTIFY:
      if (wParam == IDC_JVMLIST)
	{
	  LV_DISPINFO *lvinfo = (LV_DISPINFO *) lParam;
	  switch (lvinfo->hdr.code)
	    {
	    case LVN_ITEMCHANGED:
	      {
		int index = SendMessage (GetDlgItem (hDlg, IDC_JVMLIST),
					 LVM_GETNEXTITEM,	// Xg̃ACe
					 -1,	// Xg̐擪猟
					 LVNI_SELECTED);	// IĂACe
		if (index == -1)
		  {
		    EnableWindow (GetDlgItem (hDlg, IDC_EXITJVM), FALSE);
		  }
		else
		  {
		    EnableWindow (GetDlgItem (hDlg, IDC_EXITJVM), TRUE);
		  }
	      }
	      return TRUE;
	    }
	}
      break;

    case WM_COMMAND:
      switch (LOWORD (wParam))
	{
	case IDOK:
	  {
	    // _CAOI
	    EndDialog (hDlg, LOWORD (wParam));
	    return TRUE;
	  }
	case IDC_EXITJVM:
	  // Rg[EChE WM_CLOSE bZ[W𑗂
	  send_message_to_controller_window (hDlg, WM_CLOSE);
	  return TRUE;

	case IDC_REFRESH:
	  {
	    HWND hwndList = GetDlgItem (hDlg, IDC_JVMLIST);
	    SendMessage (hwndList, LVM_DELETEALLITEMS, 0, 0);
	    EnumWindows (EnumControllerWindowsProc, (LPARAM) hwndList);
	    EnableWindow (GetDlgItem (hDlg, IDC_EXITJVM), FALSE);
	  }
	  return TRUE;
	}
    }
  return FALSE;
}

/**
 * About_CAÕvV[W
 */
LRESULT CALLBACK
AboutDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message)
    {
    case WM_INITDIALOG:
      {
	// _CAO{bNXő剻
	SHINITDLGINFO shidi = { 0 };
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags =
	  SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN |
	  SHIDIF_EMPTYMENU;
	shidi.hDlg = hDlg;
	SHInitDialog (&shidi);

	LARGE_INTEGER version = get_jvm_version ();
	// 16rbgƂɋ؂ĕ쐬
	jstring result = NULL;
	_TCHAR buff[128];
	_sntprintf (buff,
		    sizeof (buff) / sizeof (*buff),
		    _T ("Version %d.%d.%d.%d"),
		    HIWORD (version.HighPart),
		    LOWORD (version.HighPart),
		    HIWORD (version.LowPart), LOWORD (version.LowPart));
	SetWindowText (GetDlgItem (hDlg, IDC_VERSION), buff);
#ifdef DEBUG
        SetWindowText (GetDlgItem (hDlg, IDC_BUILDTYPE), _T("Debug build"));
#else
        SetWindowText (GetDlgItem (hDlg, IDC_BUILDTYPE), _T("Release build"));
#endif
      }
      return TRUE;

    case WM_COMMAND:
      switch (LOWORD (wParam))
	{
	case IDOK:
	  {
	    // _CAOI
	    EndDialog (hDlg, LOWORD (wParam));
	    return TRUE;
	  }
	}
    }
  return FALSE;
}

/**
 * ݒ_CAÕvV[W
 */
LRESULT CALLBACK
ArgumentsDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  // \̂Rg[Ƀf[^Rs[}N
#define COPY_FROM_CONTROLS(args) \
	{ \
		HWND hwndClassName = GetDlgItem(hDlg, IDC_CLASSNAME); \
		BOOL jar = (SendMessage(GetDlgItem(hDlg, IDC_TYPE), \
								CB_GETCURSEL, \
								0, \
								0) == 0); \
		if (jar) { \
			/* jarIvVLȏꍇ */ \
			args->jar = true; \
			/* jart@C擾 */  \
			GetWindowText(hwndClassName, \
						  args->jar_file_name, \
						  sizeof(args->jar_file_name) / sizeof(*args->jar_file_name)); \
		} else { \
			args->jar = false; \
			/* NX */ \
			GetWindowText(hwndClassName, \
						  args->class_name, \
						  (sizeof(args->class_name) / sizeof(*args->class_name))); \
		} \
		\
		/* R\[\邩 */ \
		HWND hwndShowConsole = GetDlgItem(hDlg, IDC_SHOWCONSOLE); \
		if (SendMessage(hwndShowConsole, BM_GETCHECK, 0, 0)) { \
			args->show_console = true; \
		} else { \
			args->show_console = false; \
		} \
	}
#define COPY_TO_CONTROLS(args) \
	{ \
		HWND hwndClassName = GetDlgItem(hDlg, IDC_CLASSNAME); \
		HWND hwndType = GetDlgItem(hDlg, IDC_TYPE); \
		HWND hwndBrowse = GetDlgItem(hDlg, IDC_BROWSE); \
		if (args->jar) { \
			/* jarIvVLȏꍇ */ \
			SendMessage(hwndType, \
						CB_SETCURSEL, \
						0, \
						0); \
			SetWindowText(hwndClassName, args->jar_file_name); \
			EnableWindow(hwndBrowse, TRUE); \
		} else { \
			SendMessage(hwndType, \
						CB_SETCURSEL, \
						1, \
						0); \
			SetWindowText(hwndClassName, args->class_name); \
			EnableWindow(hwndBrowse, FALSE); \
		} \
		if (GetWindowTextLength(hwndClassName)) { \
			EnableWindow(GetDlgItem(hDlg, IDC_EXECUTE), TRUE); \
		} \
		/* R\[\邩 */ \
		HWND hwndShowConsole = GetDlgItem(hDlg, IDC_SHOWCONSOLE); \
		if (args->show_console) { \
			SendMessage(hwndShowConsole, BM_SETCHECK, BST_CHECKED, 0); \
		} else { \
			SendMessage(hwndShowConsole, BM_SETCHECK, BST_UNCHECKED, 0); \
		} \
	}

  static arguments **result;
  static arguments *args;
  static arguments **selectable_configs;
  static int selectable_count;
  static _TCHAR shortcut_dir[MAX_PATH + 1];
  static SHMENUBARINFO mbi = { 0 };
  switch (message)
    {
    case WM_INITDIALOG:
      {
	// _CAO{bNXő剻
	SHINITDLGINFO shidi = { 0 };
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags = SHIDIF_SIZEDLGFULLSCREEN;
	shidi.hDlg = hDlg;
	SHInitDialog (&shidi);

	// j[o[ǉ
	mbi.cbSize = sizeof (SHMENUBARINFO);
	mbi.hwndParent = hDlg;
	mbi.nToolBarId = IDR_MENUBAR;
	mbi.hInstRes = g_hInstance;
	mbi.dwFlags = SHCMBF_HMENU;

	SHCreateMenuBar (&mbi);

	SetWindowText (hDlg, _T ("Mysaifu JVM"));
	result = (arguments **) lParam;
	args = arguments_create ();

	// qXgǂݍ
	_sntprintf (shortcut_dir,
		    sizeof (shortcut_dir) / sizeof (shortcut_dir[0]),
		    SHORTCUT_DIRECTORY_FORMAT, get_java_home ());
	shortcut_dir[sizeof (shortcut_dir) / sizeof (shortcut_dir[0]) - 1] =
	  _T ('\0');
	selectable_count =
	  load_recent_arguments (shortcut_dir, &selectable_configs);

	// Xg{bNXɒǉ
	HWND hwndList = GetDlgItem (hDlg, IDC_RECENT_LIST);
	int max_width = 0;
	HDC hdc = GetDC (hwndList);
	for (int i = 0; i < selectable_count; ++i)
	  {
	    const _TCHAR *class_name = selectable_configs[i]->class_name;
	    SIZE width;
	    GetTextExtentPoint (hdc, class_name, _tcslen (class_name),
				&width);
	    if (width.cx > max_width)
	      {
		max_width = width.cx;
	      }
	    SendMessage (hwndList, LB_ADDSTRING, 0, (LPARAM) class_name);
	  }
	SendMessage (hwndList, LB_SETHORIZONTALEXTENT, (WPARAM) max_width, 0);
	ReleaseDC (hwndList, hdc);

	// TypeR{{bNX
	HWND hwndCombo = GetDlgItem (hDlg, IDC_TYPE);
	SendMessage (hwndCombo, CB_ADDSTRING, 0, (LPARAM) _T ("JAR file"));
	SendMessage (hwndCombo, CB_ADDSTRING, 0, (LPARAM) _T ("Class"));

	// arguments̓e𔽉f
	COPY_TO_CONTROLS (args);
      }
      return TRUE;

    case WM_INITMENUPOPUP:
      {
	// Save AS... j[̗L^؂ւ
	BOOL enabled =
	  GetWindowTextLength (GetDlgItem (hDlg, IDC_CLASSNAME)) > 0;
	EnableMenuItem ((HMENU) wParam, IDM_SAVE_AS,
			MF_BYCOMMAND | (enabled ? MF_ENABLED : MF_GRAYED));
      }
      return TRUE;

    case WM_CLOSE:
      EndDialog (hDlg, 0);
      return TRUE;

    case WM_COMMAND:
      switch (LOWORD (wParam))
	{
	case IDC_CLASSNAME:
	  // NX
	  if (HIWORD (wParam) == EN_CHANGE)
	    {
	      HWND hwndClassName = (HWND) lParam;
	      HWND hwndExecute = GetDlgItem (hDlg, IDC_EXECUTE);
	      if (GetWindowTextLength (hwndClassName))
		{
		  EnableWindow (hwndExecute, TRUE);
		}
	      else
		{
		  EnableWindow (hwndExecute, FALSE);
		}
	    }
	  break;

	case IDC_RECENT_LIST:
	  switch (HIWORD (wParam))
	    {
	    case LBN_SELCHANGE:
	      {
		// Xg{bNXIꂽ
		int select = SendMessage (GetDlgItem (hDlg, IDC_RECENT_LIST),
					  LB_GETCURSEL,
					  0,
					  0);
		if (select != -1)
		  {
		    args = selectable_configs[select];
		    // eRg[
		    HWND hwndType = GetDlgItem (hDlg, IDC_TYPE);
		    HWND hwndClassName = GetDlgItem (hDlg, IDC_CLASSNAME);
		    if (args->jar)
		      {
			// jarIvVLȏꍇ
			SendMessage (hwndType, CB_SETCURSEL, (WPARAM) 0, 0);

			// Browse{^L
			EnableWindow (GetDlgItem (hDlg, IDC_BROWSE), TRUE);

			// jart@Cݒ肷
			SetWindowText (hwndClassName, args->jar_file_name);

		      }
		    else
		      {
			// ʏ̃NX
			SendMessage (hwndType, CB_SETCURSEL, (WPARAM) 1, 0);

			// Browse{^𖳌
			EnableWindow (GetDlgItem (hDlg, IDC_BROWSE), FALSE);

			// NXݒ肷
			SetWindowText (hwndClassName, args->class_name);
		      }

		    // R\[\邩
		    HWND hwndShowConsole = GetDlgItem (hDlg, IDC_SHOWCONSOLE);
		    if (args->show_console)
		      {
			SendMessage (hwndShowConsole, BM_SETCHECK,
				     BST_CHECKED, 0);
		      }
		    else
		      {
			SendMessage (hwndShowConsole, BM_SETCHECK,
				     BST_UNCHECKED, 0);
		      }
		  }
		BOOL enabled = FALSE;
		if (GetWindowTextLength (GetDlgItem (hDlg, IDC_CLASSNAME)))
		  {
		    enabled = TRUE;
		  }
		HWND hwndExecute = GetDlgItem (hDlg, IDC_EXECUTE);
		if (enabled != IsWindowEnabled (hwndExecute))
		  {
		    EnableWindow (hwndExecute, enabled);
		  }
	      }
	      return TRUE;
	    }
	  break;

	case IDC_BROWSE:
	  {
	    // jart@C̑Iʂ\
	    _TCHAR filename[MAX_PATH + 1];
	    filename[0] = _T ('\0');
	    OPENFILENAME ofn = { 0 };
	    ofn.hwndOwner = hDlg;
	    ofn.lpstrFilter = _T ("JAR file (*.jar)\0*.jar\0\0");
	    ofn.lpstrFile = filename;
	    ofn.nMaxFile = sizeof (filename) / sizeof (*filename);
	    ofn.lStructSize = sizeof (OPENFILENAME);
	    if (get_open_file_name (&ofn))
	      {
		// Rg[ɒlݒ肷
		SetDlgItemText (hDlg, IDC_CLASSNAME, filename);
		// Execute{^Lɂ
		EnableWindow (GetDlgItem (hDlg, IDC_EXECUTE), TRUE);
	      }
	  }
	  return TRUE;

	case IDM_EXIT:
	  {
	    // j[o[j
	    DestroyWindow (mbi.hwndMB);

	    // _CAOI
	    SendMessage (hDlg, WM_CLOSE, 0, 0);

	    // ̒ɃvZX͏ÎŁA
	    // ̊J͍sȂ

	  }
	  return TRUE;

	case IDC_EXECUTE:
	  // JVMN
	  {
	    // Rg[ݒlRs[
	    COPY_FROM_CONTROLS (args);

	    // argumentsۑ
	    save_arguments (shortcut_dir, args);

	    // J
	    for (int i = 0; i < selectable_count; ++i)
	      {
		arguments *a = selectable_configs[i];
		if (a != args)
		  {
		    arguments_delete (a);
		  }
	      }
	    free (selectable_configs);

	    // ʂԂ
	    *result = args;

	    // j[o[j
	    DestroyWindow (mbi.hwndMB);

	    // _CAOI
	    EndDialog (hDlg, 1);
	  }
	  return TRUE;

	case IDC_TYPE:
	  switch (HIWORD (wParam))
	    {
	    case CBN_SELCHANGE:
	      {
		// R{{bNXIꂽ
		int select =
		  SendMessage (GetDlgItem (hDlg, IDC_TYPE), CB_GETCURSEL, 0,
			       0);
		if (select == 0)
		  {
		    // jarIvVL
		    args->jar = true;

		    // Browse{^L
		    EnableWindow (GetDlgItem (hDlg, IDC_BROWSE), TRUE);
		  }
		else if (select == 1)
		  {
		    // jarIvV
		    args->jar = false;
		    // Browse{^𖳌
		    EnableWindow (GetDlgItem (hDlg, IDC_BROWSE), FALSE);
		  }
	      }
	      return TRUE;
	    }
	  break;

	case IDC_OPTIONS:
	  {
	    // Options_CAO\
	    show_options_dialog (hDlg, args);
	  }
	  return TRUE;

	case IDM_OPEN:
	  // RtBOI[v
	  {
	    _TCHAR filename[MAX_PATH + 1] = _T ("");
	    OPENFILENAME ofn = { 0 };
	    ofn.lStructSize = sizeof (OPENFILENAME);
	    ofn.hwndOwner = hDlg;
	    ofn.hInstance = g_hInstance;
	    ofn.lpstrFilter = _T ("Mysaifu JVM\0*.mysaifujvm\0\0");
	    ofn.lpstrFile = filename;
	    ofn.nMaxFile = MAX_PATH;
	    ofn.Flags = OFN_FILEMUSTEXIST;
	    if (get_open_file_name (&ofn))
	      {
		arguments_delete (args);
		args = load_arguments_from (filename);
		if (args)
		  {
		    COPY_TO_CONTROLS (args);
		  }
	      }
	  }
	  return TRUE;

	case IDM_SAVE_AS:
	  // RtBOۑ
	  {
	    _TCHAR filename[MAX_PATH + 1] = _T ("");
	    OPENFILENAME ofn = { 0 };
	    ofn.lStructSize = sizeof (OPENFILENAME);
	    ofn.hwndOwner = hDlg;
	    ofn.hInstance = g_hInstance;
	    ofn.lpstrFilter = _T ("Mysaifu JVM\0*.mysaifujvm\0\0");
	    ofn.lpstrFile = filename;
	    ofn.nMaxFile = MAX_PATH;
	    ofn.Flags = OFN_OVERWRITEPROMPT;

	    if (get_save_file_name (&ofn))
	      {
		COPY_FROM_CONTROLS (args);
		FILE *fp = _tfopen (filename, _T ("w"));
		if (!fp)
		  {
		    MessageBox (hDlg,
				_T ("Failed to open file"),
				_T ("Mysaifu JVM error"),
				MB_OK | MB_ICONERROR);
		  }
		else
		  {
		    arguments_store (args, fp);
		    fclose (fp);
		  }
	      }
	  }
	  return TRUE;

	case IDM_JVMLIST:
	  {
	    // JVMXg\
	    DialogBox (g_hInstance,
		       MAKEINTRESOURCE (IDD_JVMLIST),
		       hDlg, (DLGPROC) JVMListDialogProc);
	  }
	  return TRUE;

	case IDM_ABOUT:
	  {
	    // About_CAO\
	    DialogBox (g_hInstance,
		       MAKEINTRESOURCE (IDD_ABOUT),
		       hDlg, (DLGPROC) AboutDialogProc);
	  }
	  return TRUE;

	}
    }
  return FALSE;

#undef COPY_FROM_CONTROLS
#undef COPY_TO_CONTROLS
}

/**
 * w肳ꂽXgr[ɁAVXevpeB̓e\
 */
static void
set_system_properties (HWND hwndListView, arguments * args)
{
  ListView_DeleteAllItems (hwndListView);
  LVITEM item = { 0 };
  item.mask = LVIF_TEXT;
  for (int i = 0; i < args->properties_count; ++i)
    {
      item.iItem = i;
      item.iSubItem = 0;
      const _TCHAR *key = arguments_get_property_key (args, i);
      item.pszText = const_cast < _TCHAR * >(key);
      ListView_InsertItem (hwndListView, &item);

      item.iSubItem = 1;
      const _TCHAR *value = arguments_get_property (args, key);
      item.pszText = const_cast < _TCHAR * >(value);
      ListView_SetItem (hwndListView, &item);
    }
}

/**
 * w肳ꂽXgr[ɁAVXevpeBǉ
 * ̃L[słɑ݂ĂꍇAeu
 */
static void
put_system_property (HWND hwndListView, _TCHAR * key, _TCHAR * value)
{
  LVFINDINFO info = { 0 };
  info.flags = LVFI_STRING;
  info.psz = key;
  int index = ListView_FindItem (hwndListView, -1, &info);

  int pos = -1;
  if (index == -1)
    {
      // ݂Ȃꍇ́AACe}
      pos = ListView_GetItemCount (hwndListView);
      LVITEM item = { 0 };
      item.mask = LVIF_TEXT;
      item.pszText = key;
      item.iItem = pos;
      ListView_InsertItem (hwndListView, &item);

      item.iSubItem = 1;
      item.pszText = value;
      ListView_SetItem (hwndListView, &item);
    }
  else
    {
      // ݂ꍇ́AACeu
      pos = index;
      LVITEM item = { 0 };
      item.mask = LVIF_TEXT;
      item.pszText = value;
      item.iItem = index;
      item.iSubItem = 1;
      ListView_SetItem (hwndListView, &item);
    }

  // IԂɂ
  ListView_SetItemState (hwndListView, pos, LVIS_SELECTED, LVIS_SELECTED);
  // XN[Kvȏꍇ́AXN[
  ListView_EnsureVisible (hwndListView, pos, FALSE);
}

/**
 * ʐݒy[W̃vV[W
 */
LRESULT CALLBACK
GeneralDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  // ̊֐ł̂ݎgp}N
  // w肳ꂽACLASSPATH eLXg{bNXɒǉ
#define ADD_TO_CLASSPATH(file) \
	{ \
		HWND hwndClasspath = GetDlgItem(hDlg, IDC_CLASSPATH); \
		int textlength = GetWindowTextLength(hwndClasspath); \
		SendMessage(hwndClasspath, EM_SETSEL, (WPARAM) textlength, (LPARAM) textlength); \
		if (textlength) { \
			SendMessage(hwndClasspath, EM_REPLACESEL, (WPARAM) FALSE, (LPARAM) _T(";")); \
		} \
		SendMessage(hwndClasspath, EM_REPLACESEL, (WPARAM) FALSE, (LPARAM) file); \
	}
  // w肳ꂽITEMIDLISTJ
#define FREE_ITEMIDLIST(idlist) \
	{ \
		if (idlist) { \
			IMalloc* imalloc; \
			SHGetMalloc(&imalloc); \
			imalloc->Free(idlist); \
			imalloc->Release(); \
			idlist = NULL; \
		} \
	}

  static arguments *args;
  static LPITEMIDLIST last_idlist;
  switch (message)
    {
    case WM_INITDIALOG:
      {
	args = (arguments *) ((LPPROPSHEETPAGE) (lParam))->lParam;

	// argv
	SetWindowText (GetDlgItem (hDlg, IDC_COMMANDLINE), args->argv);

	// CLASSPATH
	SetWindowText (GetDlgItem (hDlg, IDC_CLASSPATH), args->classpath);

	if (args->jar)
	  {
	    // -jar IvVĂꍇ́ACLASSPATHҏWłȂ
	    EnableWindow (GetDlgItem (hDlg, IDC_CLASSPATH), FALSE);
	    EnableWindow (GetDlgItem (hDlg, IDC_ADD_FILE), FALSE);
	    EnableWindow (GetDlgItem (hDlg, IDC_ADD_FOLDER), FALSE);
	  }

	// JgfBNg
	SetWindowText (GetDlgItem (hDlg, IDC_CURRENT_DIRECTORY),
		       args->current_directory);
      }
      return TRUE;

    case WM_COMMAND:
      switch (LOWORD (wParam))
	{
	case IDC_ADD_FILE:
	  // t@Cǉ
	  {
	    OPENFILENAME ofn = { 0 };
	    _TCHAR filename[MAX_PATH + 1] = _T ("");

	    ofn.lStructSize = sizeof (OPENFILENAME);
	    ofn.hwndOwner = hDlg;
	    ofn.hInstance = g_hInstance;
	    // *.jar, *.zip, *.*
	    ofn.lpstrFilter =
	      _T ("Jar file\0*.jar\0Zip file\0*.zip\0All files\0*.*\0");
	    ofn.lpstrFile = filename;
	    ofn.nMaxFile = MAX_PATH;

	    if (get_open_file_name (&ofn))
	      {
		ADD_TO_CLASSPATH (filename);
	      }
	    return TRUE;
	  }

	case IDC_ADD_FOLDER:
	  // tH_ǉ
	  {
	    _TCHAR path[MAX_PATH];
	    MYBROWSEINFO bi = { 0 };
	    bi.pszDisplayName = path;
	    bi.hwndOwner = hDlg;
	    bi.pidlRoot = last_idlist;

	    LPITEMIDLIST idlist = MySHBrowseForFolder (&bi);
	    if (idlist)
	      {
		SHGetPathFromIDList (idlist, path);
		FREE_ITEMIDLIST (last_idlist);
		last_idlist = idlist;
		ADD_TO_CLASSPATH (path);
	      }
	  }
	  return TRUE;

	case IDC_SELECT_CURRENT_DIRECTORY:
	  // JgfBNgݒ
	  {
	    _TCHAR path[MAX_PATH];
	    MYBROWSEINFO bi = { 0 };
	    bi.pszDisplayName = path;
	    bi.hwndOwner = hDlg;

	    LPITEMIDLIST idlist = MySHBrowseForFolder (&bi);
	    if (idlist)
	      {
		SHGetPathFromIDList (idlist, path);
		FREE_ITEMIDLIST (idlist);
		SetWindowText (GetDlgItem (hDlg, IDC_CURRENT_DIRECTORY),
			       path);
	      }
	  }
	  return TRUE;
	}
      break;

    case WM_NOTIFY:
      {
	NMHDR *hdr = (NMHDR *) lParam;
	switch (hdr->code)
	  {
	  case PSN_APPLY:
	    {
	      // Rg[̓eAargumentsɃRs[
	      _TCHAR buff[256];

	      // R}hCIvV
	      HWND hwndArgs = GetDlgItem (hDlg, IDC_COMMANDLINE);
	      GetWindowText (hwndArgs, buff, sizeof (buff) / sizeof (*buff));
	      int len = _tcslen (buff);
	      args->argv =
		(_TCHAR *) realloc (args->argv, sizeof (_TCHAR) * (len + 1));
	      if (!args->argv)
		{
		  fatal_error (FATAL_ERROR_NO_MEMORY);
		}
	      _tcscpy (args->argv, buff);

	      // CLASSPATH
	      // Classpath͉ϒƂ(Bug #12863)
	      int classpath_length =
		GetWindowTextLength (GetDlgItem (hDlg, IDC_CLASSPATH));
	      args->classpath =
		(_TCHAR *) realloc (args->classpath,
				    sizeof (_TCHAR) * (classpath_length + 1));
	      if (!args->classpath)
		{
		  fatal_error (FATAL_ERROR_NO_MEMORY);
		}
	      GetWindowText (GetDlgItem (hDlg, IDC_CLASSPATH),
			     args->classpath, classpath_length + 1);

	      // ITEMIDLISTJ
	      FREE_ITEMIDLIST (last_idlist);

	      // JgfBNg
	      GetWindowText (GetDlgItem (hDlg, IDC_CURRENT_DIRECTORY),
			     args->current_directory,
			     sizeof (args->current_directory) /
			     sizeof (args->current_directory[0]));
	    }
	    return TRUE;
	  }
	break;
      }
      break;
    }
  return FALSE;

#undef ADD_TO_CLASSPATH
#undef FREE_ITEMIDLIST
}

/**
 * ݒy[W̃vV[W
 */
LRESULT CALLBACK
MemoryDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  static arguments *args;
  switch (message)
    {
    case WM_INITDIALOG:
      {
	args = (arguments *) ((LPPROPSHEETPAGE) (lParam))->lParam;

	// őq[vTCY
	{
	  // R{{bNX
	  HWND hwndUnit = GetDlgItem (hDlg, IDC_MAXHEAPSIZE_UNIT);
	  SendMessage (hwndUnit, CB_ADDSTRING, 0, (LPARAM) _T ("KB"));
	  SendMessage (hwndUnit, CB_ADDSTRING, 0, (LPARAM) _T ("MB"));

	  // Initialize checkbox
	  HWND hwndMemUsage = GetDlgItem (hDlg, IDC_SHOW_MEMORY_USAGE);
	  SendMessage (hwndMemUsage,
		       BM_SETCHECK,
		       args->
		       show_current_heap_usage ? BST_CHECKED : BST_UNCHECKED,
		       0);

	  // c̃TCY𒲐
	  RECT rect;
	  GetWindowRect (hwndUnit, &rect);
	  SetWindowPos (hwndUnit,
			NULL,
			0,
			0,
			rect.right - rect.left,
			(rect.bottom - rect.top) * 3, SWP_NOMOVE);

	  // eLXgGAɏl\
	  int value = args->max_heap_size;
	  if (value % (1024 * 1024))
	    {
	      // KBɕϊ
	      value /= 1024;
	      SendMessage (hwndUnit, CB_SETCURSEL, 0, 0);
	    }
	  else
	    {
	      // MBɕϊ
	      value /= (1024 * 1024);
	      SendMessage (hwndUnit, CB_SETCURSEL, 1, 0);
	    }

	  HWND hwndSize = GetDlgItem (hDlg, IDC_MAXHEAPSIZE);
	  _TCHAR buff[32];
	  _itot (value, buff, 10);
	  SetWindowText (hwndSize, buff);
	}
	// JavaX^bNTCY
	{
	  // eLXgGAɏl\
	  int value = args->java_stack_size;
	  // KBɕϊ
	  value /= 1024;

	  HWND hwndSize = GetDlgItem (hDlg, IDC_JAVA_STACK_SIZE);
	  _TCHAR buff[32];
	  _itot (value, buff, 10);
	  SetWindowText (hwndSize, buff);
	}
	// lCeBuX^bNTCY
	{
	  // eLXgGAɏl\
	  int value = args->native_stack_size;
	  // KBɕϊ
	  value /= 1024;

	  HWND hwndSize = GetDlgItem (hDlg, IDC_NATIVE_STACK_SIZE);
	  _TCHAR buff[32];
	  _itot (value, buff, 10);
	  SetWindowText (hwndSize, buff);
	}

	return TRUE;
      }
      break;

    case WM_NOTIFY:
      {
	NMHDR *hdr = (NMHDR *) lParam;
	switch (hdr->code)
	  {
	  case PSN_APPLY:
	    {
	      // Rg[̓eAargumentsɃRs[
	      _TCHAR buff[256];
	      // őq[vTCY
	      {
		GetWindowText (GetDlgItem (hDlg, IDC_MAXHEAPSIZE),
			       buff, (sizeof (buff) / sizeof (*buff)));
		int value = _ttoi (buff);
		GetWindowText (GetDlgItem (hDlg, IDC_MAXHEAPSIZE_UNIT),
			       buff, (sizeof (buff) / sizeof (*buff)));
		if (_tcscmp (buff, _T ("KB")) == 0)
		  {
		    value *= 1024;
		  }
		else if (_tcscmp (buff, _T ("MB")) == 0)
		  {
		    value *= (1024 * 1024);
		  }
		if (value > 0)
		  {
		    // őq[vTCYݒ肷
		    args->max_heap_size = value;
		  }
	      }

	      // Show current memory usage
	      {
		args->show_current_heap_usage
		  =
		  (bool)
		  SendMessage (GetDlgItem (hDlg, IDC_SHOW_MEMORY_USAGE),
			       BM_GETCHECK, 0, 0);
	      }

	      // JavaX^bNTCY
	      {
		GetWindowText (GetDlgItem (hDlg, IDC_JAVA_STACK_SIZE),
			       buff, (sizeof (buff) / sizeof (*buff)));
		int value = _ttoi (buff);
		value *= 1024;
		if (value > 0)
		  {
		    // JavaX^bNTCYݒ肷
		    args->java_stack_size = value;
		  }
	      }
	      // lCeBuX^bNTCY
	      {
		GetWindowText (GetDlgItem (hDlg, IDC_NATIVE_STACK_SIZE),
			       buff, (sizeof (buff) / sizeof (*buff)));
		int value = _ttoi (buff);
		value *= 1024;
		if (value > 0)
		  {
		    // lCeBuX^bNTCYݒ肷
		    args->native_stack_size = value;
		  }
	      }
	    }
	    return TRUE;
	  }
	break;
      }
      break;
    }
  return FALSE;
}

/**
 * vpeBݒy[W̃vV[W
 */
LRESULT CALLBACK
PropertiesDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  static arguments *args;
  switch (message)
    {
    case WM_INITDIALOG:
      {
	args = (arguments *) ((LPPROPSHEETPAGE) (lParam))->lParam;

	// System properties
	RECT rect;
	HWND hwndList = GetDlgItem (hDlg, IDC_PROPERTIES);
	GetWindowRect (hwndList, &rect);
	LVCOLUMN lc = { 0 };
	lc.mask = LVCF_WIDTH | LVCF_TEXT;
	lc.cx = (rect.right - rect.left) / 4;
	lc.pszText = _T ("Key");
	ListView_InsertColumn (hwndList, 0, &lc);
	lc.cx = (rect.right - rect.left) - (lc.cx * 2);
	lc.pszText = _T ("Value");
	ListView_InsertColumn (hwndList, 1, &lc);

	set_system_properties (hwndList, args);

	// JTCY߂
	ListView_SetColumnWidth (hwndList, 0, LVSCW_AUTOSIZE);
	ListView_SetColumnWidth (hwndList, 1, LVSCW_AUTOSIZE);
      }
      return TRUE;

    case WM_NOTIFY:
      if (wParam == IDC_PROPERTIES)
	{
	  // vpeBXg瑗Ăꍇ
	  // Xgr[̑IԂɂāA{^̗L^؂ւ
	  LV_DISPINFO *lvinfo = (LV_DISPINFO *) lParam;
	  switch (lvinfo->hdr.code)
	    {
	    case LVN_ITEMCHANGED:
	      {
		HWND hwndList = GetDlgItem (hDlg, IDC_PROPERTIES);
		int index = ListView_GetNextItem (hwndList,
						  -1,	// Xg̐擪猟
						  LVNI_SELECTED);	// IĂACe
		HWND hwndEdit = GetDlgItem (hDlg, IDC_EDIT);
		HWND hwndDelete = GetDlgItem (hDlg, IDC_DELETE);
		if (index == -1)
		  {
		    if (IsWindowEnabled (hwndEdit))
		      {
			EnableWindow (GetDlgItem (hDlg, IDC_EDIT), FALSE);
		      }
		    if (IsWindowEnabled (hwndDelete))
		      {
			EnableWindow (GetDlgItem (hDlg, IDC_DELETE), FALSE);
		      }
		  }
		else
		  {
		    if (!IsWindowEnabled (hwndEdit))
		      {
			EnableWindow (GetDlgItem (hDlg, IDC_EDIT), TRUE);
		      }
		    if (!IsWindowEnabled (hwndDelete))
		      {
			EnableWindow (GetDlgItem (hDlg, IDC_DELETE), TRUE);
		      }
		  }
	      }
	      return TRUE;
	    }
	}
      else
	{
	  // vpeBV[g̃bZ[W
	  NMHDR *hdr = (NMHDR *) lParam;
	  switch (hdr->code)
	    {
	    case PSN_APPLY:
	      {
		// Rg[ݒlRs[
		// VXevpeB
		arguments_clear_all_properties (args);

		HWND hwndList = GetDlgItem (hDlg, IDC_PROPERTIES);
		int properties_count = ListView_GetItemCount (hwndList);
		LVITEM item = { 0 };
		item.mask = LVIF_TEXT;
		for (int i = 0; i < properties_count; ++i)
		  {
		    property prop;
		    item.iItem = i;
		    item.iSubItem = 0;
		    item.cchTextMax = sizeof (prop.key) / sizeof (*prop.key);
		    item.pszText = prop.key;
		    ListView_GetItem (hwndList, &item);

		    item.iSubItem = 1;
		    item.cchTextMax =
		      sizeof (prop.value) / sizeof (*prop.value);
		    item.pszText = prop.value;
		    ListView_GetItem (hwndList, &item);
		    arguments_put_property (args, prop.key, prop.value);
		  }
	      }
	      return TRUE;
	    }
	  break;
	}

    case WM_COMMAND:
      switch (LOWORD (wParam))
	{
	case IDC_ADD:
	  // vpeBGfB^\
	  {
	    property prop = { 0 };
	    DialogBoxParam (g_hInstance,
			    MAKEINTRESOURCE (IDD_PROPERTY_EDITOR),
			    hDlg,
			    (DLGPROC) SystemPropertyEditorDialogProc,
			    (LPARAM) & prop);
	    if (_tcslen (prop.key))
	      {
		// Xgr[ɒǉ
		HWND hwndList = GetDlgItem (hDlg, IDC_PROPERTIES);
		put_system_property (hwndList, prop.key, prop.value);

		// JTCY߂
		ListView_SetColumnWidth (hwndList, 0, LVSCW_AUTOSIZE);
		ListView_SetColumnWidth (hwndList, 1, LVSCW_AUTOSIZE);
	      }
	  }
	  return TRUE;

	case IDC_EDIT:
	  // vpeBҏW
	  {
	    HWND hwndList = GetDlgItem (hDlg, IDC_PROPERTIES);
	    int index = ListView_GetNextItem (hwndList, -1, LVNI_SELECTED);
	    if (index != -1)
	      {
		property prop;
		LVITEM item = { 0 };
		item.mask = LVIF_TEXT;

		item.iItem = index;
		item.iSubItem = 0;
		item.pszText = prop.key;
		item.cchTextMax = sizeof (prop.key) / sizeof (*prop.key);
		ListView_GetItem (hwndList, &item);

		item.iSubItem = 1;
		item.pszText = prop.value;
		item.cchTextMax = sizeof (prop.value) / sizeof (*prop.value);
		ListView_GetItem (hwndList, &item);

		DialogBoxParam (g_hInstance,
				MAKEINTRESOURCE (IDD_PROPERTY_EDITOR),
				hDlg,
				(DLGPROC) SystemPropertyEditorDialogProc,
				(LPARAM) & prop);
		if (_tcslen (prop.key))
		  {
		    // Xgr[̓eC
		    put_system_property (hwndList, prop.key, prop.value);
		    // JTCY߂
		    ListView_SetColumnWidth (hwndList, 0, LVSCW_AUTOSIZE);
		    ListView_SetColumnWidth (hwndList, 1, LVSCW_AUTOSIZE);
		  }
	      }
	  }
	  return TRUE;

	case IDC_DELETE:
	  // vpeB폜
	  {
	    HWND hwndList = GetDlgItem (hDlg, IDC_PROPERTIES);
	    int index = ListView_GetNextItem (hwndList, -1, LVNI_SELECTED);
	    if (index != -1)
	      {
		ListView_DeleteItem (hwndList, index);
		// JTCY߂
		ListView_SetColumnWidth (hwndList, 0, LVSCW_AUTOSIZE);
		ListView_SetColumnWidth (hwndList, 1, LVSCW_AUTOSIZE);
	      }
	  }
	  return TRUE;

	}
    }
  return FALSE;
}

/**
 * xt@Cݒy[W̃vV[W
 */
LRESULT CALLBACK
VerifierDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  static arguments *args;
  switch (message)
    {
    case WM_INITDIALOG:
      {
	args = (arguments *) ((LPPROPSHEETPAGE) (lParam))->lParam;

	// Rg[̓e
	// xt@C[h
	switch (args->verify_mode)
	  {
	  case VERIFY_MODE_NONE:
	    // -noverify
	    SendMessage (GetDlgItem (hDlg, IDC_VERIFY_NONE),
			 BM_SETCHECK, BST_CHECKED, 0);
	    break;

	  case VERIFY_MODE_ALL:
	    // -verify
	    SendMessage (GetDlgItem (hDlg, IDC_VERIFY_ALL),
			 BM_SETCHECK, BST_CHECKED, 0);
	    break;
	  }

      }
      return TRUE;

    case WM_NOTIFY:
      {
	switch (((NMHDR *) lParam)->code)
	  {
	  case PSN_APPLY:
	    {
	      // xt@C[h
	      if (BST_CHECKED ==
		  SendMessage (GetDlgItem (hDlg, IDC_VERIFY_ALL), BM_GETCHECK,
			       0, 0))
		{
		  args->verify_mode = VERIFY_MODE_ALL;
		}
	      else
		{
		  args->verify_mode = VERIFY_MODE_NONE;
		}

	    }
	    return TRUE;
	  }
	break;
      }
    }

  return FALSE;
}

/**
 * ̑ݒy[W̃vV[W
 */
LRESULT CALLBACK
MiscDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  static arguments *args;
  switch (message)
    {
    case WM_INITDIALOG:
      {
	args = (arguments *) ((LPPROPSHEETPAGE) (lParam))->lParam;

	// Rg[̓e

	// logfile
	SetWindowText (GetDlgItem (hDlg, IDC_LOGFILE), args->logfile);

	// Bootclasspath
	SetWindowText (GetDlgItem (hDlg, IDC_BOOTCLASSPATH),
		       args->boot_classpath);

	// assertion
	SendMessage (GetDlgItem (hDlg, IDC_ENABLEASSERTIONS),
		     BM_SETCHECK,
		     (WPARAM) (args->
			       enableAssertions ? BST_CHECKED :
			       BST_UNCHECKED), 0);

	// -verbose:gc
	SendMessage (GetDlgItem (hDlg, IDC_VERBOSE_GC),
		     BM_SETCHECK,
		     (WPARAM) (args->
			       verbose_gc ? BST_CHECKED : BST_UNCHECKED), 0);

	// -Xhidevmwindow
	SendMessage (GetDlgItem (hDlg, IDC_HIDE_VM_WINDOW),
		     BM_SETCHECK,
		     (WPARAM) (args->
			       hide_vm_window ? BST_CHECKED : BST_UNCHECKED),
		     0);

	// -Xusesdio
	SendMessage (GetDlgItem (hDlg, IDC_USE_STDIO),
		     BM_SETCHECK,
		     (WPARAM) (args->use_stdio ? BST_CHECKED : BST_UNCHECKED),
		     0);

      }
      return TRUE;

    case WM_NOTIFY:
      {
	switch (((NMHDR *) lParam)->code)
	  {
	  case PSN_APPLY:
	    {
	      // Ot@Cݒ肷
	      GetWindowText (GetDlgItem (hDlg, IDC_LOGFILE),
			     args->logfile,
			     (sizeof (args->logfile) /
			      sizeof (*args->logfile)));

	      // Bootclasspath
	      GetWindowText (GetDlgItem (hDlg, IDC_BOOTCLASSPATH),
			     args->boot_classpath,
			     sizeof (args->boot_classpath) /
			     sizeof (*args->boot_classpath));

	      // assertion̗L^ݒ肷
	      args->enableAssertions
		=
		(BST_CHECKED ==
		 SendMessage (GetDlgItem (hDlg, IDC_ENABLEASSERTIONS),
			      BM_GETCHECK, 0, 0)) ? true : false;

	      // -verbose:gc
	      args->verbose_gc =
		(BST_CHECKED ==
		 SendMessage (GetDlgItem (hDlg, IDC_VERBOSE_GC), BM_GETCHECK,
			      0, 0)) ? true : false;
	      // xt@C[h
	      if (BST_CHECKED ==
		  SendMessage (GetDlgItem (hDlg, IDC_VERIFY_ALL), BM_GETCHECK,
			       0, 0))
		{
		  args->verify_mode = VERIFY_MODE_ALL;
		}
	      else
		{
		  args->verify_mode = VERIFY_MODE_NONE;
		}

	      // VMEChE\
	      if (BST_CHECKED ==
		  SendMessage (GetDlgItem (hDlg, IDC_HIDE_VM_WINDOW),
			       BM_GETCHECK, 0, 0))
		{
		  args->hide_vm_window = true;
		}
	      else
		{
		  args->hide_vm_window = false;
		}

	      // stdiog
	      if (BST_CHECKED ==
		  SendMessage (GetDlgItem (hDlg, IDC_USE_STDIO), BM_GETCHECK,
			       0, 0))
		{
		  args->use_stdio = true;
		}
	      else
		{
		  args->use_stdio = false;
		}
	    }
	    return TRUE;
	  }
	break;
      }
    }

  return FALSE;
}

/**
 * VXevpeBGfB^_CAÕvV[W
 */
LRESULT CALLBACK
SystemPropertyEditorDialogProc (HWND hDlg, UINT message, WPARAM wParam,
				LPARAM lParam)
{
  static property *prop;
  switch (message)
    {
    case WM_INITDIALOG:
      {

	prop = (property *) lParam;

	// Rg[
	SetDlgItemText (hDlg, IDC_KEY, prop->key);
	SetDlgItemText (hDlg, IDC_VALUE, prop->value);
      }
      return TRUE;

    case WM_COMMAND:
      switch (LOWORD (wParam))
	{
	case IDC_KEY:
	  {
	    if (HIWORD (wParam) == EN_CHANGE)
	      {
		BOOL enabled = FALSE;
		if (GetWindowTextLength (GetDlgItem (hDlg, IDC_KEY)))
		  {
		    enabled = TRUE;
		  }
		if (enabled != IsWindowEnabled (GetDlgItem (hDlg, IDOK)))
		  {
		    EnableWindow (GetDlgItem (hDlg, IDOK), enabled);
		  }
	      }
	  }
	  return TRUE;

	case IDOK:
	  {
	    // Rg[lRs[
	    GetDlgItemText (hDlg, IDC_KEY, prop->key,
			    sizeof (prop->key) / sizeof (*prop->key));
	    GetDlgItemText (hDlg, IDC_VALUE, prop->value,
			    sizeof (prop->key) / sizeof (*prop->key));

	    // _CAOI
	    EndDialog (hDlg, 1);
	  }
	  return TRUE;

	case IDCANCEL:
	  // _CAOI
	  EndDialog (hDlg, 0);
	  return TRUE;
	}
    }
  return FALSE;
}

/**
 * vpeBV[g̃R[obN֐
 */
int
PropSheetProc (HWND hwnd, UINT uMsg, LPARAM lParam)
{
  // ȉURLQlɍ쐬
  // http://msdn.microsoft.com/library/default.asp?url=/library/en-us/win_ce/html/pwc_PropertySheets.asp

  switch (uMsg)
    {
    case PSCB_INITIALIZED:
      {
	// ^uԉɎĂ
	HWND hwndTabs = GetDlgItem (hwnd, 0x3020);
	DWORD dwStyle = GetWindowLong (hwndTabs, GWL_STYLE);
	SetWindowLong (hwndTabs, GWL_STYLE, dwStyle | TCS_BOTTOM);

	// j[
	SHINITDLGINFO shidi = { 0 };
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags = SHIDIF_SIZEDLGFULLSCREEN | SHIDIF_EMPTYMENU;
	shidi.hDlg = hwnd;
	SHInitDialog (&shidi);
      }
      break;

    case PSCB_GETVERSION:
      return COMCTL32_VERSION;
    }

  return 1;
}

/**
 * "Advanced" vpeBV[g\
 */
static void
show_options_dialog (HWND hwndParent, arguments * args)
{
  PROPSHEETPAGE psp = { 0 };
  HPROPSHEETPAGE pages[16];	// y[Wꍇɂ͕ύXKv

  psp.dwSize = sizeof (PROPSHEETPAGE);
  psp.dwFlags = PSP_USETITLE;
  psp.hInstance = g_hInstance;

  int page = 0;
  // Command line
  psp.pszTemplate = MAKEINTRESOURCE (IDD_GENERAL);
  psp.pfnDlgProc = (DLGPROC) GeneralDialogProc;
  psp.lParam = (LPARAM) args;
  psp.pszTitle = _T ("General");
  pages[page] = CreatePropertySheetPage (&psp);

  page++;

  // Memory
  psp.pszTemplate = MAKEINTRESOURCE (IDD_MEMORY);
  psp.pfnDlgProc = (DLGPROC) MemoryDialogProc;
  psp.pszTitle = _T ("Memory");
  pages[page] = CreatePropertySheetPage (&psp);

  page++;

  // Properties
  psp.pszTemplate = MAKEINTRESOURCE (IDD_PROPERTIES);
  psp.pfnDlgProc = (DLGPROC) PropertiesDialogProc;
  psp.pszTitle = _T ("Properties");
  pages[page] = CreatePropertySheetPage (&psp);

  page++;

  // Verifier
  psp.pszTemplate = MAKEINTRESOURCE (IDD_VERIFIER);
  psp.pfnDlgProc = (DLGPROC) VerifierDialogProc;
  psp.pszTitle = _T ("Verifier");
  pages[page] = CreatePropertySheetPage (&psp);

  page++;

  // Misc
  psp.pszTemplate = MAKEINTRESOURCE (IDD_MISC);
  psp.pfnDlgProc = (DLGPROC) MiscDialogProc;
  psp.pszTitle = _T ("Misc");
  pages[page] = CreatePropertySheetPage (&psp);

  page++;

  PROPSHEETHEADER psh = { 0 };
  psh.dwSize = sizeof (PROPSHEETHEADER);
  psh.dwFlags = PSH_DEFAULT | PSH_MAXIMIZE | PSH_USECALLBACK;
  psh.hInstance = g_hInstance;
  psh.hwndParent = hwndParent;
  psh.nPages = page;
  psh.phpage = pages;
  psh.pfnCallback = PropSheetProc;
  psh.pszCaption = _T ("Advanced");
  PropertySheet (&psh);
}

/**
 * t@C̊֘At
 */
static void
init_file_associations ()
{
  const _TCHAR *mysaifujvm = _T ("MysaifuJVM");

  // WXgI[v
  HKEY hKey;
  long error = RegCreateKeyEx (HKEY_CLASSES_ROOT,
			       _T (".mysaifujvm"),
			       0,
			       NULL,
			       REG_OPTION_NON_VOLATILE,
			       KEY_ALL_ACCESS,
			       NULL,
			       &hKey,
			       NULL);
  // HKEY_CLASSES_ROOT\.mysaifujvm ɁA"MysaifuJVM"쐬
  error = RegSetValueEx (hKey,
			 NULL,
			 0,
			 REG_SZ,
			 (CONST BYTE *) mysaifujvm,
			 (_tcslen (mysaifujvm) + 1) * sizeof (_TCHAR));
  RegCloseKey (hKey);

  // HKEY_CLASSES_ROOT\MysaifuJVM\shell\open\command\ L[ɒlݒ肷
  error = RegCreateKeyEx (HKEY_CLASSES_ROOT,
			  mysaifujvm,
			  0,
			  NULL,
			  REG_OPTION_NON_VOLATILE,
			  KEY_ALL_ACCESS, NULL, &hKey, NULL);
  HKEY hShellKey;
  error = RegCreateKeyEx (hKey,
			  _T ("shell"),
			  0,
			  NULL,
			  REG_OPTION_NON_VOLATILE,
			  KEY_ALL_ACCESS, NULL, &hShellKey, NULL);
  HKEY hOpenKey;
  error = RegCreateKeyEx (hShellKey,
			  _T ("open"),
			  0,
			  NULL,
			  REG_OPTION_NON_VOLATILE,
			  KEY_ALL_ACCESS, NULL, &hOpenKey, NULL);
  HKEY hCommandKey;
  error = RegCreateKeyEx (hOpenKey,
			  _T ("command"),
			  0,
			  NULL,
			  REG_OPTION_NON_VOLATILE,
			  KEY_ALL_ACCESS, NULL, &hCommandKey, NULL);

  // st@C擾AWXgɐݒ肷
  _TCHAR exename[MAX_PATH + 1];
  GetModuleFileName (GetModuleHandle (NULL), exename,
		     sizeof (exename) / sizeof (exename[0]));
  _TCHAR value[1024];
  _sntprintf (value,
	      sizeof (value) / sizeof (value[0]),
	      _T ("\"%s\" -Xconfig %%1"), exename);
  error = RegSetValueEx (hCommandKey,
			 NULL,
			 0,
			 REG_SZ,
			 (const BYTE *) value,
			 (_tcslen (value) + 1) * sizeof (_TCHAR));

  // ftHgACRݒ肷
  HKEY hDefaultIconKey;
  RegCreateKeyEx (hKey,
		  _T ("DefaultIcon"),
		  0,
		  NULL,
		  REG_OPTION_NON_VOLATILE,
		  KEY_ALL_ACCESS, NULL, &hDefaultIconKey, NULL);
  _sntprintf (value,
	      sizeof (value) / sizeof (value[0]),
	      _T ("%s,-%d"), exename, IDI_MYSAIFU);
  RegSetValueEx (hDefaultIconKey,
		 NULL,
		 0,
		 REG_SZ,
		 (const BYTE *) value,
		 (_tcslen (value) + 1) * sizeof (_TCHAR));

  RegCloseKey (hDefaultIconKey);
  RegCloseKey (hCommandKey);
  RegCloseKey (hOpenKey);
  RegCloseKey (hShellKey);
  RegCloseKey (hKey);
}

static BOOL
get_open_file_name (OPENFILENAME * ofn)
{
  // gsgetfile.dll ݂ꍇ́Agp
  HMODULE hModule = LoadLibrary (_T ("gsgetfile.dll"));
  if (hModule)
    {
      typedef BOOL (*GSGETOPENFILENAME) (OPENFILENAME * pofn);
      GSGETOPENFILENAME gsGetOpenFileName
	=
	(GSGETOPENFILENAME) GetProcAddress (hModule,
					    _T ("gsGetOpenFileName"));
      if (gsGetOpenFileName)
	{
	  return gsGetOpenFileName (ofn);
	}
    }

  // W̃_CAO\
  return GetOpenFileName (ofn);
}

static BOOL
get_save_file_name (OPENFILENAME * ofn)
{
  // gsgetfile.dll ݂ꍇ́Agp
  HMODULE hModule = LoadLibrary (_T ("gsgetfile.dll"));
  if (hModule)
    {
      typedef BOOL (*GSGETSAVEFILENAME) (OPENFILENAME * pofn);
      GSGETSAVEFILENAME gsGetSaveFileName
	=
	(GSGETSAVEFILENAME) GetProcAddress (hModule,
					    _T ("gsGetSaveFileName"));
      if (gsGetSaveFileName)
	{
	  return gsGetSaveFileName (ofn);
	}
    }

  // W̃_CAO\
  return GetSaveFileName (ofn);
}

/**
 * t@ĆuŏIXVtvr֐it\[gpj
 */
static int
compare_last_write_time (WIN32_FIND_DATA * data1, WIN32_FIND_DATA * data2)
{
  LARGE_INTEGER time1;
  time1.HighPart = data1->ftLastWriteTime.dwHighDateTime;
  time1.LowPart = data1->ftLastWriteTime.dwLowDateTime;
  LARGE_INTEGER time2;
  time2.HighPart = data2->ftLastWriteTime.dwHighDateTime;
  time2.LowPart = data2->ftLastWriteTime.dwLowDateTime;

  // tɃ\[g
  __int64 diff = time2.QuadPart - time1.QuadPart;
  if (diff < 0)
    {
      return -1;
    }
  else if (diff == 0)
    {
      return 0;
    }
  else
    {
      return 1;
    }
}

/**
 * JVḾuRg[EChEṽnhԂ
 */
HWND
get_JVM_controller_window ()
{
  return g_hwndController;
}

/**
 * VMRuntime.exit()̎sʒm
 */
void
notify_VMRuntime_exit ()
{
  g_VMRuntime_exit_done = true;
}
