/* WaveFileWriter.java
   Copyright (C) 2006 Mysaifu.com

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; the version 2.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.javax.sound.sampled.wce;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.spi.AudioFileWriter;

/**
 * Wave file writer.
 */
public class WaveFileWriter extends AudioFileWriter implements WaveFileConstants {
	/**
	 * ނƂ̂łt@C^CvԂB
	 */
	public AudioFileFormat.Type[] getAudioFileTypes() {
		return new AudioFileFormat.Type[] { AudioFileFormat.Type.WAVE };
	}

	public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream ais) {
		AudioFormat format = ais.getFormat();
		if (! format.isBigEndian()) {
			AudioFormat.Encoding encoding = format.getEncoding();
			int sampleSizeInBits = format.getSampleSizeInBits();
			// E8rbgȂPCM
			// E16rbgtPCM
			// T|[g
			if (((encoding == AudioFormat.Encoding.PCM_UNSIGNED)
						&& (sampleSizeInBits == 8))
					||
					((encoding == AudioFormat.Encoding.PCM_SIGNED)
						&& (sampleSizeInBits == 16))) {
				return new AudioFileFormat.Type[] { AudioFileFormat.Type.WAVE };
			}
		}
		return new AudioFileFormat.Type[0];
	}
	
	/**
	 * w肳ꂽt@CɃI[fBIf[^ށB
	 */
	public int write(AudioInputStream ais,
					 AudioFileFormat.Type type,
					 File out) throws IOException {
		
		if (getAudioFileTypes(ais).length == 0) {
			throw new IllegalArgumentException("Unsupported format");
		}
		FileOutputStream fos = new FileOutputStream(out);
		BufferedOutputStream bos = new BufferedOutputStream(fos);
		
		// System.err.println("Output wave header");
		
		// wb_o͂
		int totalLength = writeWaveHeader(bos, ais);
		
		// System.err.println("Output wave data");

		// f[^̓e]
		totalLength += writeData(bos, ais);
		bos.close();
		
		// ŌɃwb_̒𖄂߂
		// System.err.println("Update wave header");
		RandomAccessFile raf = new RandomAccessFile(out, "rw");

		// wb_̃TCYtB[hit@CTCY - 8 ݒ肷j
		raf.seek(4);
		writeLE32(raf, totalLength - 8);

		// g`f[^̃oCg
		raf.seek(OUTPUT_HEADER_LENGTH - 4);
		writeLE32(raf, totalLength - OUTPUT_HEADER_LENGTH);
		raf.close();

		return totalLength;
	}

	/**
	 * w肳ꂽOutputStreamɉf[^o͂B
	 * wb_Ƀt@CTCYޕKv邽߁AAudioInputStream.getFrameLength()
	 * ͕KLȒlԂKvBAudioSystem.NOT_SPECIFIED ԂĂꍇɂ́A
	 * IOExceptionthrowB
	 */
	public int write(AudioInputStream ais,
					 AudioFileFormat.Type type,
					 OutputStream os)
					 	throws IOException {
		if (getAudioFileTypes(ais).length == 0) {
			throw new IllegalArgumentException("Unsupported format");
		}
		
		// f[^TCYm肵ĂȂꍇIOExceptionthrow
		// iwb_ɏ߂Ȃ߁j
		if (ais.getFrameLength() == AudioSystem.NOT_SPECIFIED) {
			throw new IOException("Unknown frame length");
		}
		
		// wb_
		int totalLength = writeWaveHeader(os, ais);

		// f[^
		totalLength += writeData(os, ais);
		
		os.close();
		
		return totalLength;
	}
	
	private int writeData(OutputStream os, AudioInputStream ais) throws IOException {
		AudioFormat format = ais.getFormat();
		byte[] buff = new byte[(int) format.getFrameRate() * format.getFrameSize()];
		int totalLength = 0;
		int len;
		while ((len = ais.read(buff)) != -1) {
			// System.err.println("WaveFileWriter.writeData() len=" + len);
			os.write(buff, 0, len);
			totalLength += len;
		}
		
		return totalLength;
	}
	
	static void writeLE32(RandomAccessFile raf, int value)
									throws IOException {
		raf.write(value);
		raf.write((int) (value >> 8));
		raf.write((int) (value >> 16));
		raf.write((int) (value >> 24));
	}

	static void writeLE32(OutputStream os, int value)
									throws IOException {
		os.write(value);
		os.write((int) (value >> 8));
		os.write((int) (value >> 16));
		os.write((int) (value >> 24));
	}
   
	static void writeLE16(OutputStream os, int value)
									throws IOException {
		os.write(value);
		os.write((int) (value >> 8));
	}

	/**
	 * WAVEwb_o͂
	 */
	private int writeWaveHeader(OutputStream os, AudioInputStream ais)
									throws IOException {
		// g`f[^TCYvZ
		AudioFormat format = ais.getFormat();
		long frameLength = ais.getFrameLength();
		int waveDataSize = format.getFrameSize() * (int) frameLength;
		if (frameLength < 0) {
			waveDataSize = 0;
		}
		int fileSize = OUTPUT_HEADER_LENGTH + waveDataSize - 8;
		
		// RIFF^O
		os.write(RIFF_TAG);
		
		// t@CTCY
		writeLE32(os, fileSize);
		
		// WAVE^O
		os.write(WAVE_TAG);
		
		// 'fmt ' ^O
		os.write(FMT_TAG);
		
		// 'fmt ' `N
		writeLE32(os, FMT_LENGTH);
		
		// tH[}bgID(jAPCM)
		writeLE16(os, 1);
		
		// `l
		writeLE16(os, format.getChannels());
		
		// TvOg
		writeLE32(os, (int) format.getSampleRate());
		
		// 1b̓]oCg
		writeLE32(os, (int) format.getFrameRate() * format.getFrameSize());
		
		// t[TCY
		writeLE16(os, format.getFrameSize());
		
		// ʎqrbg
		writeLE16(os, format.getSampleSizeInBits());
		
		// 'data' ^O
		os.write(DATA_TAG);
		
		// WAVEf[^
		writeLE32(os, (int) waveDataSize);
		
		return OUTPUT_HEADER_LENGTH;	// wb_TCY͌Œ
	}
	
}
