/* WCEURLImage.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.AWTError;
import java.awt.AWTException;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class WCEURLImage extends WCEImage {
	/**
	 * 񓯊Ƀ[hXbh
	 */
	private static final int LOADER_THREAD_COUNT = 3;
	
	/**
	 * [hΏۂƂȂC[W̃XgB
	 * 񓯊[hXbh̃Xg珇ԂɃ[hĂ
	 */
	static List imageList = new ArrayList();
	
	static {
		initIDs();

		// 񓯊[hXbh𐶐
		for (int i = 0; i < LOADER_THREAD_COUNT; ++i) {
			Thread t = new Thread(new Loader());
			t.setDaemon(true);
			t.start();
		}
	}
	
	/**
	 * Aj[VpTimer
	 */
	private static final Timer animationTimer = new Timer();
	
	/**
	 * [g烍[hł邱ƂtO
	 */
	private boolean loading;
	
	/**
	 * [g̃C[W[hǂtO
	 */
	private boolean loaded;
	
	/**
	 * [JɃe|t@C쐬ǂ
	 */
	private boolean tempFileCreated;
	
	/**
	 * [hΏۂƂȂURL
	 */
	private URL url;
	
	/**
	 * [hΏۂƂȂt@C
	 */
	private String filename;
	
	/**
	 * Blt֐
	 * native֐lݒ肷
	 */
	int preferredBltAPI;
	
	/**
	 * F
	 * native֐lݒ肷
	 */
	int transparentColor;
	
	/**
	 * lCeBuAj[Vf[^
	 */
	int animationData;
	
	/**
	 * w肳ꂽURLɑΉImagẽCX^X쐬B
	 */
	public WCEURLImage(URL url) {
		this.url = url;
		if ("file".equals(url.getProtocol())) {
			// [Jt@C̏ꍇ́At@C擾
			this.filename = url.getPath();
			
			// C[W̓éAłɃt@CɃ[hς
			this.loaded = true;
		}
	}
	
	static native void initIDs();
	
	/**
	 * lCeBuAj[Vf[^폜
	 */
	native void deleteNativeAnimationData(int data);
	
	/**
	 * rbg}bv쐬B
	 */
	protected int createBitmapHandle(int windowHandle) {
		int hBitmap = 0;
		if (this.loaded && this.filename != null) {
			// [Jt@C܂̓t@CłɃ[hς݂̏ꍇ
			hBitmap = createNativeBitmapHandle(windowHandle,
											   this.filename);
			if (hBitmap == 0) {
				// 쐬łȂꍇ
				setFlags(ImageObserver.ERROR | ImageObserver.ABORT);
				notifyImageObservers(ImageObserver.ERROR | ImageObserver.ABORT, -1, -1, -1, -1);
			}
			
			synchronized (this) {
				if (this.tempFileCreated && this.filename != null) {
					// e|t@C폜
					File file = new File(this.filename);
					if (file.delete()) {
						filename = null;
						this.tempFileCreated = false;
					} else {
						System.err.println("WARNING:WCEURLImage:failed to delete temp file:" + file.getAbsolutePath());
					}
				}
			}

		} else {
			// [hJn
			startLoading();
		}
		return hBitmap;
	}
	
	public int getBitmapHandle() {
		boolean firstTime;
		if (this.bitmapHandle == 0) {
			firstTime = true;
		} else {
			firstTime = false;
		}
		
		int hBitmap = super.getBitmapHandle();
		
		if (firstTime && hBitmap != 0) {
			// ALLBITStOǉ
			setFlags(getFlags() | ImageObserver.ALLBITS);
			if (this.animationData == 0) {
				notifyImageObservers(getFlags(), 0, 0, getWidth(), getHeight());
			} else {
				// FRAMEBITStOǉ
				setFlags(getFlags() | ImageObserver.FRAMEBITS);

				// FRAMEBITSnextAnimationFrame()Œʒm
				nextAnimationFrame();
			}
		}
		return hBitmap;
	}
	
	/**
	 * [hJn
	 */
	private void startLoading() {
		if (! this.loading && ! this.loaded) {
			this.loading = true;
			
			// ʃXbhŃ[hJn
			synchronized (imageList) {
				// XgɒǉAҋ@̃[_Xbhɒʒm
				imageList.add(this);
				imageList.notifyAll();
			}
		}
	}
	
	/**
	 * C[Wt@C[h
	 */
  void load()
  {
    try
    {
      // Create an temp file and load image data.
      URLConnection conn = this.url.openConnection();
      InputStream ins = conn.getInputStream();
      BufferedInputStream bis = new BufferedInputStream(ins);
      
      synchronized (this)
      {
        this.tempFileCreated = true;
        File tempFile = File.createTempFile("AWT", "img");
        FileOutputStream fos = new FileOutputStream(tempFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);

        byte[] buff = new byte[16 * 1024];
        int len;
        
        // Output image data to the temp file.
        while ((len = bis.read(buff, 0, buff.length)) != -1)
        {
          bos.write(buff, 0, len);
        }
        bos.close();
        bis.close();
        
        // Sets filename and "loaded" flag.
        this.filename = tempFile.getAbsolutePath();
        this.loaded = true;
        
        tempFile.deleteOnExit();
      }

      // Create the image.
      int bitmapHandle = getBitmapHandle();
    }
    catch (IOException ioe)
    {
      ioe.printStackTrace();
      // set error flag.
      setFlags(ImageObserver.ERROR | ImageObserver.ABORT);

      // notify error to ImageObservers
      notifyImageObservers(ImageObserver.ERROR | ImageObserver.ABORT,-1,-1,-1,-1);
    }
    finally
    {
      // clear "loading" flag.
      this.loading = false;
    }
  }
	
	/**
	 * w肳ꂽt@CArbg}bv쐬
	 */
	private native int createNativeBitmapHandle(int windowHandle,
												 String filename);
	
	public void flush() {
		super.flush();
		// e|t@C폜
		if (this.filename != null && this.tempFileCreated) {
			File file = new File(filename);
			if (file.delete()) {
				this.filename = null;
				this.tempFileCreated = false;
			} else {
				System.err.println("WARNING:WCEURLImage:failed to delete temp file:" + file.getAbsolutePath());
			}
		}
		
		// Aj[Vj
		if (this.animationData != 0) {
			deleteNativeAnimationData(this.animationData);
		}
	}

	/**
	 * Blt֐Ԃ
	 */
	public int getPreferredBltAPI() {
		return this.preferredBltAPI;
	}
	
	/**
	 * FԂ
	 */
	public int getTransparentColor() {
		return this.transparentColor;
	}
	
	/**
	 * C[W[h񓯊ɍs
	 */
	private static class Loader implements Runnable {
		public void run() {
			while (true) {
				try {
					WCEURLImage img = null;
					synchronized (WCEURLImage.imageList) {
						while (imageList.size() <= 0) {
							// [hΏۃC[Wǉ܂őҋ@
							WCEURLImage.imageList.wait();
						}
						img = (WCEURLImage) WCEURLImage.imageList.get(0);
						WCEURLImage.imageList.remove(0);
					}
					if (img != null) {
						img.load();
					}
				} catch (Throwable t) {
					// ThreadDeathȊOł͂̃Xbh͒~Ȃ
					if (t instanceof ThreadDeath) {
						throw (ThreadDeath) t;
					}
					t.printStackTrace();
				}
			}
		}
	}
	
	/**
	 * Aj[V1R}i߂
	 */
	void nextAnimationFrame() {
		int duration = nextNativeAnimationFrame(this.animationData);
		if (duration != 0) {
			// ^C}[ݒ肷
			WCEURLImage.animationTimer.schedule(new AnimationTask(), duration * 10);
		}
		// ImageObserverɒʒm
		notifyImageObservers((duration == 0) ? ImageObserver.ALLBITS
											 : ImageObserver.FRAMEBITS,
							 0,
							 0,
							 0,
							 0);
	}

	/**
	 * lCeBuAj[V1R}i߂
	 *
	 * @return	̃t[̕\ԁi10~bPʁj
	 */
	native int nextNativeAnimationFrame(int data);
	
	/**
	 * Aj[V^C}^XN
	 */
	class AnimationTask extends TimerTask {
		public void run() {
			nextAnimationFrame();
		}
	}
}
