/* WCEGraphicsEnvironment.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Locale;

public class WCEGraphicsEnvironment extends GraphicsEnvironment {
	
	public WCEGraphicsEnvironment() {
	}
	
	public GraphicsDevice[] getScreenDevices() {
		GraphicsDevice[] devs = new GraphicsDevice[1];
		devs[0] = new WCEGraphicsDevice();
		return devs;
	}
	
	public GraphicsDevice getDefaultScreenDevice() {
		return new WCEGraphicsDevice();
	}
	
	public Graphics2D createGraphics(BufferedImage image) {
		return new WCEGraphics2D(image);
	}
	
	public Font[] getAllFonts() {
		String[] names = getAvailableFontFamilyNames();
		Font[] fonts = new Font[names.length];
		for (int i = 0; i < names.length; ++i) {
			fonts[i] = new Font(names[i], Font.PLAIN, 1);
		}
		return fonts;
	}
	
	public String[] getAvailableFontFamilyNames() {
		final String[] names = { "Dialog", 
							     "DialogInput", 
							     "Monospaced", 
							     "Serif", 
							     "SansSerif"
							   };
		String[] nativeNames = getNativeAvailableFontFamilyNames();
		String[] results = new String[names.length + nativeNames.length];
		System.arraycopy(names,       0, results,            0, names.length);
		System.arraycopy(nativeNames, 0, results, names.length, nativeNames.length);
		
		Arrays.sort(results);
		
		return results;
	}
	
	public native String[] getNativeAvailableFontFamilyNames();
	
	public String[] getAvailableFontFamilyNames(Locale l) {
		// Ignores Locale.
		return getAvailableFontFamilyNames();
	}

	/**
	 * ő剻ꂽWindoẅ̗ԂB
	 */
	public Rectangle getMaximumWindowBounds() {
		Rectangle r = getNativeMaximumWindowBounds();
		if (r == null) {
			// 擾łȂꍇ́ANX̌ʂԂ
			r = super.getMaximumWindowBounds();
		}
		return r;
	}
	
	/**
	 * "Today"EChË̗Ԃ
	 */
	private native Rectangle getNativeMaximumWindowBounds();

}
