/* java_io_VMFile_wce.c - Native methods for java.io.File class (Windows CE)
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
 
GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <jni.h>

/*
 * This method checks to see if we have read permission on a file.
 *
 * Class:     java_io_VMFile
 * Method:    canRead
 * Signature: (Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL
Java_java_io_VMFile_isHidden (JNIEnv * env,
							  jclass clazz,
							  jstring path) {
	
	_TCHAR unicode_filename[MAX_PATH + 1];
	jint len;
	const jchar* buff;
	DWORD attr;

	// t@C Unicodezɕϊ
	len = (*env)->GetStringLength(env, path);
	if (len > MAX_PATH) {
		return JNI_FALSE;
	}
	buff = (*env)->GetStringChars(env, path, NULL);
	if (! buff) {
		return JNI_FALSE;
	}
	_tcsncpy(unicode_filename, buff, len);
	unicode_filename[len] = _T('\0');
	(*env)->ReleaseStringChars(env, path, buff);

	// t@C̃Agr[g擾
	attr = GetFileAttributes(unicode_filename);
	if (attr == -1) {
		// Agr[g擾łȂ
		return JNI_FALSE;
	}

	// FILE_ATTRIBUTE_HIDDEN rbgĂ邩Ԃ
	return (attr & FILE_ATTRIBUTE_HIDDEN) == FILE_ATTRIBUTE_HIDDEN;
}
