/* gnu_java_awt_peer_wce_WCEMemoryImage.c
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <jni.h>
#include <assert.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEMemoryImage.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEMemoryImage
 * Method:    createNativeBitmapHandle
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEMemoryImage_createNativeBitmapHandle(JNIEnv *env, jobject obj, jint windowHandle, jint width, jint height) {
	HDC hdc = GetDC((HWND) windowHandle);
	HBITMAP hBitmap = CreateCompatibleBitmap(hdc, width, height);
	ReleaseDC((HWND) windowHandle, hdc);

	return (jint) hBitmap;
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEMemoryImage
 * Method:    updateNativeBitmap
 * Signature: (I[III)I
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEMemoryImage_updateNativeBitmap(JNIEnv *env, jobject obj, jint windowHandle, jint bitmapHandle, jintArray imageData, jint width, jint height) {
	HBITMAP hSrcBitmap;
	BITMAPINFO bminfo = {0};
	int* pBits;
	
	if (! imageData) {
		// nullnꂽꍇANullPointerException
		jclass clazz = (*env)->FindClass(env, "java/lang/NullPointerException");
		(*env)->ThrowNew(env, clazz, "imageData");
	}
	bminfo.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bminfo.bmiHeader.biWidth = width;
	bminfo.bmiHeader.biHeight = -height;	// gbv_EDIB
	bminfo.bmiHeader.biPlanes = 1;
	bminfo.bmiHeader.biBitCount = 32;
	bminfo.bmiHeader.biCompression = BI_RGB;

	// DIB쐬
	hSrcBitmap = CreateDIBSection(NULL, &bminfo, DIB_RGB_COLORS, &pBits, NULL, 0);
	if (hSrcBitmap) {
		HDC hdc, hdcDest, hdcSrc;
		HBITMAP hOldSrcBitmap, hOldDestBitmap;
		const jint image_size = width * height;

		// DC쐬ADIBIԂɂ
		hdc = GetDC((HWND) windowHandle);
		hdcDest = CreateCompatibleDC(hdc);
		hdcSrc  = CreateCompatibleDC(hdc);
		ReleaseDC((HWND) windowHandle, hdc);

		// ]rbg}bvɃf[^]
		(*env)->GetIntArrayRegion(env, imageData, 0, image_size, pBits); 

		// ]^]rbg}bvݒ肷
		hOldSrcBitmap  = SelectObject(hdcSrc,  hSrcBitmap);
		hOldDestBitmap = SelectObject(hdcDest, (HBITMAP) bitmapHandle);

		// ]{
		BitBlt(hdcDest,
				0,
				0,
				width,
				height,
				hdcSrc,
				0,
				0,
				SRCCOPY);

		// ]rbg}bv폜
		SelectObject(hdcSrc, hOldSrcBitmap);
		DeleteObject(hSrcBitmap);
		
		// ]rbg}bvɖ߂
		SelectObject(hdcDest, hOldDestBitmap);

		// DC폜
		DeleteDC(hdcSrc);
		DeleteDC(hdcDest);

	} else {
		throw_AWTError(env, "CreateDIBSection() failed.");
	}
}
