/* FreeTypeFace.h
   Copyright (C) 2008 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <ft2build.h>
#include FT_FREETYPE_H 
#include FT_OUTLINE_H 
#include FT_BITMAP_H
#include FT_ERRORS_H
#include <jni.h>

class FreeTypeFace
{
private:
  FT_Face face;
  unsigned char* buffer;
  int bufferSize;

public:
  FreeTypeFace();
  ~FreeTypeFace();
  
  FT_Error loadFrom(const char* filename);
  FT_Error loadFrom(unsigned char* buffer, int bufferSize);
  
  inline FT_Face getFace()
  {
    return face;
  }

  static int initialize();

  void setSize(FT_F26Dot6 size);

  FT_F26Dot6 getWidth(FT_F26Dot6 size, const _TCHAR* text, int textLen);

  static const char* getErrorMessage(int errorcode);

};
