/* VMConsoleOutputStream.java -- 
   Copyright (C) 2005 Free Software Foundation

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package com.mysaifu.jvm.io;

import java.io.IOException;
import java.io.OutputStream;

/**
 * JVM̃R\[ɏo͂邽߂OutputStream
 */
public class VMConsoleOutputStream extends OutputStream {
    /**
     * obt@̗L
     */
	private int length;

    /**
     * o͗pobt@
     */
    private byte[] buffer = new byte[128];	// vf͂Ȃ炸ł邱

    /**
     * lCeBȕo͏s
     */
    private native void writeNative(byte[] buff, int off, int len);

	/**
	 * PoCgo͂
	 */
	public void write(int b) throws IOException {
		if (length >= buffer.length) {
			// obt@tbV
			flush();
		}
		buffer[length++] = (byte) b;
	}
	
	/**
	 * obt@̓eo͂
	 */
	public void write(byte[] buff, int off, int len) throws IOException {
		if (len <= 0) {
			return;
		}
		
		// file.encoding  "UTF-16LE" ȊȌꍇɂ́AUTF-16LE\
		// oCgzɕϊ
		if (! "UTF-16LE".equals(System.getProperty("file.encoding"))) {
			String s = new String(buff, off, len, System.getProperty("file.encoding"));
			buff = s.getBytes("UTF-16LE");
			off = 0;
			len = buff.length;
		}
		
		int remains = this.buffer.length - this.length;
		if (len > remains) {
			// obt@ɂׂĂ܂Ȃꍇ
			if ((this.length & 0x01) != 0) {
				// obt@̃f[^̏ꍇAPoCgǉ
				this.buffer[this.length++] = buff[off++];
				// o̓oCgPoCg炷
				len--;
			}
			
			// obt@tbV
			flush();
			
			if (len > 0 && (len & 0x01) != 0) {
				// o̓oCg̏ꍇA
				// Ō̂PoCgobt@ɓĂ
				this.buffer[this.length++] = buff[off + len - 1];
				len--;
			}
			// obt@̃f[^𒼐ڏo͂
			writeNative(buff, off, len);
			
		} else {
			// obt@Ɏ܂ꍇ̓Rs[
			System.arraycopy(buff, off, this.buffer, this.length, len);
			this.length += len;
		}
	}
	
	/**
	 * obt@tbV
	 */
	public void flush() throws IOException {
		if (this.length > 0) {
			writeNative(this.buffer, 0, this.length);
			this.length = 0;
		}
	}
}
