/* VMConsoleOutputStream.java -- 
   Copyright (C) 2005 Free Software Foundation

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package com.mysaifu.jvm.io;

import java.io.InputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

/**
 * R\[̓̓Xg[B
 * ̓̓Xg[Ԃf[^̓VXevpeB
 * file.encoding ̓eɂĕϊB
 */
public class VMConsoleInputStream extends InputStream {
	/**
	 * obt@
	 * GR[h`UTF-16LEƂȂĂB
	 * iTCY͕KoCgj
	 */
	private byte[] nativeData = new byte[128];
	
	/**
	 * f[^ǂݍݗpByteBuffer
	 */
	private ByteBuffer buffer;
	
	public VMConsoleInputStream() {
		// ByteBufferƂĎ舵
		this.buffer = ByteBuffer.wrap(nativeData);
		
		// Ԃł̓obt@͋
		this.buffer.limit(0);
	}
	
	/**
	 * R\[EChEobt@Ƀf[^ǂݍ
	 */
	private native int readNative(byte[] nativeData);
	
	public int read() throws IOException {
		if (fill() < 0) {
			return -1;
		}
		return this.buffer.get();
	}
	
	public int read(byte[] b, int off, int len) throws IOException {
		if (fill() < 0) {
			return -1;
		}
		// obt@ɃRs[TCYvZ
		int datalen = available();
		int copylen = (len < datalen) ? len : datalen;
		this.buffer.get(b, off, copylen);
		return copylen;
	}
	
	public int available() throws IOException {
		// obt@̗LvfԂ
		return this.buffer.remaining();
	}
	
	/**
	 * obt@Ƀf[^Ԃɂ
	 *
	 * @return	obt@Ɋi[ꂽf[^̃oCg
	 *          f[^擾łȂꍇ -1
	 */
	private int fill() throws IOException {
		if (available() > 0) {
			return available();
		}
		// obt@Ȃ̂ŁAlCeBuR\[ǂݍ
		int limit = readNative(this.nativeData);
		if (limit < 0) {
			return -1;
		}
		// VXẽGR[fBOɂēύX
		String encoding = System.getProperty("file.encoding");
		if ("UTF-16LE".equals(encoding)) {
			// ϊsvȏꍇ́Aobt@̏Ԃݒ肵Ȃ
			// |WV=0
			// ~bg=ǂݍ񂾃oCg
			this.buffer.position(0);
			this.buffer.limit(limit);
		} else {
			// VXẽftHgGR[hɂ킹ĕϊ
			String str = new String(this.nativeData, 0, limit, "UTF-16LE");
			byte[] data = str.getBytes(encoding);
			
			// obt@č\z
			this.buffer = ByteBuffer.wrap(data);
		}
		return available();
	}
}
