/* WCEFramePeer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.peer.FramePeer;

public class WCEFramePeer extends WCEWindowPeer implements FramePeer {
	
	public WCEFramePeer(Frame f) {
		super(f);
		setTitle(f.getTitle());
		setResizable(f.isResizable());
		
		// j[o[̃sA
		MenuBar menuBar = f.getMenuBar();
		setMenuBar(menuBar);
	}
	
	protected int createNative(int hParentWnd,
							   int x,
							   int y,
							   int width,
							   int height) {
		return createNativeFrame(hParentWnd,
								 x,
								 y,
								 width,
								 height,
								 ((Frame) getComponent()).isUndecorated());
	}
	
	native int createNativeFrame(int hParentWnd,
								 int x,
								 int y,
								 int width,
								 int height,
								 boolean undecorated);
	
	public void setIconImage(Image image) {
		// Pocket PC̃t[̓ACRT|[gĂȂ
	}

	public void setMenuBar(MenuBar mb) {
		if (mb != null) {
			WCEMenuBarPeer menuBarPeer = (WCEMenuBarPeer) mb.getPeer();
			menuBarPeer.setMenuBarWindowHandle(getMenuBarWindowHandle(getWindowHandle()));
			
			int count = mb.getMenuCount();
			Menu helpMenu = mb.getHelpMenu();
			if (helpMenu != null) {
				// getHelpMenu() != null ̏ꍇ
				// MenuBar.getMenuCount() ͂P傫ȒlԂĂ
				count--;
			}
			for (int i = 0; i < count; ++i) {
				// j[o[Ƀj[ǉ
				Menu menu = mb.getMenu(i);
				if (menu != helpMenu) {
					// MenuBar.setHelpMenu()addMenu()dĂꍇ
					// ΂Ă
					menuBarPeer.add((WCEMenuPeer) menu.getPeer());
				}
			}
			// wvj[ǉ
			if (helpMenu != null) {
				menuBarPeer.add((WCEMenuPeer) helpMenu.getPeer());
			}
		}
	}
	
	/**
	 * FrameɑΉ郁j[o[̃EChEnhԂ
	 */
	native int getMenuBarWindowHandle(int frameWindowHandle);
	
	public void setResizable(boolean resizable) {
		if ((WCEToolkit.getFloatingFlags() & WCEToolkit.FRAME_IS_FLOATING) != 0) {
			setNativeResizable(getWindowHandle(), resizable);
		}
	}
	
	/**
	 * [ȖɂEChETCYύXL^ɂ
	 */
	native void setNativeResizable(int windowHandle, boolean resizable);
	
	/**
	 * EChE^Cgݒ肷
	 *
	 * @param	title	EChE^Cg
	 */
	public void setTitle(String title) {
		setNativeText(getWindowHandle(), title);
	}
	
	/**
	 * Xe[^XԂ
	 */
	public int getState() {
		// ACR͂Ȃ
		return Frame.NORMAL;
	}
	
	/**
	 * Xe[^Xݒ肷
	 */
	public void setState(int state) {
		// Ȃ
	}
	
	/**
	 * ő勫ETCYݒ肷
	 */
	public void setMaximizedBounds(Rectangle r) {
		// Ȃ
	}
	
	/**
	 * lCeBuR|[lg̃TCYݒ肷
	 */
	public void setBounds(int x, int y, int width, int height) {
		// ToDo: y W͈ȉ̂悤ɒ
		// 1. GetGraphicsEnvironment.getMaximumWindowBounds()ōő剻WindoŵW𓾂
		// 2. LvV̍𓾂
		// 3. (yW + LvV̍) Aő剻WindowyW菬𒲂ׂ
		// 4. ꍇAy = (ő剻WindowsyW - LvV̍ + dy) ƂB
		//     dy ́uTCYύXg̍vł
		if ((WCEToolkit.getFloatingFlags() & WCEToolkit.FRAME_IS_FLOATING) != 0) {
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			Rectangle rect = ge.getMaximumWindowBounds();
			if (y < rect.y) {
				y = rect.y;
			}
			
//			System.err.println("WCEFramePeer.setBounds():width=" + width + " height=" + height);
//			(new Exception()).printStackTrace();
			super.setBounds(x, y, width, height);
		}
	}

  public void setBoundsPrivate(int x, int y, int width, int height)
  {
    // TODO Auto-generated method stub
    
  }

  public Rectangle getBoundsPrivate()
  {
    // TODO: Implement this properly.
    throw new InternalError("Not yet implemented");
  }
}
