/* instruction.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#ifndef INSTRUCTION_H_INCLUDED
#define INSTRUCTION_H_INCLUDED

#include "java_object.h"
#include "frame.h"

/**
 * instruction֘Ȁ
 */
void init_instruction_settings();

/**
 * OutOfMemoryError̃CX^X
 */
bool prepare_OutOfMemoryError();

/**
 * StackOverflowError̃CX^X
 */
bool prepare_StackOverflowError();

/**
 * w肳ꂽ\bhs
 *
 * @param	caller_frame	Ăяõt[B
 * @param	ref				IuWFNg̎QƁB
 *                          CX^X\bh̏ꍇ̓CX^X̎QƂA
 *                           static\bh̏ꍇ̓NXIuWFNgꂼw肷B
 * @param	declaring_class_file		Y\bh`ĂClassFile\
 * @param	minfo			ĂяoΏۃ\bh
 */
void invoke_method(frame* caller_frame,
				   jobject ref,
				   ClassFile* declaring_file,
				   method_info* minfo);

/**
 * u[gvX^bNt[Ԃ
 */
unsigned int get_root_frames_count();

/**
 * u[gvX^bNt[ւ̃|C^Aw肳ꂽzɃRs[
 */
void get_root_frames(frame** buff, unsigned int bufflen);

/**
 * w肳ꂽIuWFNgAw肳ꂽNX̃CX^Xł邩𒲂ׂ
 *
 * @param	obj	IuWFNgւ̎Q
 * @param	NX̖O
 */
bool is_assignable_from(frame* current_frame, ClassFile* s, ClassFile* t);

/**
 * w肳ꂽUTF-8̓eێStringIuWFNg쐬
 * 쐬StringIuWFNg̎QƂ́A frame Ŏw肳ꂽX^bNt[
 * pushB
 *
 * @param	frame	X^bNt[B쐬String̎QƂpushB
 * @param	utf8	UTF-8
 */
jstring new_utf8_string(frame* current_frame, java_utf8* utf8);
jstring permanent_utf8_string(frame* current_frame, const java_utf8* utf8);



/**
 * w肳ꂽONXthrowꂽԂɂB
 * w肳ꂽNX java.lang.Throwable ̔hNXł邩̓`FbNȂ߁A
 * ĂяoƂ̐ӔCɂȂB
 *
 * @param	current_frame	Jgt[
 * @param	cfile			NXt@C
 * @param	message			bZ[W
 * @return	ꍇtrueB
 */
bool throw_exception(frame* current_frame, const char* classname, const char* message);
bool throw_exception_int(frame* current_frame, const char* classname, jint param);
bool throw_exception(frame* current_frame, ClassFile* cfile, const char* message);
bool throw_exception_int(frame* current_frame, ClassFile* cfile, jint param);
bool throw_exception(frame* current_frame, const char* classname);
bool throw_exception(frame* current_frame, jthrowable t);

/**
 * OutOfMemoryErrorthrow
 * s_ł͐VɃCX^X𐶐邱Ƃł邽߁A
 * 炩ߐĂOutOfMemoryError̃CX^Xgp
 */
bool throw_OutOfMemoryError(frame* current_frame);

bool throw_StackOverflowError(frame* current_frame);

jthrowable exception_occurred(frame* current_frame);
void exception_clear(frame* current_frame);


#endif
