/* TG01ActionEvent.java
   Copyright (C) 2009 freebeans

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package com.mysaifu.mobile.device.tg01;

import java.util.EventObject;

/**
 * TG01 Action event object.
 */
public class TG01ActionEvent
    extends EventObject
{
  /**
   * Event type is "Rotate"
   * 
   * @see #getEventType()
   */
  public static final int TYPE_ROTATE = 1;

  /**
   * Event type is "Shake"
   * 
   * @see #getEventType()
   */
  public static final int TYPE_SHAKE = 2;

  /**
   * Event type is "Shake"
   * 
   * @see #getEventType()
   */
  public static final int TYPE_DOUBLE_TAP = 3;

  /**
   * Event type is "Tilt"
   * 
   * @see #getEventType()
   */
  public static final int TYPE_TILT = 4;

  /**
   * Event parameter of "Rotate" event.
   * 
   * @see #getParameter()
   */
  public static final int PARAMETER_ROTATE_UPWARD = 0;

  /**
   * Event parameter of "Rotate" event.
   * 
   * @see #getParameter()
   */
  public static final int PARAMETER_ROTATE_RIGHT = 1;

  /**
   * Event parameter of "Rotate" event.
   * 
   * @see #getParameter()
   */
  public static final int PARAMETER_ROTATE_UPSIDE_DOWN = 2;

  /**
   * Event parameter of "Rotate" event.
   * 
   * @see #getParameter()
   */
  public static final int PARAMETER_ROTATE_LEFT = 3;

  /**
   * Event parameter of "Tilt" event.
   * 
   * @see #getParameter()
   */
  public static final int PARAMETER_TILT_RIGHT = 0;

  /**
   * Event parameter of "Tilt" event.
   * 
   * @see #getParameter()
   */
  public static final int PARAMETER_TILT_LEFT = 1;

  /**
   * Event type.
   */
  private final int eventType;

  /**
   * Event parameter.
   */
  private final int parameter;

  /**
   * Create a TG01 Action event object with specified parameters.
   * 
   * @param accelerometer <code>TG01Accelerometer</code>
   * @param eventType Type of the event.
   * @param parameter Parameter of the event.
   */
  public TG01ActionEvent(TG01Accelerometer accelerometer, int eventType,
                         int parameter)
  {
    super(accelerometer);
    this.eventType = eventType;
    this.parameter = parameter;
  }

  /**
   * Returns type of the event.
   * 
   * @return     event type.
   */
  public int getEventType()
  {
    return this.eventType;
  }

  /**
   * Returns parameter of the event.
   * 
   * @return     event parameter.
   */
  public int getParameter()
  {
    return this.parameter;
  }
}
